// Generated by CoffeeScript 2.0.0-beta4
void function () {
  var coffee, fs, hook, istanbul, Module, originalLoader, transformFn;
  fs = require('fs');
  Module = require('module');
  istanbul = require('istanbul');
  coffee = require('coffee-script-redux');
  originalLoader = require.extensions['.coffee'];
  hook = Object.create(istanbul.hook);
  transformFn = function (matcher, transformer, verbose) {
    return function (code, filename) {
      var changed, ex, shouldHook, transformed;
      shouldHook = matcher(filename);
      changed = false;
      if (shouldHook) {
        if (verbose)
          console.error('Module load hook: transform [' + filename + ']');
        try {
          transformed = transformer(code, filename);
          changed = true;
        } catch (e$) {
          ex = e$;
          console.error('Transformation error; return original code');
          console.error(ex);
          transformed = code;
        }
      } else {
        transformed = code;
      }
      return {
        code: transformed,
        changed: changed
      };
    };
  };
  hook.hookRequire = function (matcher, transformer, options) {
    var fn, postLoadHook;
    if (null == options)
      options = {};
    fn = transformFn(matcher, transformer, options.verbose);
    postLoadHook = null;
    if (options.postLoadHook && typeof options.postLoadHook === 'function')
      postLoadHook = options.postLoadHook;
    require.extensions['.coffee'] = function (module, filename) {
      var ret;
      ret = fn(fs.readFileSync(filename, 'utf8'), filename);
      if (ret.changed) {
        module._compile(ret.code, filename);
      } else {
        originalLoader(module, filename);
      }
      if (postLoadHook)
        return postLoadHook(filename);
    };
    return istanbul.hook.hookRequire(matcher, transformer, options);
  };
  hook.unhookRequire = function () {
    require.extensions['.coffee'] = originalLoader;
    return istanbul.hook.unhookRequire();
  };
  module.exports = hook;
}.call(this);
