// Generated by CoffeeScript 2.0.0-beta4
void function () {
  var calculateColumn, coffee, crypto, escodegen, estraverse, generateTrackerVar, Instrumenter, istanbul, removeIndent;
  coffee = require('coffee-script-redux');
  istanbul = require('istanbul');
  crypto = require('crypto');
  escodegen = require('escodegen');
  estraverse = require('estraverse');
  generateTrackerVar = function (filename, omitSuffix) {
    var hash, suffix;
    if (omitSuffix)
      return '__cov_';
    hash = crypto.createHash('md5');
    hash.update(filename);
    suffix = hash.digest('base64');
    suffix = suffix.replace(/\=/g, '').replace(/\+/g, '_').replace(/\//g, '$');
    return '__cov_' + suffix;
  };
  removeIndent = function (code) {
    return code.replace(/[\uEFEF\uEFFE\uEFFF]/g, '');
  };
  calculateColumn = function (raw, offset) {
    var code, lines;
    code = raw.slice(0, offset);
    lines = code.split(/(?:\r\n|[\r\n])/g);
    return removeIndent(lines[lines.length - 1]).length;
  };
  Instrumenter = function (super$) {
    extends$(Instrumenter, super$);
    function Instrumenter(opt) {
      istanbul.Instrumenter.call(this, opt);
    }
    Instrumenter.prototype.instrumentSync = function (code, filename) {
      var codegenOptions, csast, program;
      filename = filename || '' + Date.now() + '.js';
      this.coverState = {
        path: filename,
        s: {},
        b: {},
        f: {},
        fnMap: {},
        statementMap: {},
        branchMap: {}
      };
      this.currentState = {
        trackerVar: generateTrackerVar(filename, this.omitTrackerSuffix),
        func: 0,
        branch: 0,
        variable: 0,
        statement: 0
      };
      if (!(typeof code === 'string'))
        throw new Error('Code must be string');
      csast = coffee.parse(code, {
        optimise: false,
        raw: true
      });
      program = coffee.compile(csast, { bare: true });
      this.attachLocation(program);
      this.walker.startWalk(program);
      codegenOptions = this.opts.codeGenerationOptions || { format: { compact: !this.opts.noCompact } };
      return '' + this.getPreamble(code) + '\n' + escodegen.generate(program, codegenOptions) + '\n';
    };
    Instrumenter.prototype.attachLocation = function (program) {
      return estraverse.traverse(program, {
        leave: function (node, parent) {
          var lines, value;
          if (null != node.loc && null != node.range && (null != node.raw || null != node.value)) {
            value = null != node.raw ? node.raw : typeof node.value === 'string' ? '"' + node.value.replace(/"/g, '\\"') + '"' : '' + node.value;
            node.loc = {
              start: {
                line: node.loc.start.line,
                column: calculateColumn(program.raw, node.range[0])
              },
              end: {
                line: node.loc.start.line,
                column: 0
              }
            };
            node.loc.end.column = node.loc.start.column + value.length;
            lines = value.split(/(?:\r\n|[\r\n])/g);
            if (!(lines.length === 0 || lines.length === 1)) {
              node.loc.end.line += lines.length - 1;
              node.loc.end.column = removeIndent(lines[lines.length - 1]).length;
            }
          } else {
            node.loc = function () {
              switch (node.type) {
              case 'BlockStatement':
                return {
                  start: node.body[0].loc.start,
                  end: node.body[node.body.length - 1].loc.end
                };
              case 'VariableDeclarator':
                if (null != (null != node && null != node.init ? node.init.loc : void 0)) {
                  return {
                    start: node.id.loc.start,
                    end: node.init.loc.end
                  };
                } else {
                  return node.id.loc;
                }
              case 'ExpressionStatement':
                return node.expression.loc;
              case 'ReturnStatement':
                if (null != node.argument) {
                  return node.argument.loc;
                } else {
                  return node.loc;
                }
              case 'VariableDeclaration':
                return {
                  start: node.declarations[0].loc.start,
                  end: node.declarations[node.declarations.length - 1].loc.end
                };
              default:
                return {
                  start: {
                    line: 0,
                    column: 0
                  },
                  end: {
                    line: 0,
                    column: 0
                  }
                };
              }
            }.call(this);
          }
        }
      });
    };
    return Instrumenter;
  }(istanbul.Instrumenter);
  module.exports = Instrumenter;
  function isOwn$(o, p) {
    return {}.hasOwnProperty.call(o, p);
  }
  function extends$(child, parent) {
    var key;
    for (key in parent)
      if (isOwn$(parent, key))
        child[key] = parent[key];
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }
}.call(this);
