// Generated by CoffeeScript 2.0.0-beta4
var $0, $0, additionalArgs, CoffeeScript, concat, cscodegen, escodegen, esmangle, foldl, fs, humanReadable, input, input, inputName, inputSource, inspect, Jedediah, numberLines, Optimiser, optionParser, options, output, path, pkg, positionalArgs, Preprocessor, processInput, Repl, runMain;
fs = require('fs');
path = require('path');
cache$ = require('./functional-helpers');
concat = cache$.concat;
foldl = cache$.foldl;
cache$1 = require('./helpers');
numberLines = cache$1.numberLines;
humanReadable = cache$1.humanReadable;
Preprocessor = require('./preprocessor').Preprocessor;
Optimiser = require('./optimiser').Optimiser;
runMain = require('./run').runMain;
CoffeeScript = require('./module');
Repl = require('./repl');
Jedediah = require('jedediah');
cscodegen = function () {
  try {
    return require('cscodegen');
  } catch (e$) {
    return;
  }
}.call(this);
escodegen = function () {
  try {
    return require('escodegen');
  } catch (e$) {
    return;
  }
}.call(this);
esmangle = function () {
  try {
    return require('esmangle');
  } catch (e$) {
    return;
  }
}.call(this);
inspect = function (o) {
  return require('util').inspect(o, false, 9e9, true);
};
optionParser = new Jedediah;
optionParser.addOption('parse', 'p', false, 'output a JSON-serialised AST representation of the input');
optionParser.addOption('compile', 'c', false, 'output a JSON-serialised AST representation of the output');
optionParser.addOption('optimise', true, 'enable optimisations (default: on)');
optionParser.addOption('debug', false, 'output intermediate representations on stderr for debug');
optionParser.addOption('raw', false, 'preserve source position and raw parse information');
optionParser.addOption('version', 'v', false, 'display the version number');
optionParser.addOption('help', false, 'display this help message');
optionParser.addParameter('cli', 'INPUT', 'pass a string from the command line as input');
optionParser.addParameter('input', 'i', 'FILE', 'file to be used as input instead of STDIN');
optionParser.addParameter('nodejs', 'OPTS', 'pass options through to the node binary');
optionParser.addParameter('output', 'o', 'FILE', 'file to be used as output instead of STDIN');
optionParser.addParameter('watch', 'w', 'FILE', 'watch the given file/directory for changes');
if (null != escodegen) {
  optionParser.addOption('bare', 'b', false, 'omit the top-level function wrapper');
  optionParser.addOption('js', 'j', false, 'generate JavaScript output');
  optionParser.addOption('source-map', false, 'generate source map');
  optionParser.addOption('eval', 'e', false, 'evaluate compiled JavaScript');
  optionParser.addOption('repl', false, 'run an interactive CoffeeScript REPL');
  optionParser.addParameter('source-map-file', 'FILE', 'file used as output for source map when using --js');
  optionParser.addParameter('require', 'I', 'FILE', 'require a library before a script is executed');
  if (null != esmangle)
    optionParser.addOption('minify', 'm', false, 'run compiled javascript output through a JS minifier');
}
if (null != cscodegen)
  optionParser.addOption('cscodegen', 'f', false, 'output cscodegen-generated CoffeeScript code');
cache$2 = optionParser.parse(process.argv);
options = cache$2[0];
positionalArgs = cache$2[1];
if (!(options.compile || options.js || options['source-map'] || options.parse || options['eval'] || options.cscodegen))
  if (!(null != escodegen)) {
    options.compile = true;
  } else if (positionalArgs.length) {
    options['eval'] = true;
    options.input = positionalArgs.shift();
    additionalArgs = positionalArgs;
  } else {
    options.repl = true;
  }
if (1 !== (null != options.parse ? options.parse : 0) + (null != options.compile ? options.compile : 0) + (null != options.js ? options.js : 0) + (null != options['source-map'] ? options['source-map'] : 0) + (null != options['eval'] ? options['eval'] : 0) + (null != options.cscodegen ? options.cscodegen : 0) + (null != options.repl ? options.repl : 0)) {
  console.error('Error: At most one of --parse (-p), --compile (-c), --js (-j), --source-map, --eval (-e), --cscodegen, or --repl may be used.');
  process.exit(1);
}
if (1 < (null != options.input) + (null != options.watch) + (null != options.cli)) {
  console.error('Error: At most one of --input (-i), --watch (-w), or --cli may be used.');
  process.exit(1);
}
if (null != options.require && !options['eval']) {
  console.error('Error: --require (-I) depends on --eval (-e)');
  process.exit(1);
}
if (options.minify && !(options.js || options['eval'])) {
  console.error('Error: --minify does not make sense without --js or --eval');
  process.exit(1);
}
if (options.bare && !(options.compile || options.js || options['source-map'] || options['eval'])) {
  console.error('Error: --bare does not make sense without --compile, --js, --source-map, or --eval');
  process.exit(1);
}
if (options['source-map-file'] && !options.js) {
  console.error('Error: --source-map-file depends on --js');
  process.exit(1);
}
if (null != options.input && fs.statSync(options.input).isDirectory() && (!(null != options.output) || (null != (cache$3 = fs.statSync(options.output)) ? cache$3.isFile() : void 0))) {
  console.error('Error: when --input is a directory, --output must be provided, and --output must not reference a file');
  process.exit(1);
}
if (options.cscodegen && !(null != cscodegen)) {
  console.error('Error: cscodegen must be installed to use --cscodegen');
  process.exit(1);
}
output = function (out) {
  if (options.output) {
    return fs.writeFile(options.output, '' + out + '\n', function (err) {
      if (null != err)
        throw err;
    });
  } else {
    return process.stdout.write('' + out + '\n');
  }
};
if (options.help) {
  $0 = process.argv[0] === 'node' ? process.argv[1] : process.argv[0];
  $0 = path.basename($0);
  console.log('\n  Usage: (OPT is interpreted by ' + $0 + ', ARG is passed to FILE)\n\n    ' + $0 + ' OPT* -{p,c,j,f} OPT*\n      example: ' + $0 + ' --js --no-optimise <input.coffee >output.js\n    ' + $0 + ' [-e] FILE {OPT,ARG}* [-- ARG*]\n      example: ' + $0 + ' myfile.coffee arg0 arg1\n    ' + $0 + ' OPT* [--repl] OPT*\n      example: ' + $0 + '\n\n' + optionParser.help() + '\n\n  Unless given --input or --cli flags, `' + $0 + '` will operate on stdin/stdout.\n  When none of --{parse,compile,js,source-map,eval,cscodegen,repl} are given,\n    If positional arguments were given\n      * --eval is implied\n      * the first positional argument is used as an input filename\n      * additional positional arguments are passed as arguments to the script\n    Else --repl is implied\n');
} else if (options.version) {
  pkg = require('./../../package.json');
  console.log('CoffeeScript version ' + pkg.version);
} else if (options.repl) {
  Repl.start();
} else {
  input = '';
  inputName = null != options.input ? options.input : options.cli && 'cli' || 'stdin';
  inputSource = null != options.input ? fs.realpathSync(options.input) : options.cli && '(cli)' || '(stdin)';
  processInput = function (err) {
    var cache$4, e, js, jsAST, result, sourceMap;
    if (null != err)
      throw err;
    result = null;
    input = input.toString();
    if (65279 === input.charCodeAt(0))
      input = input.slice(1);
    if (options.debug)
      try {
        console.error('### PREPROCESSED CS ###');
        console.error(numberLines(humanReadable(Preprocessor.processSync(input))));
      } catch (e$) {
      }
    try {
      result = CoffeeScript.parse(input, {
        optimise: false,
        raw: options.raw || options['source-map'] || options['source-map-file'] || options['eval'],
        inputSource: inputSource
      });
    } catch (e$1) {
      e = e$1;
      console.error(e.message);
      process.exit(1);
    }
    if (options.debug && options.optimise && null != result) {
      console.error('### PARSED CS-AST ###');
      console.error(inspect(result.toBasicObject()));
    }
    if (options.optimise && null != result)
      result = Optimiser.optimise(result);
    if (options.parse)
      if (null != result) {
        output(inspect(result.toBasicObject()));
        return;
      } else {
        process.exit(1);
      }
    if (options.debug && null != result) {
      console.error('### ' + (options.optimise ? 'OPTIMISED' : 'PARSED') + ' CS-AST ###');
      console.error(inspect(result.toBasicObject()));
    }
    if (options.cscodegen) {
      try {
        result = cscodegen.generate(result);
      } catch (e$2) {
        e = e$2;
        console.error(e.stack || e.message);
        process.exit(1);
      }
      if (null != result) {
        output(result);
        return;
      } else {
        process.exit(1);
      }
    }
    jsAST = CoffeeScript.compile(result, { bare: options.bare });
    if (options.compile)
      if (null != jsAST) {
        output(inspect(jsAST.toBasicObject()));
        return;
      } else {
        process.exit(1);
      }
    if (options.debug && null != jsAST) {
      console.error('### COMPILED JS-AST ###');
      console.error(inspect(jsAST.toBasicObject()));
    }
    if (options.minify)
      try {
        jsAST = esmangle.mangle(esmangle.optimize(jsAST), { destructive: true });
      } catch (e$3) {
        e = e$3;
        console.error(e.stack || e.message);
        process.exit(1);
      }
    if (options['source-map']) {
      try {
        sourceMap = CoffeeScript.sourceMap(jsAST, inputName, { compact: options.minify });
      } catch (e$4) {
        e = e$4;
        console.error(e.stack || e.message);
        process.exit(1);
      }
      if (null != sourceMap) {
        output('' + sourceMap);
        return;
      } else {
        process.exit(1);
      }
    }
    try {
      cache$4 = CoffeeScript.jsWithSourceMap(jsAST, inputName, { compact: options.minify });
      js = cache$4.code;
      sourceMap = cache$4.map;
      cache$4;
    } catch (e$5) {
      e = e$5;
      console.error(e.stack || e.message);
      process.exit(1);
    }
    if (options.js) {
      if (options['source-map-file']) {
        fs.writeFileSync(options['source-map-file'], '' + sourceMap);
        js = '\n          ' + js + '\n\n          /*\n          //@ sourceMappingURL=' + options['source-map-file'] + '\n          */\n        ';
      }
      output(js);
      return;
    }
    if (options['eval']) {
      runMain(input, js, jsAST, inputSource);
      return;
    }
  };
  if (null != options.input) {
    fs.stat(options.input, function (err, stats) {
      if (null != err)
        throw err;
      if (stats.isDirectory())
        options.input = path.join(options.input, 'index.coffee');
      return fs.readFile(options.input, function (err, contents) {
        if (null != err)
          throw err;
        input = contents;
        return processInput();
      });
    });
  } else if (null != options.watch) {
    options.watch;
  } else if (null != options.cli) {
    input = options.cli;
    processInput();
  } else {
    process.stdin.on('data', function (data) {
      return input += data;
    });
    process.stdin.on('end', processInput);
    process.stdin.setEncoding('utf8');
    process.stdin.resume();
  }
}
