/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;

public class CommandLine {
    RSSh rssh;
    CommandLine m;
    String commandLineArgument;
    static String[] origArgs;

    public static void main(String[] args) throws IOException {
        boolean windows;
        CommandLine m;
        origArgs = args;
        m.m = m = new CommandLine();
        m.rssh = new RSSh();
        Constants.selfPID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        Constants.enableLogging = false;
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while (i < args.length) {
            String item = args[i];
            if (item.equals("-v")) {
                Constants.enableLogging = true;
            } else if (item.equals("-h")) {
                CommandLine.helpAndExit("");
            } else if (item.equals("-f")) {
                Constants.localFolder = true;
                Constants.messageOnTunnelConnect = "You can now access your local HTML, CSS and JS file(s) in our remote browsers: ";
            } else if (item.equals("-onlyAutomate")) {
                Constants.onlyAutomate = true;
                System.out.println("***\n Setting the onlyAutomate parameter will stop local testing via command line from working with Live and Screenshots. \nTo enable local testing via the command line for Live and Screenshots, disconnect and reconnect the JAR without the -onlyAutomate parameter.\n***");
            } else if (item.equals("-force")) {
                Constants.killOtherTunnels = true;
            } else if (item.equals("-tunnelIdentifier")) {
                Constants.tunnelIdentifier = args[++i];
                Constants.onlyAutomate = true;
            } else if (item.equals("-r")) {
                Constants.repeater = args[++i];
            } else if (item.equals("-skipCheck")) {
                Constants.skipCheckParams = true;
            } else if (item.equals("-proxyHost")) {
                Constants.useProxy = true;
                Constants.proxyHost = args[++i];
            } else if (item.equals("-proxyPort")) {
                Constants.proxyPort = Integer.parseInt(args[++i]);
            } else if (item.equals("-proxyUser")) {
                Constants.proxyUser = args[++i];
            } else if (item.equals("-proxyPass")) {
                Constants.proxyPass = args[++i];
            } else if (item.equals("-vv")) {
                Constants.enableLogging = true;
                Constants.extraVerbose = true;
            } else if (item.equals("-socks")) {
                Constants.socks = true;
            } else {
                result.add(item);
            }
            ++i;
        }
        String[] newArgs = new String[result.size()];
        int k = 0;
        for (String item : result) {
            newArgs[k++] = item;
        }
        if (newArgs.length < 2) {
            CommandLine.helpAndExit("Need at least two arguments!");
        }
        if (Constants.useProxy && Constants.proxyHost == "") {
            System.out.println("\n *** No proxy Host specified... ignoring proxy settings");
            Constants.useProxy = false;
            Constants.socks = false;
        }
        if (Constants.useProxy && Constants.proxyPort <= 0 && Constants.proxyPort >= 65536) {
            System.out.println("\n *** Proxy port not specified or incorrectly specified... using 3128 instead");
            Constants.proxyPort = 3128;
        }
        if (Constants.useProxy && Constants.proxyPass != "" && Constants.proxyUser == "") {
            System.out.println("\n *** Password specified, but no user... ignoring password");
            Constants.proxyPass = "";
        }
        if (!Constants.useProxy && Constants.socks) {
            System.out.println("\n *** Cannot enable SOCKS Proxy without host");
            Constants.socks = false;
        }
        Constants.auth_token = newArgs[0];
        m.commandLineArgument = newArgs[1];
        String temp = "";
        int i2 = 0;
        while (i2 < origArgs.length) {
            temp = String.valueOf(temp) + origArgs[i2] + " ";
            ++i2;
        }
        CommandLine.tunnel_log("Arguments Supplied: " + temp);
        if (newArgs.length == 3) {
            Constants.browserStackServer = newArgs[2];
        }
        if (Constants.auth_token.equals("DsVSdoJPBi2z44sbGFx1")) {
            CommandLine.helpAndExit("Invalid Key");
        }
        if (Constants.useProxy) {
            CommandLine.setProxy();
        }
        boolean bl = windows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        if (Constants.localFolder && !m.commandLineArgument.substring(0, 1).equals("/") && !windows) {
            CommandLine.helpAndExit("Please provide absolute path to folder");
        }
        if (!Constants.onlyAutomate && CommandLine.detectExistingTunnel(windows)) {
            boolean killed_other_tunnels = false;
            if (Constants.killOtherTunnels) {
                killed_other_tunnels = CommandLine.killOtherTunnels(windows);
                CommandLine.tunnel_log("Tried to kill tunnels, Killed? " + killed_other_tunnels);
            }
            if (!killed_other_tunnels) {
                CommandLine.helpAndExit("There is another JAR already running. \nPlease quit the same & try again or try running with -force parameter to kill existing local testing connections setup via command line.");
            }
        } else if (!Constants.onlyAutomate) {
            TalkLocalTesting localTestingServer = new TalkLocalTesting();
            Thread thread = new Thread(localTestingServer);
            if (Constants.enableLogging) {
                System.out.println("Trying to start Local Server at " + Constants.localServerPort);
            }
            CommandLine.tunnel_log("Starting Local Server at " + Constants.localServerPort);
            thread.start();
        }
        if (Constants.skipCheckParams) {
            System.out.println("Skipping parameter verification");
        } else {
            System.out.println("Verifying parameters");
        }
        m.createNonAppletSsh();
    }

    public static boolean detectExistingTunnel(boolean isOSWin) {
        String line = new String();
        int running_jar_count = 0;
        try {
            Process p;
            if (isOSWin) {
                p = Runtime.getRuntime().exec("cmd /c \"WMIC path win32_process get Commandline | findstr java | findstr BrowserStackTunnel | findstr .jar | findstr " + Constants.auth_token + " | findstr -v findstr\"");
                p.getOutputStream().close();
            } else {
                p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ps -ef | grep java | grep BrowserStackTunnel | grep .jar | grep " + Constants.auth_token + " | grep -v grep"});
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().equals("")) continue;
                ++running_jar_count;
            }
            input.close();
            p.destroy();
        }
        catch (Exception err) {
            if (Constants.enableLogging) {
                err.printStackTrace();
            }
            CommandLine.tunnel_log("Error Detecting Existing Tunnels: " + err.getMessage());
            CommandLine.helpAndExit(String.valueOf(err.getMessage()) + "\nError while updating jar. Please download updated Jar from http://www.browserstack.com/BrowserStackTunnel.jar & try again.");
        }
        if (running_jar_count > 1) {
            if (isOSWin) {
                return true;
            }
            return !CommandLine.wasJarUpdated();
        }
        return false;
    }

    public static boolean killOtherTunnels(boolean isOSWin) {
        boolean result = true;
        try {
            if (isOSWin) {
                Process p = Runtime.getRuntime().exec("cmd /c \"wmic process where \"commandLine like '%-jar BrowserStackTunnel% %" + Constants.auth_token + "%'\" get ProcessId\"");
                p.getOutputStream().close();
                String line = null;
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    String trimmed_line = line.trim();
                    if (trimmed_line.equals("")) continue;
                    try {
                        if (trimmed_line.equals(Constants.selfPID)) continue;
                        Runtime.getRuntime().exec("cmd /c \"taskkill /F /pid " + trimmed_line + "\"");
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                input.close();
                p.destroy();
            } else {
                Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ps -ef | grep java | grep BrowserStackTunnel | grep .jar | grep " + Constants.auth_token + " | grep -v " + Constants.selfPID + " | grep -v grep | awk '{print $2}' | xargs kill -9"});
            }
        }
        catch (Exception err) {
            if (Constants.enableLogging) {
                err.printStackTrace();
            }
            CommandLine.tunnel_log("Error Killing other Tunnels" + err.getMessage());
            result = false;
        }
        return result;
    }

    public static boolean wasJarUpdated() {
        boolean result = false;
        String line = new String();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ps -ef | grep Browserstack.cmd | grep -v grep"});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().equals("")) continue;
                result = true;
            }
            input.close();
        }
        catch (Exception err) {
            if (Constants.enableLogging) {
                err.printStackTrace();
            }
            CommandLine.tunnel_log("Error Updating Jar: " + err.getMessage());
            CommandLine.helpAndExit(String.valueOf(err.getMessage()) + "\nError while updating jar. Please download updated Jar from http://www.browserstack.com/BrowserStackTunnel.jar & try again.");
        }
        return result;
    }

    public static void reStart() throws IOException {
        block10: {
            Process p;
            String path;
            block9: {
                boolean windows;
                boolean bl = windows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
                if (windows) {
                    System.out.println("There is a new version of BrowserStackTunnel.jar available on server. Please update from : ");
                    System.out.println("http://www.browserstack.com/BrowserStackTunnel.jar\n");
                    System.exit(0);
                }
                CommandLine.tunnel_log("Updating jar file...");
                System.out.println("Updating jar file...");
                path = Request.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                path = path.replace("%20", " ");
                String[] temp = path.split("/");
                String filename = temp[temp.length - 1].split(".jar")[0];
                URL website = new URL("http://" + Constants.browserStackServer + "/BrowserStackTunnel.jar");
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(path.replace(".jar", ".jar1"));
                fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
                fos.close();
                String java = String.valueOf(System.getProperties().getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
                path = path.replace(String.valueOf(filename) + ".jar", "");
                String finalString = "\"" + java + "\" -jar \"" + path + filename + ".jar\"";
                int i = 0;
                while (i < origArgs.length) {
                    finalString = String.valueOf(finalString) + " " + origArgs[i];
                    ++i;
                }
                FileWriter fstream = new FileWriter(String.valueOf(path) + "Browserstack.cmd");
                BufferedWriter out = new BufferedWriter(fstream);
                out.write("rm \"" + path + "Browserstack.cmd\"" + " && mv \"" + path + filename + ".jar1\" \"" + path + filename + ".jar\";");
                out.write("\n");
                out.write(String.valueOf(finalString) + " > /dev/tty");
                out.write("\n");
                out.close();
                path = String.valueOf(path) + "Browserstack.cmd";
                p = Runtime.getRuntime().exec(new String[]{"chmod", "+x", path});
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    if (Constants.extraVerbose) {
                        e.printStackTrace();
                    }
                    if (!Constants.enableLogging) break block9;
                    System.out.println("Caught Exception: " + e.getMessage());
                }
            }
            TalkLocalTesting.close_sockets();
            p = Runtime.getRuntime().exec(new String[]{"sh", path});
            try {
                p.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    System.out.println(line);
                    line = reader.readLine();
                }
            }
            catch (InterruptedException e) {
                if (Constants.extraVerbose) {
                    e.printStackTrace();
                }
                if (!Constants.enableLogging) break block10;
                System.out.println("Caught Exception: " + e.getMessage());
            }
        }
        System.exit(0);
    }

    public static boolean checkConnection() {
        try {
            URI uri = new URI("http", "www.google.com", null, null, null);
            URL log_url = uri.toURL();
            log_url.openStream().close();
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void tunnel_log(String args) {
        block4: {
            if (args.length() > 0) {
                try {
                    URI uri = new URI("http", Constants.browserStackServer, "/terminal/tunnel_log", "key=" + Constants.auth_token + "&trace=" + args, null);
                    URL log_url = uri.toURL();
                    log_url.openStream().close();
                }
                catch (Exception e) {
                    if (Constants.extraVerbose) {
                        System.out.println("Failed to Log to Server");
                        e.printStackTrace();
                    }
                    if (!Constants.enableLogging) break block4;
                    System.out.println("Failed to Log to Server");
                    System.out.println("Caught Exception: " + e.getMessage());
                }
            }
        }
    }

    public static void helpAndExit(String args) {
        if (args.length() > 0) {
            System.out.println("\n *** Error: " + args);
            CommandLine.tunnel_log(args);
        }
        System.out.println("\nConfiguration Options:");
        System.out.println("-v\n\tProvides verbose logging");
        System.out.println("-f\n\tTest local folder rather than internal server");
        System.out.println("-h\n\tPrints this help and exits");
        System.out.println("-force\n\tKill other running Browserstack JARs");
        System.out.println("-onlyAutomate\n\tDisable Live Testing and Screenshots, just test Automate");
        System.out.println("-skipCheck\n\tSkip the checking for the validity of the folder/hosts parameters");
        System.out.println("-proxyHost HOST\n\tHostname/IP of proxy, remaining proxy options are ignored if this option is absent");
        System.out.println("-proxyPort PORT\n\tPort for the proxy, defaults to 3128 when -proxyHost is used");
        System.out.println("-proxyUser USERNAME\n\tUsername for connecting to proxy (Basic Auth Only)");
        System.out.println("-proxyPass PASSWORD\n\tPassword for USERNAME, will be ignored if USERNAME is empty or not specified");
        System.out.println("-socks \n\tUse SOCKSv5 proxy for connection, HTTP proxy will be used by default");
        System.out.println("-tunnelIdentifier SOME_STRING\n\tIf doing multiple tunnels, set this uniquely for different processes.");
        System.out.println("\nTo test an internal server, run:");
        System.out.println("java -jar BrowserStackTunnel.jar <KEY> host1,port1,ssl_flag,host2,port2,ssl_flag...");
        System.out.println("Example:");
        System.out.println("java -jar BrowserStackTunnel.jar DsVSdoJPBi2z44sbGFx1 localhost,3000,0");
        System.out.println("\nTo test HTML files, run:");
        System.out.println("java -jar BrowserStackTunnel.jar -f <KEY> <full path to local folder>");
        System.out.println("Example:");
        System.out.println("java -jar BrowserStackTunnel.jar -f DsVSdoJPBi2z44sbGFx1 /Applications/MAMP/htdocs/example/");
        System.out.println("\nView more configuration options at http://www.browserstack.com/local-testing");
        System.exit(0);
    }

    void createNonAppletSsh() throws IOException {
        HttpServer server;
        if (this.rssh == null) {
            this.rssh = new RSSh();
        }
        this.rssh.setCommandLineClass(this.m);
        if (Constants.localFolder) {
            server = new HttpServer();
            String[] localServers = new String[]{"localhost", "" + ++Constants.httpServerPort, "0"};
            Constants.localServers = localServers;
            String requestString = localServers[0];
            int i = 1;
            while (i < localServers.length) {
                requestString = String.valueOf(requestString) + "," + localServers[i];
                ++i;
            }
            Request.getPort(requestString, "1");
            if (Constants.invalidKey) {
                CommandLine.helpAndExit("You provided an invalid key");
            }
            if (Constants.browserStackUsername.equals("")) {
                CommandLine.helpAndExit("Username is required to test local folders. Go to 'Your Account' > 'Local Testing' tab on the dashboard to set a username.");
            }
            if (!CommandLine.checkIfParamsFine("folder", Constants.httpRoot = this.m.commandLineArgument, null)) {
                CommandLine.helpAndExit("Folder: " + Constants.httpRoot + " doesn't exists!");
            }
            Constants.frontendParams = ",'" + Constants.httpRoot + "'";
            server.setCommandLineClass(this.m);
            CommandLine.tunnel_log("Starting Local folder with :" + Constants.frontendParams);
            if (Constants.enableLogging) {
                System.out.println("Local folder starting");
            }
        } else {
            if (this.commandLineArgument.indexOf(",") == -1 || this.commandLineArgument.replaceAll("[^,]", "").length() < 2) {
                CommandLine.helpAndExit("Invalid value for host_port param");
            }
            String[] hostPorts = this.commandLineArgument.split(",");
            Constants.localServers = hostPorts;
            int i = 0;
            while (i < Constants.localServers.length) {
                block22: {
                    String host = Constants.localServers[i];
                    if (host.indexOf(47) > -1 || host.indexOf(58) > -1) {
                        try {
                            try {
                                host = host.replaceAll("http://", "").replaceAll("https://", "").split("/")[0].split(":")[0];
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                Constants.localServers[i] = host = Constants.localServers[i];
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            Constants.localServers[i] = host;
                            throw throwable;
                        }
                        Constants.localServers[i] = host;
                    }
                }
                if (!CommandLine.checkIfParamsFine("server", Constants.localServers[i + 1], Constants.localServers[i])) {
                    CommandLine.helpAndExit("Could not connect to server: " + Constants.localServers[i] + ":" + Constants.localServers[i + 1]);
                }
                i += 3;
            }
            String fixedCommandlineArgs = CommandLine.join(Constants.localServers, ",");
            Request.getPort(fixedCommandlineArgs, "0");
            if (Constants.invalidKey) {
                CommandLine.helpAndExit("You provided an invalid key");
            }
            System.out.println("Starting local testing");
            this.rssh.init(Constants.tunnelHostServer, Constants.remotePorts, Constants.remoteUserName, Constants.localServers);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        if (this.rssh.session.isConnected()) continue;
                        System.out.println("Session has been disconnected due to bad connection!");
                        System.out.println("Trying to reconnect session!");
                        CommandLine.tunnel_log("Session got disconnected due to bad connection, trying to reconnect with same parameters");
                        this.rssh.init(Constants.tunnelHostServer, Constants.remotePorts, Constants.remoteUserName, Constants.localServers);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        server.init();
    }

    static boolean checkIfParamsFine(String type, String value, String host) {
        return CommandLine.checkIfParamsFine(type, value, host, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkIfParamsFine(String type, String value, String host, int displayError) {
        if (Constants.skipCheckParams && !value.equals(Constants.localServerPort)) {
            return true;
        }
        if (type.compareToIgnoreCase("server") != 0) {
            try {
                File file = new File(value);
                if (!file.exists() || !file.isDirectory()) return false;
                CommandLine.tunnel_log("Checked for " + value + ". Absolute path given.");
                return true;
            }
            catch (Exception file) {
                return false;
            }
        }
        Socket s = new Socket();
        try {
            InetAddress addr = InetAddress.getByName(host);
            InetSocketAddress sockaddr = new InetSocketAddress(addr, Integer.parseInt(value));
            int timeout = 5000;
            s.connect(sockaddr, timeout);
            CommandLine.tunnel_log("Checked for " + host + ":" + value + ". Successfully connected.");
            return true;
        }
        catch (IOException e) {
            CommandLine.tunnel_log("Checked for " + host + ":" + value + ". Got message " + e.getMessage());
            if (displayError == 1) {
                String error_msg = "No one listening on " + host + ":" + value;
                CommandLine.tunnel_log(error_msg);
                System.out.println(error_msg);
            }
            if (Constants.extraVerbose) {
                e.printStackTrace();
            }
            if (!e.getMessage().contains("Connection refused") && !e.getMessage().contains("Verbindungsaufbau abgelehnt") && !e.getMessage().contains("Verbinding is geweigerd") && !e.getMessage().contains("Yhteys torjuttu") && !e.getMessage().contains("Connexion refus") && !e.getMessage().contains("F\u00f6rbindelse v\u00e4gras")) return true;
            return false;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setProxy() {
        if (Constants.proxyUser != "") {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Constants.proxyUser, Constants.proxyPass.toCharArray());
                }
            });
        }
        if (Constants.socks) {
            System.setProperty("socksProxySet", "true");
            System.setProperty("socksProxyHost", Constants.proxyHost);
            System.setProperty("socksProxyPort", String.valueOf(Constants.proxyPort));
            System.setProperty("java.net.socks.username", Constants.proxyUser);
            System.setProperty("java.net.socks.password", Constants.proxyPass);
        } else {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", Constants.proxyHost);
            System.setProperty("http.proxyPort", String.valueOf(Constants.proxyPort));
            System.setProperty("http.proxyUser", Constants.proxyUser);
            System.setProperty("http.proxyPassword", Constants.proxyPass);
        }
    }

    public static String join(String[] arr, String delim) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            result.append(arr[i]);
            if (i < arr.length - 1) {
                result.append(delim);
            }
            ++i;
        }
        return result.toString();
    }
}

