/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JFileChooser;

public class Main
extends Applet
implements Runnable {
    String bufferServer;
    String bufferTunnel;
    Main main;
    boolean inApplet = true;
    String isTunnelAlive = "false";
    String isSshCompleted = "false";
    RSSh rssh;
    HttpServer server;
    Thread httpServer;
    Boolean permissionDenied = null;
    boolean exceptionInCode = false;
    boolean firwallBlocked = false;
    String tunnelExceptionLog = null;
    String appletUnloaded = null;
    private static final long serialVersionUID = 1L;

    @Override
    public void paint(Graphics g) {
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int y = 15;
        if (this.bufferServer != null) {
            g.drawString(this.bufferServer.toString(), 5, 15);
            y = 25;
        }
        if (this.bufferTunnel != null) {
            g.drawString(this.bufferTunnel.toString(), 5, y);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public void init() {
        this.main = this;
        Constants.localFolder = false;
        this.rssh = new RSSh();
        this.rssh.setMainClass(this.main);
        if (this.inApplet) {
            this.setBufferServerString("Applet Loaded");
            this.repaint();
            try {
                AccessController.checkPermission(new SocketPermission("localhost:30327", "listen"));
                AccessController.checkPermission(new SocketPermission("23.23.209.94:22", "connect,accept"));
            }
            catch (AccessControlException e) {
                this.permissionDenied = true;
            }
        }
    }

    public void disConnect() {
        if (this.rssh != null) {
            if (this.rssh.session != null) {
                System.out.println("Disconnecting session..by us..");
                this.rssh.logger.log(2, "Disconnecting session..by us..");
                try {
                    this.rssh.session.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.rssh = new RSSh();
            this.rssh.setMainClass(this.main);
        }
        if (this.server != null) {
            try {
                this.server.server_socket.close();
                this.httpServer.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        this.appletUnloaded = "true";
        System.out.println("unloading applet... ");
        this.disConnect();
    }

    public void createPrivTunnel() {
        this.exceptionInCode = false;
        this.disConnect();
        this.isSshCompleted = "false";
        this.enableLogging();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Main.this.httpServer = new Thread(Main.this.main);
                Main.this.httpServer.start();
                return null;
            }
        });
    }

    public void startLocalServer() {
        this.server = new HttpServer();
        String[] localServers = new String[]{"localhost", "" + Constants.httpServerPort, "0"};
        Constants.localServers = localServers;
        this.server.setMainClass(this);
        this.server.init();
    }

    public void createTunnel() {
        if (this.rssh == null) {
            this.rssh = new RSSh();
        }
        this.rssh.setMainClass(this.main);
        this.rssh.init(Constants.tunnelHostServer, Constants.remotePorts, Constants.remoteUserName, Constants.localServers);
    }

    public void setBufferServerString(String string) {
        this.bufferServer = string;
    }

    @Override
    public void run() {
        if (Constants.localFolder) {
            this.startLocalServer();
        } else {
            this.createTunnel();
        }
    }

    public void setBufferTunnelString(String string) {
        this.bufferTunnel = string;
    }

    public void askHttpRoot() {
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    int file = fc.showOpenDialog(Main.this.main);
                    if (file == 0) {
                        String path;
                        Constants.httpRoot = path = fc.getSelectedFile().getAbsolutePath();
                        return path;
                    }
                }
                catch (Exception e) {
                    Main.this.permissionDenied = true;
                }
                return null;
            }
        });
    }

    public String isError() {
        return "appletDenied=" + this.permissionDenied + ", codeException=" + this.exceptionInCode + ", firewallBlocked=" + this.firwallBlocked;
    }

    public String isSshConnected() {
        return this.isSshCompleted;
    }

    public void setSSHKey(String ssh_key) {
        Constants.sshKey = ssh_key;
    }

    public String isTunnelAlive() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                Main.this.isTunnelAlive = Main.this.rssh != null && Main.this.rssh.isConnected() ? "true" : "false";
                return Main.this.isTunnelAlive;
            }
        });
    }

    public String isTunnelAliveSync() {
        return this.isTunnelAlive;
    }

    public void setSshTimeout(int t) {
        Constants.sshTimeout = t;
    }

    public String checkIfParamsFine(final String type, final String value, final String host) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public String run() {
                if (type.compareToIgnoreCase("server") != 0) {
                    try {
                        File file = new File(value);
                        if (!file.exists() || !file.isDirectory()) return "false";
                        return "true";
                    }
                    catch (Exception file) {
                        return "false";
                    }
                }
                Socket s = new Socket();
                try {
                    System.out.println("checking values : " + host + " : " + value);
                    InetAddress addr = InetAddress.getByName(host);
                    InetSocketAddress sockaddr = new InetSocketAddress(addr, Integer.parseInt(value));
                    int timeout = 3000;
                    s.connect(sockaddr, timeout);
                    return "true";
                }
                catch (IOException e) {
                    System.out.println(host);
                    System.out.println(value);
                    if (!e.getMessage().contains("Connection refused")) return "true";
                    return "false";
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    public String getHttpRoot() {
        return Constants.httpRoot;
    }

    public long getSuccessTime() {
        return Constants.timeofconnection;
    }

    public void setHttpRoot(String value) {
        Constants.httpRoot = value;
    }

    public void setLocalPort(int port) {
        Constants.httpServerPort = port;
    }

    public void setLocalServers(String[] args) {
        Constants.localServers = args;
        Constants.localFolder = false;
    }

    public void setRemotePort(int port) {
        Constants.remotePort = port;
    }

    public void setRemotePorts(String[] args) {
        Constants.remotePorts = args;
    }

    public void enableLogging() {
        Constants.enableLogging = true;
    }

    public String getExceptionLog() {
        return this.tunnelExceptionLog;
    }

    public String isAppletUnloaded() {
        return this.appletUnloaded;
    }

    public void setExceptionLog() {
        this.tunnelExceptionLog = null;
    }

    public void setHttpServer() {
        Constants.localFolder = true;
    }

    public void setTunnelHostServer(String host) {
        Constants.tunnelHostServer = host;
    }

    public String getLocalServers() {
        return Constants.localServers.toString();
    }

    public String getLogData() {
        return RSSh.MyLogger.getData();
    }
}

