/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TalkLocalTesting
implements Runnable {
    static ServerSocket server_socket;
    static Socket socket;

    @Override
    public void run() {
        try {
            if (CommandLine.checkIfParamsFine("server", Constants.localServerPort, "localhost", 0)) {
                CommandLine.helpAndExit("Either another local testing connection via command line is running on your machine or some server is listening on port " + Constants.localServerPort);
            }
            server_socket = new ServerSocket(Integer.parseInt(Constants.localServerPort));
            if (Constants.enableLogging) {
                System.out.println("Started background local server...");
            }
            CommandLine.tunnel_log("Started background local server...");
            while (true) {
                socket = server_socket.accept();
                try {
                    integrationWithBrowser request = new integrationWithBrowser(socket);
                    Thread thread = new Thread(request);
                    thread.start();
                }
                catch (Exception e) {
                    if (!Constants.extraVerbose) continue;
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e1) {
            if (Constants.extraVerbose) {
                e1.printStackTrace();
            }
            return;
        }
    }

    public static void close_sockets() throws IOException {
        if (socket != null) {
            socket.close();
        }
        if (server_socket != null) {
            server_socket.close();
        }
    }
}

