// Generated by CoffeeScript 2.0.0-beta4
void function () {
  var DEFAULT_REPORT_FORMAT, existsSync, fs, ibrik, istanbul, mkdirp, Module, path, which;
  Module = require('module');
  fs = require('fs');
  path = require('path');
  ibrik = require('./ibrik');
  istanbul = require('istanbul');
  mkdirp = require('mkdirp');
  which = require('which');
  existsSync = fs.existsSync || path.existsSync;
  DEFAULT_REPORT_FORMAT = 'lcov';
  module.exports = function (opts, callback) {
    var args, cache$, cmd, e, excludes, file, reportClassName, reportingDir, reports, runFn;
    cache$ = opts._;
    cmd = cache$[0];
    file = cache$[1];
    args = 3 <= cache$.length ? [].slice.call(cache$, 2) : [];
    if (!file)
      return callback('Need a filename argument for the ' + cmd + ' command!');
    if (!existsSync(file)) {
      try {
        file = which.sync(file);
      } catch (e$) {
        e = e$;
        return callback('Unable to resolve file [' + file + ']');
      }
    } else {
      file = path.resolve(file);
    }
    excludes = [];
    if (!(null != opts['default-excludes']) || opts['default-excludes'])
      excludes = [
        '**/node_modules/**',
        '**/test/**',
        '**/tests/**'
      ];
    reportingDir = opts.dir || path.resolve(process.cwd(), 'coverage');
    mkdirp.sync(reportingDir);
    reportClassName = opts.report || DEFAULT_REPORT_FORMAT;
    reports = [istanbul.Report.create(reportClassName, { dir: reportingDir })];
    runFn = function () {
      process.argv = [
        'node',
        file
      ].concat([].slice.call(args));
      if (opts.verbose)
        console.log('Running: ' + process.argv.join(' '));
      process.env.running_under_istanbul = 1;
      return Module.runMain(file, null, true);
    };
    if (!(opts.print === 'none'))
      switch (opts.print) {
      case 'detail':
        reports.push(istanbul.Report.create('text'));
        break;
      case 'both':
        reports.push(istanbul.Report.create('text'));
        reports.push(istanbul.Report.create('text-summary'));
        break;
      default:
        reports.push(istanbul.Report.create('text-summary'));
      }
    return istanbul.matcherFor({
      root: opts.root || process.cwd(),
      includes: ['**/*.coffee'],
      excludes: excludes
    }, function (err, matchFn) {
      var coverageVar, hookOpts, instrumenter, transformer;
      if (err)
        return callback(err);
      coverageVar = '$$cov_' + Date.now() + '$$';
      instrumenter = new ibrik.Instrumenter({ coverageVariable: coverageVar });
      transformer = instrumenter.instrumentSync.bind(instrumenter);
      hookOpts = { verbose: opts.verbose };
      if (opts['self-test'])
        ibrik.hook.unloadRequireCache(matchFn);
      ibrik.hook.hookRequire(matchFn, transformer, hookOpts);
      process.once('exit', function () {
        var collector, cov, report;
        file = path.resolve(reportingDir, 'coverage.json');
        if (!(null != global[coverageVar])) {
          return callback('No coverage information was collected, exit without writing coverage information');
        } else {
          cov = global[coverageVar];
        }
        mkdirp.sync(reportingDir);
        console.log('=============================================================================');
        console.log('Writing coverage object [' + file + ']');
        fs.writeFileSync(file, JSON.stringify(cov), 'utf8');
        collector = new istanbul.Collector;
        collector.add(cov);
        console.log('Writing coverage reports at [' + reportingDir + ']');
        console.log('=============================================================================');
        for (var i$ = 0, length$ = reports.length; i$ < length$; ++i$) {
          report = reports[i$];
          report.writeReport(collector, true);
        }
        return callback();
      });
      return runFn();
    });
  };
}.call(this);
