// Generated by CoffeeScript 2.0.0-beta4
var beingDeclared, cleanMarkers, concat, concatMap, CS, difference, envEnrichments, envEnrichments_, foldl, humanReadable, map, nub, numberLines, pointToErrorLocation, usedAsExpression, usedAsExpression_;
cache$ = require('./functional-helpers');
concat = cache$.concat;
concatMap = cache$.concatMap;
difference = cache$.difference;
foldl = cache$.foldl;
map = cache$.map;
nub = cache$.nub;
CS = require('./nodes');
this.numberLines = numberLines = function (input, startLine) {
  var lines, numbered, padSize;
  if (null == startLine)
    startLine = 1;
  lines = input.split('\n');
  padSize = ('' + (lines.length + startLine - 1)).length;
  numbered = function (accum$) {
    var currLine, i, line, pad;
    for (var i$ = 0, length$ = lines.length; i$ < length$; ++i$) {
      line = lines[i$];
      i = i$;
      currLine = '' + (i + startLine);
      pad = Array(padSize + 1).join('0').slice(currLine.length);
      accum$.push('' + pad + currLine + ' : ' + lines[i]);
    }
    return accum$;
  }.call(this, []);
  return numbered.join('\n');
};
cleanMarkers = function (str) {
  return str.replace(/[\uEFEF\uEFFE\uEFFF]/g, '');
};
this.humanReadable = humanReadable = function (str) {
  return str.replace(/\uEFEF/g, '(INDENT)').replace(/\uEFFE/g, '(DEDENT)').replace(/\uEFFF/g, '(TERM)');
};
this.formatParserError = function (input, e) {
  var found, message, realColumn, unicode;
  realColumn = cleanMarkers(('' + input.split('\n')[e.line - 1] + '\n').slice(0, e.column)).length;
  if (!(null != e.found))
    return 'Syntax error on line ' + e.line + ', column ' + realColumn + ': unexpected end of input';
  found = JSON.stringify(humanReadable(e.found));
  found = found.replace(/^"|"$/g, '').replace(/'/g, "\\'").replace(/\\"/g, '"');
  unicode = e.found.charCodeAt(0).toString(16).toUpperCase();
  unicode = '\\u' + '0000'.slice(unicode.length) + unicode;
  message = 'Syntax error on line ' + e.line + ', column ' + realColumn + ": unexpected '" + found + "' (" + unicode + ')';
  return '' + message + '\n' + pointToErrorLocation(input, e.line, realColumn);
};
this.pointToErrorLocation = pointToErrorLocation = function (source, line, column, numLinesOfContext) {
  var currentLineOffset, lines, numberedLines, padSize, postLines, preLines, startLine;
  if (null == numLinesOfContext)
    numLinesOfContext = 3;
  lines = source.split('\n');
  currentLineOffset = line - 1;
  startLine = currentLineOffset - numLinesOfContext;
  if (startLine < 0)
    startLine = 0;
  preLines = lines.slice(startLine, +currentLineOffset + 1 || 9e9);
  postLines = lines.slice(currentLineOffset + 1, +(currentLineOffset + numLinesOfContext) + 1 || 9e9);
  numberedLines = numberLines(cleanMarkers([].slice.call(preLines).concat([].slice.call(postLines)).join('\n')), startLine + 1).split('\n');
  preLines = numberedLines.slice(0, preLines.length);
  postLines = numberedLines.slice(preLines.length);
  column = cleanMarkers(('' + lines[currentLineOffset] + '\n').slice(0, column)).length;
  padSize = (currentLineOffset + 1 + postLines.length).toString(10).length;
  return [].slice.call(preLines).concat(['' + Array(padSize + 1).join('^') + ' :~' + Array(column).join('~') + '^'], [].slice.call(postLines)).join('\n');
};
this.beingDeclared = beingDeclared = function (assignment) {
  switch (false) {
  case !!(null != assignment):
    return [];
  case !assignment['instanceof'](CS.Identifiers):
    return [assignment.data];
  case !assignment['instanceof'](CS.Rest):
    return beingDeclared(assignment.expression);
  case !assignment['instanceof'](CS.MemberAccessOps):
    return [];
  case !assignment['instanceof'](CS.DefaultParam):
    return beingDeclared(assignment.param);
  case !assignment['instanceof'](CS.ArrayInitialiser):
    return concatMap(assignment.members, beingDeclared);
  case !assignment['instanceof'](CS.ObjectInitialiser):
    return concatMap(assignment.vals(), beingDeclared);
  default:
    throw new Error('beingDeclared: Non-exhaustive patterns in case: ' + assignment.className);
  }
};
this.declarationsFor = function (node, inScope) {
  var vars;
  vars = envEnrichments(node, inScope);
  return foldl(new CS.Undefined().g(), vars, function (expr, v) {
    return new CS.AssignOp(new CS.Identifier(v).g(), expr).g();
  });
};
usedAsExpression_ = function (ancestors) {
  var grandparent, parent;
  parent = ancestors[0];
  grandparent = ancestors[1];
  switch (false) {
  case !!(null != parent):
    return true;
  case !parent['instanceof'](CS.Program, CS.Class):
    return false;
  case !parent['instanceof'](CS.SeqOp):
    return this === parent.right && usedAsExpression(parent, ancestors.slice(1));
  case !(parent['instanceof'](CS.Block) && parent.statements.indexOf(this) !== parent.statements.length - 1):
    return false;
  case !(parent['instanceof'](CS.Functions) && parent.body === this && null != grandparent && grandparent['instanceof'](CS.Constructor)):
    return false;
  default:
    return true;
  }
};
this.usedAsExpression = usedAsExpression = function (node, ancestors) {
  return usedAsExpression_.call(node, ancestors);
};
envEnrichments_ = function (inScope) {
  var possibilities;
  if (null == inScope)
    inScope = [];
  possibilities = function () {
    var this$, this$1;
    switch (false) {
    case !this['instanceof'](CS.AssignOp):
      return nub(beingDeclared(this.assignee));
    case !this['instanceof'](CS.Class):
      return nub(concat([
        beingDeclared(this.nameAssignee),
        envEnrichments(this.parent),
        'undefined' !== typeof name && null != name ? [name] : []
      ]));
    case !this['instanceof'](CS.ForIn, CS.ForOf):
      return nub(concat([
        concatMap(this.childNodes, (this$ = this, function (child) {
          if (in$(child, this$.listMembers)) {
            return concatMap(this$[child], function (m) {
              return envEnrichments(m, inScope);
            });
          } else {
            return envEnrichments(this$[child], inScope);
          }
        })),
        beingDeclared(this.keyAssignee),
        beingDeclared(this.valAssignee)
      ]));
    case !this['instanceof'](CS.Functions):
      return [];
    default:
      return nub(concatMap(this.childNodes, (this$1 = this, function (child) {
        if (in$(child, this$1.listMembers)) {
          return concatMap(this$1[child], function (m) {
            return envEnrichments(m, inScope);
          });
        } else {
          return envEnrichments(this$1[child], inScope);
        }
      })));
    }
  }.call(this);
  return difference(possibilities, inScope);
};
this.envEnrichments = envEnrichments = function (node, args) {
  args = 2 <= arguments.length ? [].slice.call(arguments, 1) : [];
  if (null != node) {
    return envEnrichments_.apply(node, args);
  } else {
    return [];
  }
};
function in$(member, list) {
  for (var i = 0, length = list.length; i < length; ++i)
    if (i in list && list[i] === member)
      return true;
  return false;
}
