module.exports = (function(){
  /*
   * Generated by PEG.js 0.7.0.
   *
   * http://pegjs.majda.cz/
   */
  
  function subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }
  
  function quote(s) {
    /*
     * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
     * string literal except for the closing quote character, backslash,
     * carriage return, line separator, paragraph separator, and line feed.
     * Any character may appear in the form of an escape sequence.
     *
     * For portability, we also escape escape all control and non-ASCII
     * characters. Note that "\0" and "\v" escape sequences are not used
     * because JSHint does not like the first and IE the second.
     */
     return '"' + s
      .replace(/\\/g, '\\\\')  // backslash
      .replace(/"/g, '\\"')    // closing quote character
      .replace(/\x08/g, '\\b') // backspace
      .replace(/\t/g, '\\t')   // horizontal tab
      .replace(/\n/g, '\\n')   // line feed
      .replace(/\f/g, '\\f')   // form feed
      .replace(/\r/g, '\\r')   // carriage return
      .replace(/[\x00-\x07\x0B\x0E-\x1F\x80-\uFFFF]/g, escape)
      + '"';
  }
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successful,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    parse: function(input) {
      var parseFunctions = {
        "program": parse_program
      };
      
      var options = arguments.length > 1 ? arguments[1] : {},
          startRule;
      
      if (options.startRule !== undefined) {
        startRule = options.startRule;
        
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Can't start parsing from rule " + quote(startRule) + ".");
        }
      } else {
        startRule = "program";
      }
      
      var pos = 0;
      var reportedPos = 0;
      var cachedReportedPos = 0;
      var cachedReportedPosDetails = { line: 1, column: 1, seenCR: false };
      var reportFailures = 0;
      var rightmostFailuresPos = 0;
      var rightmostFailuresExpected = [];
      var cache = {};
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        var escapeChar;
        var length;
        
        if (charCode <= 0xFF) {
          escapeChar = 'x';
          length = 2;
        } else {
          escapeChar = 'u';
          length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function computeReportedPosDetails() {
        function advanceCachedReportedPos() {
          var ch;
          
          for (; cachedReportedPos < reportedPos; cachedReportedPos++) {
            ch = input.charAt(cachedReportedPos);
            if (ch === "\n") {
              if (!cachedReportedPosDetails.seenCR) { cachedReportedPosDetails.line++; }
              cachedReportedPosDetails.column = 1;
              cachedReportedPosDetails.seenCR = false;
            } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
              cachedReportedPosDetails.line++;
              cachedReportedPosDetails.column = 1;
              cachedReportedPosDetails.seenCR = true;
            } else {
              cachedReportedPosDetails.column++;
              cachedReportedPosDetails.seenCR = false;
            }
          }
        }
        
        if (cachedReportedPos !== reportedPos) {
          if (cachedReportedPos > reportedPos) {
            cachedReportedPos = 0;
            cachedReportedPosDetails = { line: 1, column: 1, seenCR: false };
          }
          advanceCachedReportedPos();
        }
        
        return cachedReportedPosDetails;
      }
      
      function text() {
        return input.substring(reportedPos, pos);
      }
      
      function offset() {
        return reportedPos;
      }
      
      function line() {
        return computeReportedPosDetails().line;
      }
      
      function column() {
        return computeReportedPosDetails().column;
      }
      
      function matchFailed(failure) {
        if (pos < rightmostFailuresPos) {
          return;
        }
        
        if (pos > rightmostFailuresPos) {
          rightmostFailuresPos = pos;
          rightmostFailuresExpected = [];
        }
        
        rightmostFailuresExpected.push(failure);
      }
      
      function parse_program() {
        var cacheKey = "program@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_toplevelBlock();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(leader, b) {
              return rp(new CS.Program(b || null));
            })(r3, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_toplevelBlock() {
        var cacheKey = "toplevelBlock@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_toplevelStatement();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r8 = parse_TERMINATOR();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_toplevelStatement();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_toplevelStatement();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(s, ss) {
              return rp(new CS.Block([s].concat(ss.map(function(s){ return s[3]; }))));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_toplevelStatement() {
        var cacheKey = "toplevelStatement@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        reportFailures++;
        r3 = parse_return();
        if (r3 === null) {
          r3 = parse_continue();
          if (r3 === null) {
            r3 = parse_break();
          }
        }
        reportFailures--;
        if (r3 === null) {
          r3 = "";
        } else {
          r3 = null;
          pos = r4;
        }
        if (r3 !== null) {
          r4 = parse_statement();
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(s) { return s; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_block() {
        var cacheKey = "block@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_statement();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r8 = parse_TERMINATOR();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_statement();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_statement();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(s, ss) {
              return rp(new CS.Block([s].concat(ss.map(function(s){ return s[3]; }))));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_statement() {
        var cacheKey = "statement@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_expression();
        if (r0 === null) {
          r0 = parse_return();
          if (r0 === null) {
            r0 = parse_continue();
            if (r0 === null) {
              r0 = parse_break();
              if (r0 === null) {
                r0 = parse_throw();
                if (r0 === null) {
                  r0 = parse_debugger();
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_expression() {
        var cacheKey = "expression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_expressionworthy();
        if (r0 === null) {
          r0 = parse_seqExpression();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryStatement() {
        var cacheKey = "secondaryStatement@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_secondaryExpression();
        if (r0 === null) {
          r0 = parse_return();
          if (r0 === null) {
            r0 = parse_continue();
            if (r0 === null) {
              r0 = parse_break();
              if (r0 === null) {
                r0 = parse_throw();
                if (r0 === null) {
                  r0 = parse_debugger();
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryExpression() {
        var cacheKey = "secondaryExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_expressionworthy();
        if (r0 === null) {
          r0 = parse_assignmentExpression();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryExpressionNoImplicitObjectCall() {
        var cacheKey = "secondaryExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_expressionworthy();
        if (r0 === null) {
          r0 = parse_assignmentExpressionNoImplicitObjectCall();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_expressionworthy() {
        var cacheKey = "expressionworthy@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_functionLiteral();
        if (r0 === null) {
          r0 = parse_conditional();
          if (r0 === null) {
            r0 = parse_while();
            if (r0 === null) {
              r0 = parse_loop();
              if (r0 === null) {
                r0 = parse_try();
                if (r0 === null) {
                  r0 = parse_forOf();
                  if (r0 === null) {
                    r0 = parse_forIn();
                    if (r0 === null) {
                      r0 = parse_class();
                      if (r0 === null) {
                        r0 = parse_switch();
                        if (r0 === null) {
                          r0 = parse_implicitObjectLiteral();
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_seqExpression() {
        var cacheKey = "seqExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_postfixControlFlowExpression();
        if (r3 !== null) {
          r5 = pos;
          r6 = parse__();
          if (r6 !== null) {
            if (input.charCodeAt(pos) === 59) {
              r7 = ";";
              pos++;
            } else {
              r7 = null;
              if (reportFailures === 0) {
                matchFailed("\";\"");
              }
            }
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              r8 = r8 !== null ? r8 : "";
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_expression();
                  if (r10 !== null) {
                    r4 = [r6, r7, r8, r9, r10];
                  } else {
                    r4 = null;
                    pos = r5;
                  }
                } else {
                  r4 = null;
                  pos = r5;
                }
              } else {
                r4 = null;
                pos = r5;
              }
            } else {
              r4 = null;
              pos = r5;
            }
          } else {
            r4 = null;
            pos = r5;
          }
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, right) {
              if(!right) return left;
              return rp(new CS.SeqOp(left, right[4]));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_postfixControlFlowExpression() {
        var cacheKey = "postfixControlFlowExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_secondaryStatement();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r8 = parse_postfixControlFlowOp();
            if (r8 !== null) {
              r5 = [r7, r8];
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_postfixControlFlowOp();
              if (r8 !== null) {
                r5 = [r7, r8];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(expr, postfixes) {
              return foldl(function(expr, postfixContainer){
                var constructor, cond,
                    postfix = postfixContainer[1],
                    indicator = postfix.type;
                switch(indicator){
                  case 'if':
                  case 'unless':
                    constructor = ('unless' === indicator) ? CS.NegatedConditional : CS.Conditional;
                    cond = ('unless' === indicator) ? new CS.LogicalNotOp(postfix.cond).g() : postfix.cond;
                    return rp(new constructor(cond, expr, null));
                  case 'while':
                  case 'until':
                    constructor = ('unless' === indicator) ? CS.NegatedWhile : CS.While;
                    cond = ('unless' === indicator) ? new CS.LogicalNotOp(postfix.cond).g() : postfix.cond;
                    return rp(new constructor(cond, expr));
                  case 'for-in':
                    return rp(new CS.ForIn(postfix.val, postfix.key, postfix.list, postfix.step, postfix.filter, expr));
                  case 'for-of':
                    return rp(new CS.ForOf(postfix.own, postfix.key, postfix.val, postfix.obj, postfix.filter, expr));
                }
              }, expr, postfixes)
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_postfixControlFlowOp() {
        var cacheKey = "postfixControlFlowOp@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14, r15, r16, r17;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_IF();
        if (r3 === null) {
          r3 = parse_UNLESS();
        }
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_assignmentExpression();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(kw, e) { return {type: kw, cond: e}; })(r3, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_WHILE();
          if (r3 === null) {
            r3 = parse_UNTIL();
          }
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_assignmentExpression();
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(kw, e) { return {type: kw, cond: e}; })(r3, r5);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = parse_FOR();
            if (r3 !== null) {
              r4 = parse__();
              if (r4 !== null) {
                r5 = parse_Assignable();
                if (r5 !== null) {
                  r6 = parse__();
                  if (r6 !== null) {
                    r8 = pos;
                    if (input.charCodeAt(pos) === 44) {
                      r9 = ",";
                      pos++;
                    } else {
                      r9 = null;
                      if (reportFailures === 0) {
                        matchFailed("\",\"");
                      }
                    }
                    if (r9 !== null) {
                      r10 = parse__();
                      if (r10 !== null) {
                        r11 = parse_Assignable();
                        if (r11 !== null) {
                          r12 = parse__();
                          if (r12 !== null) {
                            r7 = [r9, r10, r11, r12];
                          } else {
                            r7 = null;
                            pos = r8;
                          }
                        } else {
                          r7 = null;
                          pos = r8;
                        }
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                    r7 = r7 !== null ? r7 : "";
                    if (r7 !== null) {
                      r8 = parse_IN();
                      if (r8 !== null) {
                        r9 = parse__();
                        if (r9 !== null) {
                          r10 = parse_assignmentExpression();
                          if (r10 !== null) {
                            r12 = pos;
                            r13 = parse__();
                            if (r13 !== null) {
                              r14 = parse_BY();
                              if (r14 !== null) {
                                r15 = parse__();
                                if (r15 !== null) {
                                  r16 = parse_assignmentExpression();
                                  if (r16 !== null) {
                                    r11 = [r13, r14, r15, r16];
                                  } else {
                                    r11 = null;
                                    pos = r12;
                                  }
                                } else {
                                  r11 = null;
                                  pos = r12;
                                }
                              } else {
                                r11 = null;
                                pos = r12;
                              }
                            } else {
                              r11 = null;
                              pos = r12;
                            }
                            r11 = r11 !== null ? r11 : "";
                            if (r11 !== null) {
                              r13 = pos;
                              r14 = parse__();
                              if (r14 !== null) {
                                r15 = parse_WHEN();
                                if (r15 !== null) {
                                  r16 = parse__();
                                  if (r16 !== null) {
                                    r17 = parse_assignmentExpression();
                                    if (r17 !== null) {
                                      r12 = [r14, r15, r16, r17];
                                    } else {
                                      r12 = null;
                                      pos = r13;
                                    }
                                  } else {
                                    r12 = null;
                                    pos = r13;
                                  }
                                } else {
                                  r12 = null;
                                  pos = r13;
                                }
                              } else {
                                r12 = null;
                                pos = r13;
                              }
                              r12 = r12 !== null ? r12 : "";
                              if (r12 !== null) {
                                r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12];
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(val, maybeKey, list, maybeStep, maybeFilter) {
                    var key = maybeKey ? maybeKey[2] : null,
                        step = maybeStep ? maybeStep[3] : new CS.Int(1).r('1').g(),
                        filter = maybeFilter ? maybeFilter[3] : null;
                    return 0,
                      { type: 'for-in'
                      , val: val, key: key, list: list, step: step, filter: filter
                      };
                  })(r5, r7, r10, r11, r12);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              r3 = parse_FOR();
              if (r3 !== null) {
                r4 = parse__();
                if (r4 !== null) {
                  r6 = pos;
                  r7 = parse_OWN();
                  if (r7 !== null) {
                    r8 = parse__();
                    if (r8 !== null) {
                      r5 = [r7, r8];
                    } else {
                      r5 = null;
                      pos = r6;
                    }
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                  r5 = r5 !== null ? r5 : "";
                  if (r5 !== null) {
                    r6 = parse_Assignable();
                    if (r6 !== null) {
                      r7 = parse__();
                      if (r7 !== null) {
                        r9 = pos;
                        if (input.charCodeAt(pos) === 44) {
                          r10 = ",";
                          pos++;
                        } else {
                          r10 = null;
                          if (reportFailures === 0) {
                            matchFailed("\",\"");
                          }
                        }
                        if (r10 !== null) {
                          r11 = parse__();
                          if (r11 !== null) {
                            r12 = parse_Assignable();
                            if (r12 !== null) {
                              r13 = parse__();
                              if (r13 !== null) {
                                r8 = [r10, r11, r12, r13];
                              } else {
                                r8 = null;
                                pos = r9;
                              }
                            } else {
                              r8 = null;
                              pos = r9;
                            }
                          } else {
                            r8 = null;
                            pos = r9;
                          }
                        } else {
                          r8 = null;
                          pos = r9;
                        }
                        r8 = r8 !== null ? r8 : "";
                        if (r8 !== null) {
                          r9 = parse_OF();
                          if (r9 !== null) {
                            r10 = parse__();
                            if (r10 !== null) {
                              r11 = parse_assignmentExpression();
                              if (r11 !== null) {
                                r13 = pos;
                                r14 = parse__();
                                if (r14 !== null) {
                                  r15 = parse_WHEN();
                                  if (r15 !== null) {
                                    r16 = parse__();
                                    if (r16 !== null) {
                                      r17 = parse_assignmentExpression();
                                      if (r17 !== null) {
                                        r12 = [r14, r15, r16, r17];
                                      } else {
                                        r12 = null;
                                        pos = r13;
                                      }
                                    } else {
                                      r12 = null;
                                      pos = r13;
                                    }
                                  } else {
                                    r12 = null;
                                    pos = r13;
                                  }
                                } else {
                                  r12 = null;
                                  pos = r13;
                                }
                                r12 = r12 !== null ? r12 : "";
                                if (r12 !== null) {
                                  r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12];
                                } else {
                                  r0 = null;
                                  pos = r2;
                                }
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function(maybeOwn, key, maybeVal, obj, maybeFilter) {
                      var own = !!maybeOwn,
                          val = maybeVal ? maybeVal[2] : null,
                          filter = maybeFilter ? maybeFilter[3] : null;
                      return 0,
                        { type: 'for-of'
                        , own: own, key: key, val: val, obj: obj, filter: filter
                        };
                    })(r5, r6, r8, r11, r12);
              }
              if (r0 === null) {
                pos = r1;
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_assignmentExpression() {
        var cacheKey = "assignmentExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_assignmentOp();
        if (r0 === null) {
          r0 = parse_compoundAssignmentOp();
          if (r0 === null) {
            r0 = parse_existsAssignmentOp();
            if (r0 === null) {
              r0 = parse_binaryExpression();
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_assignmentOp() {
        var cacheKey = "assignmentOp@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_Assignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 61) {
              r5 = "=";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (r5 !== null) {
              r7 = pos;
              reportFailures++;
              if (input.charCodeAt(pos) === 61) {
                r6 = "=";
                pos++;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("\"=\"");
                }
              }
              reportFailures--;
              if (r6 === null) {
                r6 = "";
              } else {
                r6 = null;
                pos = r7;
              }
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_secondaryExpression();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return e; })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_secondaryExpression();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return e; })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, right) {
                return rp(new CS.AssignOp(left, right));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_compoundAssignmentOp() {
        var cacheKey = "compoundAssignmentOp@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CompoundAssignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r6 = pos;
            reportFailures++;
            if (input.charCodeAt(pos) === 63) {
              r5 = "?";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"?\"");
              }
            }
            reportFailures--;
            if (r5 === null) {
              r5 = "";
            } else {
              r5 = null;
              pos = r6;
            }
            if (r5 !== null) {
              r6 = parse_CompoundAssignmentOperators();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 61) {
                  r7 = "=";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"=\"");
                  }
                }
                if (r7 !== null) {
                  r9 = pos;
                  r10 = pos;
                  r11 = parse_TERMINDENT();
                  if (r11 !== null) {
                    r12 = parse_secondaryExpression();
                    if (r12 !== null) {
                      r13 = parse_DEDENT();
                      if (r13 !== null) {
                        r8 = [r11, r12, r13];
                      } else {
                        r8 = null;
                        pos = r10;
                      }
                    } else {
                      r8 = null;
                      pos = r10;
                    }
                  } else {
                    r8 = null;
                    pos = r10;
                  }
                  if (r8 !== null) {
                    reportedPos = r9;
                    r8 = (function(e) { return e; })(r12);
                  }
                  if (r8 === null) {
                    pos = r9;
                  }
                  if (r8 === null) {
                    r9 = pos;
                    r10 = pos;
                    r11 = parse_TERMINATOR();
                    r11 = r11 !== null ? r11 : "";
                    if (r11 !== null) {
                      r12 = parse__();
                      if (r12 !== null) {
                        r13 = parse_secondaryExpression();
                        if (r13 !== null) {
                          r8 = [r11, r12, r13];
                        } else {
                          r8 = null;
                          pos = r10;
                        }
                      } else {
                        r8 = null;
                        pos = r10;
                      }
                    } else {
                      r8 = null;
                      pos = r10;
                    }
                    if (r8 !== null) {
                      reportedPos = r9;
                      r8 = (function(e) { return e; })(r13);
                    }
                    if (r8 === null) {
                      pos = r9;
                    }
                  }
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, op, right) {
                return rp(new CS.CompoundAssignOp(constructorLookup[op].prototype.className, left, right));
              })(r3, r6, r8);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CompoundAssignmentOperators() {
        var cacheKey = "CompoundAssignmentOperators@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        if (input.substr(pos, 2) === "&&") {
          r0 = "&&";
          pos += 2;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"&&\"");
          }
        }
        if (r0 === null) {
          r0 = parse_AND();
          if (r0 === null) {
            if (input.substr(pos, 2) === "||") {
              r0 = "||";
              pos += 2;
            } else {
              r0 = null;
              if (reportFailures === 0) {
                matchFailed("\"||\"");
              }
            }
            if (r0 === null) {
              r0 = parse_OR();
              if (r0 === null) {
                if (input.substr(pos, 2) === "**") {
                  r0 = "**";
                  pos += 2;
                } else {
                  r0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"**\"");
                  }
                }
                if (r0 === null) {
                  if (/^[?&\^|*\/%]/.test(input.charAt(pos))) {
                    r0 = input.charAt(pos);
                    pos++;
                  } else {
                    r0 = null;
                    if (reportFailures === 0) {
                      matchFailed("[?&\\^|*\\/%]");
                    }
                  }
                  if (r0 === null) {
                    r2 = pos;
                    if (input.charCodeAt(pos) === 43) {
                      r3 = "+";
                      pos++;
                    } else {
                      r3 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"+\"");
                      }
                    }
                    if (r3 !== null) {
                      r5 = pos;
                      reportFailures++;
                      if (input.charCodeAt(pos) === 43) {
                        r4 = "+";
                        pos++;
                      } else {
                        r4 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"+\"");
                        }
                      }
                      reportFailures--;
                      if (r4 === null) {
                        r4 = "";
                      } else {
                        r4 = null;
                        pos = r5;
                      }
                      if (r4 !== null) {
                        r0 = [r3, r4];
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                    if (r0 === null) {
                      r2 = pos;
                      if (input.charCodeAt(pos) === 45) {
                        r3 = "-";
                        pos++;
                      } else {
                        r3 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"-\"");
                        }
                      }
                      if (r3 !== null) {
                        r5 = pos;
                        reportFailures++;
                        if (input.charCodeAt(pos) === 45) {
                          r4 = "-";
                          pos++;
                        } else {
                          r4 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"-\"");
                          }
                        }
                        reportFailures--;
                        if (r4 === null) {
                          r4 = "";
                        } else {
                          r4 = null;
                          pos = r5;
                        }
                        if (r4 !== null) {
                          r0 = [r3, r4];
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                      if (r0 === null) {
                        if (input.substr(pos, 2) === "<<") {
                          r0 = "<<";
                          pos += 2;
                        } else {
                          r0 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"<<\"");
                          }
                        }
                        if (r0 === null) {
                          if (input.substr(pos, 3) === ">>>") {
                            r0 = ">>>";
                            pos += 3;
                          } else {
                            r0 = null;
                            if (reportFailures === 0) {
                              matchFailed("\">>>\"");
                            }
                          }
                          if (r0 === null) {
                            if (input.substr(pos, 2) === ">>") {
                              r0 = ">>";
                              pos += 2;
                            } else {
                              r0 = null;
                              if (reportFailures === 0) {
                                matchFailed("\">>\"");
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_existsAssignmentOp() {
        var cacheKey = "existsAssignmentOp@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CompoundAssignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.substr(pos, 2) === "?=") {
              r5 = "?=";
              pos += 2;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"?=\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_secondaryExpression();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return e; })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_secondaryExpression();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return e; })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, right) {
                return rp(new CS.CompoundAssignOp(constructorLookup['?'].prototype.className, left, right));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_assignmentExpressionNoImplicitObjectCall() {
        var cacheKey = "assignmentExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_assignmentOpNoImplicitObjectCall();
        if (r0 === null) {
          r0 = parse_compoundAssignmentOpNoImplicitObjectCall();
          if (r0 === null) {
            r0 = parse_existsAssignmentOpNoImplicitObjectCall();
            if (r0 === null) {
              r0 = parse_binaryExpressionNoImplicitObjectCall();
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_assignmentOpNoImplicitObjectCall() {
        var cacheKey = "assignmentOpNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_Assignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 61) {
              r5 = "=";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (r5 !== null) {
              r7 = pos;
              reportFailures++;
              if (input.charCodeAt(pos) === 61) {
                r6 = "=";
                pos++;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("\"=\"");
                }
              }
              reportFailures--;
              if (r6 === null) {
                r6 = "";
              } else {
                r6 = null;
                pos = r7;
              }
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_secondaryExpressionNoImplicitObjectCall();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return e; })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_secondaryExpressionNoImplicitObjectCall();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return e; })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, right) {
                return rp(new CS.AssignOp(left, right));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_compoundAssignmentOpNoImplicitObjectCall() {
        var cacheKey = "compoundAssignmentOpNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CompoundAssignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r6 = pos;
            reportFailures++;
            if (input.charCodeAt(pos) === 63) {
              r5 = "?";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"?\"");
              }
            }
            reportFailures--;
            if (r5 === null) {
              r5 = "";
            } else {
              r5 = null;
              pos = r6;
            }
            if (r5 !== null) {
              r6 = parse_CompoundAssignmentOperators();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 61) {
                  r7 = "=";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"=\"");
                  }
                }
                if (r7 !== null) {
                  r9 = pos;
                  r10 = pos;
                  r11 = parse_TERMINDENT();
                  if (r11 !== null) {
                    r12 = parse_secondaryExpressionNoImplicitObjectCall();
                    if (r12 !== null) {
                      r13 = parse_DEDENT();
                      if (r13 !== null) {
                        r8 = [r11, r12, r13];
                      } else {
                        r8 = null;
                        pos = r10;
                      }
                    } else {
                      r8 = null;
                      pos = r10;
                    }
                  } else {
                    r8 = null;
                    pos = r10;
                  }
                  if (r8 !== null) {
                    reportedPos = r9;
                    r8 = (function(e) { return e; })(r12);
                  }
                  if (r8 === null) {
                    pos = r9;
                  }
                  if (r8 === null) {
                    r9 = pos;
                    r10 = pos;
                    r11 = parse_TERMINATOR();
                    r11 = r11 !== null ? r11 : "";
                    if (r11 !== null) {
                      r12 = parse__();
                      if (r12 !== null) {
                        r13 = parse_secondaryExpressionNoImplicitObjectCall();
                        if (r13 !== null) {
                          r8 = [r11, r12, r13];
                        } else {
                          r8 = null;
                          pos = r10;
                        }
                      } else {
                        r8 = null;
                        pos = r10;
                      }
                    } else {
                      r8 = null;
                      pos = r10;
                    }
                    if (r8 !== null) {
                      reportedPos = r9;
                      r8 = (function(e) { return e; })(r13);
                    }
                    if (r8 === null) {
                      pos = r9;
                    }
                  }
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, op, right) {
                return rp(new CS.CompoundAssignOp(constructorLookup[op].prototype.className, left, right));
              })(r3, r6, r8);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_existsAssignmentOpNoImplicitObjectCall() {
        var cacheKey = "existsAssignmentOpNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CompoundAssignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.substr(pos, 2) === "?=") {
              r5 = "?=";
              pos += 2;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"?=\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_secondaryExpressionNoImplicitObjectCall();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return e; })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_secondaryExpressionNoImplicitObjectCall();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return e; })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, right) {
                return rp(new CS.CompoundAssignOp(constructorLookup['?'].prototype.className, left, right));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_binaryExpression() {
        var cacheKey = "binaryExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_prefixExpression();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = pos;
          r8 = parse__();
          if (r8 !== null) {
            r9 = parse_binaryOperator();
            if (r9 !== null) {
              r10 = parse_TERMINATOR();
              r10 = r10 !== null ? r10 : "";
              if (r10 !== null) {
                r11 = parse__();
                if (r11 !== null) {
                  r12 = parse_expressionworthy();
                  if (r12 === null) {
                    r12 = parse_prefixExpression();
                  }
                  if (r12 !== null) {
                    r5 = [r8, r9, r10, r11, r12];
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
            } else {
              r5 = null;
              pos = r7;
            }
          } else {
            r5 = null;
            pos = r7;
          }
          if (r5 !== null) {
            reportedPos = r6;
            r5 = (function(o, e) { return [o, e]; })(r9, r12);
          }
          if (r5 === null) {
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = pos;
            r8 = parse__();
            if (r8 !== null) {
              r9 = parse_binaryOperator();
              if (r9 !== null) {
                r10 = parse_TERMINATOR();
                r10 = r10 !== null ? r10 : "";
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r12 = parse_expressionworthy();
                    if (r12 === null) {
                      r12 = parse_prefixExpression();
                    }
                    if (r12 !== null) {
                      r5 = [r8, r9, r10, r11, r12];
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
            } else {
              r5 = null;
              pos = r7;
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(o, e) { return [o, e]; })(r9, r12);
            }
            if (r5 === null) {
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, rights) {
              switch(rights.length) {
                case 0: return left;
                case 1: return rp(new constructorLookup[rights[0][0]](left, rights[0][1]));
                default: return rp(foldBinaryExpr([].concat.apply([left], rights)));
              }
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_binaryOperator() {
        var cacheKey = "binaryOperator@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CompoundAssignmentOperators();
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          if (input.charCodeAt(pos) === 61) {
            r4 = "=";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"=\"");
            }
          }
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        if (r0 === null) {
          if (input.substr(pos, 2) === "<=") {
            r0 = "<=";
            pos += 2;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"<=\"");
            }
          }
          if (r0 === null) {
            if (input.substr(pos, 2) === ">=") {
              r0 = ">=";
              pos += 2;
            } else {
              r0 = null;
              if (reportFailures === 0) {
                matchFailed("\">=\"");
              }
            }
            if (r0 === null) {
              if (input.charCodeAt(pos) === 60) {
                r0 = "<";
                pos++;
              } else {
                r0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"<\"");
                }
              }
              if (r0 === null) {
                if (input.charCodeAt(pos) === 62) {
                  r0 = ">";
                  pos++;
                } else {
                  r0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\">\"");
                  }
                }
                if (r0 === null) {
                  if (input.substr(pos, 2) === "==") {
                    r0 = "==";
                    pos += 2;
                  } else {
                    r0 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"==\"");
                    }
                  }
                  if (r0 === null) {
                    r0 = parse_IS();
                    if (r0 === null) {
                      if (input.substr(pos, 2) === "!=") {
                        r0 = "!=";
                        pos += 2;
                      } else {
                        r0 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"!=\"");
                        }
                      }
                      if (r0 === null) {
                        r0 = parse_ISNT();
                        if (r0 === null) {
                          r0 = parse_EXTENDS();
                          if (r0 === null) {
                            r0 = parse_INSTANCEOF();
                            if (r0 === null) {
                              r0 = parse_IN();
                              if (r0 === null) {
                                r0 = parse_OF();
                                if (r0 === null) {
                                  r1 = pos;
                                  r2 = pos;
                                  r3 = parse_NOT();
                                  if (r3 !== null) {
                                    r4 = parse__();
                                    if (r4 !== null) {
                                      r5 = parse_INSTANCEOF();
                                      if (r5 === null) {
                                        r5 = parse_IN();
                                        if (r5 === null) {
                                          r5 = parse_OF();
                                        }
                                      }
                                      if (r5 !== null) {
                                        r0 = [r3, r4, r5];
                                      } else {
                                        r0 = null;
                                        pos = r2;
                                      }
                                    } else {
                                      r0 = null;
                                      pos = r2;
                                    }
                                  } else {
                                    r0 = null;
                                    pos = r2;
                                  }
                                  if (r0 !== null) {
                                    reportedPos = r1;
                                    r0 = (function(op) { return 'not ' + op;  })(r5);
                                  }
                                  if (r0 === null) {
                                    pos = r1;
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_binaryExpressionNoImplicitObjectCall() {
        var cacheKey = "binaryExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_prefixExpressionNoImplicitObjectCall();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = pos;
          r8 = parse__();
          if (r8 !== null) {
            r9 = parse_binaryOperator();
            if (r9 !== null) {
              r10 = parse_TERMINATOR();
              r10 = r10 !== null ? r10 : "";
              if (r10 !== null) {
                r11 = parse__();
                if (r11 !== null) {
                  r12 = parse_expressionworthy();
                  if (r12 === null) {
                    r12 = parse_prefixExpressionNoImplicitObjectCall();
                  }
                  if (r12 !== null) {
                    r5 = [r8, r9, r10, r11, r12];
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
            } else {
              r5 = null;
              pos = r7;
            }
          } else {
            r5 = null;
            pos = r7;
          }
          if (r5 !== null) {
            reportedPos = r6;
            r5 = (function(o, e) { return [o, e]; })(r9, r12);
          }
          if (r5 === null) {
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = pos;
            r8 = parse__();
            if (r8 !== null) {
              r9 = parse_binaryOperator();
              if (r9 !== null) {
                r10 = parse_TERMINATOR();
                r10 = r10 !== null ? r10 : "";
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r12 = parse_expressionworthy();
                    if (r12 === null) {
                      r12 = parse_prefixExpressionNoImplicitObjectCall();
                    }
                    if (r12 !== null) {
                      r5 = [r8, r9, r10, r11, r12];
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
            } else {
              r5 = null;
              pos = r7;
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(o, e) { return [o, e]; })(r9, r12);
            }
            if (r5 === null) {
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, rights) {
              switch(rights.length) {
                case 0: return left;
                case 1: return rp(new constructorLookup[rights[0][0]](left, rights[0][1]));
                default: return rp(foldBinaryExpr([].concat.apply([left], rights)));
              }
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_prefixExpression() {
        var cacheKey = "prefixExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r0 = parse_postfixExpression();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_DO();
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_nfe();
              if (r5 === null) {
                r5 = parse_expressionworthy();
                if (r5 === null) {
                  r5 = parse_prefixExpression();
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e) { return rp(new CS.DoOp(e)); })(r5);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r5 = pos;
            r6 = parse_PrefixOperators();
            if (r6 !== null) {
              r7 = parse__();
              if (r7 !== null) {
                r4 = [r6, r7];
              } else {
                r4 = null;
                pos = r5;
              }
            } else {
              r4 = null;
              pos = r5;
            }
            if (r4 !== null) {
              r3 = [];
              while (r4 !== null) {
                r3.push(r4);
                r5 = pos;
                r6 = parse_PrefixOperators();
                if (r6 !== null) {
                  r7 = parse__();
                  if (r7 !== null) {
                    r4 = [r6, r7];
                  } else {
                    r4 = null;
                    pos = r5;
                  }
                } else {
                  r4 = null;
                  pos = r5;
                }
              }
            } else {
              r3 = null;
            }
            if (r3 !== null) {
              r4 = parse_expressionworthy();
              if (r4 === null) {
                r4 = parse_prefixExpression();
              }
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(ops, e) {
                  return rp(foldr(function(e, op){
                    return new prefixConstructorLookup[op[0]](e);
                  }, e, ops));
                })(r3, r4);
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_PrefixOperators() {
        var cacheKey = "PrefixOperators@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (input.substr(pos, 2) === "++") {
          r0 = "++";
          pos += 2;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"++\"");
          }
        }
        if (r0 === null) {
          if (input.substr(pos, 2) === "--") {
            r0 = "--";
            pos += 2;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"--\"");
            }
          }
          if (r0 === null) {
            if (input.charCodeAt(pos) === 43) {
              r0 = "+";
              pos++;
            } else {
              r0 = null;
              if (reportFailures === 0) {
                matchFailed("\"+\"");
              }
            }
            if (r0 === null) {
              if (input.charCodeAt(pos) === 45) {
                r0 = "-";
                pos++;
              } else {
                r0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"-\"");
                }
              }
              if (r0 === null) {
                if (input.charCodeAt(pos) === 33) {
                  r0 = "!";
                  pos++;
                } else {
                  r0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"!\"");
                  }
                }
                if (r0 === null) {
                  r0 = parse_NOT();
                  if (r0 === null) {
                    if (input.charCodeAt(pos) === 126) {
                      r0 = "~";
                      pos++;
                    } else {
                      r0 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"~\"");
                      }
                    }
                    if (r0 === null) {
                      r0 = parse_DO();
                      if (r0 === null) {
                        r0 = parse_TYPEOF();
                        if (r0 === null) {
                          r0 = parse_DELETE();
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_nfe() {
        var cacheKey = "nfe@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        reportFailures++;
        r3 = parse_unassignable();
        reportFailures--;
        if (r3 === null) {
          r3 = "";
        } else {
          r3 = null;
          pos = r4;
        }
        if (r3 !== null) {
          r4 = parse_identifier();
          if (r4 !== null) {
            r5 = parse__();
            if (r5 !== null) {
              if (input.charCodeAt(pos) === 61) {
                r6 = "=";
                pos++;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("\"=\"");
                }
              }
              if (r6 !== null) {
                r7 = parse__();
                if (r7 !== null) {
                  r8 = parse_functionLiteral();
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(a, f) { return rp(new CS.AssignOp(a, f)); })(r4, r8);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_prefixExpressionNoImplicitObjectCall() {
        var cacheKey = "prefixExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r0 = parse_postfixExpressionNoImplicitObjectCall();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_DO();
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_nfe();
              if (r5 === null) {
                r5 = parse_expressionworthy();
                if (r5 === null) {
                  r5 = parse_prefixExpressionNoImplicitObjectCall();
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e) { return rp(new CS.DoOp(e)); })(r5);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r5 = pos;
            r6 = parse_PrefixOperators();
            if (r6 !== null) {
              r7 = parse__();
              if (r7 !== null) {
                r4 = [r6, r7];
              } else {
                r4 = null;
                pos = r5;
              }
            } else {
              r4 = null;
              pos = r5;
            }
            if (r4 !== null) {
              r3 = [];
              while (r4 !== null) {
                r3.push(r4);
                r5 = pos;
                r6 = parse_PrefixOperators();
                if (r6 !== null) {
                  r7 = parse__();
                  if (r7 !== null) {
                    r4 = [r6, r7];
                  } else {
                    r4 = null;
                    pos = r5;
                  }
                } else {
                  r4 = null;
                  pos = r5;
                }
              }
            } else {
              r3 = null;
            }
            if (r3 !== null) {
              r4 = parse_expressionworthy();
              if (r4 === null) {
                r4 = parse_prefixExpressionNoImplicitObjectCall();
              }
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(ops, e) {
                  return rp(foldr(function(e, op){
                    return new prefixConstructorLookup[op[0]](e);
                  }, e, ops));
                })(r3, r4);
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_postfixExpression() {
        var cacheKey = "postfixExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_leftHandSideExpression();
        if (r3 !== null) {
          r4 = [];
          r5 = parse_PostfixOperators();
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_PostfixOperators();
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, ops) {
              return rp(foldl(function(e, op){
                return new postfixConstructorLookup[op](e);
              }, e, ops));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_PostfixOperators() {
        var cacheKey = "PostfixOperators@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (input.charCodeAt(pos) === 63) {
          r0 = "?";
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"?\"");
          }
        }
        if (r0 === null) {
          if (input.substr(pos, 4) === "[..]") {
            r0 = "[..]";
            pos += 4;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"[..]\"");
            }
          }
          if (r0 === null) {
            if (input.substr(pos, 2) === "++") {
              r0 = "++";
              pos += 2;
            } else {
              r0 = null;
              if (reportFailures === 0) {
                matchFailed("\"++\"");
              }
            }
            if (r0 === null) {
              if (input.substr(pos, 2) === "--") {
                r0 = "--";
                pos += 2;
              } else {
                r0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"--\"");
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_postfixExpressionNoImplicitObjectCall() {
        var cacheKey = "postfixExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_leftHandSideExpressionNoImplicitObjectCall();
        if (r3 !== null) {
          r4 = [];
          r5 = parse_PostfixOperators();
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_PostfixOperators();
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, ops) {
              return rp(foldl(function(e, op){
                return new postfixConstructorLookup[op](e);
              }, e, ops));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_leftHandSideExpression() {
        var cacheKey = "leftHandSideExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_callExpression();
        if (r0 === null) {
          r0 = parse_newExpression();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_argumentList() {
        var cacheKey = "argumentList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 63) {
          r3 = "?";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"?\"");
          }
        }
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          if (input.charCodeAt(pos) === 40) {
            r4 = "(";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"(\"");
            }
          }
          if (r4 !== null) {
            r5 = parse__();
            if (r5 !== null) {
              r6 = parse_argumentListContents();
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r7 = parse__();
                if (r7 !== null) {
                  if (input.charCodeAt(pos) === 41) {
                    r8 = ")";
                    pos++;
                  } else {
                    r8 = null;
                    if (reportFailures === 0) {
                      matchFailed("\")\"");
                    }
                  }
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(soaked, a) {
                return rp(
                  { op: soaked ? CS.SoakedFunctionApplication : CS.FunctionApplication
                  , operands: [a || []]
                  }
                );
              })(r3, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_argumentListContents() {
        var cacheKey = "argumentListContents@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_argument();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            if (input.charCodeAt(pos) === 44) {
              r8 = ",";
              pos++;
            } else {
              r8 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (r8 === null) {
              r8 = parse_TERMINATOR();
            }
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_argument();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              if (input.charCodeAt(pos) === 44) {
                r8 = ",";
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              if (r8 === null) {
                r8 = parse_TERMINATOR();
              }
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_argument();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 44) {
              r5 = ",";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (r5 === null) {
              r5 = parse_TERMINATOR();
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[3]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_TERMINDENT();
          if (r3 !== null) {
            r4 = parse_argumentListContents();
            if (r4 !== null) {
              r5 = parse_DEDENT();
              if (r5 !== null) {
                r6 = parse_TERMINATOR();
                r6 = r6 !== null ? r6 : "";
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(a) { return a; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_argument() {
        var cacheKey = "argument@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_spread();
        if (r0 === null) {
          r0 = parse_expression();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryArgumentList() {
        var cacheKey = "secondaryArgumentList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14;
        
        r1 = pos;
        r2 = pos;
        r3 = parse___();
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r6 = pos;
          if (/^[+-\/]/.test(input.charAt(pos))) {
            r7 = input.charAt(pos);
            pos++;
          } else {
            r7 = null;
            if (reportFailures === 0) {
              matchFailed("[+-\\/]");
            }
          }
          if (r7 !== null) {
            r8 = parse___();
            if (r8 !== null) {
              r4 = [r7, r8];
            } else {
              r4 = null;
              pos = r6;
            }
          } else {
            r4 = null;
            pos = r6;
          }
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r5 = parse_secondaryArgument();
            if (r5 !== null) {
              r6 = [];
              r8 = pos;
              r9 = parse__();
              if (r9 !== null) {
                if (input.charCodeAt(pos) === 44) {
                  r10 = ",";
                  pos++;
                } else {
                  r10 = null;
                  if (reportFailures === 0) {
                    matchFailed("\",\"");
                  }
                }
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r12 = parse_TERMINATOR();
                    r12 = r12 !== null ? r12 : "";
                    if (r12 !== null) {
                      r13 = parse__();
                      if (r13 !== null) {
                        r14 = parse_secondaryArgument();
                        if (r14 !== null) {
                          r7 = [r9, r10, r11, r12, r13, r14];
                        } else {
                          r7 = null;
                          pos = r8;
                        }
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
              } else {
                r7 = null;
                pos = r8;
              }
              while (r7 !== null) {
                r6.push(r7);
                r8 = pos;
                r9 = parse__();
                if (r9 !== null) {
                  if (input.charCodeAt(pos) === 44) {
                    r10 = ",";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\",\"");
                    }
                  }
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_TERMINATOR();
                      r12 = r12 !== null ? r12 : "";
                      if (r12 !== null) {
                        r13 = parse__();
                        if (r13 !== null) {
                          r14 = parse_secondaryArgument();
                          if (r14 !== null) {
                            r7 = [r9, r10, r11, r12, r13, r14];
                          } else {
                            r7 = null;
                            pos = r8;
                          }
                        } else {
                          r7 = null;
                          pos = r8;
                        }
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
              }
              if (r6 !== null) {
                r8 = pos;
                if (input.charCodeAt(pos) === 44) {
                  r9 = ",";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\",\"");
                  }
                }
                r9 = r9 !== null ? r9 : "";
                if (r9 !== null) {
                  r10 = parse_TERMINDENT();
                  if (r10 !== null) {
                    r11 = parse_implicitObjectLiteral();
                    if (r11 !== null) {
                      r12 = parse_DEDENT();
                      if (r12 !== null) {
                        r7 = [r9, r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
                r7 = r7 !== null ? r7 : "";
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es, obj) {
                es = [e].concat(es.map(function(e){ return e[5]; }));
                if(obj) es.push(obj[2]);
                return es;
              })(r5, r6, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_TERMINDENT();
          if (r3 !== null) {
            r4 = parse_implicitObjectLiteral();
            if (r4 !== null) {
              r5 = parse_DEDENT();
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(o) { return [o]; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryArgument() {
        var cacheKey = "secondaryArgument@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_spread();
        if (r0 === null) {
          r0 = parse_secondaryExpression();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_leftHandSideExpressionNoImplicitObjectCall() {
        var cacheKey = "leftHandSideExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_callExpressionNoImplicitObjectCall();
        if (r0 === null) {
          r0 = parse_newExpressionNoImplicitObjectCall();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryArgumentListNoImplicitObjectCall() {
        var cacheKey = "secondaryArgumentListNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14;
        
        r1 = pos;
        r2 = pos;
        r3 = parse___();
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r6 = pos;
          if (/^[+-\/]/.test(input.charAt(pos))) {
            r7 = input.charAt(pos);
            pos++;
          } else {
            r7 = null;
            if (reportFailures === 0) {
              matchFailed("[+-\\/]");
            }
          }
          if (r7 !== null) {
            r8 = parse___();
            if (r8 !== null) {
              r4 = [r7, r8];
            } else {
              r4 = null;
              pos = r6;
            }
          } else {
            r4 = null;
            pos = r6;
          }
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r5 = parse_secondaryArgumentNoImplicitObjectCall();
            if (r5 !== null) {
              r6 = [];
              r8 = pos;
              r9 = parse__();
              if (r9 !== null) {
                if (input.charCodeAt(pos) === 44) {
                  r10 = ",";
                  pos++;
                } else {
                  r10 = null;
                  if (reportFailures === 0) {
                    matchFailed("\",\"");
                  }
                }
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r12 = parse_TERMINATOR();
                    r12 = r12 !== null ? r12 : "";
                    if (r12 !== null) {
                      r13 = parse__();
                      if (r13 !== null) {
                        r14 = parse_secondaryArgumentNoImplicitObjectCall();
                        if (r14 !== null) {
                          r7 = [r9, r10, r11, r12, r13, r14];
                        } else {
                          r7 = null;
                          pos = r8;
                        }
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
              } else {
                r7 = null;
                pos = r8;
              }
              while (r7 !== null) {
                r6.push(r7);
                r8 = pos;
                r9 = parse__();
                if (r9 !== null) {
                  if (input.charCodeAt(pos) === 44) {
                    r10 = ",";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\",\"");
                    }
                  }
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_TERMINATOR();
                      r12 = r12 !== null ? r12 : "";
                      if (r12 !== null) {
                        r13 = parse__();
                        if (r13 !== null) {
                          r14 = parse_secondaryArgumentNoImplicitObjectCall();
                          if (r14 !== null) {
                            r7 = [r9, r10, r11, r12, r13, r14];
                          } else {
                            r7 = null;
                            pos = r8;
                          }
                        } else {
                          r7 = null;
                          pos = r8;
                        }
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
              }
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                es = [e].concat(es.map(function(e){ return e[5]; }));
                return es;
              })(r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_secondaryArgumentNoImplicitObjectCall() {
        var cacheKey = "secondaryArgumentNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_spreadNoImplicitObjectCall();
        if (r0 === null) {
          r0 = parse_secondaryExpressionNoImplicitObjectCall();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_callExpression() {
        var cacheKey = "callExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_memberExpression();
        if (r3 !== null) {
          r4 = [];
          r5 = parse_argumentList();
          if (r5 === null) {
            r5 = parse_MemberAccessOps();
          }
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_argumentList();
            if (r5 === null) {
              r5 = parse_MemberAccessOps();
            }
          }
          if (r4 !== null) {
            r6 = pos;
            if (input.charCodeAt(pos) === 63) {
              r7 = "?";
              pos++;
            } else {
              r7 = null;
              if (reportFailures === 0) {
                matchFailed("\"?\"");
              }
            }
            r7 = r7 !== null ? r7 : "";
            if (r7 !== null) {
              r8 = parse_secondaryArgumentList();
              if (r8 !== null) {
                r5 = [r7, r8];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(fn, accesses, secondaryArgs) {
              if(accesses) fn = createMemberExpression(fn, accesses);
              var soaked, secondaryCtor;
              if(secondaryArgs) {
                soaked = secondaryArgs[0];
                secondaryCtor = soaked ? CS.SoakedFunctionApplication : CS.FunctionApplication;
                fn = rp(new secondaryCtor(fn, secondaryArgs[1]));
              }
              return fn;
            })(r3, r4, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_callExpressionNoImplicitObjectCall() {
        var cacheKey = "callExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_memberExpressionNoImplicitObjectCall();
        if (r3 !== null) {
          r4 = [];
          r5 = parse_argumentList();
          if (r5 === null) {
            r5 = parse_MemberAccessOps();
          }
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_argumentList();
            if (r5 === null) {
              r5 = parse_MemberAccessOps();
            }
          }
          if (r4 !== null) {
            r6 = pos;
            if (input.charCodeAt(pos) === 63) {
              r7 = "?";
              pos++;
            } else {
              r7 = null;
              if (reportFailures === 0) {
                matchFailed("\"?\"");
              }
            }
            r7 = r7 !== null ? r7 : "";
            if (r7 !== null) {
              r8 = parse_secondaryArgumentListNoImplicitObjectCall();
              if (r8 !== null) {
                r5 = [r7, r8];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(fn, accesses, secondaryArgs) {
              if(accesses) fn = createMemberExpression(fn, accesses);
              var soaked, secondaryCtor;
              if(secondaryArgs) {
                soaked = secondaryArgs[0];
                secondaryCtor = soaked ? CS.SoakedFunctionApplication : CS.FunctionApplication;
                fn = rp(new secondaryCtor(fn, secondaryArgs[1]));
              }
              return fn;
            })(r3, r4, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_newExpression() {
        var cacheKey = "newExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r0 = parse_memberExpression();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_NEW();
          if (r3 !== null) {
            r4 = parse___();
            if (r4 !== null) {
              r5 = parse_expressionworthy();
              if (r5 === null) {
                r5 = parse_newExpression();
                if (r5 === null) {
                  r5 = parse_prefixExpression();
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e) {
                return rp(new CS.NewOp(e, []));
              })(r5);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_newExpressionNoImplicitObjectCall() {
        var cacheKey = "newExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r0 = parse_memberExpressionNoImplicitObjectCall();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_NEW();
          if (r3 !== null) {
            r4 = parse___();
            if (r4 !== null) {
              r5 = parse_expressionworthy();
              if (r5 === null) {
                r5 = parse_newExpressionNoImplicitObjectCall();
                if (r5 === null) {
                  r5 = parse_prefixExpressionNoImplicitObjectCall();
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e) {
                return rp(new CS.NewOp(e, []));
              })(r5);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_memberExpression() {
        var cacheKey = "memberExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_primaryExpression();
        if (r3 === null) {
          r4 = pos;
          r5 = pos;
          r6 = parse_NEW();
          if (r6 !== null) {
            r7 = parse___();
            if (r7 !== null) {
              r8 = parse_memberExpression();
              if (r8 !== null) {
                r9 = parse_argumentList();
                if (r9 !== null) {
                  r3 = [r6, r7, r8, r9];
                } else {
                  r3 = null;
                  pos = r5;
                }
              } else {
                r3 = null;
                pos = r5;
              }
            } else {
              r3 = null;
              pos = r5;
            }
          } else {
            r3 = null;
            pos = r5;
          }
          if (r3 !== null) {
            reportedPos = r4;
            r3 = (function(e, args) { return rp(new CS.NewOp(e, args.operands[0])); })(r8, r9);
          }
          if (r3 === null) {
            pos = r4;
          }
        }
        if (r3 !== null) {
          r4 = [];
          r5 = parse_MemberAccessOps();
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_MemberAccessOps();
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, accesses) {
              return createMemberExpression(e, accesses || []);
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_NEW();
          if (r3 !== null) {
            r4 = parse___();
            if (r4 !== null) {
              r5 = parse_memberExpression();
              if (r5 !== null) {
                r6 = parse_secondaryArgumentList();
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e, args) {
                return rp(new CS.NewOp(e, args));
              })(r5, r6);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_memberAccess() {
        var cacheKey = "memberAccess@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_primaryExpression();
        if (r3 === null) {
          r4 = pos;
          r5 = pos;
          r6 = parse_NEW();
          if (r6 !== null) {
            r7 = parse___();
            if (r7 !== null) {
              r8 = parse_memberExpression();
              if (r8 !== null) {
                r9 = parse_argumentList();
                if (r9 !== null) {
                  r3 = [r6, r7, r8, r9];
                } else {
                  r3 = null;
                  pos = r5;
                }
              } else {
                r3 = null;
                pos = r5;
              }
            } else {
              r3 = null;
              pos = r5;
            }
          } else {
            r3 = null;
            pos = r5;
          }
          if (r3 !== null) {
            reportedPos = r4;
            r3 = (function(e, args) { return rp(new CS.NewOp(e, args.operands[0])); })(r8, r9);
          }
          if (r3 === null) {
            pos = r4;
          }
        }
        if (r3 !== null) {
          r6 = pos;
          r7 = parse_argumentList();
          if (r7 !== null) {
            r8 = parse_MemberAccessOps();
            if (r8 !== null) {
              r5 = [r7, r8];
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          if (r5 === null) {
            r5 = parse_MemberAccessOps();
          }
          if (r5 !== null) {
            r4 = [];
            while (r5 !== null) {
              r4.push(r5);
              r6 = pos;
              r7 = parse_argumentList();
              if (r7 !== null) {
                r8 = parse_MemberAccessOps();
                if (r8 !== null) {
                  r5 = [r7, r8];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
              if (r5 === null) {
                r5 = parse_MemberAccessOps();
              }
            }
          } else {
            r4 = null;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, accesses) {
                var acc = foldl(function(memo, a){ return memo.concat(a); }, [], accesses);
                return createMemberExpression(e, acc);
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_MemberAccessOps() {
        var cacheKey = "MemberAccessOps@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 46) {
              r5 = ".";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\".\"");
              }
            }
            if (r5 !== null) {
              r6 = parse_TERMINATOR();
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r7 = parse__();
                if (r7 !== null) {
                  r8 = parse_identifierName();
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) { return rp({op: CS.MemberAccessOp, operands: [e]}); })(r8);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.substr(pos, 2) === "?.") {
            r3 = "?.";
            pos += 2;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"?.\"");
            }
          }
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_identifierName();
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e) { return rp({op: CS.SoakedMemberAccessOp, operands: [e]}); })(r5);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            if (input.charCodeAt(pos) === 91) {
              r3 = "[";
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"[\"");
              }
            }
            if (r3 !== null) {
              r4 = parse__();
              if (r4 !== null) {
                r5 = parse_expression();
                if (r5 !== null) {
                  r6 = parse__();
                  if (r6 !== null) {
                    if (input.charCodeAt(pos) === 93) {
                      r7 = "]";
                      pos++;
                    } else {
                      r7 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"]\"");
                      }
                    }
                    if (r7 !== null) {
                      r0 = [r3, r4, r5, r6, r7];
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(e) { return rp({op: CS.DynamicMemberAccessOp, operands: [e]}); })(r5);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              if (input.substr(pos, 2) === "?[") {
                r3 = "?[";
                pos += 2;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"?[\"");
                }
              }
              if (r3 !== null) {
                r4 = parse__();
                if (r4 !== null) {
                  r5 = parse_expression();
                  if (r5 !== null) {
                    r6 = parse__();
                    if (r6 !== null) {
                      if (input.charCodeAt(pos) === 93) {
                        r7 = "]";
                        pos++;
                      } else {
                        r7 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"]\"");
                        }
                      }
                      if (r7 !== null) {
                        r0 = [r3, r4, r5, r6, r7];
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function(e) { return rp({op: CS.SoakedDynamicMemberAccessOp, operands: [e]}); })(r5);
              }
              if (r0 === null) {
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                r2 = pos;
                if (input.substr(pos, 2) === "::") {
                  r3 = "::";
                  pos += 2;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"::\"");
                  }
                }
                if (r3 !== null) {
                  r4 = parse__();
                  if (r4 !== null) {
                    r5 = parse_identifierName();
                    if (r5 !== null) {
                      r0 = [r3, r4, r5];
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
                if (r0 !== null) {
                  reportedPos = r1;
                  r0 = (function(e) { return rp({op: CS.ProtoMemberAccessOp, operands: [e]}); })(r5);
                }
                if (r0 === null) {
                  pos = r1;
                }
                if (r0 === null) {
                  r1 = pos;
                  r2 = pos;
                  if (input.substr(pos, 3) === "::[") {
                    r3 = "::[";
                    pos += 3;
                  } else {
                    r3 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"::[\"");
                    }
                  }
                  if (r3 !== null) {
                    r4 = parse__();
                    if (r4 !== null) {
                      r5 = parse_expression();
                      if (r5 !== null) {
                        r6 = parse__();
                        if (r6 !== null) {
                          if (input.charCodeAt(pos) === 93) {
                            r7 = "]";
                            pos++;
                          } else {
                            r7 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"]\"");
                            }
                          }
                          if (r7 !== null) {
                            r0 = [r3, r4, r5, r6, r7];
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                  if (r0 !== null) {
                    reportedPos = r1;
                    r0 = (function(e) { return rp({op: CS.DynamicProtoMemberAccessOp, operands: [e]}); })(r5);
                  }
                  if (r0 === null) {
                    pos = r1;
                  }
                  if (r0 === null) {
                    r1 = pos;
                    r2 = pos;
                    if (input.substr(pos, 3) === "?::") {
                      r3 = "?::";
                      pos += 3;
                    } else {
                      r3 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"?::\"");
                      }
                    }
                    if (r3 !== null) {
                      r4 = parse__();
                      if (r4 !== null) {
                        r5 = parse_identifierName();
                        if (r5 !== null) {
                          r0 = [r3, r4, r5];
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                    if (r0 !== null) {
                      reportedPos = r1;
                      r0 = (function(e) { return rp({op: CS.SoakedProtoMemberAccessOp, operands: [e]}); })(r5);
                    }
                    if (r0 === null) {
                      pos = r1;
                    }
                    if (r0 === null) {
                      r1 = pos;
                      r2 = pos;
                      if (input.substr(pos, 4) === "?::[") {
                        r3 = "?::[";
                        pos += 4;
                      } else {
                        r3 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"?::[\"");
                        }
                      }
                      if (r3 !== null) {
                        r4 = parse__();
                        if (r4 !== null) {
                          r5 = parse_expression();
                          if (r5 !== null) {
                            r6 = parse__();
                            if (r6 !== null) {
                              if (input.charCodeAt(pos) === 93) {
                                r7 = "]";
                                pos++;
                              } else {
                                r7 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"]\"");
                                }
                              }
                              if (r7 !== null) {
                                r0 = [r3, r4, r5, r6, r7];
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                      if (r0 !== null) {
                        reportedPos = r1;
                        r0 = (function(e) { return rp({op: CS.SoakedDynamicProtoMemberAccessOp, operands: [e]}); })(r5);
                      }
                      if (r0 === null) {
                        pos = r1;
                      }
                      if (r0 === null) {
                        r1 = pos;
                        r2 = pos;
                        if (input.charCodeAt(pos) === 91) {
                          r3 = "[";
                          pos++;
                        } else {
                          r3 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"[\"");
                          }
                        }
                        if (r3 !== null) {
                          r4 = parse__();
                          if (r4 !== null) {
                            r5 = parse_assignmentExpression();
                            r5 = r5 !== null ? r5 : "";
                            if (r5 !== null) {
                              r6 = parse__();
                              if (r6 !== null) {
                                if (input.substr(pos, 2) === "..") {
                                  r7 = "..";
                                  pos += 2;
                                } else {
                                  r7 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"..\"");
                                  }
                                }
                                if (r7 !== null) {
                                  if (input.charCodeAt(pos) === 46) {
                                    r8 = ".";
                                    pos++;
                                  } else {
                                    r8 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\".\"");
                                    }
                                  }
                                  r8 = r8 !== null ? r8 : "";
                                  if (r8 !== null) {
                                    r9 = parse__();
                                    if (r9 !== null) {
                                      r10 = parse_assignmentExpression();
                                      r10 = r10 !== null ? r10 : "";
                                      if (r10 !== null) {
                                        r11 = parse__();
                                        if (r11 !== null) {
                                          if (input.charCodeAt(pos) === 93) {
                                            r12 = "]";
                                            pos++;
                                          } else {
                                            r12 = null;
                                            if (reportFailures === 0) {
                                              matchFailed("\"]\"");
                                            }
                                          }
                                          if (r12 !== null) {
                                            r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12];
                                          } else {
                                            r0 = null;
                                            pos = r2;
                                          }
                                        } else {
                                          r0 = null;
                                          pos = r2;
                                        }
                                      } else {
                                        r0 = null;
                                        pos = r2;
                                      }
                                    } else {
                                      r0 = null;
                                      pos = r2;
                                    }
                                  } else {
                                    r0 = null;
                                    pos = r2;
                                  }
                                } else {
                                  r0 = null;
                                  pos = r2;
                                }
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                        if (r0 !== null) {
                          reportedPos = r1;
                          r0 = (function(left, exclusive, right) {
                                return rp({op: CS.Slice, operands: [!exclusive, left || null, right || null]});
                              })(r5, r8, r10);
                        }
                        if (r0 === null) {
                          pos = r1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_memberExpressionNoImplicitObjectCall() {
        var cacheKey = "memberExpressionNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_primaryExpression();
        if (r3 === null) {
          r4 = pos;
          r5 = pos;
          r6 = parse_NEW();
          if (r6 !== null) {
            r7 = parse___();
            if (r7 !== null) {
              r8 = parse_memberExpressionNoImplicitObjectCall();
              if (r8 !== null) {
                r9 = parse_argumentList();
                if (r9 !== null) {
                  r3 = [r6, r7, r8, r9];
                } else {
                  r3 = null;
                  pos = r5;
                }
              } else {
                r3 = null;
                pos = r5;
              }
            } else {
              r3 = null;
              pos = r5;
            }
          } else {
            r3 = null;
            pos = r5;
          }
          if (r3 !== null) {
            reportedPos = r4;
            r3 = (function(e, args) { return rp(new CS.NewOp(e, args.operands[0])); })(r8, r9);
          }
          if (r3 === null) {
            pos = r4;
          }
        }
        if (r3 !== null) {
          r4 = [];
          r5 = parse_MemberAccessOps();
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_MemberAccessOps();
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, accesses) {
              return createMemberExpression(e, accesses || []);
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_NEW();
          if (r3 !== null) {
            r4 = parse___();
            if (r4 !== null) {
              r5 = parse_memberExpressionNoImplicitObjectCall();
              if (r5 !== null) {
                r6 = parse_secondaryArgumentListNoImplicitObjectCall();
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(e, args) {
                return rp(new CS.NewOp(e, args));
              })(r5, r6);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_primaryExpression() {
        var cacheKey = "primaryExpression@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r0 = parse_macro();
        if (r0 === null) {
          r0 = parse_Numbers();
          if (r0 === null) {
            r0 = parse_bool();
            if (r0 === null) {
              r0 = parse_null();
              if (r0 === null) {
                r0 = parse_undefined();
                if (r0 === null) {
                  r0 = parse_contextVar();
                  if (r0 === null) {
                    r1 = pos;
                    r0 = parse_THIS();
                    if (r0 === null) {
                      if (input.charCodeAt(pos) === 64) {
                        r0 = "@";
                        pos++;
                      } else {
                        r0 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"@\"");
                        }
                      }
                    }
                    if (r0 !== null) {
                      reportedPos = r1;
                      r0 = (function(r) { return rp(new CS.This); })(r0);
                    }
                    if (r0 === null) {
                      pos = r1;
                    }
                    if (r0 === null) {
                      r0 = parse_identifier();
                      if (r0 === null) {
                        r0 = parse_range();
                        if (r0 === null) {
                          r0 = parse_arrayLiteral();
                          if (r0 === null) {
                            r0 = parse_objectLiteral();
                            if (r0 === null) {
                              r0 = parse_interpolation();
                              if (r0 === null) {
                                r0 = parse_JSLiteral();
                                if (r0 === null) {
                                  r0 = parse_string();
                                  if (r0 === null) {
                                    r0 = parse_regexp();
                                    if (r0 === null) {
                                      r1 = pos;
                                      r2 = pos;
                                      if (input.charCodeAt(pos) === 40) {
                                        r3 = "(";
                                        pos++;
                                      } else {
                                        r3 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("\"(\"");
                                        }
                                      }
                                      if (r3 !== null) {
                                        r4 = parse_TERMINDENT();
                                        if (r4 !== null) {
                                          r5 = parse_expression();
                                          if (r5 !== null) {
                                            r6 = parse_DEDENT();
                                            if (r6 !== null) {
                                              r7 = parse_TERMINATOR();
                                              r7 = r7 !== null ? r7 : "";
                                              if (r7 !== null) {
                                                if (input.charCodeAt(pos) === 41) {
                                                  r8 = ")";
                                                  pos++;
                                                } else {
                                                  r8 = null;
                                                  if (reportFailures === 0) {
                                                    matchFailed("\")\"");
                                                  }
                                                }
                                                if (r8 !== null) {
                                                  r0 = [r3, r4, r5, r6, r7, r8];
                                                } else {
                                                  r0 = null;
                                                  pos = r2;
                                                }
                                              } else {
                                                r0 = null;
                                                pos = r2;
                                              }
                                            } else {
                                              r0 = null;
                                              pos = r2;
                                            }
                                          } else {
                                            r0 = null;
                                            pos = r2;
                                          }
                                        } else {
                                          r0 = null;
                                          pos = r2;
                                        }
                                      } else {
                                        r0 = null;
                                        pos = r2;
                                      }
                                      if (r0 !== null) {
                                        reportedPos = r1;
                                        r0 = (function(e) { return r(e.clone()); })(r5);
                                      }
                                      if (r0 === null) {
                                        pos = r1;
                                      }
                                      if (r0 === null) {
                                        r1 = pos;
                                        r2 = pos;
                                        if (input.charCodeAt(pos) === 40) {
                                          r3 = "(";
                                          pos++;
                                        } else {
                                          r3 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\"(\"");
                                          }
                                        }
                                        if (r3 !== null) {
                                          r4 = parse__();
                                          if (r4 !== null) {
                                            r5 = parse_expression();
                                            if (r5 !== null) {
                                              r6 = parse__();
                                              if (r6 !== null) {
                                                r7 = parse_TERMINATOR();
                                                r7 = r7 !== null ? r7 : "";
                                                if (r7 !== null) {
                                                  r8 = parse__();
                                                  if (r8 !== null) {
                                                    if (input.charCodeAt(pos) === 41) {
                                                      r9 = ")";
                                                      pos++;
                                                    } else {
                                                      r9 = null;
                                                      if (reportFailures === 0) {
                                                        matchFailed("\")\"");
                                                      }
                                                    }
                                                    if (r9 !== null) {
                                                      r0 = [r3, r4, r5, r6, r7, r8, r9];
                                                    } else {
                                                      r0 = null;
                                                      pos = r2;
                                                    }
                                                  } else {
                                                    r0 = null;
                                                    pos = r2;
                                                  }
                                                } else {
                                                  r0 = null;
                                                  pos = r2;
                                                }
                                              } else {
                                                r0 = null;
                                                pos = r2;
                                              }
                                            } else {
                                              r0 = null;
                                              pos = r2;
                                            }
                                          } else {
                                            r0 = null;
                                            pos = r2;
                                          }
                                        } else {
                                          r0 = null;
                                          pos = r2;
                                        }
                                        if (r0 !== null) {
                                          reportedPos = r1;
                                          r0 = (function(e) { return r(e.clone()); })(r5);
                                        }
                                        if (r0 === null) {
                                          pos = r1;
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_contextVar() {
        var cacheKey = "contextVar@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        if (input.charCodeAt(pos) === 64) {
          r3 = "@";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"@\"");
          }
        }
        if (r3 !== null) {
          reportedPos = r4;
          r3 = (function() { return rp(new CS.This); })();
        }
        if (r3 === null) {
          pos = r4;
        }
        if (r3 !== null) {
          r4 = parse_identifierName();
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(a, m) {
                return rp(new CS.MemberAccessOp(a, m));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_JSLiteral() {
        var cacheKey = "JSLiteral@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 96) {
          r3 = "`";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"`\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          r4 = [];
          if (/^[^`]/.test(input.charAt(pos))) {
            r6 = input.charAt(pos);
            pos++;
          } else {
            r6 = null;
            if (reportFailures === 0) {
              matchFailed("[^`]");
            }
          }
          while (r6 !== null) {
            r4.push(r6);
            if (/^[^`]/.test(input.charAt(pos))) {
              r6 = input.charAt(pos);
              pos++;
            } else {
              r6 = null;
              if (reportFailures === 0) {
                matchFailed("[^`]");
              }
            }
          }
          if (r4 !== null) {
            r4 = input.substring(pos, r5);
          }
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 96) {
              r5 = "`";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"`\"");
              }
            }
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(d) { return rp(new CS.JavaScript(d)); })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_spread() {
        var cacheKey = "spread@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_postfixExpression();
        if (r3 !== null) {
          if (input.substr(pos, 3) === "...") {
            r4 = "...";
            pos += 3;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"...\"");
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) { return rp(new CS.Spread(e)); })(r3);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_spreadNoImplicitObjectCall() {
        var cacheKey = "spreadNoImplicitObjectCall@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_postfixExpressionNoImplicitObjectCall();
        if (r3 !== null) {
          if (input.substr(pos, 3) === "...") {
            r4 = "...";
            pos += 3;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"...\"");
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) { return rp(new CS.Spread(e)); })(r3);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_conditional() {
        var cacheKey = "conditional@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_IF();
        if (r3 === null) {
          r3 = parse_UNLESS();
        }
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_assignmentExpressionNoImplicitObjectCall();
            if (r5 !== null) {
              r6 = parse_conditionalBody();
              if (r6 !== null) {
                r7 = parse_elseClause();
                r7 = r7 !== null ? r7 : "";
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(kw, cond, body, elseClause) {
              var constructor = 'unless' === kw ? CS.NegatedConditional : CS.Conditional;
              if('unless' === kw) cond = new CS.LogicalNotOp(cond).g();
              return rp(new constructor(cond, body.block, elseClause || null));
            })(r3, r5, r6, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_conditionalBody() {
        var cacheKey = "conditionalBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse__();
        if (r3 !== null) {
          r4 = parse_TERMINDENT();
          if (r4 !== null) {
            r5 = parse_block();
            if (r5 !== null) {
              r6 = parse_DEDENT();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return {block: b}; })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_TERMINATOR();
          r3 = r3 !== null ? r3 : "";
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_THEN();
              if (r5 !== null) {
                r6 = parse__();
                if (r6 !== null) {
                  r7 = parse_statement();
                  if (r7 !== null) {
                    r0 = [r3, r4, r5, r6, r7];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(s) { return {block: s}; })(r7);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = parse__();
            if (r3 !== null) {
              r4 = parse_THEN();
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function() { return {block: null}; })();
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_elseClause() {
        var cacheKey = "elseClause@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse__();
        if (r3 !== null) {
          r4 = parse_TERMINATOR();
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r5 = parse__();
            if (r5 !== null) {
              r6 = parse_ELSE();
              if (r6 !== null) {
                r7 = parse_functionBody();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return b; })(r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_while() {
        var cacheKey = "while@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_WHILE();
        if (r3 === null) {
          r3 = parse_UNTIL();
        }
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_assignmentExpressionNoImplicitObjectCall();
            if (r5 !== null) {
              r6 = parse_conditionalBody();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(kw, cond, body) {
              var constructor = 'until' === kw ? CS.NegatedWhile : CS.While;
              if('until' === kw) cond = new CS.LogicalNotOp(cond).g();
              return rp(new constructor(cond, body.block));
            })(r3, r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_loop() {
        var cacheKey = "loop@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_LOOP();
        if (r3 !== null) {
          r4 = parse_conditionalBody();
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(body) {
              return rp(new CS.Loop(body.block));
            })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_try() {
        var cacheKey = "try@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TRY();
        if (r3 !== null) {
          r4 = parse_tryBody();
          if (r4 !== null) {
            r5 = parse_catchClause();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse_finallyClause();
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(body, c, f) {
              return rp(new CS.Try(body.block, c ? c.assignee : null, c ? c.block : null, f ? f.block : null));
            })(r4, r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_tryBody() {
        var cacheKey = "tryBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_functionBody();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return {block: b}; })(r0);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r0 = parse_conditionalBody();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_catchClause() {
        var cacheKey = "catchClause@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_CATCH();
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r7 = parse_Assignable();
                if (r7 !== null) {
                  r8 = parse_conditionalBody();
                  if (r8 !== null) {
                    r0 = [r3, r4, r5, r6, r7, r8];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, body) {
              return r({block: body.block, assignee: e});
            })(r7, r8);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_finallyClause() {
        var cacheKey = "finallyClause@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_FINALLY();
            if (r5 !== null) {
              r6 = parse_tryBody();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(body) {
              return r({block: body.block});
            })(r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_class() {
        var cacheKey = "class@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_CLASS();
        if (r3 !== null) {
          r5 = pos;
          r6 = parse__();
          if (r6 !== null) {
            r7 = parse_Assignable();
            if (r7 !== null) {
              r4 = [r6, r7];
            } else {
              r4 = null;
              pos = r5;
            }
          } else {
            r4 = null;
            pos = r5;
          }
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_EXTENDS();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_secondaryExpressionNoImplicitObjectCall();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse_classBody();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(name, parent, body) {
              var ctor = null;
              name = name ? name[1] : null;
              parent = parent ? parent[3] : null;
              var boundMembers = [];
              var stmts = body ? body.statements || [body] : [];
              for(var i = 0, l = stmts.length; i < l; ++i) {
                var m = stmts[i];
                if(m.instanceof(CS.Constructor)) {
                  ctor = m;
                } else if(m.instanceof(CS.ClassProtoAssignOp) && m.expression.instanceof(CS.BoundFunction)) {
                  boundMembers.push(m);
                }
              }
              return rp(new CS.Class(name, parent, ctor, body, boundMembers));
            })(r4, r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_classBody() {
        var cacheKey = "classBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse__();
        if (r3 !== null) {
          r4 = parse_TERMINDENT();
          if (r4 !== null) {
            r5 = parse_classBlock();
            if (r5 !== null) {
              r6 = parse_DEDENT();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return b; })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_THEN();
            if (r4 !== null) {
              r5 = parse__();
              if (r5 !== null) {
                r6 = parse_classStatement();
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(s) { return s; })(r6);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = parse__();
            if (r3 !== null) {
              r4 = parse_THEN();
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            r0 = r0 !== null ? r0 : "";
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function() { return new CS.Block([]); })();
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_classBlock() {
        var cacheKey = "classBlock@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_classStatement();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r8 = parse_TERMINATOR();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_classStatement();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_classStatement();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(s, ss) {
                return rp(new CS.Block([s].concat(ss.map(function(s){ return s[3]; }))));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_classStatement() {
        var cacheKey = "classStatement@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_classProtoAssignment();
        if (r0 === null) {
          r0 = parse_staticAssignment();
          if (r0 === null) {
            r0 = parse_constructor();
            if (r0 === null) {
              r0 = parse_expression();
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_constructor() {
        var cacheKey = "constructor@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        r3 = parse_ObjectInitialiserKeys();
        if (r3 !== null) {
          reportedPos = r4;
          r3 = (function(key) { return key.instanceof(CS.String, CS.Identifier) && 'constructor' === key.data || null; })(r3);
        }
        if (r3 === null) {
          pos = r4;
        }
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 58) {
              r5 = ":";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\":\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_expression();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return e; })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_expression();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return e; })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) {
                if(e.instanceof(CS.BoundFunction))
                  e = c(new CS.Function(e.parameters, e.body).r(e.raw), e);
                return rp(new CS.Constructor(e));
              })(r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_staticAssignment() {
        var cacheKey = "staticAssignment@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_contextVar();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 58) {
              r5 = ":";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\":\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r7 = parse_expression();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(key, e) {
                return rp(new CS.AssignOp(key, e));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_classProtoAssignment() {
        var cacheKey = "classProtoAssignment@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_ObjectInitialiserKeys();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 58) {
              r5 = ":";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\":\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r8 = pos;
                r9 = pos;
                r10 = parse_TERMINDENT();
                if (r10 !== null) {
                  r11 = parse_expression();
                  if (r11 !== null) {
                    r12 = parse_DEDENT();
                    if (r12 !== null) {
                      r7 = [r10, r11, r12];
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
                if (r7 !== null) {
                  reportedPos = r8;
                  r7 = (function(e) { return r({expr: e}); })(r11);
                }
                if (r7 === null) {
                  pos = r8;
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_expression();
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    reportedPos = r8;
                    r7 = (function(e) { return r({expr: e}); })(r12);
                  }
                  if (r7 === null) {
                    pos = r8;
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(key, e) {
                if('constructor' === key.data) return null;
                return rp(new CS.ClassProtoAssignOp(key, e.expr));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_forOf() {
        var cacheKey = "forOf@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14, r15, r16, r17, r18;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_FOR();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r6 = pos;
            r7 = parse_OWN();
            if (r7 !== null) {
              r8 = parse__();
              if (r8 !== null) {
                r5 = [r7, r8];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse_Assignable();
              if (r6 !== null) {
                r7 = parse__();
                if (r7 !== null) {
                  r9 = pos;
                  if (input.charCodeAt(pos) === 44) {
                    r10 = ",";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\",\"");
                    }
                  }
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_Assignable();
                      if (r12 !== null) {
                        r13 = parse__();
                        if (r13 !== null) {
                          r8 = [r10, r11, r12, r13];
                        } else {
                          r8 = null;
                          pos = r9;
                        }
                      } else {
                        r8 = null;
                        pos = r9;
                      }
                    } else {
                      r8 = null;
                      pos = r9;
                    }
                  } else {
                    r8 = null;
                    pos = r9;
                  }
                  r8 = r8 !== null ? r8 : "";
                  if (r8 !== null) {
                    r9 = parse_OF();
                    if (r9 !== null) {
                      r10 = parse__();
                      if (r10 !== null) {
                        r11 = parse_assignmentExpressionNoImplicitObjectCall();
                        if (r11 !== null) {
                          r12 = parse__();
                          if (r12 !== null) {
                            r14 = pos;
                            r15 = parse_WHEN();
                            if (r15 !== null) {
                              r16 = parse__();
                              if (r16 !== null) {
                                r17 = parse_assignmentExpressionNoImplicitObjectCall();
                                if (r17 !== null) {
                                  r18 = parse__();
                                  if (r18 !== null) {
                                    r13 = [r15, r16, r17, r18];
                                  } else {
                                    r13 = null;
                                    pos = r14;
                                  }
                                } else {
                                  r13 = null;
                                  pos = r14;
                                }
                              } else {
                                r13 = null;
                                pos = r14;
                              }
                            } else {
                              r13 = null;
                              pos = r14;
                            }
                            r13 = r13 !== null ? r13 : "";
                            if (r13 !== null) {
                              r14 = parse_conditionalBody();
                              if (r14 !== null) {
                                r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14];
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(own, key, maybeVal, obj, maybeFilter, body) {
              var val = maybeVal ? maybeVal[2] : null;
              var filter = maybeFilter ? maybeFilter[2] : null;
              return rp(new CS.ForOf(!!own, key, val, obj, filter, body.block));
            })(r5, r6, r8, r11, r13, r14);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_forIn() {
        var cacheKey = "forIn@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14, r15, r16, r17, r18;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_FOR();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_Assignable();
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r8 = pos;
                if (input.charCodeAt(pos) === 44) {
                  r9 = ",";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\",\"");
                  }
                }
                if (r9 !== null) {
                  r10 = parse__();
                  if (r10 !== null) {
                    r11 = parse_Assignable();
                    if (r11 !== null) {
                      r12 = parse__();
                      if (r12 !== null) {
                        r7 = [r9, r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r8;
                      }
                    } else {
                      r7 = null;
                      pos = r8;
                    }
                  } else {
                    r7 = null;
                    pos = r8;
                  }
                } else {
                  r7 = null;
                  pos = r8;
                }
                r7 = r7 !== null ? r7 : "";
                if (r7 !== null) {
                  r8 = parse_IN();
                  if (r8 !== null) {
                    r9 = parse__();
                    if (r9 !== null) {
                      r10 = parse_assignmentExpressionNoImplicitObjectCall();
                      if (r10 !== null) {
                        r11 = parse__();
                        if (r11 !== null) {
                          r13 = pos;
                          r14 = parse_BY();
                          if (r14 !== null) {
                            r15 = parse__();
                            if (r15 !== null) {
                              r16 = parse_assignmentExpressionNoImplicitObjectCall();
                              if (r16 !== null) {
                                r17 = parse__();
                                if (r17 !== null) {
                                  r12 = [r14, r15, r16, r17];
                                } else {
                                  r12 = null;
                                  pos = r13;
                                }
                              } else {
                                r12 = null;
                                pos = r13;
                              }
                            } else {
                              r12 = null;
                              pos = r13;
                            }
                          } else {
                            r12 = null;
                            pos = r13;
                          }
                          r12 = r12 !== null ? r12 : "";
                          if (r12 !== null) {
                            r14 = pos;
                            r15 = parse_WHEN();
                            if (r15 !== null) {
                              r16 = parse__();
                              if (r16 !== null) {
                                r17 = parse_assignmentExpressionNoImplicitObjectCall();
                                if (r17 !== null) {
                                  r18 = parse__();
                                  if (r18 !== null) {
                                    r13 = [r15, r16, r17, r18];
                                  } else {
                                    r13 = null;
                                    pos = r14;
                                  }
                                } else {
                                  r13 = null;
                                  pos = r14;
                                }
                              } else {
                                r13 = null;
                                pos = r14;
                              }
                            } else {
                              r13 = null;
                              pos = r14;
                            }
                            r13 = r13 !== null ? r13 : "";
                            if (r13 !== null) {
                              r14 = parse_conditionalBody();
                              if (r14 !== null) {
                                r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14];
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                            } else {
                              r0 = null;
                              pos = r2;
                            }
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(val, maybeKey, list, maybeStep, maybeFilter, body) {
              var key = maybeKey ? maybeKey[2] : null;
              var step = maybeStep ? maybeStep[2] : new CS.Int(1).r('1').g();
              var filter = maybeFilter ? maybeFilter[2] : null;
              return rp(new CS.ForIn(val, key, list, step, filter, body.block));
            })(r5, r7, r10, r12, r13, r14);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_switch() {
        var cacheKey = "switch@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_SWITCH();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_expressionworthy();
            if (r5 === null) {
              r5 = parse_assignmentExpression();
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse_switchBody();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, body) {
              return rp(new CS.Switch(e || null, body.cases, body['else'] || null));
            })(r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_switchBody() {
        var cacheKey = "switchBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse__();
        if (r3 !== null) {
          r4 = parse_TERMINDENT();
          if (r4 !== null) {
            r5 = parse_switchBlock();
            if (r5 !== null) {
              r6 = parse_DEDENT();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return r({cases: b.cases, 'else': b['else']}); })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_THEN();
            if (r4 !== null) {
              r5 = parse__();
              if (r5 !== null) {
                r6 = parse_case();
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(c) { return r({cases: [c]}); })(r6);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = parse__();
            if (r3 !== null) {
              r4 = parse_THEN();
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function() { return r({cases: []}); })();
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_switchBlock() {
        var cacheKey = "switchBlock@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_case();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r8 = parse_TERMINATOR();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_case();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_case();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r8 = parse_TERMINATOR();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_elseClause();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse_TERMINATOR();
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(c, cs, elseClause) {
                var cases = [c].concat(cs.map(function(w){ return w[3]; }));
                return r({cases: cases, 'else': elseClause ? elseClause[3] : null});
              })(r3, r4, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_case() {
        var cacheKey = "case@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_WHEN();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_caseConditions();
            if (r5 !== null) {
              r6 = parse_conditionalBody();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(conditions, body) {
                return rp(new CS.SwitchCase(conditions, body.block));
              })(r5, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_caseConditions() {
        var cacheKey = "caseConditions@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_assignmentExpressionNoImplicitObjectCall();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            if (input.charCodeAt(pos) === 44) {
              r8 = ",";
              pos++;
            } else {
              r8 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_assignmentExpressionNoImplicitObjectCall();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              if (input.charCodeAt(pos) === 44) {
                r8 = ",";
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_assignmentExpressionNoImplicitObjectCall();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(c, cs) {
                return [c].concat(cs.map(function(c){ return c[3]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_functionLiteral() {
        var cacheKey = "functionLiteral@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        if (input.charCodeAt(pos) === 40) {
          r5 = "(";
          pos++;
        } else {
          r5 = null;
          if (reportFailures === 0) {
            matchFailed("\"(\"");
          }
        }
        if (r5 !== null) {
          r6 = parse__();
          if (r6 !== null) {
            r8 = pos;
            r9 = pos;
            r10 = parse_TERMINDENT();
            if (r10 !== null) {
              r11 = parse_parameterList();
              if (r11 !== null) {
                r12 = parse_DEDENT();
                if (r12 !== null) {
                  r13 = parse_TERMINATOR();
                  if (r13 !== null) {
                    r7 = [r10, r11, r12, r13];
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
              } else {
                r7 = null;
                pos = r9;
              }
            } else {
              r7 = null;
              pos = r9;
            }
            if (r7 !== null) {
              reportedPos = r8;
              r7 = (function(p) { return p; })(r11);
            }
            if (r7 === null) {
              pos = r8;
            }
            if (r7 === null) {
              r7 = parse_parameterList();
            }
            r7 = r7 !== null ? r7 : "";
            if (r7 !== null) {
              r8 = parse__();
              if (r8 !== null) {
                if (input.charCodeAt(pos) === 41) {
                  r9 = ")";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\")\"");
                  }
                }
                if (r9 !== null) {
                  r10 = parse__();
                  if (r10 !== null) {
                    r3 = [r5, r6, r7, r8, r9, r10];
                  } else {
                    r3 = null;
                    pos = r4;
                  }
                } else {
                  r3 = null;
                  pos = r4;
                }
              } else {
                r3 = null;
                pos = r4;
              }
            } else {
              r3 = null;
              pos = r4;
            }
          } else {
            r3 = null;
            pos = r4;
          }
        } else {
          r3 = null;
          pos = r4;
        }
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          if (input.substr(pos, 2) === "->") {
            r4 = "->";
            pos += 2;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"->\"");
            }
          }
          if (r4 === null) {
            if (input.substr(pos, 2) === "=>") {
              r4 = "=>";
              pos += 2;
            } else {
              r4 = null;
              if (reportFailures === 0) {
                matchFailed("\"=>\"");
              }
            }
          }
          if (r4 !== null) {
            r5 = parse_functionBody();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(params, arrow, body) {
              var constructor;
              switch(arrow) {
                case '->': constructor = CS.Function; break;
                case '=>': constructor = CS.BoundFunction; break;
                default: throw new Error('parsed function arrow ("' + arrow + '") not associated with a constructor');
              }
              return rp(new constructor(params && params[2] || [], body || null));
            })(r3, r4, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_functionBody() {
        var cacheKey = "functionBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        r3 = parse__();
        if (r3 !== null) {
          r4 = parse_TERMINDENT();
          if (r4 !== null) {
            r5 = parse_block();
            if (r5 !== null) {
              r6 = parse_DEDENT();
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(b) { return b; })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_statement();
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(s) { return s; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_parameter() {
        var cacheKey = "parameter@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_Assignable();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 61) {
              r5 = "=";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r7 = parse_secondaryExpression();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(param, default_) {
                return rp(new CS.DefaultParam(param, default_));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r0 = parse_rest();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_rest() {
        var cacheKey = "rest@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_Assignable();
        if (r3 !== null) {
          if (input.substr(pos, 3) === "...") {
            r4 = "...";
            pos += 3;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"...\"");
            }
          }
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(a, rest) {
                  return rp(rest ? new CS.Rest(a) : a);
                })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_parameterList() {
        var cacheKey = "parameterList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_parameter();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            r9 = pos;
            if (input.charCodeAt(pos) === 44) {
              r10 = ",";
              pos++;
            } else {
              r10 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (r10 !== null) {
              r11 = parse_TERMINATOR();
              r11 = r11 !== null ? r11 : "";
              if (r11 !== null) {
                r8 = [r10, r11];
              } else {
                r8 = null;
                pos = r9;
              }
            } else {
              r8 = null;
              pos = r9;
            }
            if (r8 === null) {
              r8 = parse_TERMINATOR();
            }
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_parameter();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              r9 = pos;
              if (input.charCodeAt(pos) === 44) {
                r10 = ",";
                pos++;
              } else {
                r10 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              if (r10 !== null) {
                r11 = parse_TERMINATOR();
                r11 = r11 !== null ? r11 : "";
                if (r11 !== null) {
                  r8 = [r10, r11];
                } else {
                  r8 = null;
                  pos = r9;
                }
              } else {
                r8 = null;
                pos = r9;
              }
              if (r8 === null) {
                r8 = parse_TERMINATOR();
              }
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_parameter();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[3]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_range() {
        var cacheKey = "range@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 91) {
          r3 = "[";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"[\"");
          }
        }
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_secondaryExpression();
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                if (input.substr(pos, 2) === "..") {
                  r7 = "..";
                  pos += 2;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"..\"");
                  }
                }
                if (r7 !== null) {
                  if (input.charCodeAt(pos) === 46) {
                    r8 = ".";
                    pos++;
                  } else {
                    r8 = null;
                    if (reportFailures === 0) {
                      matchFailed("\".\"");
                    }
                  }
                  r8 = r8 !== null ? r8 : "";
                  if (r8 !== null) {
                    r9 = parse__();
                    if (r9 !== null) {
                      r10 = parse_secondaryExpression();
                      if (r10 !== null) {
                        r11 = parse__();
                        if (r11 !== null) {
                          if (input.charCodeAt(pos) === 93) {
                            r12 = "]";
                            pos++;
                          } else {
                            r12 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"]\"");
                            }
                          }
                          if (r12 !== null) {
                            r0 = [r3, r4, r5, r6, r7, r8, r9, r10, r11, r12];
                          } else {
                            r0 = null;
                            pos = r2;
                          }
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(left, exclusiveDot, right) {
              var inclusive = !exclusiveDot;
              return rp(new CS.Range(inclusive, left, right));
            })(r5, r8, r10);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_arrayLiteral() {
        var cacheKey = "arrayLiteral@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 91) {
          r3 = "[";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"[\"");
          }
        }
        if (r3 !== null) {
          r4 = parse_arrayLiteralBody();
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 93) {
                  r7 = "]";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"]\"");
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) {
              return rp(new CS.ArrayInitialiser(members));
            })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_arrayLiteralBody() {
        var cacheKey = "arrayLiteralBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINDENT();
        if (r3 !== null) {
          r4 = parse_arrayLiteralMemberList();
          if (r4 !== null) {
            r5 = parse_DEDENT();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) { return members; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_arrayLiteralMemberList();
            r4 = r4 !== null ? r4 : "";
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(members) { return members || []; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_arrayLiteralMemberList() {
        var cacheKey = "arrayLiteralMemberList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_arrayLiteralMember();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = [];
            r7 = pos;
            r8 = parse_arrayLiteralMemberSeparator();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_arrayLiteralMember();
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r6 = [r8, r9, r10, r11];
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              } else {
                r6 = null;
                pos = r7;
              }
            } else {
              r6 = null;
              pos = r7;
            }
            while (r6 !== null) {
              r5.push(r6);
              r7 = pos;
              r8 = parse_arrayLiteralMemberSeparator();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_arrayLiteralMember();
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r6 = [r8, r9, r10, r11];
                    } else {
                      r6 = null;
                      pos = r7;
                    }
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              } else {
                r6 = null;
                pos = r7;
              }
            }
            if (r5 !== null) {
              r6 = parse_arrayLiteralMemberSeparator();
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[2]; }));
              })(r3, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_arrayLiteralMember() {
        var cacheKey = "arrayLiteralMember@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r0 = parse_spread();
        if (r0 === null) {
          r0 = parse_expression();
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = parse_TERMINDENT();
            if (r3 !== null) {
              r4 = parse_implicitObjectLiteral();
              if (r4 !== null) {
                r5 = parse_DEDENT();
                if (r5 !== null) {
                  r0 = [r3, r4, r5];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(o) { return o; })(r4);
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_arrayLiteralMemberSeparator() {
        var cacheKey = "arrayLiteralMemberSeparator@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 44) {
              r5 = ",";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.charCodeAt(pos) === 44) {
            r3 = ",";
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (r3 !== null) {
            r4 = parse_TERMINATOR();
            r4 = r4 !== null ? r4 : "";
            if (r4 !== null) {
              r5 = parse__();
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            r0 = input.substring(pos, r1);
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_objectLiteral() {
        var cacheKey = "objectLiteral@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 123) {
          r3 = "{";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"{\"");
          }
        }
        if (r3 !== null) {
          r4 = parse_objectLiteralBody();
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 125) {
                  r7 = "}";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"}\"");
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) {
            return rp(new CS.ObjectInitialiser(members));
          })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_objectLiteralBody() {
        var cacheKey = "objectLiteralBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINDENT();
        if (r3 !== null) {
          r4 = parse_objectLiteralMemberList();
          if (r4 !== null) {
            r5 = parse_DEDENT();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) { return members; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_objectLiteralMemberList();
            r4 = r4 !== null ? r4 : "";
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(members) { return members || []; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_objectLiteralMemberList() {
        var cacheKey = "objectLiteralMemberList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_objectLiteralMember();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = [];
            r7 = pos;
            r8 = parse_arrayLiteralMemberSeparator();
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_objectLiteralMember();
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r6 = [r8, r9, r10, r11];
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              } else {
                r6 = null;
                pos = r7;
              }
            } else {
              r6 = null;
              pos = r7;
            }
            while (r6 !== null) {
              r5.push(r6);
              r7 = pos;
              r8 = parse_arrayLiteralMemberSeparator();
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_objectLiteralMember();
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r6 = [r8, r9, r10, r11];
                    } else {
                      r6 = null;
                      pos = r7;
                    }
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              } else {
                r6 = null;
                pos = r7;
              }
            }
            if (r5 !== null) {
              if (input.charCodeAt(pos) === 44) {
                r6 = ",";
                pos++;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              r6 = r6 !== null ? r6 : "";
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[2]; }));
              })(r3, r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_objectLiteralMember() {
        var cacheKey = "objectLiteralMember@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r0 = parse_implicitObjectLiteralMember();
        if (r0 === null) {
          r1 = pos;
          r0 = parse_contextVar();
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(v) {
                  var key = p(new CS.String(v.memberName).g());
                  return rp(new CS.ObjectInitialiserMember(key, v));
                })(r0);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r0 = parse_ObjectInitialiserKeys();
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(v) {
                    return rp(new CS.ObjectInitialiserMember(v, v));
                  })(r0);
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ObjectInitialiserKeys() {
        var cacheKey = "ObjectInitialiserKeys@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_identifierName();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(i) { return rp(new CS.Identifier(i)); })(r0);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r0 = parse_string();
          if (r0 === null) {
            r0 = parse_Numbers();
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_implicitObjectLiteral() {
        var cacheKey = "implicitObjectLiteral@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_implicitObjectLiteralMemberList();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) {
            return rp(new CS.ObjectInitialiser(members));
          })(r0);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_implicitObjectLiteralMemberList() {
        var cacheKey = "implicitObjectLiteralMemberList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_implicitObjectLiteralMember();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse_implicitObjectLiteralMemberSeparator();
          if (r7 !== null) {
            r8 = parse__();
            if (r8 !== null) {
              r9 = parse_implicitObjectLiteralMember();
              if (r9 !== null) {
                r5 = [r7, r8, r9];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse_implicitObjectLiteralMemberSeparator();
            if (r7 !== null) {
              r8 = parse__();
              if (r8 !== null) {
                r9 = parse_implicitObjectLiteralMember();
                if (r9 !== null) {
                  r5 = [r7, r8, r9];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[2]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_implicitObjectLiteralMemberSeparator() {
        var cacheKey = "implicitObjectLiteralMemberSeparator@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = parse_TERMINATOR();
        if (r2 !== null) {
          if (input.charCodeAt(pos) === 44) {
            r3 = ",";
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          r3 = r3 !== null ? r3 : "";
          if (r3 !== null) {
            r4 = parse__();
            if (r4 !== null) {
              r0 = [r2, r3, r4];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          if (input.charCodeAt(pos) === 44) {
            r2 = ",";
            pos++;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (r2 !== null) {
            r3 = parse_TERMINATOR();
            r3 = r3 !== null ? r3 : "";
            if (r3 !== null) {
              r0 = [r2, r3];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_implicitObjectLiteralMember() {
        var cacheKey = "implicitObjectLiteralMember@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_ObjectInitialiserKeys();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 58) {
              r5 = ":";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\":\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r7 = parse_implicitObjectLiteralMemberValue();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(key, val) {
                return rp(new CS.ObjectInitialiserMember(key, val));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_implicitObjectLiteralMemberValue() {
        var cacheKey = "implicitObjectLiteralMemberValue@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r0 = parse_expression();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse_TERMINDENT();
          if (r3 !== null) {
            r4 = parse_implicitObjectLiteral();
            if (r4 !== null) {
              r5 = parse_DEDENT();
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(o) { return o; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_macro() {
        var cacheKey = "macro@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        if (input.substr(pos, 8) === "__LINE__") {
          r0 = "__LINE__";
          pos += 8;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"__LINE__\"");
          }
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Int(line())); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          if (input.substr(pos, 12) === "__FILENAME__") {
            r0 = "__FILENAME__";
            pos += 12;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"__FILENAME__\"");
            }
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function() { return rp(new CS.String(options.inputSource || "")); })();
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            if (input.substr(pos, 8) === "__DATE__") {
              r0 = "__DATE__";
              pos += 8;
            } else {
              r0 = null;
              if (reportFailures === 0) {
                matchFailed("\"__DATE__\"");
              }
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function() { return rp(new CS.String((new Date).toDateString().slice(4))); })();
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              if (input.substr(pos, 8) === "__TIME__") {
                r0 = "__TIME__";
                pos += 8;
              } else {
                r0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"__TIME__\"");
                }
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function() { return rp(new CS.String((new Date).toTimeString().slice(0, 8))); })();
              }
              if (r0 === null) {
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                if (input.substr(pos, 14) === "__DATETIMEMS__") {
                  r0 = "__DATETIMEMS__";
                  pos += 14;
                } else {
                  r0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"__DATETIMEMS__\"");
                  }
                }
                if (r0 !== null) {
                  reportedPos = r1;
                  r0 = (function() { return rp(new CS.Int(+new Date)); })();
                }
                if (r0 === null) {
                  pos = r1;
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_bool() {
        var cacheKey = "bool@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_TRUE();
        if (r0 === null) {
          r0 = parse_YES();
          if (r0 === null) {
            r0 = parse_ON();
          }
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Bool(true)); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r0 = parse_FALSE();
          if (r0 === null) {
            r0 = parse_NO();
            if (r0 === null) {
              r0 = parse_OFF();
            }
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function() { return rp(new CS.Bool(false)); })();
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_Numbers() {
        var cacheKey = "Numbers@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "0b") {
          r3 = "0b";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"0b\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          r6 = parse_bit();
          if (r6 !== null) {
            r4 = [];
            while (r6 !== null) {
              r4.push(r6);
              r6 = parse_bit();
            }
          } else {
            r4 = null;
          }
          if (r4 !== null) {
            r4 = input.substring(pos, r5);
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(bs) { return rp(new CS.Int(parseInt(bs, 2))); })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.substr(pos, 2) === "0o") {
            r3 = "0o";
            pos += 2;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"0o\"");
            }
          }
          if (r3 !== null) {
            r5 = pos;
            r6 = parse_octalDigit();
            if (r6 !== null) {
              r4 = [];
              while (r6 !== null) {
                r4.push(r6);
                r6 = parse_octalDigit();
              }
            } else {
              r4 = null;
            }
            if (r4 !== null) {
              r4 = input.substring(pos, r5);
            }
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(os) { return rp(new CS.Int(parseInt(os, 8))); })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            if (input.substr(pos, 2) === "0x") {
              r3 = "0x";
              pos += 2;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"0x\"");
              }
            }
            if (r3 !== null) {
              r5 = pos;
              r6 = parse_hexDigit();
              if (r6 !== null) {
                r4 = [];
                while (r6 !== null) {
                  r4.push(r6);
                  r6 = parse_hexDigit();
                }
              } else {
                r4 = null;
              }
              if (r4 !== null) {
                r4 = input.substring(pos, r5);
              }
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(hs) { return rp(new CS.Int(parseInt(hs, 16))); })(r4);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              r3 = parse_decimal();
              if (r3 !== null) {
                if (/^[eE]/.test(input.charAt(pos))) {
                  r4 = input.charAt(pos);
                  pos++;
                } else {
                  r4 = null;
                  if (reportFailures === 0) {
                    matchFailed("[eE]");
                  }
                }
                if (r4 !== null) {
                  if (/^[+\-]/.test(input.charAt(pos))) {
                    r5 = input.charAt(pos);
                    pos++;
                  } else {
                    r5 = null;
                    if (reportFailures === 0) {
                      matchFailed("[+\\-]");
                    }
                  }
                  r5 = r5 !== null ? r5 : "";
                  if (r5 !== null) {
                    r6 = parse_decimal();
                    if (r6 !== null) {
                      r0 = [r3, r4, r5, r6];
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function(base, e, sign, exponent) {
                    return rp(new CS.Float(parseFloat('' + base.data + e + sign + exponent.data, 10)));
                  })(r3, r4, r5, r6);
              }
              if (r0 === null) {
                pos = r1;
              }
              if (r0 === null) {
                r0 = parse_decimal();
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_decimal() {
        var cacheKey = "decimal@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_integer();
        if (r3 !== null) {
          r5 = pos;
          r6 = pos;
          if (input.charCodeAt(pos) === 46) {
            r7 = ".";
            pos++;
          } else {
            r7 = null;
            if (reportFailures === 0) {
              matchFailed("\".\"");
            }
          }
          if (r7 !== null) {
            r9 = parse_decimalDigit();
            if (r9 !== null) {
              r8 = [];
              while (r9 !== null) {
                r8.push(r9);
                r9 = parse_decimalDigit();
              }
            } else {
              r8 = null;
            }
            if (r8 !== null) {
              r4 = [r7, r8];
            } else {
              r4 = null;
              pos = r6;
            }
          } else {
            r4 = null;
            pos = r6;
          }
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r4 = input.substring(pos, r5);
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(integral, fractional) {
              return fractional
                ? rp(new CS.Float(parseFloat(integral + fractional, 10)))
                : rp(new CS.Int(+integral));
            })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_integer() {
        var cacheKey = "integer@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        if (input.charCodeAt(pos) === 48) {
          r0 = "0";
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"0\"");
          }
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (/^[1-9]/.test(input.charAt(pos))) {
            r3 = input.charAt(pos);
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("[1-9]");
            }
          }
          if (r3 !== null) {
            r4 = [];
            r5 = parse_decimalDigit();
            while (r5 !== null) {
              r4.push(r5);
              r5 = parse_decimalDigit();
            }
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            r0 = input.substring(pos, r1);
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_decimalDigit() {
        var cacheKey = "decimalDigit@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (/^[0-9]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_hexDigit() {
        var cacheKey = "hexDigit@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (/^[0-9a-fA-F]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9a-fA-F]");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_octalDigit() {
        var cacheKey = "octalDigit@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (/^[0-7]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[0-7]");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_bit() {
        var cacheKey = "bit@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (/^[01]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[01]");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_string() {
        var cacheKey = "string@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "\"\"\"") {
          r3 = "\"\"\"";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\\"\\\"\\\"\"");
          }
        }
        if (r3 !== null) {
          r5 = parse_stringData();
          if (r5 === null) {
            if (input.charCodeAt(pos) === 39) {
              r5 = "'";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"'\"");
              }
            }
            if (r5 === null) {
              r6 = pos;
              r7 = pos;
              if (input.charCodeAt(pos) === 34) {
                r8 = "\"";
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\\"\"");
                }
              }
              if (r8 !== null) {
                if (input.charCodeAt(pos) === 34) {
                  r9 = "\"";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\\"\"");
                  }
                }
                r9 = r9 !== null ? r9 : "";
                if (r9 !== null) {
                  r11 = pos;
                  reportFailures++;
                  if (input.charCodeAt(pos) === 34) {
                    r10 = "\"";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  reportFailures--;
                  if (r10 === null) {
                    r10 = "";
                  } else {
                    r10 = null;
                    pos = r11;
                  }
                  if (r10 !== null) {
                    r5 = [r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
              if (r5 !== null) {
                r5 = input.substring(pos, r6);
              }
            }
          }
          if (r5 !== null) {
            r4 = [];
            while (r5 !== null) {
              r4.push(r5);
              r5 = parse_stringData();
              if (r5 === null) {
                if (input.charCodeAt(pos) === 39) {
                  r5 = "'";
                  pos++;
                } else {
                  r5 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"'\"");
                  }
                }
                if (r5 === null) {
                  r6 = pos;
                  r7 = pos;
                  if (input.charCodeAt(pos) === 34) {
                    r8 = "\"";
                    pos++;
                  } else {
                    r8 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  if (r8 !== null) {
                    if (input.charCodeAt(pos) === 34) {
                      r9 = "\"";
                      pos++;
                    } else {
                      r9 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\\"\"");
                      }
                    }
                    r9 = r9 !== null ? r9 : "";
                    if (r9 !== null) {
                      r11 = pos;
                      reportFailures++;
                      if (input.charCodeAt(pos) === 34) {
                        r10 = "\"";
                        pos++;
                      } else {
                        r10 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\\"\"");
                        }
                      }
                      reportFailures--;
                      if (r10 === null) {
                        r10 = "";
                      } else {
                        r10 = null;
                        pos = r11;
                      }
                      if (r10 !== null) {
                        r5 = [r8, r9, r10];
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                  if (r5 !== null) {
                    r5 = input.substring(pos, r6);
                  }
                }
              }
            }
          } else {
            r4 = null;
          }
          if (r4 !== null) {
            if (input.substr(pos, 3) === "\"\"\"") {
              r5 = "\"\"\"";
              pos += 3;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\"\\\"\\\"\"");
              }
            }
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(d) {
              return rp(new CS.String(stripLeadingWhitespace(d.join(''))));
            })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.substr(pos, 3) === "'''") {
            r3 = "'''";
            pos += 3;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"'''\"");
            }
          }
          if (r3 !== null) {
            r5 = parse_stringData();
            if (r5 === null) {
              if (input.charCodeAt(pos) === 34) {
                r5 = "\"";
                pos++;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\\"\"");
                }
              }
              if (r5 === null) {
                if (input.charCodeAt(pos) === 35) {
                  r5 = "#";
                  pos++;
                } else {
                  r5 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"#\"");
                  }
                }
                if (r5 === null) {
                  r6 = pos;
                  r7 = pos;
                  if (input.charCodeAt(pos) === 39) {
                    r8 = "'";
                    pos++;
                  } else {
                    r8 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                  if (r8 !== null) {
                    if (input.charCodeAt(pos) === 39) {
                      r9 = "'";
                      pos++;
                    } else {
                      r9 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"'\"");
                      }
                    }
                    r9 = r9 !== null ? r9 : "";
                    if (r9 !== null) {
                      r11 = pos;
                      reportFailures++;
                      if (input.charCodeAt(pos) === 39) {
                        r10 = "'";
                        pos++;
                      } else {
                        r10 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"'\"");
                        }
                      }
                      reportFailures--;
                      if (r10 === null) {
                        r10 = "";
                      } else {
                        r10 = null;
                        pos = r11;
                      }
                      if (r10 !== null) {
                        r5 = [r8, r9, r10];
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                  if (r5 !== null) {
                    r5 = input.substring(pos, r6);
                  }
                }
              }
            }
            if (r5 !== null) {
              r4 = [];
              while (r5 !== null) {
                r4.push(r5);
                r5 = parse_stringData();
                if (r5 === null) {
                  if (input.charCodeAt(pos) === 34) {
                    r5 = "\"";
                    pos++;
                  } else {
                    r5 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  if (r5 === null) {
                    if (input.charCodeAt(pos) === 35) {
                      r5 = "#";
                      pos++;
                    } else {
                      r5 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"#\"");
                      }
                    }
                    if (r5 === null) {
                      r6 = pos;
                      r7 = pos;
                      if (input.charCodeAt(pos) === 39) {
                        r8 = "'";
                        pos++;
                      } else {
                        r8 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"'\"");
                        }
                      }
                      if (r8 !== null) {
                        if (input.charCodeAt(pos) === 39) {
                          r9 = "'";
                          pos++;
                        } else {
                          r9 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"'\"");
                          }
                        }
                        r9 = r9 !== null ? r9 : "";
                        if (r9 !== null) {
                          r11 = pos;
                          reportFailures++;
                          if (input.charCodeAt(pos) === 39) {
                            r10 = "'";
                            pos++;
                          } else {
                            r10 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"'\"");
                            }
                          }
                          reportFailures--;
                          if (r10 === null) {
                            r10 = "";
                          } else {
                            r10 = null;
                            pos = r11;
                          }
                          if (r10 !== null) {
                            r5 = [r8, r9, r10];
                          } else {
                            r5 = null;
                            pos = r7;
                          }
                        } else {
                          r5 = null;
                          pos = r7;
                        }
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                      if (r5 !== null) {
                        r5 = input.substring(pos, r6);
                      }
                    }
                  }
                }
              }
            } else {
              r4 = null;
            }
            if (r4 !== null) {
              if (input.substr(pos, 3) === "'''") {
                r5 = "'''";
                pos += 3;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("\"'''\"");
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(d) {
                return rp(new CS.String(stripLeadingWhitespace(d.join(''))));
              })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            if (input.charCodeAt(pos) === 34) {
              r3 = "\"";
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\"\"");
              }
            }
            if (r3 !== null) {
              r4 = [];
              r5 = parse_stringData();
              if (r5 === null) {
                if (input.charCodeAt(pos) === 39) {
                  r5 = "'";
                  pos++;
                } else {
                  r5 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"'\"");
                  }
                }
              }
              while (r5 !== null) {
                r4.push(r5);
                r5 = parse_stringData();
                if (r5 === null) {
                  if (input.charCodeAt(pos) === 39) {
                    r5 = "'";
                    pos++;
                  } else {
                    r5 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                }
              }
              if (r4 !== null) {
                if (input.charCodeAt(pos) === 34) {
                  r5 = "\"";
                  pos++;
                } else {
                  r5 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\\"\"");
                  }
                }
                if (r5 !== null) {
                  r0 = [r3, r4, r5];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(d) { return rp(new CS.String(d.join(''))); })(r4);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              if (input.charCodeAt(pos) === 39) {
                r3 = "'";
                pos++;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"'\"");
                }
              }
              if (r3 !== null) {
                r4 = [];
                r5 = parse_stringData();
                if (r5 === null) {
                  if (input.charCodeAt(pos) === 34) {
                    r5 = "\"";
                    pos++;
                  } else {
                    r5 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  if (r5 === null) {
                    if (input.charCodeAt(pos) === 35) {
                      r5 = "#";
                      pos++;
                    } else {
                      r5 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"#\"");
                      }
                    }
                  }
                }
                while (r5 !== null) {
                  r4.push(r5);
                  r5 = parse_stringData();
                  if (r5 === null) {
                    if (input.charCodeAt(pos) === 34) {
                      r5 = "\"";
                      pos++;
                    } else {
                      r5 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\\"\"");
                      }
                    }
                    if (r5 === null) {
                      if (input.charCodeAt(pos) === 35) {
                        r5 = "#";
                        pos++;
                      } else {
                        r5 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"#\"");
                        }
                      }
                    }
                  }
                }
                if (r4 !== null) {
                  if (input.charCodeAt(pos) === 39) {
                    r5 = "'";
                    pos++;
                  } else {
                    r5 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                  if (r5 !== null) {
                    r0 = [r3, r4, r5];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function(d) { return rp(new CS.String(d.join(''))); })(r4);
              }
              if (r0 === null) {
                pos = r1;
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_stringData() {
        var cacheKey = "stringData@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        if (/^[^"'\\#]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[^\"'\\\\#]");
          }
        }
        if (r0 === null) {
          r0 = parse_UnicodeEscapeSequence();
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            if (input.substr(pos, 2) === "\\x") {
              r3 = "\\x";
              pos += 2;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\\x\"");
              }
            }
            if (r3 !== null) {
              r5 = pos;
              r6 = pos;
              r7 = parse_hexDigit();
              if (r7 !== null) {
                r8 = parse_hexDigit();
                if (r8 !== null) {
                  r4 = [r7, r8];
                } else {
                  r4 = null;
                  pos = r6;
                }
              } else {
                r4 = null;
                pos = r6;
              }
              if (r4 !== null) {
                r4 = input.substring(pos, r5);
              }
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(h) { return String.fromCharCode(parseInt(h, 16)); })(r4);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              if (input.substr(pos, 2) === "\\0") {
                r3 = "\\0";
                pos += 2;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\\\0\"");
                }
              }
              if (r3 !== null) {
                r5 = pos;
                reportFailures++;
                r4 = parse_decimalDigit();
                reportFailures--;
                if (r4 === null) {
                  r4 = "";
                } else {
                  r4 = null;
                  pos = r5;
                }
                if (r4 !== null) {
                  r0 = [r3, r4];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function() { return '\0'; })();
              }
              if (r0 === null) {
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                r2 = pos;
                if (input.substr(pos, 2) === "\\0") {
                  r3 = "\\0";
                  pos += 2;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\\\0\"");
                  }
                }
                if (r3 !== null) {
                  r5 = pos;
                  reportFailures++;
                  r4 = parse_decimalDigit();
                  reportFailures--;
                  if (r4 !== null) {
                    r4 = "";
                    pos = r5;
                  } else {
                    r4 = null;
                  }
                  if (r4 !== null) {
                    r0 = [r3, r4];
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
                if (r0 !== null) {
                  reportedPos = r1;
                  r0 = (function() { throw new SyntaxError(['string data'], 'octal escape sequence', offset(), line(), column()); })();
                }
                if (r0 === null) {
                  pos = r1;
                }
                if (r0 === null) {
                  r1 = pos;
                  if (input.substr(pos, 2) === "\\b") {
                    r0 = "\\b";
                    pos += 2;
                  } else {
                    r0 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\\b\"");
                    }
                  }
                  if (r0 !== null) {
                    reportedPos = r1;
                    r0 = (function() { return '\b'; })();
                  }
                  if (r0 === null) {
                    pos = r1;
                  }
                  if (r0 === null) {
                    r1 = pos;
                    if (input.substr(pos, 2) === "\\t") {
                      r0 = "\\t";
                      pos += 2;
                    } else {
                      r0 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\\\t\"");
                      }
                    }
                    if (r0 !== null) {
                      reportedPos = r1;
                      r0 = (function() { return '\t'; })();
                    }
                    if (r0 === null) {
                      pos = r1;
                    }
                    if (r0 === null) {
                      r1 = pos;
                      if (input.substr(pos, 2) === "\\n") {
                        r0 = "\\n";
                        pos += 2;
                      } else {
                        r0 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\\\n\"");
                        }
                      }
                      if (r0 !== null) {
                        reportedPos = r1;
                        r0 = (function() { return '\n'; })();
                      }
                      if (r0 === null) {
                        pos = r1;
                      }
                      if (r0 === null) {
                        r1 = pos;
                        if (input.substr(pos, 2) === "\\v") {
                          r0 = "\\v";
                          pos += 2;
                        } else {
                          r0 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"\\\\v\"");
                          }
                        }
                        if (r0 !== null) {
                          reportedPos = r1;
                          r0 = (function() { return '\v'; })();
                        }
                        if (r0 === null) {
                          pos = r1;
                        }
                        if (r0 === null) {
                          r1 = pos;
                          if (input.substr(pos, 2) === "\\f") {
                            r0 = "\\f";
                            pos += 2;
                          } else {
                            r0 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"\\\\f\"");
                            }
                          }
                          if (r0 !== null) {
                            reportedPos = r1;
                            r0 = (function() { return '\f'; })();
                          }
                          if (r0 === null) {
                            pos = r1;
                          }
                          if (r0 === null) {
                            r1 = pos;
                            if (input.substr(pos, 2) === "\\r") {
                              r0 = "\\r";
                              pos += 2;
                            } else {
                              r0 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"\\\\r\"");
                              }
                            }
                            if (r0 !== null) {
                              reportedPos = r1;
                              r0 = (function() { return '\r'; })();
                            }
                            if (r0 === null) {
                              pos = r1;
                            }
                            if (r0 === null) {
                              r1 = pos;
                              r2 = pos;
                              if (input.charCodeAt(pos) === 92) {
                                r3 = "\\";
                                pos++;
                              } else {
                                r3 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"\\\\\"");
                                }
                              }
                              if (r3 !== null) {
                                if (input.length > pos) {
                                  r4 = input.charAt(pos);
                                  pos++;
                                } else {
                                  r4 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("any character");
                                  }
                                }
                                if (r4 !== null) {
                                  r0 = [r3, r4];
                                } else {
                                  r0 = null;
                                  pos = r2;
                                }
                              } else {
                                r0 = null;
                                pos = r2;
                              }
                              if (r0 !== null) {
                                reportedPos = r1;
                                r0 = (function(c) { return c; })(r4);
                              }
                              if (r0 === null) {
                                pos = r1;
                              }
                              if (r0 === null) {
                                r1 = pos;
                                r2 = pos;
                                if (input.charCodeAt(pos) === 35) {
                                  r3 = "#";
                                  pos++;
                                } else {
                                  r3 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"#\"");
                                  }
                                }
                                if (r3 !== null) {
                                  r5 = pos;
                                  reportFailures++;
                                  if (input.charCodeAt(pos) === 123) {
                                    r4 = "{";
                                    pos++;
                                  } else {
                                    r4 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\"{\"");
                                    }
                                  }
                                  reportFailures--;
                                  if (r4 === null) {
                                    r4 = "";
                                  } else {
                                    r4 = null;
                                    pos = r5;
                                  }
                                  if (r4 !== null) {
                                    r0 = [r3, r4];
                                  } else {
                                    r0 = null;
                                    pos = r2;
                                  }
                                } else {
                                  r0 = null;
                                  pos = r2;
                                }
                                if (r0 !== null) {
                                  reportedPos = r1;
                                  r0 = (function(c) { return c; })(r3);
                                }
                                if (r0 === null) {
                                  pos = r1;
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_interpolation() {
        var cacheKey = "interpolation@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "\"\"\"") {
          r3 = "\"\"\"";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\\"\\\"\\\"\"");
          }
        }
        if (r3 !== null) {
          r6 = pos;
          r7 = parse_stringData();
          if (r7 === null) {
            if (input.charCodeAt(pos) === 39) {
              r7 = "'";
              pos++;
            } else {
              r7 = null;
              if (reportFailures === 0) {
                matchFailed("\"'\"");
              }
            }
            if (r7 === null) {
              r8 = pos;
              r9 = pos;
              if (input.charCodeAt(pos) === 34) {
                r10 = "\"";
                pos++;
              } else {
                r10 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\\"\"");
                }
              }
              if (r10 !== null) {
                if (input.charCodeAt(pos) === 34) {
                  r11 = "\"";
                  pos++;
                } else {
                  r11 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\\"\"");
                  }
                }
                r11 = r11 !== null ? r11 : "";
                if (r11 !== null) {
                  r13 = pos;
                  reportFailures++;
                  if (input.charCodeAt(pos) === 34) {
                    r12 = "\"";
                    pos++;
                  } else {
                    r12 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  reportFailures--;
                  if (r12 === null) {
                    r12 = "";
                  } else {
                    r12 = null;
                    pos = r13;
                  }
                  if (r12 !== null) {
                    r7 = [r10, r11, r12];
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                } else {
                  r7 = null;
                  pos = r9;
                }
              } else {
                r7 = null;
                pos = r9;
              }
              if (r7 !== null) {
                r7 = input.substring(pos, r8);
              }
            }
          }
          if (r7 !== null) {
            r5 = [];
            while (r7 !== null) {
              r5.push(r7);
              r7 = parse_stringData();
              if (r7 === null) {
                if (input.charCodeAt(pos) === 39) {
                  r7 = "'";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"'\"");
                  }
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  if (input.charCodeAt(pos) === 34) {
                    r10 = "\"";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  if (r10 !== null) {
                    if (input.charCodeAt(pos) === 34) {
                      r11 = "\"";
                      pos++;
                    } else {
                      r11 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\\"\"");
                      }
                    }
                    r11 = r11 !== null ? r11 : "";
                    if (r11 !== null) {
                      r13 = pos;
                      reportFailures++;
                      if (input.charCodeAt(pos) === 34) {
                        r12 = "\"";
                        pos++;
                      } else {
                        r12 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\\"\"");
                        }
                      }
                      reportFailures--;
                      if (r12 === null) {
                        r12 = "";
                      } else {
                        r12 = null;
                        pos = r13;
                      }
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    r7 = input.substring(pos, r8);
                  }
                }
              }
            }
          } else {
            r5 = null;
          }
          if (r5 !== null) {
            reportedPos = r6;
            r5 = (function(d) { return rp(new CS.String(d.join(''))); })(r5);
          }
          if (r5 === null) {
            pos = r6;
          }
          if (r5 === null) {
            r6 = pos;
            r7 = pos;
            if (input.substr(pos, 2) === "#{") {
              r8 = "#{";
              pos += 2;
            } else {
              r8 = null;
              if (reportFailures === 0) {
                matchFailed("\"#{\"");
              }
            }
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_expression();
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    if (input.charCodeAt(pos) === 125) {
                      r12 = "}";
                      pos++;
                    } else {
                      r12 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"}\"");
                      }
                    }
                    if (r12 !== null) {
                      r5 = [r8, r9, r10, r11, r12];
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
            } else {
              r5 = null;
              pos = r7;
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(e) { return e; })(r10);
            }
            if (r5 === null) {
              pos = r6;
            }
          }
          if (r5 !== null) {
            r4 = [];
            while (r5 !== null) {
              r4.push(r5);
              r6 = pos;
              r7 = parse_stringData();
              if (r7 === null) {
                if (input.charCodeAt(pos) === 39) {
                  r7 = "'";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"'\"");
                  }
                }
                if (r7 === null) {
                  r8 = pos;
                  r9 = pos;
                  if (input.charCodeAt(pos) === 34) {
                    r10 = "\"";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\\"\"");
                    }
                  }
                  if (r10 !== null) {
                    if (input.charCodeAt(pos) === 34) {
                      r11 = "\"";
                      pos++;
                    } else {
                      r11 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\\"\"");
                      }
                    }
                    r11 = r11 !== null ? r11 : "";
                    if (r11 !== null) {
                      r13 = pos;
                      reportFailures++;
                      if (input.charCodeAt(pos) === 34) {
                        r12 = "\"";
                        pos++;
                      } else {
                        r12 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\\"\"");
                        }
                      }
                      reportFailures--;
                      if (r12 === null) {
                        r12 = "";
                      } else {
                        r12 = null;
                        pos = r13;
                      }
                      if (r12 !== null) {
                        r7 = [r10, r11, r12];
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                    } else {
                      r7 = null;
                      pos = r9;
                    }
                  } else {
                    r7 = null;
                    pos = r9;
                  }
                  if (r7 !== null) {
                    r7 = input.substring(pos, r8);
                  }
                }
              }
              if (r7 !== null) {
                r5 = [];
                while (r7 !== null) {
                  r5.push(r7);
                  r7 = parse_stringData();
                  if (r7 === null) {
                    if (input.charCodeAt(pos) === 39) {
                      r7 = "'";
                      pos++;
                    } else {
                      r7 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"'\"");
                      }
                    }
                    if (r7 === null) {
                      r8 = pos;
                      r9 = pos;
                      if (input.charCodeAt(pos) === 34) {
                        r10 = "\"";
                        pos++;
                      } else {
                        r10 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\\"\"");
                        }
                      }
                      if (r10 !== null) {
                        if (input.charCodeAt(pos) === 34) {
                          r11 = "\"";
                          pos++;
                        } else {
                          r11 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"\\\"\"");
                          }
                        }
                        r11 = r11 !== null ? r11 : "";
                        if (r11 !== null) {
                          r13 = pos;
                          reportFailures++;
                          if (input.charCodeAt(pos) === 34) {
                            r12 = "\"";
                            pos++;
                          } else {
                            r12 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"\\\"\"");
                            }
                          }
                          reportFailures--;
                          if (r12 === null) {
                            r12 = "";
                          } else {
                            r12 = null;
                            pos = r13;
                          }
                          if (r12 !== null) {
                            r7 = [r10, r11, r12];
                          } else {
                            r7 = null;
                            pos = r9;
                          }
                        } else {
                          r7 = null;
                          pos = r9;
                        }
                      } else {
                        r7 = null;
                        pos = r9;
                      }
                      if (r7 !== null) {
                        r7 = input.substring(pos, r8);
                      }
                    }
                  }
                }
              } else {
                r5 = null;
              }
              if (r5 !== null) {
                reportedPos = r6;
                r5 = (function(d) { return rp(new CS.String(d.join(''))); })(r5);
              }
              if (r5 === null) {
                pos = r6;
              }
              if (r5 === null) {
                r6 = pos;
                r7 = pos;
                if (input.substr(pos, 2) === "#{") {
                  r8 = "#{";
                  pos += 2;
                } else {
                  r8 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"#{\"");
                  }
                }
                if (r8 !== null) {
                  r9 = parse__();
                  if (r9 !== null) {
                    r10 = parse_expression();
                    if (r10 !== null) {
                      r11 = parse__();
                      if (r11 !== null) {
                        if (input.charCodeAt(pos) === 125) {
                          r12 = "}";
                          pos++;
                        } else {
                          r12 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"}\"");
                          }
                        }
                        if (r12 !== null) {
                          r5 = [r8, r9, r10, r11, r12];
                        } else {
                          r5 = null;
                          pos = r7;
                        }
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
                if (r5 !== null) {
                  reportedPos = r6;
                  r5 = (function(e) { return e; })(r10);
                }
                if (r5 === null) {
                  pos = r6;
                }
              }
            }
          } else {
            r4 = null;
          }
          if (r4 !== null) {
            if (input.substr(pos, 3) === "\"\"\"") {
              r5 = "\"\"\"";
              pos += 3;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\"\\\"\\\"\"");
              }
            }
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(es) {
              return rp(createInterpolation(stripLeadingWhitespaceInterpolation(es)));
            })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.charCodeAt(pos) === 34) {
            r3 = "\"";
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\\"\"");
            }
          }
          if (r3 !== null) {
            r6 = pos;
            r7 = parse_stringData();
            if (r7 === null) {
              if (input.charCodeAt(pos) === 39) {
                r7 = "'";
                pos++;
              } else {
                r7 = null;
                if (reportFailures === 0) {
                  matchFailed("\"'\"");
                }
              }
            }
            if (r7 !== null) {
              r5 = [];
              while (r7 !== null) {
                r5.push(r7);
                r7 = parse_stringData();
                if (r7 === null) {
                  if (input.charCodeAt(pos) === 39) {
                    r7 = "'";
                    pos++;
                  } else {
                    r7 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                }
              }
            } else {
              r5 = null;
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(d) { return rp(new CS.String(d.join(''))); })(r5);
            }
            if (r5 === null) {
              pos = r6;
            }
            if (r5 === null) {
              r6 = pos;
              r7 = pos;
              if (input.substr(pos, 2) === "#{") {
                r8 = "#{";
                pos += 2;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\"#{\"");
                }
              }
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_expression();
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      if (input.charCodeAt(pos) === 125) {
                        r12 = "}";
                        pos++;
                      } else {
                        r12 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"}\"");
                        }
                      }
                      if (r12 !== null) {
                        r5 = [r8, r9, r10, r11, r12];
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                } else {
                  r5 = null;
                  pos = r7;
                }
              } else {
                r5 = null;
                pos = r7;
              }
              if (r5 !== null) {
                reportedPos = r6;
                r5 = (function(e) { return e; })(r10);
              }
              if (r5 === null) {
                pos = r6;
              }
            }
            if (r5 !== null) {
              r4 = [];
              while (r5 !== null) {
                r4.push(r5);
                r6 = pos;
                r7 = parse_stringData();
                if (r7 === null) {
                  if (input.charCodeAt(pos) === 39) {
                    r7 = "'";
                    pos++;
                  } else {
                    r7 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                }
                if (r7 !== null) {
                  r5 = [];
                  while (r7 !== null) {
                    r5.push(r7);
                    r7 = parse_stringData();
                    if (r7 === null) {
                      if (input.charCodeAt(pos) === 39) {
                        r7 = "'";
                        pos++;
                      } else {
                        r7 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"'\"");
                        }
                      }
                    }
                  }
                } else {
                  r5 = null;
                }
                if (r5 !== null) {
                  reportedPos = r6;
                  r5 = (function(d) { return rp(new CS.String(d.join(''))); })(r5);
                }
                if (r5 === null) {
                  pos = r6;
                }
                if (r5 === null) {
                  r6 = pos;
                  r7 = pos;
                  if (input.substr(pos, 2) === "#{") {
                    r8 = "#{";
                    pos += 2;
                  } else {
                    r8 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"#{\"");
                    }
                  }
                  if (r8 !== null) {
                    r9 = parse__();
                    if (r9 !== null) {
                      r10 = parse_expression();
                      if (r10 !== null) {
                        r11 = parse__();
                        if (r11 !== null) {
                          if (input.charCodeAt(pos) === 125) {
                            r12 = "}";
                            pos++;
                          } else {
                            r12 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"}\"");
                            }
                          }
                          if (r12 !== null) {
                            r5 = [r8, r9, r10, r11, r12];
                          } else {
                            r5 = null;
                            pos = r7;
                          }
                        } else {
                          r5 = null;
                          pos = r7;
                        }
                      } else {
                        r5 = null;
                        pos = r7;
                      }
                    } else {
                      r5 = null;
                      pos = r7;
                    }
                  } else {
                    r5 = null;
                    pos = r7;
                  }
                  if (r5 !== null) {
                    reportedPos = r6;
                    r5 = (function(e) { return e; })(r10);
                  }
                  if (r5 === null) {
                    pos = r6;
                  }
                }
              }
            } else {
              r4 = null;
            }
            if (r4 !== null) {
              if (input.charCodeAt(pos) === 34) {
                r5 = "\"";
                pos++;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\\"\"");
                }
              }
              if (r5 !== null) {
                r0 = [r3, r4, r5];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(es) {
                return rp(createInterpolation(es));
              })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_regexp() {
        var cacheKey = "regexp@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "///") {
          r3 = "///";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"///\"");
          }
        }
        if (r3 !== null) {
          r6 = pos;
          if (/^[ \r\n]/.test(input.charAt(pos))) {
            r7 = input.charAt(pos);
            pos++;
          } else {
            r7 = null;
            if (reportFailures === 0) {
              matchFailed("[ \\r\\n]");
            }
          }
          if (r7 !== null) {
            r5 = [];
            while (r7 !== null) {
              r5.push(r7);
              if (/^[ \r\n]/.test(input.charAt(pos))) {
                r7 = input.charAt(pos);
                pos++;
              } else {
                r7 = null;
                if (reportFailures === 0) {
                  matchFailed("[ \\r\\n]");
                }
              }
            }
          } else {
            r5 = null;
          }
          if (r5 !== null) {
            reportedPos = r6;
            r5 = (function() { return [rp(new CS.String('').g())]; })();
          }
          if (r5 === null) {
            pos = r6;
          }
          if (r5 === null) {
            r6 = pos;
            if (/^[^\\\/#[ \r\n]/.test(input.charAt(pos))) {
              r7 = input.charAt(pos);
              pos++;
            } else {
              r7 = null;
              if (reportFailures === 0) {
                matchFailed("[^\\\\\\/#[ \\r\\n]");
              }
            }
            if (r7 !== null) {
              r5 = [];
              while (r7 !== null) {
                r5.push(r7);
                if (/^[^\\\/#[ \r\n]/.test(input.charAt(pos))) {
                  r7 = input.charAt(pos);
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("[^\\\\\\/#[ \\r\\n]");
                  }
                }
              }
            } else {
              r5 = null;
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(s) { return [rp(new CS.String(s.join('')).g())]; })(r5);
            }
            if (r5 === null) {
              pos = r6;
            }
            if (r5 === null) {
              r5 = parse_hereregexpData();
            }
          }
          if (r5 !== null) {
            r4 = [];
            while (r5 !== null) {
              r4.push(r5);
              r6 = pos;
              if (/^[ \r\n]/.test(input.charAt(pos))) {
                r7 = input.charAt(pos);
                pos++;
              } else {
                r7 = null;
                if (reportFailures === 0) {
                  matchFailed("[ \\r\\n]");
                }
              }
              if (r7 !== null) {
                r5 = [];
                while (r7 !== null) {
                  r5.push(r7);
                  if (/^[ \r\n]/.test(input.charAt(pos))) {
                    r7 = input.charAt(pos);
                    pos++;
                  } else {
                    r7 = null;
                    if (reportFailures === 0) {
                      matchFailed("[ \\r\\n]");
                    }
                  }
                }
              } else {
                r5 = null;
              }
              if (r5 !== null) {
                reportedPos = r6;
                r5 = (function() { return [rp(new CS.String('').g())]; })();
              }
              if (r5 === null) {
                pos = r6;
              }
              if (r5 === null) {
                r6 = pos;
                if (/^[^\\\/#[ \r\n]/.test(input.charAt(pos))) {
                  r7 = input.charAt(pos);
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("[^\\\\\\/#[ \\r\\n]");
                  }
                }
                if (r7 !== null) {
                  r5 = [];
                  while (r7 !== null) {
                    r5.push(r7);
                    if (/^[^\\\/#[ \r\n]/.test(input.charAt(pos))) {
                      r7 = input.charAt(pos);
                      pos++;
                    } else {
                      r7 = null;
                      if (reportFailures === 0) {
                        matchFailed("[^\\\\\\/#[ \\r\\n]");
                      }
                    }
                  }
                } else {
                  r5 = null;
                }
                if (r5 !== null) {
                  reportedPos = r6;
                  r5 = (function(s) { return [rp(new CS.String(s.join('')).g())]; })(r5);
                }
                if (r5 === null) {
                  pos = r6;
                }
                if (r5 === null) {
                  r5 = parse_hereregexpData();
                }
              }
            }
          } else {
            r4 = null;
          }
          if (r4 !== null) {
            if (input.substr(pos, 3) === "///") {
              r5 = "///";
              pos += 3;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"///\"");
              }
            }
            if (r5 !== null) {
              r6 = [];
              if (/^[gimy]/.test(input.charAt(pos))) {
                r7 = input.charAt(pos);
                pos++;
              } else {
                r7 = null;
                if (reportFailures === 0) {
                  matchFailed("[gimy]");
                }
              }
              while (r7 !== null) {
                r6.push(r7);
                if (/^[gimy]/.test(input.charAt(pos))) {
                  r7 = input.charAt(pos);
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("[gimy]");
                  }
                }
              }
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(es, flags) {
              if(!isValidRegExpFlags(flags))
                throw new SyntaxError(['regular expression flags'], 'regular expression flags', offset(), line(), column());
              if(!flags) flags = [];
              var interp = createInterpolation(foldl(function(memo, e){ return memo.concat(e); }, [], es));
              if(interp instanceof CS.String) return p(new CS.RegExp(interp.data, flags));
              return rp(new CS.HeregExp(interp, flags));
            })(r4, r6);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.charCodeAt(pos) === 47) {
            r3 = "/";
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"/\"");
            }
          }
          if (r3 !== null) {
            r4 = [];
            r5 = parse_regexpData();
            if (r5 === null) {
              r6 = pos;
              if (/^[^\/\\[\n]/.test(input.charAt(pos))) {
                r7 = input.charAt(pos);
                pos++;
              } else {
                r7 = null;
                if (reportFailures === 0) {
                  matchFailed("[^\\/\\\\[\\n]");
                }
              }
              if (r7 !== null) {
                r5 = [];
                while (r7 !== null) {
                  r5.push(r7);
                  if (/^[^\/\\[\n]/.test(input.charAt(pos))) {
                    r7 = input.charAt(pos);
                    pos++;
                  } else {
                    r7 = null;
                    if (reportFailures === 0) {
                      matchFailed("[^\\/\\\\[\\n]");
                    }
                  }
                }
              } else {
                r5 = null;
              }
              if (r5 !== null) {
                reportedPos = r6;
                r5 = (function(d) { return d.join(''); })(r5);
              }
              if (r5 === null) {
                pos = r6;
              }
            }
            while (r5 !== null) {
              r4.push(r5);
              r5 = parse_regexpData();
              if (r5 === null) {
                r6 = pos;
                if (/^[^\/\\[\n]/.test(input.charAt(pos))) {
                  r7 = input.charAt(pos);
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("[^\\/\\\\[\\n]");
                  }
                }
                if (r7 !== null) {
                  r5 = [];
                  while (r7 !== null) {
                    r5.push(r7);
                    if (/^[^\/\\[\n]/.test(input.charAt(pos))) {
                      r7 = input.charAt(pos);
                      pos++;
                    } else {
                      r7 = null;
                      if (reportFailures === 0) {
                        matchFailed("[^\\/\\\\[\\n]");
                      }
                    }
                  }
                } else {
                  r5 = null;
                }
                if (r5 !== null) {
                  reportedPos = r6;
                  r5 = (function(d) { return d.join(''); })(r5);
                }
                if (r5 === null) {
                  pos = r6;
                }
              }
            }
            if (r4 !== null) {
              if (input.charCodeAt(pos) === 47) {
                r5 = "/";
                pos++;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("\"/\"");
                }
              }
              if (r5 !== null) {
                r6 = [];
                if (/^[gimy]/.test(input.charAt(pos))) {
                  r7 = input.charAt(pos);
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("[gimy]");
                  }
                }
                while (r7 !== null) {
                  r6.push(r7);
                  if (/^[gimy]/.test(input.charAt(pos))) {
                    r7 = input.charAt(pos);
                    pos++;
                  } else {
                    r7 = null;
                    if (reportFailures === 0) {
                      matchFailed("[gimy]");
                    }
                  }
                }
                if (r6 !== null) {
                  r0 = [r3, r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(d, flags) {
                if(!isValidRegExpFlags(flags))
                  throw new SyntaxError(['regular expression flags'], 'regular expression flags', offset(), line(), column());
                return rp(new CS.RegExp(d.join(''), flags));
              })(r4, r6);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_regexpData() {
        var cacheKey = "regexpData@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 91) {
          r3 = "[";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"[\"");
          }
        }
        if (r3 !== null) {
          r4 = [];
          if (/^[^\\\]\n]/.test(input.charAt(pos))) {
            r5 = input.charAt(pos);
            pos++;
          } else {
            r5 = null;
            if (reportFailures === 0) {
              matchFailed("[^\\\\\\]\\n]");
            }
          }
          if (r5 === null) {
            r5 = parse_regexpData();
          }
          while (r5 !== null) {
            r4.push(r5);
            if (/^[^\\\]\n]/.test(input.charAt(pos))) {
              r5 = input.charAt(pos);
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("[^\\\\\\]\\n]");
              }
            }
            if (r5 === null) {
              r5 = parse_regexpData();
            }
          }
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 93) {
              r5 = "]";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"]\"");
              }
            }
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(d) { return '[' + d.join('') + ']'; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          if (input.charCodeAt(pos) === 92) {
            r3 = "\\";
            pos++;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\\\\"");
            }
          }
          if (r3 !== null) {
            if (input.length > pos) {
              r4 = input.charAt(pos);
              pos++;
            } else {
              r4 = null;
              if (reportFailures === 0) {
                matchFailed("any character");
              }
            }
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            r0 = input.substring(pos, r1);
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_hereregexpData() {
        var cacheKey = "hereregexpData@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 91) {
          r3 = "[";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"[\"");
          }
        }
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r5 = parse_hereregexpData();
          if (r5 !== null) {
            reportedPos = r6;
            r5 = (function(h) { return h[0]; })(r5);
          }
          if (r5 === null) {
            pos = r6;
          }
          if (r5 === null) {
            r6 = pos;
            if (/^[^\\\/\]]/.test(input.charAt(pos))) {
              r5 = input.charAt(pos);
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("[^\\\\\\/\\]]");
              }
            }
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(s) { return p(new CS.String(s)); })(r5);
            }
            if (r5 === null) {
              pos = r6;
            }
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r5 = parse_hereregexpData();
            if (r5 !== null) {
              reportedPos = r6;
              r5 = (function(h) { return h[0]; })(r5);
            }
            if (r5 === null) {
              pos = r6;
            }
            if (r5 === null) {
              r6 = pos;
              if (/^[^\\\/\]]/.test(input.charAt(pos))) {
                r5 = input.charAt(pos);
                pos++;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("[^\\\\\\/\\]]");
                }
              }
              if (r5 !== null) {
                reportedPos = r6;
                r5 = (function(s) { return p(new CS.String(s)); })(r5);
              }
              if (r5 === null) {
                pos = r6;
              }
            }
          }
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 93) {
              r5 = "]";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\"]\"");
              }
            }
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(d) {
                return [p(new CS.String("["))].concat(d || []).concat([p(new CS.String("]"))]);
              })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = pos;
          if (input.charCodeAt(pos) === 92) {
            r4 = "\\";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\\\\"");
            }
          }
          if (r4 !== null) {
            if (input.length > pos) {
              r5 = input.charAt(pos);
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("any character");
              }
            }
            if (r5 !== null) {
              r0 = [r4, r5];
            } else {
              r0 = null;
              pos = r3;
            }
          } else {
            r0 = null;
            pos = r3;
          }
          if (r0 !== null) {
            r0 = input.substring(pos, r2);
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(d) { return [rp(new CS.String(d))]; })(r0);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r3 = pos;
            if (input.charCodeAt(pos) === 47) {
              r4 = "/";
              pos++;
            } else {
              r4 = null;
              if (reportFailures === 0) {
                matchFailed("\"/\"");
              }
            }
            if (r4 !== null) {
              if (input.charCodeAt(pos) === 47) {
                r5 = "/";
                pos++;
              } else {
                r5 = null;
                if (reportFailures === 0) {
                  matchFailed("\"/\"");
                }
              }
              r5 = r5 !== null ? r5 : "";
              if (r5 !== null) {
                r7 = pos;
                reportFailures++;
                if (input.charCodeAt(pos) === 47) {
                  r6 = "/";
                  pos++;
                } else {
                  r6 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"/\"");
                  }
                }
                reportFailures--;
                if (r6 === null) {
                  r6 = "";
                } else {
                  r6 = null;
                  pos = r7;
                }
                if (r6 !== null) {
                  r0 = [r4, r5, r6];
                } else {
                  r0 = null;
                  pos = r3;
                }
              } else {
                r0 = null;
                pos = r3;
              }
            } else {
              r0 = null;
              pos = r3;
            }
            if (r0 !== null) {
              r0 = input.substring(pos, r2);
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(s) { return [rp(new CS.String(s))]; })(r0);
            }
            if (r0 === null) {
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              r2 = pos;
              if (input.charCodeAt(pos) === 35) {
                r3 = "#";
                pos++;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"#\"");
                }
              }
              if (r3 !== null) {
                r5 = pos;
                reportFailures++;
                if (input.charCodeAt(pos) === 123) {
                  r4 = "{";
                  pos++;
                } else {
                  r4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"{\"");
                  }
                }
                reportFailures--;
                if (r4 === null) {
                  r4 = "";
                } else {
                  r4 = null;
                  pos = r5;
                }
                if (r4 !== null) {
                  r0 = [r3, r4];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
              if (r0 !== null) {
                reportedPos = r1;
                r0 = (function(c) { return [rp(new CS.String(c))]; })(r3);
              }
              if (r0 === null) {
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                r2 = pos;
                if (input.substr(pos, 2) === "#{") {
                  r3 = "#{";
                  pos += 2;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"#{\"");
                  }
                }
                if (r3 !== null) {
                  r4 = parse__();
                  if (r4 !== null) {
                    r5 = parse_expression();
                    if (r5 !== null) {
                      r6 = parse__();
                      if (r6 !== null) {
                        if (input.charCodeAt(pos) === 125) {
                          r7 = "}";
                          pos++;
                        } else {
                          r7 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"}\"");
                          }
                        }
                        if (r7 !== null) {
                          r0 = [r3, r4, r5, r6, r7];
                        } else {
                          r0 = null;
                          pos = r2;
                        }
                      } else {
                        r0 = null;
                        pos = r2;
                      }
                    } else {
                      r0 = null;
                      pos = r2;
                    }
                  } else {
                    r0 = null;
                    pos = r2;
                  }
                } else {
                  r0 = null;
                  pos = r2;
                }
                if (r0 !== null) {
                  reportedPos = r1;
                  r0 = (function(e) { return [e]; })(r5);
                }
                if (r0 === null) {
                  pos = r1;
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_throw() {
        var cacheKey = "throw@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_THROW();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_secondaryExpression();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) { return rp(new CS.Throw(e)); })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_return() {
        var cacheKey = "return@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_RETURN();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            r5 = parse_secondaryExpression();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e) { return rp(new CS.Return(e || null)); })(r5);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_continue() {
        var cacheKey = "continue@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_CONTINUE();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Continue); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_break() {
        var cacheKey = "break@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_BREAK();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Break); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_debugger() {
        var cacheKey = "debugger@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_DEBUGGER();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Debugger); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_undefined() {
        var cacheKey = "undefined@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_UNDEFINED();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Undefined); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_null() {
        var cacheKey = "null@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1;
        
        r1 = pos;
        r0 = parse_NULL();
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function() { return rp(new CS.Null); })();
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_unassignable() {
        var cacheKey = "unassignable@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        if (input.substr(pos, 9) === "arguments") {
          r2 = "arguments";
          pos += 9;
        } else {
          r2 = null;
          if (reportFailures === 0) {
            matchFailed("\"arguments\"");
          }
        }
        if (r2 === null) {
          if (input.substr(pos, 4) === "eval") {
            r2 = "eval";
            pos += 4;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"eval\"");
            }
          }
        }
        if (r2 !== null) {
          r4 = pos;
          reportFailures++;
          r3 = parse_identifierPart();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r0 = [r2, r3];
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CompoundAssignable() {
        var cacheKey = "CompoundAssignable@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r0 = parse_memberAccess();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r4 = pos;
          reportFailures++;
          r3 = parse_unassignable();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r4 = parse_identifier();
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(i) { return i; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r0 = parse_contextVar();
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_Assignable() {
        var cacheKey = "Assignable@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r0 = parse_memberAccess();
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r4 = pos;
          reportFailures++;
          r3 = parse_unassignable();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r4 = parse_identifier();
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(i) { return i; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r0 = parse_contextVar();
            if (r0 === null) {
              r0 = parse_positionalDestructuring();
              if (r0 === null) {
                r0 = parse_namedDestructuring();
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_positionalDestructuring() {
        var cacheKey = "positionalDestructuring@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 91) {
          r3 = "[";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"[\"");
          }
        }
        if (r3 !== null) {
          r4 = parse_positionalDestructuringBody();
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 93) {
                  r7 = "]";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"]\"");
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) {
              return rp(new CS.ArrayInitialiser(members));
            })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_positionalDestructuringBody() {
        var cacheKey = "positionalDestructuringBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINDENT();
        if (r3 !== null) {
          r4 = parse_positionalDestructuringMemberList();
          if (r4 !== null) {
            r5 = parse_DEDENT();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) { return members; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_positionalDestructuringMemberList();
            r4 = r4 !== null ? r4 : "";
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(members) { return members || []; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_positionalDestructuringMemberList() {
        var cacheKey = "positionalDestructuringMemberList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_positionalDestructuringMember();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse__();
          if (r7 !== null) {
            if (input.charCodeAt(pos) === 44) {
              r8 = ",";
              pos++;
            } else {
              r8 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (r8 !== null) {
              r9 = parse__();
              if (r9 !== null) {
                r10 = parse_positionalDestructuringMember();
                if (r10 !== null) {
                  r5 = [r7, r8, r9, r10];
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse__();
            if (r7 !== null) {
              if (input.charCodeAt(pos) === 44) {
                r8 = ",";
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              if (r8 !== null) {
                r9 = parse__();
                if (r9 !== null) {
                  r10 = parse_positionalDestructuringMember();
                  if (r10 !== null) {
                    r5 = [r7, r8, r9, r10];
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[3]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_positionalDestructuringMember() {
        var cacheKey = "positionalDestructuringMember@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_rest();
        if (r0 === null) {
          r0 = parse_Assignable();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_namedDestructuring() {
        var cacheKey = "namedDestructuring@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 123) {
          r3 = "{";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"{\"");
          }
        }
        if (r3 !== null) {
          r4 = parse_namedDestructuringBody();
          if (r4 !== null) {
            r5 = parse_TERMINATOR();
            r5 = r5 !== null ? r5 : "";
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                if (input.charCodeAt(pos) === 125) {
                  r7 = "}";
                  pos++;
                } else {
                  r7 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"}\"");
                  }
                }
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) {
            return rp(new CS.ObjectInitialiser(members));
          })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_namedDestructuringBody() {
        var cacheKey = "namedDestructuringBody@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINDENT();
        if (r3 !== null) {
          r4 = parse_namedDestructuringMemberList();
          if (r4 !== null) {
            r5 = parse_DEDENT();
            if (r5 !== null) {
              r0 = [r3, r4, r5];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(members) { return members; })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r2 = pos;
          r3 = parse__();
          if (r3 !== null) {
            r4 = parse_namedDestructuringMemberList();
            r4 = r4 !== null ? r4 : "";
            if (r4 !== null) {
              r0 = [r3, r4];
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(members) { return members || []; })(r4);
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_namedDestructuringMemberList() {
        var cacheKey = "namedDestructuringMemberList@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_namedDestructuringMember();
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r7 = parse_TERMINATOR();
          r7 = r7 !== null ? r7 : "";
          if (r7 !== null) {
            r8 = parse__();
            if (r8 !== null) {
              if (input.charCodeAt(pos) === 44) {
                r9 = ",";
                pos++;
              } else {
                r9 = null;
                if (reportFailures === 0) {
                  matchFailed("\",\"");
                }
              }
              if (r9 === null) {
                r9 = parse_TERMINATOR();
              }
              if (r9 !== null) {
                r10 = parse_TERMINATOR();
                r10 = r10 !== null ? r10 : "";
                if (r10 !== null) {
                  r11 = parse__();
                  if (r11 !== null) {
                    r12 = parse_namedDestructuringMember();
                    if (r12 !== null) {
                      r5 = [r7, r8, r9, r10, r11, r12];
                    } else {
                      r5 = null;
                      pos = r6;
                    }
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r7 = parse_TERMINATOR();
            r7 = r7 !== null ? r7 : "";
            if (r7 !== null) {
              r8 = parse__();
              if (r8 !== null) {
                if (input.charCodeAt(pos) === 44) {
                  r9 = ",";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\",\"");
                  }
                }
                if (r9 === null) {
                  r9 = parse_TERMINATOR();
                }
                if (r9 !== null) {
                  r10 = parse_TERMINATOR();
                  r10 = r10 !== null ? r10 : "";
                  if (r10 !== null) {
                    r11 = parse__();
                    if (r11 !== null) {
                      r12 = parse_namedDestructuringMember();
                      if (r12 !== null) {
                        r5 = [r7, r8, r9, r10, r11, r12];
                      } else {
                        r5 = null;
                        pos = r6;
                      }
                    } else {
                      r5 = null;
                      pos = r6;
                    }
                  } else {
                    r5 = null;
                    pos = r6;
                  }
                } else {
                  r5 = null;
                  pos = r6;
                }
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(e, es) {
                return [e].concat(es.map(function(e){ return e[5]; }));
              })(r3, r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_namedDestructuringMember() {
        var cacheKey = "namedDestructuringMember@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_ObjectInitialiserKeys();
        if (r3 !== null) {
          r4 = parse__();
          if (r4 !== null) {
            if (input.charCodeAt(pos) === 58) {
              r5 = ":";
              pos++;
            } else {
              r5 = null;
              if (reportFailures === 0) {
                matchFailed("\":\"");
              }
            }
            if (r5 !== null) {
              r6 = parse__();
              if (r6 !== null) {
                r7 = parse_Assignable();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(key, val) {
                return rp(new CS.ObjectInitialiserMember(key, val));
              })(r3, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        if (r0 === null) {
          r1 = pos;
          r0 = parse_contextVar();
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function(v) {
                  var key = rp(new CS.String(v.memberName));
                  return rp(new CS.ObjectInitialiserMember(key, v));
                })(r0);
          }
          if (r0 === null) {
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            r4 = pos;
            reportFailures++;
            r3 = parse_unassignable();
            reportFailures--;
            if (r3 === null) {
              r3 = "";
            } else {
              r3 = null;
              pos = r4;
            }
            if (r3 !== null) {
              r4 = parse_identifier();
              if (r4 !== null) {
                r0 = [r3, r4];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              reportedPos = r1;
              r0 = (function(i) {
                    return rp(new CS.ObjectInitialiserMember(i, i));
                  })(r4);
            }
            if (r0 === null) {
              pos = r1;
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_identifier() {
        var cacheKey = "identifier@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        reportFailures++;
        r3 = parse_reserved();
        reportFailures--;
        if (r3 === null) {
          r3 = "";
        } else {
          r3 = null;
          pos = r4;
        }
        if (r3 !== null) {
          r4 = parse_identifierName();
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(i) { return rp(new CS.Identifier(i)); })(r4);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_identifierName() {
        var cacheKey = "identifierName@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_identifierStart();
        if (r3 !== null) {
          r4 = [];
          r5 = parse_identifierPart();
          while (r5 !== null) {
            r4.push(r5);
            r5 = parse_identifierPart();
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_identifierStart() {
        var cacheKey = "identifierStart@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_UnicodeLetter();
        if (r0 === null) {
          if (/^[$_]/.test(input.charAt(pos))) {
            r0 = input.charAt(pos);
            pos++;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("[$_]");
            }
          }
          if (r0 === null) {
            r0 = parse_UnicodeEscapeSequence();
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_identifierPart() {
        var cacheKey = "identifierPart@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_identifierStart();
        if (r0 === null) {
          r0 = parse_UnicodeCombiningMark();
          if (r0 === null) {
            r0 = parse_UnicodeDigit();
            if (r0 === null) {
              r0 = parse_UnicodeConnectorPunctuation();
              if (r0 === null) {
                r0 = parse_ZWNJ();
                if (r0 === null) {
                  r0 = parse_ZWJ();
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse___() {
        var cacheKey = "__@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        r4 = parse_whitespace();
        if (r4 !== null) {
          r3 = [];
          while (r4 !== null) {
            r3.push(r4);
            r4 = parse_whitespace();
          }
        } else {
          r3 = null;
        }
        if (r3 !== null) {
          r5 = pos;
          r6 = parse_blockComment();
          if (r6 !== null) {
            r8 = parse_whitespace();
            if (r8 !== null) {
              r7 = [];
              while (r8 !== null) {
                r7.push(r8);
                r8 = parse_whitespace();
              }
            } else {
              r7 = null;
            }
            if (r7 !== null) {
              r4 = [r6, r7];
            } else {
              r4 = null;
              pos = r5;
            }
          } else {
            r4 = null;
            pos = r5;
          }
          r4 = r4 !== null ? r4 : "";
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse__() {
        var cacheKey = "_@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse___();
        r0 = r0 !== null ? r0 : "";
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_comment() {
        var cacheKey = "comment@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_blockComment();
        if (r0 === null) {
          r0 = parse_singleLineComment();
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_singleLineComment() {
        var cacheKey = "singleLineComment@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 35) {
          r3 = "#";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"#\"");
          }
        }
        if (r3 !== null) {
          r4 = [];
          r6 = pos;
          r8 = pos;
          reportFailures++;
          r7 = parse_TERM();
          reportFailures--;
          if (r7 === null) {
            r7 = "";
          } else {
            r7 = null;
            pos = r8;
          }
          if (r7 !== null) {
            if (input.length > pos) {
              r8 = input.charAt(pos);
              pos++;
            } else {
              r8 = null;
              if (reportFailures === 0) {
                matchFailed("any character");
              }
            }
            if (r8 !== null) {
              r5 = [r7, r8];
            } else {
              r5 = null;
              pos = r6;
            }
          } else {
            r5 = null;
            pos = r6;
          }
          while (r5 !== null) {
            r4.push(r5);
            r6 = pos;
            r8 = pos;
            reportFailures++;
            r7 = parse_TERM();
            reportFailures--;
            if (r7 === null) {
              r7 = "";
            } else {
              r7 = null;
              pos = r8;
            }
            if (r7 !== null) {
              if (input.length > pos) {
                r8 = input.charAt(pos);
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("any character");
                }
              }
              if (r8 !== null) {
                r5 = [r7, r8];
              } else {
                r5 = null;
                pos = r6;
              }
            } else {
              r5 = null;
              pos = r6;
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_blockComment() {
        var cacheKey = "blockComment@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "###") {
          r3 = "###";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"###\"");
          }
        }
        if (r3 !== null) {
          if (/^[^#]/.test(input.charAt(pos))) {
            r4 = input.charAt(pos);
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("[^#]");
            }
          }
          if (r4 !== null) {
            r5 = [];
            if (/^[^#]/.test(input.charAt(pos))) {
              r6 = input.charAt(pos);
              pos++;
            } else {
              r6 = null;
              if (reportFailures === 0) {
                matchFailed("[^#]");
              }
            }
            if (r6 === null) {
              r7 = pos;
              if (input.charCodeAt(pos) === 35) {
                r8 = "#";
                pos++;
              } else {
                r8 = null;
                if (reportFailures === 0) {
                  matchFailed("\"#\"");
                }
              }
              if (r8 !== null) {
                if (input.charCodeAt(pos) === 35) {
                  r9 = "#";
                  pos++;
                } else {
                  r9 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"#\"");
                  }
                }
                r9 = r9 !== null ? r9 : "";
                if (r9 !== null) {
                  r11 = pos;
                  reportFailures++;
                  if (input.charCodeAt(pos) === 35) {
                    r10 = "#";
                    pos++;
                  } else {
                    r10 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"#\"");
                    }
                  }
                  reportFailures--;
                  if (r10 === null) {
                    r10 = "";
                  } else {
                    r10 = null;
                    pos = r11;
                  }
                  if (r10 !== null) {
                    r6 = [r8, r9, r10];
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              } else {
                r6 = null;
                pos = r7;
              }
            }
            while (r6 !== null) {
              r5.push(r6);
              if (/^[^#]/.test(input.charAt(pos))) {
                r6 = input.charAt(pos);
                pos++;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("[^#]");
                }
              }
              if (r6 === null) {
                r7 = pos;
                if (input.charCodeAt(pos) === 35) {
                  r8 = "#";
                  pos++;
                } else {
                  r8 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"#\"");
                  }
                }
                if (r8 !== null) {
                  if (input.charCodeAt(pos) === 35) {
                    r9 = "#";
                    pos++;
                  } else {
                    r9 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"#\"");
                    }
                  }
                  r9 = r9 !== null ? r9 : "";
                  if (r9 !== null) {
                    r11 = pos;
                    reportFailures++;
                    if (input.charCodeAt(pos) === 35) {
                      r10 = "#";
                      pos++;
                    } else {
                      r10 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"#\"");
                      }
                    }
                    reportFailures--;
                    if (r10 === null) {
                      r10 = "";
                    } else {
                      r10 = null;
                      pos = r11;
                    }
                    if (r10 !== null) {
                      r6 = [r8, r9, r10];
                    } else {
                      r6 = null;
                      pos = r7;
                    }
                  } else {
                    r6 = null;
                    pos = r7;
                  }
                } else {
                  r6 = null;
                  pos = r7;
                }
              }
            }
            if (r5 !== null) {
              if (input.substr(pos, 3) === "###") {
                r6 = "###";
                pos += 3;
              } else {
                r6 = null;
                if (reportFailures === 0) {
                  matchFailed("\"###\"");
                }
              }
              if (r6 !== null) {
                r0 = [r3, r4, r5, r6];
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_whitespace() {
        var cacheKey = "whitespace@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        if (/^[\t\x0B\f \xA0\uFEFF\u1680\u180E\u2000-\u200A\u202F\u205F\u3000]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[\\t\\x0B\\f \\xA0\\uFEFF\\u1680\\u180E\\u2000-\\u200A\\u202F\\u205F\\u3000]");
          }
        }
        if (r0 === null) {
          if (input.charCodeAt(pos) === 13) {
            r0 = "\r";
            pos++;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\r\"");
            }
          }
          if (r0 === null) {
            r1 = pos;
            r2 = pos;
            if (input.charCodeAt(pos) === 92) {
              r3 = "\\";
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\\\"");
              }
            }
            if (r3 !== null) {
              if (input.charCodeAt(pos) === 13) {
                r4 = "\r";
                pos++;
              } else {
                r4 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\r\"");
                }
              }
              r4 = r4 !== null ? r4 : "";
              if (r4 !== null) {
                if (input.charCodeAt(pos) === 10) {
                  r5 = "\n";
                  pos++;
                } else {
                  r5 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\n\"");
                  }
                }
                if (r5 !== null) {
                  r0 = [r3, r4, r5];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
            if (r0 !== null) {
              r0 = input.substring(pos, r1);
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_INDENT() {
        var cacheKey = "INDENT@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse___();
        if (r3 !== null) {
          if (input.charCodeAt(pos) === 61423) {
            r4 = "\uEFEF";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uEFEF\"");
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(ws) { return ws; })(r3);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_DEDENT() {
        var cacheKey = "DEDENT@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        r4 = pos;
        r5 = pos;
        r6 = parse_TERMINATOR();
        r6 = r6 !== null ? r6 : "";
        if (r6 !== null) {
          r7 = parse__();
          if (r7 !== null) {
            r3 = [r6, r7];
          } else {
            r3 = null;
            pos = r5;
          }
        } else {
          r3 = null;
          pos = r5;
        }
        if (r3 !== null) {
          r3 = input.substring(pos, r4);
        }
        if (r3 !== null) {
          if (input.charCodeAt(pos) === 61438) {
            r4 = "\uEFFE";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uEFFE\"");
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(ws) { return ws; })(r3);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TERM() {
        var cacheKey = "TERM@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        if (input.charCodeAt(pos) === 13) {
          r3 = "\r";
          pos++;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\r\"");
          }
        }
        r3 = r3 !== null ? r3 : "";
        if (r3 !== null) {
          if (input.charCodeAt(pos) === 10) {
            r4 = "\n";
            pos++;
          } else {
            r4 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\n\"");
            }
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        if (r0 === null) {
          r1 = pos;
          if (input.charCodeAt(pos) === 61439) {
            r0 = "\uEFFF";
            pos++;
          } else {
            r0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uEFFF\"");
            }
          }
          if (r0 !== null) {
            reportedPos = r1;
            r0 = (function() { return ''; })();
          }
          if (r0 === null) {
            pos = r1;
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TERMINATOR() {
        var cacheKey = "TERMINATOR@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r3 = pos;
        r4 = parse__();
        if (r4 !== null) {
          r5 = parse_comment();
          r5 = r5 !== null ? r5 : "";
          if (r5 !== null) {
            r6 = parse_TERM();
            if (r6 !== null) {
              r7 = parse_blockComment();
              r7 = r7 !== null ? r7 : "";
              if (r7 !== null) {
                r2 = [r4, r5, r6, r7];
              } else {
                r2 = null;
                pos = r3;
              }
            } else {
              r2 = null;
              pos = r3;
            }
          } else {
            r2 = null;
            pos = r3;
          }
        } else {
          r2 = null;
          pos = r3;
        }
        if (r2 !== null) {
          r0 = [];
          while (r2 !== null) {
            r0.push(r2);
            r3 = pos;
            r4 = parse__();
            if (r4 !== null) {
              r5 = parse_comment();
              r5 = r5 !== null ? r5 : "";
              if (r5 !== null) {
                r6 = parse_TERM();
                if (r6 !== null) {
                  r7 = parse_blockComment();
                  r7 = r7 !== null ? r7 : "";
                  if (r7 !== null) {
                    r2 = [r4, r5, r6, r7];
                  } else {
                    r2 = null;
                    pos = r3;
                  }
                } else {
                  r2 = null;
                  pos = r3;
                }
              } else {
                r2 = null;
                pos = r3;
              }
            } else {
              r2 = null;
              pos = r3;
            }
          }
        } else {
          r0 = null;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TERMINDENT() {
        var cacheKey = "TERMINDENT@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        r2 = pos;
        r3 = parse_TERMINATOR();
        if (r3 !== null) {
          r4 = parse_INDENT();
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_AND() {
        var cacheKey = "AND@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "and") {
          r3 = "and";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"and\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_BREAK() {
        var cacheKey = "BREAK@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "break") {
          r3 = "break";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"break\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_BY() {
        var cacheKey = "BY@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "by") {
          r3 = "by";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"by\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CATCH() {
        var cacheKey = "CATCH@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "catch") {
          r3 = "catch";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"catch\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CONTINUE() {
        var cacheKey = "CONTINUE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 8) === "continue") {
          r3 = "continue";
          pos += 8;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"continue\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CLASS() {
        var cacheKey = "CLASS@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "class") {
          r3 = "class";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"class\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_DELETE() {
        var cacheKey = "DELETE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 6) === "delete") {
          r3 = "delete";
          pos += 6;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"delete\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_DEBUGGER() {
        var cacheKey = "DEBUGGER@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 8) === "debugger") {
          r3 = "debugger";
          pos += 8;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"debugger\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_DO() {
        var cacheKey = "DO@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "do") {
          r3 = "do";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"do\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ELSE() {
        var cacheKey = "ELSE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "else") {
          r3 = "else";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"else\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_EXTENDS() {
        var cacheKey = "EXTENDS@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 7) === "extends") {
          r3 = "extends";
          pos += 7;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"extends\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_FALSE() {
        var cacheKey = "FALSE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "false") {
          r3 = "false";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"false\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_FINALLY() {
        var cacheKey = "FINALLY@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 7) === "finally") {
          r3 = "finally";
          pos += 7;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"finally\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_FOR() {
        var cacheKey = "FOR@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "for") {
          r3 = "for";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"for\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_IF() {
        var cacheKey = "IF@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "if") {
          r3 = "if";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"if\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_IN() {
        var cacheKey = "IN@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "in") {
          r3 = "in";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"in\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_INSTANCEOF() {
        var cacheKey = "INSTANCEOF@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 10) === "instanceof") {
          r3 = "instanceof";
          pos += 10;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"instanceof\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_IS() {
        var cacheKey = "IS@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "is") {
          r3 = "is";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"is\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ISNT() {
        var cacheKey = "ISNT@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "isnt") {
          r3 = "isnt";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"isnt\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_LOOP() {
        var cacheKey = "LOOP@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "loop") {
          r3 = "loop";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"loop\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_NEW() {
        var cacheKey = "NEW@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "new") {
          r3 = "new";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"new\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_NO() {
        var cacheKey = "NO@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "no") {
          r3 = "no";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"no\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_NOT() {
        var cacheKey = "NOT@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "not") {
          r3 = "not";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"not\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_NULL() {
        var cacheKey = "NULL@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "null") {
          r3 = "null";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"null\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_OF() {
        var cacheKey = "OF@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "of") {
          r3 = "of";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"of\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_OFF() {
        var cacheKey = "OFF@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "off") {
          r3 = "off";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"off\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ON() {
        var cacheKey = "ON@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "on") {
          r3 = "on";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"on\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_OR() {
        var cacheKey = "OR@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "or") {
          r3 = "or";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"or\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_OWN() {
        var cacheKey = "OWN@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "own") {
          r3 = "own";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"own\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_RETURN() {
        var cacheKey = "RETURN@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 6) === "return") {
          r3 = "return";
          pos += 6;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"return\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_SWITCH() {
        var cacheKey = "SWITCH@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 6) === "switch") {
          r3 = "switch";
          pos += 6;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"switch\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_THEN() {
        var cacheKey = "THEN@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "then") {
          r3 = "then";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"then\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_THIS() {
        var cacheKey = "THIS@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "this") {
          r3 = "this";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"this\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_THROW() {
        var cacheKey = "THROW@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "throw") {
          r3 = "throw";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"throw\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TRUE() {
        var cacheKey = "TRUE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "true") {
          r3 = "true";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"true\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TRY() {
        var cacheKey = "TRY@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "try") {
          r3 = "try";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"try\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_TYPEOF() {
        var cacheKey = "TYPEOF@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 6) === "typeof") {
          r3 = "typeof";
          pos += 6;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"typeof\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UNDEFINED() {
        var cacheKey = "UNDEFINED@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 9) === "undefined") {
          r3 = "undefined";
          pos += 9;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"undefined\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UNLESS() {
        var cacheKey = "UNLESS@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 6) === "unless") {
          r3 = "unless";
          pos += 6;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"unless\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UNTIL() {
        var cacheKey = "UNTIL@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "until") {
          r3 = "until";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"until\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_WHEN() {
        var cacheKey = "WHEN@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 4) === "when") {
          r3 = "when";
          pos += 4;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"when\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_WHILE() {
        var cacheKey = "WHILE@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 5) === "while") {
          r3 = "while";
          pos += 5;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"while\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_YES() {
        var cacheKey = "YES@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 3) === "yes") {
          r3 = "yes";
          pos += 3;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"yes\"");
          }
        }
        if (r3 !== null) {
          r5 = pos;
          reportFailures++;
          r4 = parse_identifierPart();
          reportFailures--;
          if (r4 === null) {
            r4 = "";
          } else {
            r4 = null;
            pos = r5;
          }
          if (r4 !== null) {
            r0 = [r3, r4];
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          r0 = input.substring(pos, r1);
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_SharedKeywords() {
        var cacheKey = "SharedKeywords@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        if (input.substr(pos, 4) === "true") {
          r2 = "true";
          pos += 4;
        } else {
          r2 = null;
          if (reportFailures === 0) {
            matchFailed("\"true\"");
          }
        }
        if (r2 === null) {
          if (input.substr(pos, 5) === "false") {
            r2 = "false";
            pos += 5;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"false\"");
            }
          }
          if (r2 === null) {
            if (input.substr(pos, 4) === "null") {
              r2 = "null";
              pos += 4;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"null\"");
              }
            }
            if (r2 === null) {
              if (input.substr(pos, 4) === "this") {
                r2 = "this";
                pos += 4;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"this\"");
                }
              }
              if (r2 === null) {
                if (input.substr(pos, 3) === "new") {
                  r2 = "new";
                  pos += 3;
                } else {
                  r2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"new\"");
                  }
                }
                if (r2 === null) {
                  if (input.substr(pos, 6) === "delete") {
                    r2 = "delete";
                    pos += 6;
                  } else {
                    r2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"delete\"");
                    }
                  }
                  if (r2 === null) {
                    if (input.substr(pos, 6) === "typeof") {
                      r2 = "typeof";
                      pos += 6;
                    } else {
                      r2 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"typeof\"");
                      }
                    }
                    if (r2 === null) {
                      if (input.substr(pos, 10) === "instanceof") {
                        r2 = "instanceof";
                        pos += 10;
                      } else {
                        r2 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"instanceof\"");
                        }
                      }
                      if (r2 === null) {
                        if (input.substr(pos, 2) === "in") {
                          r2 = "in";
                          pos += 2;
                        } else {
                          r2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"in\"");
                          }
                        }
                        if (r2 === null) {
                          if (input.substr(pos, 6) === "return") {
                            r2 = "return";
                            pos += 6;
                          } else {
                            r2 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"return\"");
                            }
                          }
                          if (r2 === null) {
                            if (input.substr(pos, 5) === "throw") {
                              r2 = "throw";
                              pos += 5;
                            } else {
                              r2 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"throw\"");
                              }
                            }
                            if (r2 === null) {
                              if (input.substr(pos, 5) === "break") {
                                r2 = "break";
                                pos += 5;
                              } else {
                                r2 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"break\"");
                                }
                              }
                              if (r2 === null) {
                                if (input.substr(pos, 8) === "continue") {
                                  r2 = "continue";
                                  pos += 8;
                                } else {
                                  r2 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"continue\"");
                                  }
                                }
                                if (r2 === null) {
                                  if (input.substr(pos, 8) === "debugger") {
                                    r2 = "debugger";
                                    pos += 8;
                                  } else {
                                    r2 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\"debugger\"");
                                    }
                                  }
                                  if (r2 === null) {
                                    if (input.substr(pos, 2) === "if") {
                                      r2 = "if";
                                      pos += 2;
                                    } else {
                                      r2 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\"if\"");
                                      }
                                    }
                                    if (r2 === null) {
                                      if (input.substr(pos, 4) === "else") {
                                        r2 = "else";
                                        pos += 4;
                                      } else {
                                        r2 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("\"else\"");
                                        }
                                      }
                                      if (r2 === null) {
                                        if (input.substr(pos, 6) === "switch") {
                                          r2 = "switch";
                                          pos += 6;
                                        } else {
                                          r2 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\"switch\"");
                                          }
                                        }
                                        if (r2 === null) {
                                          if (input.substr(pos, 3) === "for") {
                                            r2 = "for";
                                            pos += 3;
                                          } else {
                                            r2 = null;
                                            if (reportFailures === 0) {
                                              matchFailed("\"for\"");
                                            }
                                          }
                                          if (r2 === null) {
                                            if (input.substr(pos, 5) === "while") {
                                              r2 = "while";
                                              pos += 5;
                                            } else {
                                              r2 = null;
                                              if (reportFailures === 0) {
                                                matchFailed("\"while\"");
                                              }
                                            }
                                            if (r2 === null) {
                                              if (input.substr(pos, 2) === "do") {
                                                r2 = "do";
                                                pos += 2;
                                              } else {
                                                r2 = null;
                                                if (reportFailures === 0) {
                                                  matchFailed("\"do\"");
                                                }
                                              }
                                              if (r2 === null) {
                                                if (input.substr(pos, 3) === "try") {
                                                  r2 = "try";
                                                  pos += 3;
                                                } else {
                                                  r2 = null;
                                                  if (reportFailures === 0) {
                                                    matchFailed("\"try\"");
                                                  }
                                                }
                                                if (r2 === null) {
                                                  if (input.substr(pos, 5) === "catch") {
                                                    r2 = "catch";
                                                    pos += 5;
                                                  } else {
                                                    r2 = null;
                                                    if (reportFailures === 0) {
                                                      matchFailed("\"catch\"");
                                                    }
                                                  }
                                                  if (r2 === null) {
                                                    if (input.substr(pos, 7) === "finally") {
                                                      r2 = "finally";
                                                      pos += 7;
                                                    } else {
                                                      r2 = null;
                                                      if (reportFailures === 0) {
                                                        matchFailed("\"finally\"");
                                                      }
                                                    }
                                                    if (r2 === null) {
                                                      if (input.substr(pos, 5) === "class") {
                                                        r2 = "class";
                                                        pos += 5;
                                                      } else {
                                                        r2 = null;
                                                        if (reportFailures === 0) {
                                                          matchFailed("\"class\"");
                                                        }
                                                      }
                                                      if (r2 === null) {
                                                        if (input.substr(pos, 7) === "extends") {
                                                          r2 = "extends";
                                                          pos += 7;
                                                        } else {
                                                          r2 = null;
                                                          if (reportFailures === 0) {
                                                            matchFailed("\"extends\"");
                                                          }
                                                        }
                                                        if (r2 === null) {
                                                          if (input.substr(pos, 5) === "super") {
                                                            r2 = "super";
                                                            pos += 5;
                                                          } else {
                                                            r2 = null;
                                                            if (reportFailures === 0) {
                                                              matchFailed("\"super\"");
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (r2 !== null) {
          r4 = pos;
          reportFailures++;
          r3 = parse_identifierPart();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r0 = [r2, r3];
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_JSKeywords() {
        var cacheKey = "JSKeywords@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        if (input.substr(pos, 4) === "case") {
          r2 = "case";
          pos += 4;
        } else {
          r2 = null;
          if (reportFailures === 0) {
            matchFailed("\"case\"");
          }
        }
        if (r2 === null) {
          if (input.substr(pos, 7) === "default") {
            r2 = "default";
            pos += 7;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"default\"");
            }
          }
          if (r2 === null) {
            if (input.substr(pos, 8) === "function") {
              r2 = "function";
              pos += 8;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"function\"");
              }
            }
            if (r2 === null) {
              if (input.substr(pos, 3) === "var") {
                r2 = "var";
                pos += 3;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"var\"");
                }
              }
              if (r2 === null) {
                if (input.substr(pos, 4) === "void") {
                  r2 = "void";
                  pos += 4;
                } else {
                  r2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"void\"");
                  }
                }
                if (r2 === null) {
                  if (input.substr(pos, 4) === "with") {
                    r2 = "with";
                    pos += 4;
                  } else {
                    r2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"with\"");
                    }
                  }
                  if (r2 === null) {
                    if (input.substr(pos, 5) === "const") {
                      r2 = "const";
                      pos += 5;
                    } else {
                      r2 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"const\"");
                      }
                    }
                    if (r2 === null) {
                      if (input.substr(pos, 3) === "let") {
                        r2 = "let";
                        pos += 3;
                      } else {
                        r2 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"let\"");
                        }
                      }
                      if (r2 === null) {
                        if (input.substr(pos, 4) === "enum") {
                          r2 = "enum";
                          pos += 4;
                        } else {
                          r2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"enum\"");
                          }
                        }
                        if (r2 === null) {
                          if (input.substr(pos, 6) === "export") {
                            r2 = "export";
                            pos += 6;
                          } else {
                            r2 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"export\"");
                            }
                          }
                          if (r2 === null) {
                            if (input.substr(pos, 6) === "import") {
                              r2 = "import";
                              pos += 6;
                            } else {
                              r2 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"import\"");
                              }
                            }
                            if (r2 === null) {
                              if (input.substr(pos, 6) === "native") {
                                r2 = "native";
                                pos += 6;
                              } else {
                                r2 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"native\"");
                                }
                              }
                              if (r2 === null) {
                                if (input.substr(pos, 10) === "implements") {
                                  r2 = "implements";
                                  pos += 10;
                                } else {
                                  r2 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"implements\"");
                                  }
                                }
                                if (r2 === null) {
                                  if (input.substr(pos, 9) === "interface") {
                                    r2 = "interface";
                                    pos += 9;
                                  } else {
                                    r2 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\"interface\"");
                                    }
                                  }
                                  if (r2 === null) {
                                    if (input.substr(pos, 7) === "package") {
                                      r2 = "package";
                                      pos += 7;
                                    } else {
                                      r2 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\"package\"");
                                      }
                                    }
                                    if (r2 === null) {
                                      if (input.substr(pos, 7) === "private") {
                                        r2 = "private";
                                        pos += 7;
                                      } else {
                                        r2 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("\"private\"");
                                        }
                                      }
                                      if (r2 === null) {
                                        if (input.substr(pos, 9) === "protected") {
                                          r2 = "protected";
                                          pos += 9;
                                        } else {
                                          r2 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\"protected\"");
                                          }
                                        }
                                        if (r2 === null) {
                                          if (input.substr(pos, 6) === "public") {
                                            r2 = "public";
                                            pos += 6;
                                          } else {
                                            r2 = null;
                                            if (reportFailures === 0) {
                                              matchFailed("\"public\"");
                                            }
                                          }
                                          if (r2 === null) {
                                            if (input.substr(pos, 6) === "static") {
                                              r2 = "static";
                                              pos += 6;
                                            } else {
                                              r2 = null;
                                              if (reportFailures === 0) {
                                                matchFailed("\"static\"");
                                              }
                                            }
                                            if (r2 === null) {
                                              if (input.substr(pos, 5) === "yield") {
                                                r2 = "yield";
                                                pos += 5;
                                              } else {
                                                r2 = null;
                                                if (reportFailures === 0) {
                                                  matchFailed("\"yield\"");
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (r2 !== null) {
          r4 = pos;
          reportFailures++;
          r3 = parse_identifierPart();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r0 = [r2, r3];
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_CSKeywords() {
        var cacheKey = "CSKeywords@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        if (input.substr(pos, 9) === "undefined") {
          r2 = "undefined";
          pos += 9;
        } else {
          r2 = null;
          if (reportFailures === 0) {
            matchFailed("\"undefined\"");
          }
        }
        if (r2 === null) {
          if (input.substr(pos, 4) === "then") {
            r2 = "then";
            pos += 4;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"then\"");
            }
          }
          if (r2 === null) {
            if (input.substr(pos, 6) === "unless") {
              r2 = "unless";
              pos += 6;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"unless\"");
              }
            }
            if (r2 === null) {
              if (input.substr(pos, 5) === "until") {
                r2 = "until";
                pos += 5;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"until\"");
                }
              }
              if (r2 === null) {
                if (input.substr(pos, 4) === "loop") {
                  r2 = "loop";
                  pos += 4;
                } else {
                  r2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"loop\"");
                  }
                }
                if (r2 === null) {
                  if (input.substr(pos, 3) === "off") {
                    r2 = "off";
                    pos += 3;
                  } else {
                    r2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"off\"");
                    }
                  }
                  if (r2 === null) {
                    if (input.substr(pos, 2) === "by") {
                      r2 = "by";
                      pos += 2;
                    } else {
                      r2 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"by\"");
                      }
                    }
                    if (r2 === null) {
                      if (input.substr(pos, 4) === "when") {
                        r2 = "when";
                        pos += 4;
                      } else {
                        r2 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"when\"");
                        }
                      }
                      if (r2 === null) {
                        if (input.substr(pos, 3) === "and") {
                          r2 = "and";
                          pos += 3;
                        } else {
                          r2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"and\"");
                          }
                        }
                        if (r2 === null) {
                          if (input.substr(pos, 2) === "or") {
                            r2 = "or";
                            pos += 2;
                          } else {
                            r2 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"or\"");
                            }
                          }
                          if (r2 === null) {
                            if (input.substr(pos, 4) === "isnt") {
                              r2 = "isnt";
                              pos += 4;
                            } else {
                              r2 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"isnt\"");
                              }
                            }
                            if (r2 === null) {
                              if (input.substr(pos, 2) === "is") {
                                r2 = "is";
                                pos += 2;
                              } else {
                                r2 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"is\"");
                                }
                              }
                              if (r2 === null) {
                                if (input.substr(pos, 3) === "not") {
                                  r2 = "not";
                                  pos += 3;
                                } else {
                                  r2 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"not\"");
                                  }
                                }
                                if (r2 === null) {
                                  if (input.substr(pos, 3) === "yes") {
                                    r2 = "yes";
                                    pos += 3;
                                  } else {
                                    r2 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\"yes\"");
                                    }
                                  }
                                  if (r2 === null) {
                                    if (input.substr(pos, 2) === "no") {
                                      r2 = "no";
                                      pos += 2;
                                    } else {
                                      r2 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\"no\"");
                                      }
                                    }
                                    if (r2 === null) {
                                      if (input.substr(pos, 2) === "on") {
                                        r2 = "on";
                                        pos += 2;
                                      } else {
                                        r2 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("\"on\"");
                                        }
                                      }
                                      if (r2 === null) {
                                        if (input.substr(pos, 2) === "of") {
                                          r2 = "of";
                                          pos += 2;
                                        } else {
                                          r2 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\"of\"");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (r2 !== null) {
          r4 = pos;
          reportFailures++;
          r3 = parse_identifierPart();
          reportFailures--;
          if (r3 === null) {
            r3 = "";
          } else {
            r3 = null;
            pos = r4;
          }
          if (r3 !== null) {
            r0 = [r2, r3];
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_StandardPredefinedMacros() {
        var cacheKey = "StandardPredefinedMacros@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4;
        
        r1 = pos;
        if (input.substr(pos, 2) === "__") {
          r2 = "__";
          pos += 2;
        } else {
          r2 = null;
          if (reportFailures === 0) {
            matchFailed("\"__\"");
          }
        }
        if (r2 !== null) {
          if (input.substr(pos, 8) === "FILENAME") {
            r3 = "FILENAME";
            pos += 8;
          } else {
            r3 = null;
            if (reportFailures === 0) {
              matchFailed("\"FILENAME\"");
            }
          }
          if (r3 === null) {
            if (input.substr(pos, 4) === "LINE") {
              r3 = "LINE";
              pos += 4;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("\"LINE\"");
              }
            }
            if (r3 === null) {
              if (input.substr(pos, 10) === "DATETIMEMS") {
                r3 = "DATETIMEMS";
                pos += 10;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"DATETIMEMS\"");
                }
              }
              if (r3 === null) {
                if (input.substr(pos, 4) === "DATE") {
                  r3 = "DATE";
                  pos += 4;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"DATE\"");
                  }
                }
                if (r3 === null) {
                  if (input.substr(pos, 4) === "TIME") {
                    r3 = "TIME";
                    pos += 4;
                  } else {
                    r3 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"TIME\"");
                    }
                  }
                }
              }
            }
          }
          if (r3 !== null) {
            if (input.substr(pos, 2) === "__") {
              r4 = "__";
              pos += 2;
            } else {
              r4 = null;
              if (reportFailures === 0) {
                matchFailed("\"__\"");
              }
            }
            if (r4 !== null) {
              r0 = [r2, r3, r4];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
        } else {
          r0 = null;
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_reserved() {
        var cacheKey = "reserved@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        r0 = parse_StandardPredefinedMacros();
        if (r0 === null) {
          r0 = parse_SharedKeywords();
          if (r0 === null) {
            r0 = parse_CSKeywords();
            if (r0 === null) {
              r0 = parse_JSKeywords();
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UnicodeEscapeSequence() {
        var cacheKey = "UnicodeEscapeSequence@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3, r4, r5, r6, r7;
        
        r1 = pos;
        r2 = pos;
        if (input.substr(pos, 2) === "\\u") {
          r3 = "\\u";
          pos += 2;
        } else {
          r3 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\\\u\"");
          }
        }
        if (r3 !== null) {
          r4 = parse_hexDigit();
          if (r4 !== null) {
            r5 = parse_hexDigit();
            if (r5 !== null) {
              r6 = parse_hexDigit();
              if (r6 !== null) {
                r7 = parse_hexDigit();
                if (r7 !== null) {
                  r0 = [r3, r4, r5, r6, r7];
                } else {
                  r0 = null;
                  pos = r2;
                }
              } else {
                r0 = null;
                pos = r2;
              }
            } else {
              r0 = null;
              pos = r2;
            }
          } else {
            r0 = null;
            pos = r2;
          }
        } else {
          r0 = null;
          pos = r2;
        }
        if (r0 !== null) {
          reportedPos = r1;
          r0 = (function(h0, h1, h2, h3) { return String.fromCharCode(parseInt(h0 + h1 + h2 + h3, 16)); })(r4, r5, r6, r7);
        }
        if (r0 === null) {
          pos = r1;
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UnicodeLetter() {
        var cacheKey = "UnicodeLetter@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3;
        
        if (/^[A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0531-\u0556\u10A0-\u10C5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2183\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uFF21-\uFF3Aa-z\xAA\xB5\xBA\xDF-\xF6\xF8-\xFF\u0101\u0103\u0105\u0107\u0109\u010B\u010D\u010F\u0111\u0113\u0115\u0117\u0119\u011B\u011D\u011F\u0121\u0123\u0125\u0127\u0129\u012B\u012D\u012F\u0131\u0133\u0135\u0137\u0138\u013A\u013C\u013E\u0140\u0142\u0144\u0146\u0148\u0149\u014B\u014D\u014F\u0151\u0153\u0155\u0157\u0159\u015B\u015D\u015F\u0161\u0163\u0165\u0167\u0169\u016B\u016D\u016F\u0171\u0173\u0175\u0177\u017A\u017C\u017E-\u0180\u0183\u0185\u0188\u018C\u018D\u0192\u0195\u0199-\u019B\u019E\u01A1\u01A3\u01A5\u01A8\u01AA\u01AB\u01AD\u01B0\u01B4\u01B6\u01B9\u01BA\u01BD-\u01BF\u01C6\u01C9\u01CC\u01CE\u01D0\u01D2\u01D4\u01D6\u01D8\u01DA\u01DC\u01DD\u01DF\u01E1\u01E3\u01E5\u01E7\u01E9\u01EB\u01ED\u01EF\u01F0\u01F3\u01F5\u01F9\u01FB\u01FD\u01FF\u0201\u0203\u0205\u0207\u0209\u020B\u020D\u020F\u0211\u0213\u0215\u0217\u0219\u021B\u021D\u021F\u0221\u0223\u0225\u0227\u0229\u022B\u022D\u022F\u0231\u0233-\u0239\u023C\u023F\u0240\u0242\u0247\u0249\u024B\u024D\u024F-\u0293\u0295-\u02AF\u0371\u0373\u0377\u037B-\u037D\u0390\u03AC-\u03CE\u03D0\u03D1\u03D5-\u03D7\u03D9\u03DB\u03DD\u03DF\u03E1\u03E3\u03E5\u03E7\u03E9\u03EB\u03ED\u03EF-\u03F3\u03F5\u03F8\u03FB\u03FC\u0430-\u045F\u0461\u0463\u0465\u0467\u0469\u046B\u046D\u046F\u0471\u0473\u0475\u0477\u0479\u047B\u047D\u047F\u0481\u048B\u048D\u048F\u0491\u0493\u0495\u0497\u0499\u049B\u049D\u049F\u04A1\u04A3\u04A5\u04A7\u04A9\u04AB\u04AD\u04AF\u04B1\u04B3\u04B5\u04B7\u04B9\u04BB\u04BD\u04BF\u04C2\u04C4\u04C6\u04C8\u04CA\u04CC\u04CE\u04CF\u04D1\u04D3\u04D5\u04D7\u04D9\u04DB\u04DD\u04DF\u04E1\u04E3\u04E5\u04E7\u04E9\u04EB\u04ED\u04EF\u04F1\u04F3\u04F5\u04F7\u04F9\u04FB\u04FD\u04FF\u0501\u0503\u0505\u0507\u0509\u050B\u050D\u050F\u0511\u0513\u0515\u0517\u0519\u051B\u051D\u051F\u0521\u0523\u0525\u0527\u0561-\u0587\u1D00-\u1D2B\u1D62-\u1D77\u1D79-\u1D9A\u1E01\u1E03\u1E05\u1E07\u1E09\u1E0B\u1E0D\u1E0F\u1E11\u1E13\u1E15\u1E17\u1E19\u1E1B\u1E1D\u1E1F\u1E21\u1E23\u1E25\u1E27\u1E29\u1E2B\u1E2D\u1E2F\u1E31\u1E33\u1E35\u1E37\u1E39\u1E3B\u1E3D\u1E3F\u1E41\u1E43\u1E45\u1E47\u1E49\u1E4B\u1E4D\u1E4F\u1E51\u1E53\u1E55\u1E57\u1E59\u1E5B\u1E5D\u1E5F\u1E61\u1E63\u1E65\u1E67\u1E69\u1E6B\u1E6D\u1E6F\u1E71\u1E73\u1E75\u1E77\u1E79\u1E7B\u1E7D\u1E7F\u1E81\u1E83\u1E85\u1E87\u1E89\u1E8B\u1E8D\u1E8F\u1E91\u1E93\u1E95-\u1E9D\u1E9F\u1EA1\u1EA3\u1EA5\u1EA7\u1EA9\u1EAB\u1EAD\u1EAF\u1EB1\u1EB3\u1EB5\u1EB7\u1EB9\u1EBB\u1EBD\u1EBF\u1EC1\u1EC3\u1EC5\u1EC7\u1EC9\u1ECB\u1ECD\u1ECF\u1ED1\u1ED3\u1ED5\u1ED7\u1ED9\u1EDB\u1EDD\u1EDF\u1EE1\u1EE3\u1EE5\u1EE7\u1EE9\u1EEB\u1EED\u1EEF\u1EF1\u1EF3\u1EF5\u1EF7\u1EF9\u1EFB\u1EFD\u1EFF-\u1F07\u1F10-\u1F15\u1F20-\u1F27\u1F30-\u1F37\u1F40-\u1F45\u1F50-\u1F57\u1F60-\u1F67\u1F70-\u1F7D\u1F80-\u1F87\u1F90-\u1F97\u1FA0-\u1FA7\u1FB0-\u1FB4\u1FB6\u1FB7\u1FBE\u1FC2-\u1FC4\u1FC6\u1FC7\u1FD0-\u1FD3\u1FD6\u1FD7\u1FE0-\u1FE7\u1FF2-\u1FF4\u1FF6\u1FF7\u210A\u210E\u210F\u2113\u212F\u2134\u2139\u213C\u213D\u2146-\u2149\u214E\u2184\u2C30-\u2C5E\u2C61\u2C65\u2C66\u2C68\u2C6A\u2C6C\u2C71\u2C73\u2C74\u2C76-\u2C7C\u2C81\u2C83\u2C85\u2C87\u2C89\u2C8B\u2C8D\u2C8F\u2C91\u2C93\u2C95\u2C97\u2C99\u2C9B\u2C9D\u2C9F\u2CA1\u2CA3\u2CA5\u2CA7\u2CA9\u2CAB\u2CAD\u2CAF\u2CB1\u2CB3\u2CB5\u2CB7\u2CB9\u2CBB\u2CBD\u2CBF\u2CC1\u2CC3\u2CC5\u2CC7\u2CC9\u2CCB\u2CCD\u2CCF\u2CD1\u2CD3\u2CD5\u2CD7\u2CD9\u2CDB\u2CDD\u2CDF\u2CE1\u2CE3\u2CE4\u2CEC\u2CEE\u2D00-\u2D25\uA641\uA643\uA645\uA647\uA649\uA64B\uA64D\uA64F\uA651\uA653\uA655\uA657\uA659\uA65B\uA65D\uA65F\uA661\uA663\uA665\uA667\uA669\uA66B\uA66D\uA681\uA683\uA685\uA687\uA689\uA68B\uA68D\uA68F\uA691\uA693\uA695\uA697\uA723\uA725\uA727\uA729\uA72B\uA72D\uA72F-\uA731\uA733\uA735\uA737\uA739\uA73B\uA73D\uA73F\uA741\uA743\uA745\uA747\uA749\uA74B\uA74D\uA74F\uA751\uA753\uA755\uA757\uA759\uA75B\uA75D\uA75F\uA761\uA763\uA765\uA767\uA769\uA76B\uA76D\uA76F\uA771-\uA778\uA77A\uA77C\uA77F\uA781\uA783\uA785\uA787\uA78C\uA78E\uA791\uA7A1\uA7A3\uA7A5\uA7A7\uA7A9\uA7FA\uFB00-\uFB06\uFB13-\uFB17\uFF41-\uFF5A\u01C5\u01C8\u01CB\u01F2\u1F88-\u1F8F\u1F98-\u1F9F\u1FA8-\u1FAF\u1FBC\u1FCC\u1FFC\u02B0-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0374\u037A\u0559\u0640\u06E5\u06E6\u07F4\u07F5\u07FA\u081A\u0824\u0828\u0971\u0E46\u0EC6\u10FC\u17D7\u1843\u1AA7\u1C78-\u1C7D\u1D2C-\u1D61\u1D78\u1D9B-\u1DBF\u2071\u207F\u2090-\u209C\u2C7D\u2D6F\u2E2F\u3005\u3031-\u3035\u303B\u309D\u309E\u30FC-\u30FE\uA015\uA4F8-\uA4FD\uA60C\uA67F\uA717-\uA71F\uA770\uA788\uA9CF\uAA70\uAADD\uFF70\uFF9E\uFF9F\u01BB\u01C0-\u01C3\u0294\u05D0-\u05EA\u05F0-\u05F2\u0620-\u063F\u0641-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u0800-\u0815\u0840-\u0858\u0904-\u0939\u093D\u0950\u0958-\u0961\u0972-\u0977\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E45\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EDC\u0EDD\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10D0-\u10FA\u1100-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17DC\u1820-\u1842\u1844-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BC0-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C77\u1CE9-\u1CEC\u1CEE-\u1CF1\u2135-\u2138\u2D30-\u2D65\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3006\u303C\u3041-\u3096\u309F\u30A1-\u30FA\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400\u4DB5\u4E00\u9FCB\uA000-\uA014\uA016-\uA48C\uA4D0-\uA4F7\uA500-\uA60B\uA610-\uA61F\uA62A\uA62B\uA66E\uA6A0-\uA6E5\uA7FB-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA6F\uAA71-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB\uAADC\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uAC00\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA2D\uFA30-\uFA6D\uFA70-\uFAD9\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF66-\uFF6F\uFF71-\uFF9D\uFFA0-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\u16EE-\u16F0\u2160-\u2182\u2185-\u2188\u3007\u3021-\u3029\u3038-\u303A\uA6E6-\uA6EF]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[A-Z\\xC0-\\xD6\\xD8-\\xDE\\u0100\\u0102\\u0104\\u0106\\u0108\\u010A\\u010C\\u010E\\u0110\\u0112\\u0114\\u0116\\u0118\\u011A\\u011C\\u011E\\u0120\\u0122\\u0124\\u0126\\u0128\\u012A\\u012C\\u012E\\u0130\\u0132\\u0134\\u0136\\u0139\\u013B\\u013D\\u013F\\u0141\\u0143\\u0145\\u0147\\u014A\\u014C\\u014E\\u0150\\u0152\\u0154\\u0156\\u0158\\u015A\\u015C\\u015E\\u0160\\u0162\\u0164\\u0166\\u0168\\u016A\\u016C\\u016E\\u0170\\u0172\\u0174\\u0176\\u0178\\u0179\\u017B\\u017D\\u0181\\u0182\\u0184\\u0186\\u0187\\u0189-\\u018B\\u018E-\\u0191\\u0193\\u0194\\u0196-\\u0198\\u019C\\u019D\\u019F\\u01A0\\u01A2\\u01A4\\u01A6\\u01A7\\u01A9\\u01AC\\u01AE\\u01AF\\u01B1-\\u01B3\\u01B5\\u01B7\\u01B8\\u01BC\\u01C4\\u01C7\\u01CA\\u01CD\\u01CF\\u01D1\\u01D3\\u01D5\\u01D7\\u01D9\\u01DB\\u01DE\\u01E0\\u01E2\\u01E4\\u01E6\\u01E8\\u01EA\\u01EC\\u01EE\\u01F1\\u01F4\\u01F6-\\u01F8\\u01FA\\u01FC\\u01FE\\u0200\\u0202\\u0204\\u0206\\u0208\\u020A\\u020C\\u020E\\u0210\\u0212\\u0214\\u0216\\u0218\\u021A\\u021C\\u021E\\u0220\\u0222\\u0224\\u0226\\u0228\\u022A\\u022C\\u022E\\u0230\\u0232\\u023A\\u023B\\u023D\\u023E\\u0241\\u0243-\\u0246\\u0248\\u024A\\u024C\\u024E\\u0370\\u0372\\u0376\\u0386\\u0388-\\u038A\\u038C\\u038E\\u038F\\u0391-\\u03A1\\u03A3-\\u03AB\\u03CF\\u03D2-\\u03D4\\u03D8\\u03DA\\u03DC\\u03DE\\u03E0\\u03E2\\u03E4\\u03E6\\u03E8\\u03EA\\u03EC\\u03EE\\u03F4\\u03F7\\u03F9\\u03FA\\u03FD-\\u042F\\u0460\\u0462\\u0464\\u0466\\u0468\\u046A\\u046C\\u046E\\u0470\\u0472\\u0474\\u0476\\u0478\\u047A\\u047C\\u047E\\u0480\\u048A\\u048C\\u048E\\u0490\\u0492\\u0494\\u0496\\u0498\\u049A\\u049C\\u049E\\u04A0\\u04A2\\u04A4\\u04A6\\u04A8\\u04AA\\u04AC\\u04AE\\u04B0\\u04B2\\u04B4\\u04B6\\u04B8\\u04BA\\u04BC\\u04BE\\u04C0\\u04C1\\u04C3\\u04C5\\u04C7\\u04C9\\u04CB\\u04CD\\u04D0\\u04D2\\u04D4\\u04D6\\u04D8\\u04DA\\u04DC\\u04DE\\u04E0\\u04E2\\u04E4\\u04E6\\u04E8\\u04EA\\u04EC\\u04EE\\u04F0\\u04F2\\u04F4\\u04F6\\u04F8\\u04FA\\u04FC\\u04FE\\u0500\\u0502\\u0504\\u0506\\u0508\\u050A\\u050C\\u050E\\u0510\\u0512\\u0514\\u0516\\u0518\\u051A\\u051C\\u051E\\u0520\\u0522\\u0524\\u0526\\u0531-\\u0556\\u10A0-\\u10C5\\u1E00\\u1E02\\u1E04\\u1E06\\u1E08\\u1E0A\\u1E0C\\u1E0E\\u1E10\\u1E12\\u1E14\\u1E16\\u1E18\\u1E1A\\u1E1C\\u1E1E\\u1E20\\u1E22\\u1E24\\u1E26\\u1E28\\u1E2A\\u1E2C\\u1E2E\\u1E30\\u1E32\\u1E34\\u1E36\\u1E38\\u1E3A\\u1E3C\\u1E3E\\u1E40\\u1E42\\u1E44\\u1E46\\u1E48\\u1E4A\\u1E4C\\u1E4E\\u1E50\\u1E52\\u1E54\\u1E56\\u1E58\\u1E5A\\u1E5C\\u1E5E\\u1E60\\u1E62\\u1E64\\u1E66\\u1E68\\u1E6A\\u1E6C\\u1E6E\\u1E70\\u1E72\\u1E74\\u1E76\\u1E78\\u1E7A\\u1E7C\\u1E7E\\u1E80\\u1E82\\u1E84\\u1E86\\u1E88\\u1E8A\\u1E8C\\u1E8E\\u1E90\\u1E92\\u1E94\\u1E9E\\u1EA0\\u1EA2\\u1EA4\\u1EA6\\u1EA8\\u1EAA\\u1EAC\\u1EAE\\u1EB0\\u1EB2\\u1EB4\\u1EB6\\u1EB8\\u1EBA\\u1EBC\\u1EBE\\u1EC0\\u1EC2\\u1EC4\\u1EC6\\u1EC8\\u1ECA\\u1ECC\\u1ECE\\u1ED0\\u1ED2\\u1ED4\\u1ED6\\u1ED8\\u1EDA\\u1EDC\\u1EDE\\u1EE0\\u1EE2\\u1EE4\\u1EE6\\u1EE8\\u1EEA\\u1EEC\\u1EEE\\u1EF0\\u1EF2\\u1EF4\\u1EF6\\u1EF8\\u1EFA\\u1EFC\\u1EFE\\u1F08-\\u1F0F\\u1F18-\\u1F1D\\u1F28-\\u1F2F\\u1F38-\\u1F3F\\u1F48-\\u1F4D\\u1F59\\u1F5B\\u1F5D\\u1F5F\\u1F68-\\u1F6F\\u1FB8-\\u1FBB\\u1FC8-\\u1FCB\\u1FD8-\\u1FDB\\u1FE8-\\u1FEC\\u1FF8-\\u1FFB\\u2102\\u2107\\u210B-\\u210D\\u2110-\\u2112\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u2130-\\u2133\\u213E\\u213F\\u2145\\u2183\\u2C00-\\u2C2E\\u2C60\\u2C62-\\u2C64\\u2C67\\u2C69\\u2C6B\\u2C6D-\\u2C70\\u2C72\\u2C75\\u2C7E-\\u2C80\\u2C82\\u2C84\\u2C86\\u2C88\\u2C8A\\u2C8C\\u2C8E\\u2C90\\u2C92\\u2C94\\u2C96\\u2C98\\u2C9A\\u2C9C\\u2C9E\\u2CA0\\u2CA2\\u2CA4\\u2CA6\\u2CA8\\u2CAA\\u2CAC\\u2CAE\\u2CB0\\u2CB2\\u2CB4\\u2CB6\\u2CB8\\u2CBA\\u2CBC\\u2CBE\\u2CC0\\u2CC2\\u2CC4\\u2CC6\\u2CC8\\u2CCA\\u2CCC\\u2CCE\\u2CD0\\u2CD2\\u2CD4\\u2CD6\\u2CD8\\u2CDA\\u2CDC\\u2CDE\\u2CE0\\u2CE2\\u2CEB\\u2CED\\uA640\\uA642\\uA644\\uA646\\uA648\\uA64A\\uA64C\\uA64E\\uA650\\uA652\\uA654\\uA656\\uA658\\uA65A\\uA65C\\uA65E\\uA660\\uA662\\uA664\\uA666\\uA668\\uA66A\\uA66C\\uA680\\uA682\\uA684\\uA686\\uA688\\uA68A\\uA68C\\uA68E\\uA690\\uA692\\uA694\\uA696\\uA722\\uA724\\uA726\\uA728\\uA72A\\uA72C\\uA72E\\uA732\\uA734\\uA736\\uA738\\uA73A\\uA73C\\uA73E\\uA740\\uA742\\uA744\\uA746\\uA748\\uA74A\\uA74C\\uA74E\\uA750\\uA752\\uA754\\uA756\\uA758\\uA75A\\uA75C\\uA75E\\uA760\\uA762\\uA764\\uA766\\uA768\\uA76A\\uA76C\\uA76E\\uA779\\uA77B\\uA77D\\uA77E\\uA780\\uA782\\uA784\\uA786\\uA78B\\uA78D\\uA790\\uA7A0\\uA7A2\\uA7A4\\uA7A6\\uA7A8\\uFF21-\\uFF3Aa-z\\xAA\\xB5\\xBA\\xDF-\\xF6\\xF8-\\xFF\\u0101\\u0103\\u0105\\u0107\\u0109\\u010B\\u010D\\u010F\\u0111\\u0113\\u0115\\u0117\\u0119\\u011B\\u011D\\u011F\\u0121\\u0123\\u0125\\u0127\\u0129\\u012B\\u012D\\u012F\\u0131\\u0133\\u0135\\u0137\\u0138\\u013A\\u013C\\u013E\\u0140\\u0142\\u0144\\u0146\\u0148\\u0149\\u014B\\u014D\\u014F\\u0151\\u0153\\u0155\\u0157\\u0159\\u015B\\u015D\\u015F\\u0161\\u0163\\u0165\\u0167\\u0169\\u016B\\u016D\\u016F\\u0171\\u0173\\u0175\\u0177\\u017A\\u017C\\u017E-\\u0180\\u0183\\u0185\\u0188\\u018C\\u018D\\u0192\\u0195\\u0199-\\u019B\\u019E\\u01A1\\u01A3\\u01A5\\u01A8\\u01AA\\u01AB\\u01AD\\u01B0\\u01B4\\u01B6\\u01B9\\u01BA\\u01BD-\\u01BF\\u01C6\\u01C9\\u01CC\\u01CE\\u01D0\\u01D2\\u01D4\\u01D6\\u01D8\\u01DA\\u01DC\\u01DD\\u01DF\\u01E1\\u01E3\\u01E5\\u01E7\\u01E9\\u01EB\\u01ED\\u01EF\\u01F0\\u01F3\\u01F5\\u01F9\\u01FB\\u01FD\\u01FF\\u0201\\u0203\\u0205\\u0207\\u0209\\u020B\\u020D\\u020F\\u0211\\u0213\\u0215\\u0217\\u0219\\u021B\\u021D\\u021F\\u0221\\u0223\\u0225\\u0227\\u0229\\u022B\\u022D\\u022F\\u0231\\u0233-\\u0239\\u023C\\u023F\\u0240\\u0242\\u0247\\u0249\\u024B\\u024D\\u024F-\\u0293\\u0295-\\u02AF\\u0371\\u0373\\u0377\\u037B-\\u037D\\u0390\\u03AC-\\u03CE\\u03D0\\u03D1\\u03D5-\\u03D7\\u03D9\\u03DB\\u03DD\\u03DF\\u03E1\\u03E3\\u03E5\\u03E7\\u03E9\\u03EB\\u03ED\\u03EF-\\u03F3\\u03F5\\u03F8\\u03FB\\u03FC\\u0430-\\u045F\\u0461\\u0463\\u0465\\u0467\\u0469\\u046B\\u046D\\u046F\\u0471\\u0473\\u0475\\u0477\\u0479\\u047B\\u047D\\u047F\\u0481\\u048B\\u048D\\u048F\\u0491\\u0493\\u0495\\u0497\\u0499\\u049B\\u049D\\u049F\\u04A1\\u04A3\\u04A5\\u04A7\\u04A9\\u04AB\\u04AD\\u04AF\\u04B1\\u04B3\\u04B5\\u04B7\\u04B9\\u04BB\\u04BD\\u04BF\\u04C2\\u04C4\\u04C6\\u04C8\\u04CA\\u04CC\\u04CE\\u04CF\\u04D1\\u04D3\\u04D5\\u04D7\\u04D9\\u04DB\\u04DD\\u04DF\\u04E1\\u04E3\\u04E5\\u04E7\\u04E9\\u04EB\\u04ED\\u04EF\\u04F1\\u04F3\\u04F5\\u04F7\\u04F9\\u04FB\\u04FD\\u04FF\\u0501\\u0503\\u0505\\u0507\\u0509\\u050B\\u050D\\u050F\\u0511\\u0513\\u0515\\u0517\\u0519\\u051B\\u051D\\u051F\\u0521\\u0523\\u0525\\u0527\\u0561-\\u0587\\u1D00-\\u1D2B\\u1D62-\\u1D77\\u1D79-\\u1D9A\\u1E01\\u1E03\\u1E05\\u1E07\\u1E09\\u1E0B\\u1E0D\\u1E0F\\u1E11\\u1E13\\u1E15\\u1E17\\u1E19\\u1E1B\\u1E1D\\u1E1F\\u1E21\\u1E23\\u1E25\\u1E27\\u1E29\\u1E2B\\u1E2D\\u1E2F\\u1E31\\u1E33\\u1E35\\u1E37\\u1E39\\u1E3B\\u1E3D\\u1E3F\\u1E41\\u1E43\\u1E45\\u1E47\\u1E49\\u1E4B\\u1E4D\\u1E4F\\u1E51\\u1E53\\u1E55\\u1E57\\u1E59\\u1E5B\\u1E5D\\u1E5F\\u1E61\\u1E63\\u1E65\\u1E67\\u1E69\\u1E6B\\u1E6D\\u1E6F\\u1E71\\u1E73\\u1E75\\u1E77\\u1E79\\u1E7B\\u1E7D\\u1E7F\\u1E81\\u1E83\\u1E85\\u1E87\\u1E89\\u1E8B\\u1E8D\\u1E8F\\u1E91\\u1E93\\u1E95-\\u1E9D\\u1E9F\\u1EA1\\u1EA3\\u1EA5\\u1EA7\\u1EA9\\u1EAB\\u1EAD\\u1EAF\\u1EB1\\u1EB3\\u1EB5\\u1EB7\\u1EB9\\u1EBB\\u1EBD\\u1EBF\\u1EC1\\u1EC3\\u1EC5\\u1EC7\\u1EC9\\u1ECB\\u1ECD\\u1ECF\\u1ED1\\u1ED3\\u1ED5\\u1ED7\\u1ED9\\u1EDB\\u1EDD\\u1EDF\\u1EE1\\u1EE3\\u1EE5\\u1EE7\\u1EE9\\u1EEB\\u1EED\\u1EEF\\u1EF1\\u1EF3\\u1EF5\\u1EF7\\u1EF9\\u1EFB\\u1EFD\\u1EFF-\\u1F07\\u1F10-\\u1F15\\u1F20-\\u1F27\\u1F30-\\u1F37\\u1F40-\\u1F45\\u1F50-\\u1F57\\u1F60-\\u1F67\\u1F70-\\u1F7D\\u1F80-\\u1F87\\u1F90-\\u1F97\\u1FA0-\\u1FA7\\u1FB0-\\u1FB4\\u1FB6\\u1FB7\\u1FBE\\u1FC2-\\u1FC4\\u1FC6\\u1FC7\\u1FD0-\\u1FD3\\u1FD6\\u1FD7\\u1FE0-\\u1FE7\\u1FF2-\\u1FF4\\u1FF6\\u1FF7\\u210A\\u210E\\u210F\\u2113\\u212F\\u2134\\u2139\\u213C\\u213D\\u2146-\\u2149\\u214E\\u2184\\u2C30-\\u2C5E\\u2C61\\u2C65\\u2C66\\u2C68\\u2C6A\\u2C6C\\u2C71\\u2C73\\u2C74\\u2C76-\\u2C7C\\u2C81\\u2C83\\u2C85\\u2C87\\u2C89\\u2C8B\\u2C8D\\u2C8F\\u2C91\\u2C93\\u2C95\\u2C97\\u2C99\\u2C9B\\u2C9D\\u2C9F\\u2CA1\\u2CA3\\u2CA5\\u2CA7\\u2CA9\\u2CAB\\u2CAD\\u2CAF\\u2CB1\\u2CB3\\u2CB5\\u2CB7\\u2CB9\\u2CBB\\u2CBD\\u2CBF\\u2CC1\\u2CC3\\u2CC5\\u2CC7\\u2CC9\\u2CCB\\u2CCD\\u2CCF\\u2CD1\\u2CD3\\u2CD5\\u2CD7\\u2CD9\\u2CDB\\u2CDD\\u2CDF\\u2CE1\\u2CE3\\u2CE4\\u2CEC\\u2CEE\\u2D00-\\u2D25\\uA641\\uA643\\uA645\\uA647\\uA649\\uA64B\\uA64D\\uA64F\\uA651\\uA653\\uA655\\uA657\\uA659\\uA65B\\uA65D\\uA65F\\uA661\\uA663\\uA665\\uA667\\uA669\\uA66B\\uA66D\\uA681\\uA683\\uA685\\uA687\\uA689\\uA68B\\uA68D\\uA68F\\uA691\\uA693\\uA695\\uA697\\uA723\\uA725\\uA727\\uA729\\uA72B\\uA72D\\uA72F-\\uA731\\uA733\\uA735\\uA737\\uA739\\uA73B\\uA73D\\uA73F\\uA741\\uA743\\uA745\\uA747\\uA749\\uA74B\\uA74D\\uA74F\\uA751\\uA753\\uA755\\uA757\\uA759\\uA75B\\uA75D\\uA75F\\uA761\\uA763\\uA765\\uA767\\uA769\\uA76B\\uA76D\\uA76F\\uA771-\\uA778\\uA77A\\uA77C\\uA77F\\uA781\\uA783\\uA785\\uA787\\uA78C\\uA78E\\uA791\\uA7A1\\uA7A3\\uA7A5\\uA7A7\\uA7A9\\uA7FA\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFF41-\\uFF5A\\u01C5\\u01C8\\u01CB\\u01F2\\u1F88-\\u1F8F\\u1F98-\\u1F9F\\u1FA8-\\u1FAF\\u1FBC\\u1FCC\\u1FFC\\u02B0-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0374\\u037A\\u0559\\u0640\\u06E5\\u06E6\\u07F4\\u07F5\\u07FA\\u081A\\u0824\\u0828\\u0971\\u0E46\\u0EC6\\u10FC\\u17D7\\u1843\\u1AA7\\u1C78-\\u1C7D\\u1D2C-\\u1D61\\u1D78\\u1D9B-\\u1DBF\\u2071\\u207F\\u2090-\\u209C\\u2C7D\\u2D6F\\u2E2F\\u3005\\u3031-\\u3035\\u303B\\u309D\\u309E\\u30FC-\\u30FE\\uA015\\uA4F8-\\uA4FD\\uA60C\\uA67F\\uA717-\\uA71F\\uA770\\uA788\\uA9CF\\uAA70\\uAADD\\uFF70\\uFF9E\\uFF9F\\u01BB\\u01C0-\\u01C3\\u0294\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u063F\\u0641-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u0800-\\u0815\\u0840-\\u0858\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0972-\\u0977\\u0979-\\u097F\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C33\\u0C35-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E45\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EDC\\u0EDD\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10D0-\\u10FA\\u1100-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17DC\\u1820-\\u1842\\u1844-\\u1877\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191C\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BC0-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C77\\u1CE9-\\u1CEC\\u1CEE-\\u1CF1\\u2135-\\u2138\\u2D30-\\u2D65\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u3006\\u303C\\u3041-\\u3096\\u309F\\u30A1-\\u30FA\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400\\u4DB5\\u4E00\\u9FCB\\uA000-\\uA014\\uA016-\\uA48C\\uA4D0-\\uA4F7\\uA500-\\uA60B\\uA610-\\uA61F\\uA62A\\uA62B\\uA66E\\uA6A0-\\uA6E5\\uA7FB-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA6F\\uAA71-\\uAA76\\uAA7A\\uAA80-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB\\uAADC\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uABC0-\\uABE2\\uAC00\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA2D\\uFA30-\\uFA6D\\uFA70-\\uFAD9\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF66-\\uFF6F\\uFF71-\\uFF9D\\uFFA0-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC\\u16EE-\\u16F0\\u2160-\\u2182\\u2185-\\u2188\\u3007\\u3021-\\u3029\\u3038-\\u303A\\uA6E6-\\uA6EF]");
          }
        }
        if (r0 === null) {
          r1 = pos;
          if (input.charCodeAt(pos) === 55340) {
            r2 = "\uD82C";
            pos++;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uD82C\"");
            }
          }
          if (r2 !== null) {
            if (/^[\uDC00\uDC01]/.test(input.charAt(pos))) {
              r3 = input.charAt(pos);
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("[\\uDC00\\uDC01]");
              }
            }
            if (r3 !== null) {
              r0 = [r2, r3];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            if (input.charCodeAt(pos) === 55304) {
              r2 = "\uD808";
              pos++;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\uD808\"");
              }
            }
            if (r2 !== null) {
              if (/^[\uDC00-\uDF6E]/.test(input.charAt(pos))) {
                r3 = input.charAt(pos);
                pos++;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("[\\uDC00-\\uDF6E]");
                }
              }
              if (r3 !== null) {
                r0 = [r2, r3];
              } else {
                r0 = null;
                pos = r1;
              }
            } else {
              r0 = null;
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              if (input.charCodeAt(pos) === 55401) {
                r2 = "\uD869";
                pos++;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\uD869\"");
                }
              }
              if (r2 !== null) {
                if (/^[\uDED6\uDF00]/.test(input.charAt(pos))) {
                  r3 = input.charAt(pos);
                  pos++;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[\\uDED6\\uDF00]");
                  }
                }
                if (r3 !== null) {
                  r0 = [r2, r3];
                } else {
                  r0 = null;
                  pos = r1;
                }
              } else {
                r0 = null;
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                if (input.charCodeAt(pos) === 55305) {
                  r2 = "\uD809";
                  pos++;
                } else {
                  r2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\uD809\"");
                  }
                }
                if (r2 !== null) {
                  if (/^[\uDC00-\uDC62]/.test(input.charAt(pos))) {
                    r3 = input.charAt(pos);
                    pos++;
                  } else {
                    r3 = null;
                    if (reportFailures === 0) {
                      matchFailed("[\\uDC00-\\uDC62]");
                    }
                  }
                  if (r3 !== null) {
                    r0 = [r2, r3];
                  } else {
                    r0 = null;
                    pos = r1;
                  }
                } else {
                  r0 = null;
                  pos = r1;
                }
                if (r0 === null) {
                  r1 = pos;
                  if (input.charCodeAt(pos) === 55349) {
                    r2 = "\uD835";
                    pos++;
                  } else {
                    r2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\uD835\"");
                    }
                  }
                  if (r2 !== null) {
                    if (/^[\uDC00-\uDC19\uDC34-\uDC4D\uDC68-\uDC81\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB5\uDCD0-\uDCE9\uDD04\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD38\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD6C-\uDD85\uDDA0-\uDDB9\uDDD4-\uDDED\uDE08-\uDE21\uDE3C-\uDE55\uDE70-\uDE89\uDEA8-\uDEC0\uDEE2-\uDEFA\uDF1C-\uDF34\uDF56-\uDF6E\uDF90-\uDFA8\uDFCA\uDC1A-\uDC33\uDC4E-\uDC54\uDC56-\uDC67\uDC82-\uDC9B\uDCB6-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDCCF\uDCEA-\uDD03\uDD1E-\uDD37\uDD52-\uDD6B\uDD86-\uDD9F\uDDBA-\uDDD3\uDDEE-\uDE07\uDE22-\uDE3B\uDE56-\uDE6F\uDE8A-\uDEA5\uDEC2-\uDEDA\uDEDC-\uDEE1\uDEFC-\uDF14\uDF16-\uDF1B\uDF36-\uDF4E\uDF50-\uDF55\uDF70-\uDF88\uDF8A-\uDF8F\uDFAA-\uDFC2\uDFC4-\uDFC9\uDFCB]/.test(input.charAt(pos))) {
                      r3 = input.charAt(pos);
                      pos++;
                    } else {
                      r3 = null;
                      if (reportFailures === 0) {
                        matchFailed("[\\uDC00-\\uDC19\\uDC34-\\uDC4D\\uDC68-\\uDC81\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB5\\uDCD0-\\uDCE9\\uDD04\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD38\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD6C-\\uDD85\\uDDA0-\\uDDB9\\uDDD4-\\uDDED\\uDE08-\\uDE21\\uDE3C-\\uDE55\\uDE70-\\uDE89\\uDEA8-\\uDEC0\\uDEE2-\\uDEFA\\uDF1C-\\uDF34\\uDF56-\\uDF6E\\uDF90-\\uDFA8\\uDFCA\\uDC1A-\\uDC33\\uDC4E-\\uDC54\\uDC56-\\uDC67\\uDC82-\\uDC9B\\uDCB6-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDCCF\\uDCEA-\\uDD03\\uDD1E-\\uDD37\\uDD52-\\uDD6B\\uDD86-\\uDD9F\\uDDBA-\\uDDD3\\uDDEE-\\uDE07\\uDE22-\\uDE3B\\uDE56-\\uDE6F\\uDE8A-\\uDEA5\\uDEC2-\\uDEDA\\uDEDC-\\uDEE1\\uDEFC-\\uDF14\\uDF16-\\uDF1B\\uDF36-\\uDF4E\\uDF50-\\uDF55\\uDF70-\\uDF88\\uDF8A-\\uDF8F\\uDFAA-\\uDFC2\\uDFC4-\\uDFC9\\uDFCB]");
                      }
                    }
                    if (r3 !== null) {
                      r0 = [r2, r3];
                    } else {
                      r0 = null;
                      pos = r1;
                    }
                  } else {
                    r0 = null;
                    pos = r1;
                  }
                  if (r0 === null) {
                    r1 = pos;
                    if (input.charCodeAt(pos) === 55300) {
                      r2 = "\uD804";
                      pos++;
                    } else {
                      r2 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"\\uD804\"");
                      }
                    }
                    if (r2 !== null) {
                      if (/^[\uDC03-\uDC37\uDC83-\uDCAF]/.test(input.charAt(pos))) {
                        r3 = input.charAt(pos);
                        pos++;
                      } else {
                        r3 = null;
                        if (reportFailures === 0) {
                          matchFailed("[\\uDC03-\\uDC37\\uDC83-\\uDCAF]");
                        }
                      }
                      if (r3 !== null) {
                        r0 = [r2, r3];
                      } else {
                        r0 = null;
                        pos = r1;
                      }
                    } else {
                      r0 = null;
                      pos = r1;
                    }
                    if (r0 === null) {
                      r1 = pos;
                      if (input.charCodeAt(pos) === 55296) {
                        r2 = "\uD800";
                        pos++;
                      } else {
                        r2 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\uD800\"");
                        }
                      }
                      if (r2 !== null) {
                        if (/^[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1E\uDF30-\uDF40\uDF42-\uDF49\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDD40-\uDD74\uDF41\uDF4A\uDFD1-\uDFD5]/.test(input.charAt(pos))) {
                          r3 = input.charAt(pos);
                          pos++;
                        } else {
                          r3 = null;
                          if (reportFailures === 0) {
                            matchFailed("[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDF00-\\uDF1E\\uDF30-\\uDF40\\uDF42-\\uDF49\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDD40-\\uDD74\\uDF41\\uDF4A\\uDFD1-\\uDFD5]");
                          }
                        }
                        if (r3 !== null) {
                          r0 = [r2, r3];
                        } else {
                          r0 = null;
                          pos = r1;
                        }
                      } else {
                        r0 = null;
                        pos = r1;
                      }
                      if (r0 === null) {
                        r1 = pos;
                        if (input.charCodeAt(pos) === 55308) {
                          r2 = "\uD80C";
                          pos++;
                        } else {
                          r2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"\\uD80C\"");
                          }
                        }
                        if (r2 !== null) {
                          if (/^[\uDC00-\uDFFF]/.test(input.charAt(pos))) {
                            r3 = input.charAt(pos);
                            pos++;
                          } else {
                            r3 = null;
                            if (reportFailures === 0) {
                              matchFailed("[\\uDC00-\\uDFFF]");
                            }
                          }
                          if (r3 !== null) {
                            r0 = [r2, r3];
                          } else {
                            r0 = null;
                            pos = r1;
                          }
                        } else {
                          r0 = null;
                          pos = r1;
                        }
                        if (r0 === null) {
                          r1 = pos;
                          if (input.charCodeAt(pos) === 55297) {
                            r2 = "\uD801";
                            pos++;
                          } else {
                            r2 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"\\uD801\"");
                            }
                          }
                          if (r2 !== null) {
                            if (/^[\uDC00-\uDC9D]/.test(input.charAt(pos))) {
                              r3 = input.charAt(pos);
                              pos++;
                            } else {
                              r3 = null;
                              if (reportFailures === 0) {
                                matchFailed("[\\uDC00-\\uDC9D]");
                              }
                            }
                            if (r3 !== null) {
                              r0 = [r2, r3];
                            } else {
                              r0 = null;
                              pos = r1;
                            }
                          } else {
                            r0 = null;
                            pos = r1;
                          }
                          if (r0 === null) {
                            r1 = pos;
                            if (input.charCodeAt(pos) === 55406) {
                              r2 = "\uD86E";
                              pos++;
                            } else {
                              r2 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"\\uD86E\"");
                              }
                            }
                            if (r2 !== null) {
                              if (/^[\uDC1D]/.test(input.charAt(pos))) {
                                r3 = input.charAt(pos);
                                pos++;
                              } else {
                                r3 = null;
                                if (reportFailures === 0) {
                                  matchFailed("[\\uDC1D]");
                                }
                              }
                              if (r3 !== null) {
                                r0 = [r2, r3];
                              } else {
                                r0 = null;
                                pos = r1;
                              }
                            } else {
                              r0 = null;
                              pos = r1;
                            }
                            if (r0 === null) {
                              r1 = pos;
                              if (input.charCodeAt(pos) === 55299) {
                                r2 = "\uD803";
                                pos++;
                              } else {
                                r2 = null;
                                if (reportFailures === 0) {
                                  matchFailed("\"\\uD803\"");
                                }
                              }
                              if (r2 !== null) {
                                if (/^[\uDC00-\uDC48]/.test(input.charAt(pos))) {
                                  r3 = input.charAt(pos);
                                  pos++;
                                } else {
                                  r3 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("[\\uDC00-\\uDC48]");
                                  }
                                }
                                if (r3 !== null) {
                                  r0 = [r2, r3];
                                } else {
                                  r0 = null;
                                  pos = r1;
                                }
                              } else {
                                r0 = null;
                                pos = r1;
                              }
                              if (r0 === null) {
                                r1 = pos;
                                if (input.charCodeAt(pos) === 55360) {
                                  r2 = "\uD840";
                                  pos++;
                                } else {
                                  r2 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"\\uD840\"");
                                  }
                                }
                                if (r2 !== null) {
                                  if (/^[\uDC00]/.test(input.charAt(pos))) {
                                    r3 = input.charAt(pos);
                                    pos++;
                                  } else {
                                    r3 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("[\\uDC00]");
                                    }
                                  }
                                  if (r3 !== null) {
                                    r0 = [r2, r3];
                                  } else {
                                    r0 = null;
                                    pos = r1;
                                  }
                                } else {
                                  r0 = null;
                                  pos = r1;
                                }
                                if (r0 === null) {
                                  r1 = pos;
                                  if (input.charCodeAt(pos) === 55422) {
                                    r2 = "\uD87E";
                                    pos++;
                                  } else {
                                    r2 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\"\\uD87E\"");
                                    }
                                  }
                                  if (r2 !== null) {
                                    if (/^[\uDC00-\uDE1D]/.test(input.charAt(pos))) {
                                      r3 = input.charAt(pos);
                                      pos++;
                                    } else {
                                      r3 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("[\\uDC00-\\uDE1D]");
                                      }
                                    }
                                    if (r3 !== null) {
                                      r0 = [r2, r3];
                                    } else {
                                      r0 = null;
                                      pos = r1;
                                    }
                                  } else {
                                    r0 = null;
                                    pos = r1;
                                  }
                                  if (r0 === null) {
                                    r1 = pos;
                                    if (input.charCodeAt(pos) === 55405) {
                                      r2 = "\uD86D";
                                      pos++;
                                    } else {
                                      r2 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\"\\uD86D\"");
                                      }
                                    }
                                    if (r2 !== null) {
                                      if (/^[\uDF34\uDF40]/.test(input.charAt(pos))) {
                                        r3 = input.charAt(pos);
                                        pos++;
                                      } else {
                                        r3 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("[\\uDF34\\uDF40]");
                                        }
                                      }
                                      if (r3 !== null) {
                                        r0 = [r2, r3];
                                      } else {
                                        r0 = null;
                                        pos = r1;
                                      }
                                    } else {
                                      r0 = null;
                                      pos = r1;
                                    }
                                    if (r0 === null) {
                                      r1 = pos;
                                      if (input.charCodeAt(pos) === 55322) {
                                        r2 = "\uD81A";
                                        pos++;
                                      } else {
                                        r2 = null;
                                        if (reportFailures === 0) {
                                          matchFailed("\"\\uD81A\"");
                                        }
                                      }
                                      if (r2 !== null) {
                                        if (/^[\uDC00-\uDE38]/.test(input.charAt(pos))) {
                                          r3 = input.charAt(pos);
                                          pos++;
                                        } else {
                                          r3 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("[\\uDC00-\\uDE38]");
                                          }
                                        }
                                        if (r3 !== null) {
                                          r0 = [r2, r3];
                                        } else {
                                          r0 = null;
                                          pos = r1;
                                        }
                                      } else {
                                        r0 = null;
                                        pos = r1;
                                      }
                                      if (r0 === null) {
                                        r1 = pos;
                                        if (input.charCodeAt(pos) === 55298) {
                                          r2 = "\uD802";
                                          pos++;
                                        } else {
                                          r2 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\"\\uD802\"");
                                          }
                                        }
                                        if (r2 !== null) {
                                          if (/^[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDD00-\uDD15\uDD20-\uDD39\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72]/.test(input.charAt(pos))) {
                                            r3 = input.charAt(pos);
                                            pos++;
                                          } else {
                                            r3 = null;
                                            if (reportFailures === 0) {
                                              matchFailed("[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDE00\\uDE10-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE33\\uDE60-\\uDE7C\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72]");
                                            }
                                          }
                                          if (r3 !== null) {
                                            r0 = [r2, r3];
                                          } else {
                                            r0 = null;
                                            pos = r1;
                                          }
                                        } else {
                                          r0 = null;
                                          pos = r1;
                                        }
                                        if (r0 === null) {
                                          r1 = pos;
                                          if (input.charCodeAt(pos) === 55309) {
                                            r2 = "\uD80D";
                                            pos++;
                                          } else {
                                            r2 = null;
                                            if (reportFailures === 0) {
                                              matchFailed("\"\\uD80D\"");
                                            }
                                          }
                                          if (r2 !== null) {
                                            if (/^[\uDC00-\uDC2E]/.test(input.charAt(pos))) {
                                              r3 = input.charAt(pos);
                                              pos++;
                                            } else {
                                              r3 = null;
                                              if (reportFailures === 0) {
                                                matchFailed("[\\uDC00-\\uDC2E]");
                                              }
                                            }
                                            if (r3 !== null) {
                                              r0 = [r2, r3];
                                            } else {
                                              r0 = null;
                                              pos = r1;
                                            }
                                          } else {
                                            r0 = null;
                                            pos = r1;
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UnicodeCombiningMark() {
        var cacheKey = "UnicodeCombiningMark@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3;
        
        if (/^[\u0300-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0900-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0CBC\u0CBF\u0CC6\u0CCC\u0CCD\u0CE2\u0CE3\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA67C\uA67D\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA8C4\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE26\u0903\u093B\u093E-\u0940\u0949-\u094C\u094E\u094F\u0982\u0983\u09BE-\u09C0\u09C7\u09C8\u09CB\u09CC\u09D7\u0A03\u0A3E-\u0A40\u0A83\u0ABE-\u0AC0\u0AC9\u0ACB\u0ACC\u0B02\u0B03\u0B3E\u0B40\u0B47\u0B48\u0B4B\u0B4C\u0B57\u0BBE\u0BBF\u0BC1\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCC\u0BD7\u0C01-\u0C03\u0C41-\u0C44\u0C82\u0C83\u0CBE\u0CC0-\u0CC4\u0CC7\u0CC8\u0CCA\u0CCB\u0CD5\u0CD6\u0D02\u0D03\u0D3E-\u0D40\u0D46-\u0D48\u0D4A-\u0D4C\u0D57\u0D82\u0D83\u0DCF-\u0DD1\u0DD8-\u0DDF\u0DF2\u0DF3\u0F3E\u0F3F\u0F7F\u102B\u102C\u1031\u1038\u103B\u103C\u1056\u1057\u1062-\u1064\u1067-\u106D\u1083\u1084\u1087-\u108C\u108F\u109A-\u109C\u17B6\u17BE-\u17C5\u17C7\u17C8\u1923-\u1926\u1929-\u192B\u1930\u1931\u1933-\u1938\u19B0-\u19C0\u19C8\u19C9\u1A19-\u1A1B\u1A55\u1A57\u1A61\u1A63\u1A64\u1A6D-\u1A72\u1B04\u1B35\u1B3B\u1B3D-\u1B41\u1B43\u1B44\u1B82\u1BA1\u1BA6\u1BA7\u1BAA\u1BE7\u1BEA-\u1BEC\u1BEE\u1BF2\u1BF3\u1C24-\u1C2B\u1C34\u1C35\u1CE1\u1CF2\uA823\uA824\uA827\uA880\uA881\uA8B4-\uA8C3\uA952\uA953\uA983\uA9B4\uA9B5\uA9BA\uA9BB\uA9BD-\uA9C0\uAA2F\uAA30\uAA33\uAA34\uAA4D\uAA7B\uABE3\uABE4\uABE6\uABE7\uABE9\uABEA\uABEC]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[\\u0300-\\u036F\\u0483-\\u0487\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u0610-\\u061A\\u064B-\\u065F\\u0670\\u06D6-\\u06DC\\u06DF-\\u06E4\\u06E7\\u06E8\\u06EA-\\u06ED\\u0711\\u0730-\\u074A\\u07A6-\\u07B0\\u07EB-\\u07F3\\u0816-\\u0819\\u081B-\\u0823\\u0825-\\u0827\\u0829-\\u082D\\u0859-\\u085B\\u0900-\\u0902\\u093A\\u093C\\u0941-\\u0948\\u094D\\u0951-\\u0957\\u0962\\u0963\\u0981\\u09BC\\u09C1-\\u09C4\\u09CD\\u09E2\\u09E3\\u0A01\\u0A02\\u0A3C\\u0A41\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A70\\u0A71\\u0A75\\u0A81\\u0A82\\u0ABC\\u0AC1-\\u0AC5\\u0AC7\\u0AC8\\u0ACD\\u0AE2\\u0AE3\\u0B01\\u0B3C\\u0B3F\\u0B41-\\u0B44\\u0B4D\\u0B56\\u0B62\\u0B63\\u0B82\\u0BC0\\u0BCD\\u0C3E-\\u0C40\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C62\\u0C63\\u0CBC\\u0CBF\\u0CC6\\u0CCC\\u0CCD\\u0CE2\\u0CE3\\u0D41-\\u0D44\\u0D4D\\u0D62\\u0D63\\u0DCA\\u0DD2-\\u0DD4\\u0DD6\\u0E31\\u0E34-\\u0E3A\\u0E47-\\u0E4E\\u0EB1\\u0EB4-\\u0EB9\\u0EBB\\u0EBC\\u0EC8-\\u0ECD\\u0F18\\u0F19\\u0F35\\u0F37\\u0F39\\u0F71-\\u0F7E\\u0F80-\\u0F84\\u0F86\\u0F87\\u0F8D-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u102D-\\u1030\\u1032-\\u1037\\u1039\\u103A\\u103D\\u103E\\u1058\\u1059\\u105E-\\u1060\\u1071-\\u1074\\u1082\\u1085\\u1086\\u108D\\u109D\\u135D-\\u135F\\u1712-\\u1714\\u1732-\\u1734\\u1752\\u1753\\u1772\\u1773\\u17B7-\\u17BD\\u17C6\\u17C9-\\u17D3\\u17DD\\u180B-\\u180D\\u18A9\\u1920-\\u1922\\u1927\\u1928\\u1932\\u1939-\\u193B\\u1A17\\u1A18\\u1A56\\u1A58-\\u1A5E\\u1A60\\u1A62\\u1A65-\\u1A6C\\u1A73-\\u1A7C\\u1A7F\\u1B00-\\u1B03\\u1B34\\u1B36-\\u1B3A\\u1B3C\\u1B42\\u1B6B-\\u1B73\\u1B80\\u1B81\\u1BA2-\\u1BA5\\u1BA8\\u1BA9\\u1BE6\\u1BE8\\u1BE9\\u1BED\\u1BEF-\\u1BF1\\u1C2C-\\u1C33\\u1C36\\u1C37\\u1CD0-\\u1CD2\\u1CD4-\\u1CE0\\u1CE2-\\u1CE8\\u1CED\\u1DC0-\\u1DE6\\u1DFC-\\u1DFF\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2CEF-\\u2CF1\\u2D7F\\u2DE0-\\u2DFF\\u302A-\\u302F\\u3099\\u309A\\uA66F\\uA67C\\uA67D\\uA6F0\\uA6F1\\uA802\\uA806\\uA80B\\uA825\\uA826\\uA8C4\\uA8E0-\\uA8F1\\uA926-\\uA92D\\uA947-\\uA951\\uA980-\\uA982\\uA9B3\\uA9B6-\\uA9B9\\uA9BC\\uAA29-\\uAA2E\\uAA31\\uAA32\\uAA35\\uAA36\\uAA43\\uAA4C\\uAAB0\\uAAB2-\\uAAB4\\uAAB7\\uAAB8\\uAABE\\uAABF\\uAAC1\\uABE5\\uABE8\\uABED\\uFB1E\\uFE00-\\uFE0F\\uFE20-\\uFE26\\u0903\\u093B\\u093E-\\u0940\\u0949-\\u094C\\u094E\\u094F\\u0982\\u0983\\u09BE-\\u09C0\\u09C7\\u09C8\\u09CB\\u09CC\\u09D7\\u0A03\\u0A3E-\\u0A40\\u0A83\\u0ABE-\\u0AC0\\u0AC9\\u0ACB\\u0ACC\\u0B02\\u0B03\\u0B3E\\u0B40\\u0B47\\u0B48\\u0B4B\\u0B4C\\u0B57\\u0BBE\\u0BBF\\u0BC1\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCC\\u0BD7\\u0C01-\\u0C03\\u0C41-\\u0C44\\u0C82\\u0C83\\u0CBE\\u0CC0-\\u0CC4\\u0CC7\\u0CC8\\u0CCA\\u0CCB\\u0CD5\\u0CD6\\u0D02\\u0D03\\u0D3E-\\u0D40\\u0D46-\\u0D48\\u0D4A-\\u0D4C\\u0D57\\u0D82\\u0D83\\u0DCF-\\u0DD1\\u0DD8-\\u0DDF\\u0DF2\\u0DF3\\u0F3E\\u0F3F\\u0F7F\\u102B\\u102C\\u1031\\u1038\\u103B\\u103C\\u1056\\u1057\\u1062-\\u1064\\u1067-\\u106D\\u1083\\u1084\\u1087-\\u108C\\u108F\\u109A-\\u109C\\u17B6\\u17BE-\\u17C5\\u17C7\\u17C8\\u1923-\\u1926\\u1929-\\u192B\\u1930\\u1931\\u1933-\\u1938\\u19B0-\\u19C0\\u19C8\\u19C9\\u1A19-\\u1A1B\\u1A55\\u1A57\\u1A61\\u1A63\\u1A64\\u1A6D-\\u1A72\\u1B04\\u1B35\\u1B3B\\u1B3D-\\u1B41\\u1B43\\u1B44\\u1B82\\u1BA1\\u1BA6\\u1BA7\\u1BAA\\u1BE7\\u1BEA-\\u1BEC\\u1BEE\\u1BF2\\u1BF3\\u1C24-\\u1C2B\\u1C34\\u1C35\\u1CE1\\u1CF2\\uA823\\uA824\\uA827\\uA880\\uA881\\uA8B4-\\uA8C3\\uA952\\uA953\\uA983\\uA9B4\\uA9B5\\uA9BA\\uA9BB\\uA9BD-\\uA9C0\\uAA2F\\uAA30\\uAA33\\uAA34\\uAA4D\\uAA7B\\uABE3\\uABE4\\uABE6\\uABE7\\uABE9\\uABEA\\uABEC]");
          }
        }
        if (r0 === null) {
          r1 = pos;
          if (input.charCodeAt(pos) === 56128) {
            r2 = "\uDB40";
            pos++;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uDB40\"");
            }
          }
          if (r2 !== null) {
            if (/^[\uDD00-\uDDEF]/.test(input.charAt(pos))) {
              r3 = input.charAt(pos);
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("[\\uDD00-\\uDDEF]");
              }
            }
            if (r3 !== null) {
              r0 = [r2, r3];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            if (input.charCodeAt(pos) === 55348) {
              r2 = "\uD834";
              pos++;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\uD834\"");
              }
            }
            if (r2 !== null) {
              if (/^[\uDD67-\uDD69\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44\uDD65\uDD66\uDD6D-\uDD72]/.test(input.charAt(pos))) {
                r3 = input.charAt(pos);
                pos++;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("[\\uDD67-\\uDD69\\uDD7B-\\uDD82\\uDD85-\\uDD8B\\uDDAA-\\uDDAD\\uDE42-\\uDE44\\uDD65\\uDD66\\uDD6D-\\uDD72]");
                }
              }
              if (r3 !== null) {
                r0 = [r2, r3];
              } else {
                r0 = null;
                pos = r1;
              }
            } else {
              r0 = null;
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              if (input.charCodeAt(pos) === 55300) {
                r2 = "\uD804";
                pos++;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\uD804\"");
                }
              }
              if (r2 !== null) {
                if (/^[\uDC01\uDC38-\uDC46\uDC80\uDC81\uDCB3-\uDCB6\uDCB9\uDCBA\uDC00\uDC02\uDC82\uDCB0-\uDCB2\uDCB7\uDCB8]/.test(input.charAt(pos))) {
                  r3 = input.charAt(pos);
                  pos++;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[\\uDC01\\uDC38-\\uDC46\\uDC80\\uDC81\\uDCB3-\\uDCB6\\uDCB9\\uDCBA\\uDC00\\uDC02\\uDC82\\uDCB0-\\uDCB2\\uDCB7\\uDCB8]");
                  }
                }
                if (r3 !== null) {
                  r0 = [r2, r3];
                } else {
                  r0 = null;
                  pos = r1;
                }
              } else {
                r0 = null;
                pos = r1;
              }
              if (r0 === null) {
                r1 = pos;
                if (input.charCodeAt(pos) === 55296) {
                  r2 = "\uD800";
                  pos++;
                } else {
                  r2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\uD800\"");
                  }
                }
                if (r2 !== null) {
                  if (/^[\uDDFD]/.test(input.charAt(pos))) {
                    r3 = input.charAt(pos);
                    pos++;
                  } else {
                    r3 = null;
                    if (reportFailures === 0) {
                      matchFailed("[\\uDDFD]");
                    }
                  }
                  if (r3 !== null) {
                    r0 = [r2, r3];
                  } else {
                    r0 = null;
                    pos = r1;
                  }
                } else {
                  r0 = null;
                  pos = r1;
                }
                if (r0 === null) {
                  r1 = pos;
                  if (input.charCodeAt(pos) === 55298) {
                    r2 = "\uD802";
                    pos++;
                  } else {
                    r2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"\\uD802\"");
                    }
                  }
                  if (r2 !== null) {
                    if (/^[\uDE01-\uDE03\uDE05\uDE06\uDE0C-\uDE0F\uDE38-\uDE3A\uDE3F]/.test(input.charAt(pos))) {
                      r3 = input.charAt(pos);
                      pos++;
                    } else {
                      r3 = null;
                      if (reportFailures === 0) {
                        matchFailed("[\\uDE01-\\uDE03\\uDE05\\uDE06\\uDE0C-\\uDE0F\\uDE38-\\uDE3A\\uDE3F]");
                      }
                    }
                    if (r3 !== null) {
                      r0 = [r2, r3];
                    } else {
                      r0 = null;
                      pos = r1;
                    }
                  } else {
                    r0 = null;
                    pos = r1;
                  }
                }
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UnicodeDigit() {
        var cacheKey = "UnicodeDigit@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0, r1, r2, r3;
        
        if (/^[0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9\\u0660-\\u0669\\u06F0-\\u06F9\\u07C0-\\u07C9\\u0966-\\u096F\\u09E6-\\u09EF\\u0A66-\\u0A6F\\u0AE6-\\u0AEF\\u0B66-\\u0B6F\\u0BE6-\\u0BEF\\u0C66-\\u0C6F\\u0CE6-\\u0CEF\\u0D66-\\u0D6F\\u0E50-\\u0E59\\u0ED0-\\u0ED9\\u0F20-\\u0F29\\u1040-\\u1049\\u1090-\\u1099\\u17E0-\\u17E9\\u1810-\\u1819\\u1946-\\u194F\\u19D0-\\u19D9\\u1A80-\\u1A89\\u1A90-\\u1A99\\u1B50-\\u1B59\\u1BB0-\\u1BB9\\u1C40-\\u1C49\\u1C50-\\u1C59\\uA620-\\uA629\\uA8D0-\\uA8D9\\uA900-\\uA909\\uA9D0-\\uA9D9\\uAA50-\\uAA59\\uABF0-\\uABF9\\uFF10-\\uFF19]");
          }
        }
        if (r0 === null) {
          r1 = pos;
          if (input.charCodeAt(pos) === 55349) {
            r2 = "\uD835";
            pos++;
          } else {
            r2 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\uD835\"");
            }
          }
          if (r2 !== null) {
            if (/^[\uDFCE-\uDFFF]/.test(input.charAt(pos))) {
              r3 = input.charAt(pos);
              pos++;
            } else {
              r3 = null;
              if (reportFailures === 0) {
                matchFailed("[\\uDFCE-\\uDFFF]");
              }
            }
            if (r3 !== null) {
              r0 = [r2, r3];
            } else {
              r0 = null;
              pos = r1;
            }
          } else {
            r0 = null;
            pos = r1;
          }
          if (r0 === null) {
            r1 = pos;
            if (input.charCodeAt(pos) === 55300) {
              r2 = "\uD804";
              pos++;
            } else {
              r2 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\uD804\"");
              }
            }
            if (r2 !== null) {
              if (/^[\uDC66-\uDC6F]/.test(input.charAt(pos))) {
                r3 = input.charAt(pos);
                pos++;
              } else {
                r3 = null;
                if (reportFailures === 0) {
                  matchFailed("[\\uDC66-\\uDC6F]");
                }
              }
              if (r3 !== null) {
                r0 = [r2, r3];
              } else {
                r0 = null;
                pos = r1;
              }
            } else {
              r0 = null;
              pos = r1;
            }
            if (r0 === null) {
              r1 = pos;
              if (input.charCodeAt(pos) === 55297) {
                r2 = "\uD801";
                pos++;
              } else {
                r2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\uD801\"");
                }
              }
              if (r2 !== null) {
                if (/^[\uDCA0-\uDCA9]/.test(input.charAt(pos))) {
                  r3 = input.charAt(pos);
                  pos++;
                } else {
                  r3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[\\uDCA0-\\uDCA9]");
                  }
                }
                if (r3 !== null) {
                  r0 = [r2, r3];
                } else {
                  r0 = null;
                  pos = r1;
                }
              } else {
                r0 = null;
                pos = r1;
              }
            }
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_UnicodeConnectorPunctuation() {
        var cacheKey = "UnicodeConnectorPunctuation@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (/^[_\u203F\u2040\u2054\uFE33\uFE34\uFE4D-\uFE4F\uFF3F]/.test(input.charAt(pos))) {
          r0 = input.charAt(pos);
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("[_\\u203F\\u2040\\u2054\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFF3F]");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ZWNJ() {
        var cacheKey = "ZWNJ@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (input.charCodeAt(pos) === 8204) {
          r0 = "\u200C";
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\u200C\"");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      function parse_ZWJ() {
        var cacheKey = "ZWJ@" + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var r0;
        
        if (input.charCodeAt(pos) === 8205) {
          r0 = "\u200D";
          pos++;
        } else {
          r0 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\u200D\"");
          }
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  r0
        };
        return r0;
      }
      
      
      function cleanupExpected(expected) {
        expected.sort();
        
        var lastExpected = null;
        var cleanExpected = [];
        for (var i = 0; i < expected.length; i++) {
          if (expected[i] !== lastExpected) {
            cleanExpected.push(expected[i]);
            lastExpected = expected[i];
          }
        }
        return cleanExpected;
      }
      
      
      var CS = require("./nodes"),
      
        constructorLookup =
          { '||': CS.LogicalOrOp
          , or: CS.LogicalOrOp
          , '&&': CS.LogicalAndOp
          , and: CS.LogicalAndOp
          , '|': CS.BitOrOp
          , '^': CS.BitXorOp
          , '&': CS.BitAndOp
          , '?': CS.ExistsOp
          , '==': CS.EQOp
          , is: CS.EQOp
          , '!=': CS.NEQOp
          , isnt: CS.NEQOp
          , '<=': CS.LTEOp
          , '>=': CS.GTEOp
          , '<': CS.LTOp
          , '>': CS.GTOp
          , 'extends': CS.ExtendsOp
          , 'instanceof': CS.InstanceofOp
          , 'in': CS.InOp
          , 'of': CS.OfOp
          , '<<': CS.LeftShiftOp
          , '>>': CS.SignedRightShiftOp
          , '>>>': CS.UnsignedRightShiftOp
          , '+': CS.PlusOp
          , '-': CS.SubtractOp
          , '*': CS.MultiplyOp
          , '/': CS.DivideOp
          , '%': CS.RemOp
          , '**': CS.ExpOp
          },
      
        negatableOps = ['instanceof', 'in', 'of'],
        chainableComparisonOps = ['<=', '>=', '<', '>', '==', 'is', '!=', 'isnt'],
      
        rightAssocOps = [';', '=', '?', '**'],
        precedenceHierarchy =
          [ ['or', '||']
          , ['and', '&&']
          , ['|']
          , ['^']
          , ['&']
          , ['?']
          , ['is', '==', 'isnt', '!=']
          , ['instanceof', 'in', 'of', '<=', '>=', '<', '>']
          , ['<<', '>>', '>>>']
          , ['+', '-']
          , ['*', '/', '%']
          , ['**']
          ],
      
        precedenceTable = (function(){
          var table = {}, ops, op;
          for(var level = 0, l = precedenceHierarchy.length; level < l; ++level) {
            ops = precedenceHierarchy[level];
            for(var o = 0, k = ops.length; o < k; ++o) {
              op = ops[o];
              table[op] = level;
            }
          }
          return table;
        }()),
      
        RIGHT_ASSOCIATIVE = {},
        LEFT_ASSOCIATIVE = {},
      
        associativities = (function(){
          var result = {};
          for(var op in precedenceTable) {
            if(!{}.hasOwnProperty.call(precedenceTable, op)) continue;
            result[op] = LEFT_ASSOCIATIVE;
          }
          for(var i = 0, l = rightAssocOps.length; i < l; ++i) {
            result[rightAssocOps[i]] = RIGHT_ASSOCIATIVE;
          }
          return result;
        }());
      
        for(var i = 0, l = negatableOps.length; i < l; ++i) {
          (function(op){
            var fn = function(a, b){ return new CS.LogicalNotOp(new constructorLookup[op](a, b)); };
            fn.prototype = constructorLookup[op].prototype;
            var negatedOp = 'not ' + op;
            constructorLookup[negatedOp] = fn;
            precedenceTable[negatedOp] = precedenceTable[op];
            associativities[negatedOp] = associativities[op];
          }(negatableOps[i]));
        }
      
      
        var
        prefixConstructorLookup =
          { '++': CS.PreIncrementOp
          , '--': CS.PreDecrementOp
          , '+': CS.UnaryPlusOp
          , '-': CS.UnaryNegateOp
          , '!': CS.LogicalNotOp
          , 'not': CS.LogicalNotOp
          , '~': CS.BitNotOp
          , 'do': CS.DoOp
          , 'typeof': CS.TypeofOp
          , 'delete': CS.DeleteOp
          },
      
        postfixConstructorLookup =
          { '?': CS.UnaryExistsOp
          , '[..]': CS.ShallowCopyArray
          , '++': CS.PostIncrementOp
          , '--': CS.PostDecrementOp
          },
      
        foldl = function(fn, memo, list){
          for(var i = 0, l = list.length; i < l; ++i)
            memo = fn(memo, list[i]);
          return memo;
        },
        foldr = function(fn, memo, list){
          for(var i = list.length; i--;)
            memo = fn(memo, list[i]);
          return memo;
        },
      
        // TODO: clean up and use a functional approach; stack === recursion
        foldBinaryExpr = function(parts, ignoreChains) {
          var stack, chainStack, nextPrec, nextOp, className, ctor, prec, rightOperand, leftOperand, operator, i, expr;
          if(parts.length < 3) return parts[0]; // should never happen
          stack = [].slice.call(parts, 0, 3);
          parts = [].slice.call(parts, 3);
      
          while(parts.length > 0) {
            nextOp = parts[0];
      
            if(!ignoreChains && stack.length > 2) {
              operator = stack[stack.length - 2];
              // reduce chained comparisons
              if(chainableComparisonOps.indexOf(operator) >= 0 && chainableComparisonOps.indexOf(nextOp) >= 0) {
                chainStack = stack.slice(-3);
                stack = stack.slice(0, stack.length - 3);
                do {
                  operator = nextOp;
                  chainStack.push(parts.shift(), parts.shift());
                  nextOp = parts[0];
                  if(nextOp) {
                    nextPrec = precedenceTable[nextOp];
                    prec = precedenceTable[operator];
                  }
                // TODO: I would love `a < b is c < d` to instead denote `(a < b) is (c < d)`
                } while(nextOp != null && (nextPrec > prec || chainableComparisonOps.indexOf(nextOp) >= 0));
                stack.push(new CS.ChainedComparisonOp(foldBinaryExpr(chainStack, true)));
                continue;
              }
            }
      
            // reduce
            while(
              stack.length > 2 &&
              (
                operator = stack[stack.length - 2],
                prec = precedenceTable[operator],
                nextPrec = precedenceTable[nextOp],
                nextPrec < prec ||
                chainableComparisonOps.indexOf(operator) >= 0 && chainableComparisonOps.indexOf(nextOp) >= 0 ||
                nextPrec == prec && associativities[operator] === LEFT_ASSOCIATIVE
              )
            ) {
              rightOperand = stack.pop();
              stack.pop(); // operator
              leftOperand = stack.pop();
              stack.push(new constructorLookup[operator](leftOperand, rightOperand));
            }
            // shift
            stack.push(parts.shift()); // operator
            stack.push(parts.shift()); // next operand
          }
      
          // reduce the rest of the stack
          expr = stack.pop();
          while(stack.length > 0)
            expr = new constructorLookup[stack.pop()](stack.pop(), expr);
      
          return expr;
        },
      
        createInterpolation = function(es){
          var init = new CS.String('').g();
          return foldl(function(memo, s){
            if(s instanceof CS.String) {
              var left = memo;
              while(left)
                if(left instanceof CS.String) {
                  if(left === init) {
                    c(left, s);
                    delete left.generated;
                  }
                  left.data = left.data + s.data;
                  return memo;
                } else if(left instanceof CS.ConcatOp) {
                  left = left.right
                } else {
                  break;
                }
            }
            return new CS.ConcatOp(memo, s);
          }, init, es);
        },
      
        createMemberExpression = function(e, accesses){
          return foldl(function(left, access){
            var F = function(){};
            F.prototype = access.op.prototype;
            var o = new F;
            // rather safely assumes access.op is returning non-Object
            access.op.apply(o, [left].concat(access.operands));
            return c(o.r(left.raw + access.raw), access);
          }, e, accesses);
        },
      
        isValidRegExpFlags = function(flags) {
          if(!flags) return true;
          if(flags.length > 4) return false;
          flags.sort();
          var flag = null;
          for(var i = 0, l = flags.length; i < l; ++i)
            if(flag == flags[i]) return false;
            else flag = flags[i];
          return true;
        },
      
        // TODO: refactor this
        stripLeadingWhitespace = function(str){
          str = str.replace(/\s+$/, '');
          var attempt, match, matchStr = str, indent = null;
          while(match = /\n+([^\n\S]*)/.exec(matchStr)) {
            attempt = match[1];
            matchStr = matchStr.slice(match.index + match[0].length);
            if (indent == null || 0 < attempt.length && attempt.length < indent.length)
              indent = attempt;
          }
          if(indent) str = str.replace(new RegExp('\\n' + indent, 'g'), '\n');
          str = str.replace(/^\n/, '');
          return str;
        },
      
        // TODO: remove mutation?
        stripLeadingWhitespaceInterpolation = function(pieces){
          var indent = '', piece, match, i, l;
          for(i = 0, l = pieces.length; i < l; ++i) {
            piece = pieces[i];
            if(piece instanceof CS.String) {
              match = piece.data.match(i < l - 1 ? /\n(\s*)/ : /\n(\s*)[^$\s]/);
              if(!indent && match && match[1].length < indent.length) {
                indent = match[1];
              }
            }
          }
          if(indent) {
            for(i = 0, l = pieces.length; i < l; ++i) {
              piece = pieces[i];
              if(piece instanceof CS.String) {
                piece.data = piece.data.replace(new RegExp('\\n' + indent, 'g'), '\n');
                if(i === l - 1) piece.data = piece.data.replace(/(\n\s*)+$/, '');
                if(i === 0) piece.data = piece.data.replace(/^\n/, '');
              }
            }
          }
          return pieces;
        },
      
        // the identity function
        id = function(x){ return x; },
        // store raw parse information
        r = options.raw ? function(node){
          node.raw = text();
          return node;
        } : id,
        // store position information
        p = options.raw ? function(node){
          node.line = line();
          node.column = column();
          node.offset = offset();
          return node;
        } : id,
        // composition of r and p
        rp = options.raw ? function(node){ return r(p(node)); } : id,
        // copy position information
        c = options.raw ? function(to, from){
          to.line = from.line;
          to.column = from.column;
          to.offset = from.offset;
          return to;
        } : id;
      
      
      
      var result = parseFunctions[startRule]();
      
      /*
       * The parser is now in one of the following three states:
       *
       * 1. The parser successfully parsed the whole input.
       *
       *    - |result !== null|
       *    - |pos === input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 2. The parser successfully parsed only a part of the input.
       *
       *    - |result !== null|
       *    - |pos < input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 3. The parser did not successfully parse any part of the input.
       *
       *   - |result === null|
       *   - |pos === 0|
       *   - |rightmostFailuresExpected| contains at least one failure
       *
       * All code following this comment (including called functions) must
       * handle these states.
       */
      if (result === null || pos !== input.length) {
        reportedPos = Math.max(pos, rightmostFailuresPos);
        var found = reportedPos < input.length ? input.charAt(reportedPos) : null;
        var reportedPosDetails = computeReportedPosDetails();
        
        throw new this.SyntaxError(
          cleanupExpected(rightmostFailuresExpected),
          found,
          reportedPos,
          reportedPosDetails.line,
          reportedPosDetails.column
        );
      }
      
      return result;
    }
  };
  
  /* Thrown when a parser encounters a syntax error. */
  
  result.SyntaxError = function(expected, found, offset, line, column) {
    function buildMessage(expected, found) {
      var expectedHumanized, foundHumanized;
      
      switch (expected.length) {
        case 0:
          expectedHumanized = "end of input";
          break;
        case 1:
          expectedHumanized = expected[0];
          break;
        default:
          expectedHumanized = expected.slice(0, expected.length - 1).join(", ")
            + " or "
            + expected[expected.length - 1];
      }
      
      foundHumanized = found ? quote(found) : "end of input";
      
      return "Expected " + expectedHumanized + " but " + foundHumanized + " found.";
    }
    
    this.name = "SyntaxError";
    this.expected = expected;
    this.found = found;
    this.message = buildMessage(expected, found);
    this.offset = offset;
    this.line = line;
    this.column = column;
  };
  
  subclass(result.SyntaxError, Error);
  
  return result;
})();
