// Generated by CoffeeScript 2.0.0-beta4
var addMultilineHandler, CoffeeScript, merge, nodeREPL, vm;
vm = require('vm');
nodeREPL = require('repl');
CoffeeScript = require('./module');
merge = require('./helpers').merge;
addMultilineHandler = function (repl) {
  var buffer, cache$, continuationPrompt, enabled, initialPrompt, inputStream, nodeLineListener, outputStream, rli;
  cache$ = repl;
  rli = cache$.rli;
  inputStream = cache$.inputStream;
  outputStream = cache$.outputStream;
  initialPrompt = repl.prompt.replace(/^[^> ]*/, function (x) {
    return x.replace(/./g, '-');
  });
  continuationPrompt = repl.prompt.replace(/^[^> ]*>?/, function (x) {
    return x.replace(/./g, '.');
  });
  enabled = false;
  buffer = '';
  nodeLineListener = rli.listeners('line')[0];
  rli.removeListener('line', nodeLineListener);
  rli.on('line', function (cmd) {
    if (enabled) {
      buffer += '' + cmd + '\n';
      rli.setPrompt(continuationPrompt);
      rli.prompt(true);
    } else {
      nodeLineListener(cmd);
    }
  });
  return inputStream.on('keypress', function (char, key) {
    if (!(key && key.ctrl && !key.meta && !key.shift && key.name === 'v'))
      return;
    if (enabled) {
      if (!buffer.match(/\n/)) {
        enabled = !enabled;
        rli.setPrompt(repl.prompt);
        rli.prompt(true);
        return;
      }
      if (null != rli.line && !rli.line.match(/^\s*$/))
        return;
      enabled = !enabled;
      rli.line = '';
      rli.cursor = 0;
      rli.output.cursorTo(0);
      rli.output.clearLine(1);
      buffer = buffer.replace(/\n/g, '\uff00');
      rli.emit('line', buffer);
      buffer = '';
    } else {
      enabled = !enabled;
      rli.setPrompt(initialPrompt);
      rli.prompt(true);
    }
  });
};
module.exports = {
  start: function (opts) {
    var repl;
    if (null == opts)
      opts = {};
    opts.prompt || (opts.prompt = 'coffee> ');
    opts['eval'] || (opts['eval'] = function (input, context, filename, cb) {
      var err, js;
      input = input.replace(/\uFF00/g, '\n');
      input = input.replace(/(^|[\r\n]+)(\s*)##?(?:[^#\r\n][^\r\n]*|)($|[\r\n])/, '$1$2$3');
      if (/^(\s*|\(\s*\))$/.test(input))
        return cb(null);
      try {
        js = CoffeeScript.cs2js('_=(' + input + '\n)', {
          filename: filename,
          bare: true
        });
        return cb(null, vm.runInContext(js, context, filename));
      } catch (e$) {
        err = e$;
        return cb('\x1b[0;31m' + err.constructor.name + ': ' + err.message + '\x1b[0m');
      }
    });
    repl = nodeREPL.start(opts);
    repl.on('exit', function () {
      return repl.outputStream.write('\n');
    });
    addMultilineHandler(repl);
    return repl;
  }
};
