// Generated by CoffeeScript 1.3.3
(function() {
  var __hasProp = {}.hasOwnProperty,
    __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(exports) {
    var TAB, clone, eq, formatInterpolation, formatStringData, generate, indent, levels, needsParensWhenOnLeft, operators, parens, precedence;
    TAB = '  ';
    indent = function(code) {
      var line;
      return ((function() {
        var _i, _len, _ref, _results;
        _ref = code.split('\n');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          line = _ref[_i];
          _results.push("" + TAB + line);
        }
        return _results;
      })()).join('\n');
    };
    parens = function(code) {
      return "(" + code + ")";
    };
    formatStringData = function(data) {
      return data.replace(/[^\x20-\x7e]|['\\]/, function(c) {
        var escape, pad;
        switch (c) {
          case '\0':
            return '\\0';
          case '\b':
            return '\\b';
          case '\t':
            return '\\t';
          case '\n':
            return '\\n';
          case '\f':
            return '\\f';
          case '\r':
            return '\\r';
          case '\'':
            return '\\\'';
          case '\\':
            return '\\\\';
          default:
            escape = (c.charCodeAt(0)).toString(16);
            pad = "0000".slice(escape.length);
            return "\\u" + pad + escape;
        }
      });
    };
    formatInterpolation = function(ast, options) {
      var left, right;
      switch (ast.className) {
        case "ConcatOp":
          left = formatInterpolation(ast.left, options);
          right = formatInterpolation(ast.right, options);
          return "" + left + right;
        case "String":
          return formatStringData(ast.data);
        default:
          return "\#{" + (generate(ast, options)) + "}";
      }
    };
    needsParensWhenOnLeft = function(ast) {
      switch (ast.className) {
        case 'Function':
        case 'BoundFunction':
        case 'NewOp':
          return true;
        case 'Conditional':
        case 'Switch':
        case 'While':
        case 'Block':
          return true;
        case 'PreIncrementOp':
        case 'PreDecrementOp':
        case 'UnaryPlusOp':
        case 'UnaryNegateOp':
        case 'LogicalNotOp':
        case 'BitNotOp':
        case 'DoOp':
        case 'TypeofOp':
        case 'DeleteOp':
          return needsParensWhenOnLeft(ast.expression);
        case 'FunctionApplication':
          return ast["arguments"].length > 0;
        default:
          return false;
      }
    };
    eq = function(nodeA, nodeB) {
      var i, prop, v, val, _i, _len;
      for (prop in nodeA) {
        if (!__hasProp.call(nodeA, prop)) continue;
        val = nodeA[prop];
        if (prop === 'raw' || prop === 'line' || prop === 'column') {
          continue;
        }
        switch (Object.prototype.toString.call(val)) {
          case '[object Object]':
            if (!eq(nodeB[prop], val)) {
              return false;
            }
            break;
          case '[object Array]':
            for (i = _i = 0, _len = val.length; _i < _len; i = ++_i) {
              v = val[i];
              if (!eq(nodeB[prop][i], v)) {
                return false;
              }
            }
            break;
          default:
            if (nodeB[prop] !== val) {
              return false;
            }
        }
      }
      return true;
    };
    clone = function(obj, overrides) {
      var newObj, prop, val;
      if (overrides == null) {
        overrides = {};
      }
      newObj = {};
      for (prop in obj) {
        if (!__hasProp.call(obj, prop)) continue;
        val = obj[prop];
        newObj[prop] = val;
      }
      for (prop in overrides) {
        if (!__hasProp.call(overrides, prop)) continue;
        val = overrides[prop];
        newObj[prop] = val;
      }
      return newObj;
    };
    levels = [['SeqOp'], ['Conditional', 'ForIn', 'ForOf', 'While'], ['FunctionApplication', 'SoakedFunctionApplication'], ['AssignOp', 'CompoundAssignOp', 'ExistsAssignOp'], ['LogicalOrOp'], ['LogicalAndOp'], ['BitOrOp'], ['BitXorOp'], ['BitAndOp'], ['ExistsOp'], ['EQOp', 'NEQOp'], ['LTOp', 'LTEOp', 'GTOp', 'GTEOp', 'InOp', 'OfOp', 'InstanceofOp'], ['LeftShiftOp', 'SignedRightShiftOp', 'UnsignedRightShiftOp'], ['PlusOp', 'SubtractOp'], ['MultiplyOp', 'DivideOp', 'RemOp'], ['UnaryPlusOp', 'UnaryNegateOp', 'LogicalNotOp', 'BitNotOp', 'DoOp', 'TypeofOp', 'PreIncrementOp', 'PreDecrementOp', 'DeleteOp'], ['UnaryExistsOp', 'ShallowCopyArray', 'PostIncrementOp', 'PostDecrementOp', 'Spread'], ['NewOp'], ['MemberAccessOp', 'SoakedMemberAccessOp', 'DynamicMemberAccessOp', 'SoakedDynamicMemberAccessOp', 'ProtoMemberAccessOp', 'DynamicProtoMemberAccessOp', 'SoakedProtoMemberAccessOp', 'SoakedDynamicProtoMemberAccessOp']];
    precedence = {};
    (function() {
      var level, op, ops, _i, _len, _results;
      _results = [];
      for (level = _i = 0, _len = levels.length; _i < _len; level = ++_i) {
        ops = levels[level];
        _results.push((function() {
          var _j, _len1, _results1;
          _results1 = [];
          for (_j = 0, _len1 = ops.length; _j < _len1; _j++) {
            op = ops[_j];
            _results1.push(precedence[op] = level);
          }
          return _results1;
        })());
      }
      return _results;
    })();
    operators = {
      SeqOp: ';',
      LogicalOrOp: 'or',
      LogicalAndOp: 'and',
      BitOrOp: '|',
      BitXorOp: '^',
      BitAndOp: '&',
      EQOp: 'is',
      NEQOp: 'isnt',
      LTOp: '<',
      LTEOp: '<=',
      GTOp: '>',
      GTEOp: '>=',
      InOp: 'in',
      OfOp: 'of',
      InstanceofOp: 'instanceof',
      LeftShiftOp: '<<',
      SignedRightShiftOp: '>>',
      UnsignedRightShiftOp: '>>>',
      PlusOp: '+',
      SubtractOp: '-',
      MultiplyOp: '*',
      DivideOp: '/',
      RemOp: '%',
      UnaryPlusOp: '+',
      UnaryNegateOp: '-',
      LogicalNotOp: 'not ',
      BitNotOp: '~',
      DoOp: 'do ',
      NewOp: 'new ',
      TypeofOp: 'typeof ',
      PreIncrementOp: '++',
      PreDecrementOp: '--',
      UnaryExistsOp: '?',
      ShallowCopyArray: '[..]',
      PostIncrementOp: '++',
      PostDecrementOp: '--',
      Spread: '...',
      FunctionApplication: '',
      SoakedFunctionApplication: '?',
      MemberAccessOp: '.',
      SoakedMemberAccessOp: '?.',
      ProtoMemberAccessOp: '::',
      SoakedProtoMemberAccessOp: '?::',
      DynamicMemberAccessOp: '',
      SoakedDynamicMemberAccessOp: '?',
      DynamicProtoMemberAccessOp: '::',
      SoakedDynamicProtoMemberAccessOp: '?::'
    };
    return exports.generate = generate = function(ast, options) {
      var a, absNum, arg, args, expression_, hasAlternate, i, isMultiline, key_, m, memberAccessOps, members_, needsParens, p, parameters, parent, parentClassName, prec, s, sep, src, usedAsExpression, _alternate, _argList, _args, _assignee, _block, _body, _consequent, _ctor, _expr, _fn, _indexingExpr, _left, _op, _paramList, _ref, _ref1, _right;
      if (options == null) {
        options = {};
      }
      needsParens = false;
      if ((_ref = options.precedence) == null) {
        options.precedence = 0;
      }
      if ((_ref1 = options.ancestors) == null) {
        options.ancestors = [];
      }
      parent = options.ancestors[0];
      parentClassName = parent != null ? parent.className : void 0;
      usedAsExpression = (parent != null) && parentClassName !== 'Block';
      src = (function() {
        var _i, _len, _ref2, _ref3, _ref4, _ref5, _ref6;
        switch (ast.className) {
          case 'Program':
            options.ancestors = [ast].concat(__slice.call(options.ancestors));
            if (ast.body != null) {
              return generate(ast.body, options);
            } else {
              return '';
            }
            break;
          case 'Block':
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: 0
            });
            if (ast.statements.length === 0) {
              return generate((new Undefined).g(), options);
            } else {
              sep = parentClassName === 'Program' ? '\n\n' : '\n';
              return ((function() {
                var _i, _len, _ref2, _results;
                _ref2 = ast.statements;
                _results = [];
                for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
                  s = _ref2[_i];
                  _results.push(generate(s, options));
                }
                return _results;
              })()).join(sep);
            }
            break;
          case 'Conditional':
            options.ancestors.unshift(ast);
            options.precedence = 0;
            hasAlternate = (ast.consequent != null) && (ast.alternate != null);
            _consequent = generate((_ref2 = ast.consequent) != null ? _ref2 : (new Undefined).g(), options);
            _alternate = hasAlternate ? generate(ast.alternate, options) : "";
            isMultiline = _consequent.length > 90 || _alternate.length > 90 || __indexOf.call(_alternate, '\n') >= 0 || __indexOf.call(_consequent, '\n') >= 0;
            _consequent = isMultiline ? "\n" + (indent(_consequent)) : " then " + _consequent;
            if (hasAlternate) {
              _alternate = isMultiline ? "\nelse\n" + (indent(_alternate)) : " else " + _alternate;
            }
            return "if " + (generate(ast.condition, options)) + _consequent + _alternate;
          case 'Identifier':
            return ast.data;
          case 'Null':
            return 'null';
          case 'This':
            return 'this';
          case 'Undefined':
            return 'undefined';
          case 'Int':
            absNum = ast.data < 0 ? -ast.data : ast.data;
            if (absNum >= 1e12 || (absNum >= 0x10 && 0 === (absNum & (absNum - 1)))) {
              return "0x" + (ast.data.toString(16));
            } else {
              return ast.data.toString(10);
            }
            break;
          case 'Float':
            return ast.data.toString(10);
          case 'String':
            return "'" + (formatStringData(ast.data)) + "'";
          case 'ArrayInitialiser':
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: precedence.AssignmentExpression
            });
            members_ = (function() {
              var _i, _len, _ref3, _results;
              _ref3 = ast.members;
              _results = [];
              for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                m = _ref3[_i];
                _results.push(generate(m, options));
              }
              return _results;
            })();
            switch (ast.members.length) {
              case 0:
                return '[]';
              case 1:
              case 2:
                for (i = _i = 0, _len = members_.length; _i < _len; i = ++_i) {
                  m = members_[i];
                  if (i + 1 !== members_.length) {
                    if (needsParensWhenOnLeft(ast.members[i])) {
                      members_[i] = parens(m);
                    }
                  }
                }
                return "[" + (members_.join(', ')) + "]";
              default:
                return "[\n" + (indent(members_.join('\n'))) + "\n]";
            }
            break;
          case 'ObjectInitialiser':
            options.ancestors = [ast].concat(__slice.call(options.ancestors));
            members_ = (function() {
              var _j, _len1, _ref3, _results;
              _ref3 = ast.members;
              _results = [];
              for (_j = 0, _len1 = _ref3.length; _j < _len1; _j++) {
                m = _ref3[_j];
                _results.push(generate(m, options));
              }
              return _results;
            })();
            switch (ast.members.length) {
              case 0:
                return '{}';
              case 1:
                return "{" + (members_.join(', ')) + "}";
              default:
                return "{\n" + (indent(members_.join('\n'))) + "\n}";
            }
            break;
          case 'ObjectInitialiserMember':
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: precedence.AssignmentExpression
            });
            key_ = generate(ast.key, options);
            expression_ = generate(ast.expression, options);
            memberAccessOps = ['MemberAccessOp', 'ProtoMemberAccessOp', 'SoakedMemberAccessOp', 'SoakedProtoMemberAccessOp'];
            if (eq(ast.key, ast.expression)) {
              return "" + key_;
            } else if ((_ref3 = ast.expression.className, __indexOf.call(memberAccessOps, _ref3) >= 0) && ast.key.data === ast.expression.memberName) {
              return "" + expression_;
            } else {
              return "" + key_ + ": " + expression_;
            }
            break;
          case 'Function':
          case 'BoundFunction':
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: precedence.AssignmentExpression
            });
            parameters = (function() {
              var _j, _len1, _ref4, _results;
              _ref4 = ast.parameters;
              _results = [];
              for (_j = 0, _len1 = _ref4.length; _j < _len1; _j++) {
                p = _ref4[_j];
                _results.push(generate(p, options));
              }
              return _results;
            })();
            options.precedence = 0;
            _body = !(ast.body != null) || ast.body.className === 'Undefined' ? '' : generate(ast.body, options);
            _paramList = ast.parameters.length > 0 ? "(" + (parameters.join(', ')) + ") " : '';
            _block = _body.length === 0 ? '' : _paramList.length + _body.length < 100 && __indexOf.call(_body, '\n') < 0 ? " " + _body : "\n" + (indent(_body));
            switch (ast.className) {
              case 'Function':
                return "" + _paramList + "->" + _block;
              case 'BoundFunction':
                return "" + _paramList + "=>" + _block;
            }
            break;
          case 'AssignOp':
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _assignee = generate(ast.assignee, options);
            _expr = generate(ast.expression, options);
            return "" + _assignee + " = " + _expr;
          case 'CompoundAssignOp':
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _op = operators[ast.op.prototype.className];
            _assignee = generate(ast.assignee, options);
            _expr = generate(ast.expression, options);
            return "" + _assignee + " " + _op + "= " + _expr;
          case 'SeqOp':
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _left = generate(ast.left, options);
            _right = generate(ast.right, options);
            return "" + _left + "; " + _right;
          case 'LogicalOrOp':
          case 'LogicalAndOp':
          case 'BitOrOp':
          case 'BitXorOp':
          case 'BitAndOp':
          case 'LeftShiftOp':
          case 'SignedRightShiftOp':
          case 'UnsignedRightShiftOp':
          case 'EQOp':
          case 'NEQOp':
          case 'LTOp':
          case 'LTEOp':
          case 'GTOp':
          case 'GTEOp':
          case 'InOp':
          case 'OfOp':
          case 'InstanceofOp':
          case 'PlusOp':
          case 'SubtractOp':
          case 'MultiplyOp':
          case 'DivideOp':
          case 'RemOp':
          case 'ExistsOp':
            _op = operators[ast.className];
            if (((_ref4 = ast.className) === 'InOp' || _ref4 === 'OfOp' || _ref4 === 'InstanceofOp') && parentClassName === 'LogicalNotOp') {
              _op = "not " + _op;
            }
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _left = generate(ast.left, options);
            if (needsParensWhenOnLeft(ast.left)) {
              _left = parens(_left);
            }
            _right = generate(ast.right, options);
            return "" + _left + " " + _op + " " + _right;
          case 'UnaryPlusOp':
          case 'UnaryNegateOp':
          case 'LogicalNotOp':
          case 'BitNotOp':
          case 'DoOp':
          case 'TypeofOp':
          case 'PreIncrementOp':
          case 'PreDecrementOp':
            _op = operators[ast.className];
            prec = precedence[ast.className];
            if (ast.className === 'LogicalNotOp') {
              if ((_ref5 = ast.expression.className) === 'InOp' || _ref5 === 'OfOp' || _ref5 === 'InstanceofOp') {
                _op = '';
                prec = precedence[ast.expression.className];
              }
              if ('LogicalNotOp' === parentClassName || 'LogicalNotOp' === ast.expression.className) {
                _op = '!';
              }
            }
            needsParens = prec < options.precedence;
            if (parentClassName === ast.className && ((_ref6 = ast.className) === 'UnaryPlusOp' || _ref6 === 'UnaryNegateOp')) {
              needsParens = true;
            }
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            return "" + _op + (generate(ast.expression, options));
          case 'UnaryExistsOp':
          case 'PostIncrementOp':
          case 'PostDecrementOp':
          case 'Spread':
            _op = operators[ast.className];
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _expr = generate(ast.expression, options);
            if (needsParensWhenOnLeft(ast.expression)) {
              _expr = parens(_expr);
            }
            return "" + _expr + _op;
          case 'NewOp':
            _op = operators[ast.className];
            prec = precedence[ast.className];
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            _ctor = generate(ast.ctor, options);
            if (ast["arguments"].length > 0 && needsParensWhenOnLeft(ast.ctor)) {
              _ctor = parens(_ctor);
            }
            options.precedence = precedence['AssignOp'];
            args = (function() {
              var _j, _len1, _ref7, _results;
              _ref7 = ast["arguments"];
              _results = [];
              for (i = _j = 0, _len1 = _ref7.length; _j < _len1; i = ++_j) {
                a = _ref7[i];
                arg = generate(a, options);
                if ((needsParensWhenOnLeft(a)) && i + 1 !== ast["arguments"].length) {
                  arg = parens(arg);
                }
                _results.push(arg);
              }
              return _results;
            })();
            _args = ast["arguments"].length === 0 ? '' : " " + (args.join(', '));
            return "" + _op + _ctor + _args;
          case 'FunctionApplication':
          case 'SoakedFunctionApplication':
            if (ast.className === 'FunctionApplication' && ast["arguments"].length === 0 && !usedAsExpression) {
              return generate(new DoOp(ast["function"]), options);
            } else {
              options = clone(options, {
                ancestors: [ast].concat(__slice.call(options.ancestors)),
                precedence: precedence[ast.className]
              });
              _op = operators[ast.className];
              _fn = generate(ast["function"], options);
              if (needsParensWhenOnLeft(ast["function"])) {
                _fn = parens(_fn);
              }
              args = (function() {
                var _j, _len1, _ref7, _results;
                _ref7 = ast["arguments"];
                _results = [];
                for (i = _j = 0, _len1 = _ref7.length; _j < _len1; i = ++_j) {
                  a = _ref7[i];
                  arg = generate(a, options);
                  if ((needsParensWhenOnLeft(a)) && i + 1 !== ast["arguments"].length) {
                    arg = parens(arg);
                  }
                  _results.push(arg);
                }
                return _results;
              })();
              _argList = ast["arguments"].length === 0 ? '()' : " " + (args.join(', '));
              return "" + _fn + _op + _argList;
            }
            break;
          case 'MemberAccessOp':
          case 'SoakedMemberAccessOp':
          case 'ProtoMemberAccessOp':
          case 'SoakedProtoMemberAccessOp':
            _op = operators[ast.className];
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            if (ast.expression.className === 'This') {
              _expr = '@';
              if (ast.className === 'MemberAccessOp') {
                _op = '';
              }
            } else {
              _expr = generate(ast.expression, options);
              if (needsParensWhenOnLeft(ast.expression)) {
                _expr = parens(_expr);
              }
            }
            return "" + _expr + _op + ast.memberName;
          case 'DynamicMemberAccessOp':
          case 'SoakedDynamicMemberAccessOp':
          case 'DynamicProtoMemberAccessOp':
          case 'SoakedDynamicProtoMemberAccessOp':
            _op = operators[ast.className];
            prec = precedence[ast.className];
            needsParens = prec < options.precedence;
            options = clone(options, {
              ancestors: [ast].concat(__slice.call(options.ancestors)),
              precedence: prec
            });
            if (ast.expression.className === 'This') {
              _expr = '@';
            } else {
              _expr = generate(ast.expression, options);
              if (needsParensWhenOnLeft(ast.expression)) {
                _expr = parens(_expr);
              }
            }
            options.precedence = 0;
            _indexingExpr = generate(ast.indexingExpr, options);
            return "" + _expr + _op + "[" + _indexingExpr + "]";
          case 'ConcatOp':
            _left = formatInterpolation(ast.left, options);
            _right = formatInterpolation(ast.right, options);
            return "\"" + _left + _right + "\"";
          default:
            throw new Error("Non-exhaustive patterns in case: " + ast.className);
        }
      })();
      if (needsParens) {
        return parens(src);
      } else {
        return src;
      }
    };
  })(typeof exports !== "undefined" && exports !== null ? exports : this.cscodegen = {});

}).call(this);
