// Generated by CoffeeScript 2.0.0-beta5
void function () {
  var addAliases, formatOptions, Jedediah, ListParameter, MAX_WIDTH, Option, Parameter, wrap;
  MAX_WIDTH = 85;
  wrap = function (lhsWidth, input) {
    var pad, rhsWidth, rows;
    rhsWidth = MAX_WIDTH - lhsWidth;
    pad = Array(lhsWidth + 4 + 1).join(' ');
    rows = function (accum$) {
      var row;
      while (input.length) {
        row = input.slice(0, rhsWidth);
        input = input.slice(rhsWidth);
        accum$.push(row);
      }
      return accum$;
    }.call(this, []);
    return rows.join('\n' + pad);
  };
  formatOptions = function (opts) {
    opts = function (accum$) {
      var opt;
      for (var i$ = 0, length$ = opts.length; i$ < length$; ++i$) {
        opt = opts[i$];
        if (!opt.length)
          continue;
        accum$.push(opt.length === 1 ? '-' + opt : '--' + opt);
      }
      return accum$;
    }.call(this, []);
    opts.sort(function (a, b) {
      return a.length - b.length;
    });
    return opts.join(', ');
  };
  addAliases = function (name, aliases, aliasMap, shortList, longList) {
    return function (accum$) {
      var alias;
      for (var cache$ = [name].concat([].slice.call(aliases)), i$ = 0, length$ = cache$.length; i$ < length$; ++i$) {
        alias = cache$[i$];
        aliasMap[alias] = name;
        accum$.push(alias.length === 1 ? shortList.push(alias) : alias.length > 1 ? longList.push(alias) : void 0);
      }
      return accum$;
    }.call(this, []);
  };
  Option = function () {
    function Option(param$, param$1, param$2, param$3) {
      this.name = param$;
      this.aliases = param$1;
      this['default'] = param$2;
      this.description = param$3;
    }
    return Option;
  }();
  Parameter = function () {
    function Parameter(param$, param$1, param$2, param$3) {
      this.name = param$;
      this.aliases = param$1;
      this.placeholder = param$2;
      this.description = param$3;
    }
    Parameter.prototype['default'] = function () {
      return null;
    };
    return Parameter;
  }();
  ListParameter = function () {
    function ListParameter(param$, param$1, param$2, param$3) {
      this.name = param$;
      this.aliases = param$1;
      this.placeholder = param$2;
      this.description = param$3;
    }
    ListParameter.prototype['default'] = function () {
      return [];
    };
    return ListParameter;
  }();
  module.exports = Jedediah = function () {
    Jedediah.Jedediah = Jedediah;
    function Jedediah() {
      this.options = {};
      this.parameters = {};
      this.aliasMap = {};
      this.shortOptionArguments = [];
      this.longOptionArguments = [];
      this.shortParameterArguments = [];
      this.longParameterArguments = [];
    }
    Jedediah.prototype.addOption = function (name, default_, description) {
      var aliases, numArgs$;
      if ((numArgs$ = arguments.length) > 3) {
        aliases = [].slice.call(arguments, 1, numArgs$ - 2);
        default_ = arguments[numArgs$ - 2];
        description = arguments[numArgs$ - 1];
      } else {
        aliases = [];
      }
      this.options[name] = new Option(name, aliases, function () {
        return default_;
      }, description);
      return addAliases(name, aliases, this.aliasMap, this.shortOptionArguments, this.longOptionArguments);
    };
    Jedediah.prototype.addParameter = function (name, placeholder, description) {
      var aliases, numArgs$;
      if ((numArgs$ = arguments.length) > 3) {
        aliases = [].slice.call(arguments, 1, numArgs$ - 2);
        placeholder = arguments[numArgs$ - 2];
        description = arguments[numArgs$ - 1];
      } else {
        aliases = [];
      }
      this.parameters[name] = new Parameter(name, aliases, placeholder, description);
      return addAliases(name, aliases, this.aliasMap, this.shortParameterArguments, this.longParameterArguments);
    };
    Jedediah.prototype.addListParameter = function (name, placeholder, description) {
      var aliases, numArgs$;
      if ((numArgs$ = arguments.length) > 3) {
        aliases = [].slice.call(arguments, 1, numArgs$ - 2);
        placeholder = arguments[numArgs$ - 2];
        description = arguments[numArgs$ - 1];
      } else {
        aliases = [];
      }
      this.parameters[name] = new ListParameter(name, aliases, placeholder, description);
      return addAliases(name, aliases, this.aliasMap, this.shortParameterArguments, this.longParameterArguments);
    };
    Jedediah.prototype.addAlias = function () {
    };
    Jedediah.prototype.getDefaults = function () {
      var k, o, obj;
      obj = {};
      for (k in this.options) {
        if (!isOwn$(this.options, k))
          continue;
        o = this.options[k];
        obj[k] = o['default']();
      }
      for (k in this.parameters) {
        if (!isOwn$(this.parameters, k))
          continue;
        o = this.parameters[k];
        obj[k] = o['default']();
      }
      return obj;
    };
    Jedediah.prototype.parse = function (argv) {
      var additionalArgs, arg, args, cache$1, match, o, options, positionalArgs, reLongOption, reLongParameter, reShortOptions, reShortOptionsShortParameter, reShortParameter;
      args = argv.slice(1 + (argv[0] === 'node'));
      additionalArgs = [];
      if (in$('--', args))
        additionalArgs = args.splice(args.indexOf('--'), 9e9).slice(1);
      reShortOptions = new RegExp('^-(' + this.shortOptionArguments.join('|') + ')+$');
      reLongOption = new RegExp('^--(no-)?(' + this.longOptionArguments.join('|') + ')$');
      reShortParameter = new RegExp('^-(' + this.shortParameterArguments.join('|') + ')$');
      reLongParameter = new RegExp('^--(' + this.longParameterArguments.join('|') + ')$');
      reShortOptionsShortParameter = new RegExp('^-(' + this.shortOptionArguments.join('|') + ')+(' + this.shortParameterArguments.join('|') + ')$');
      options = this.getDefaults();
      positionalArgs = [];
      while (args.length) {
        arg = args.shift();
        if (this.shortParameterArguments.length && reShortOptionsShortParameter.exec(arg)) {
          args.unshift('-' + arg.slice(1, -1), '-' + arg.slice(-1));
        } else if (reShortOptions.exec(arg)) {
          for (var cache$ = arg.slice(1).split(''), i$ = 0, length$ = cache$.length; i$ < length$; ++i$) {
            o = cache$[i$];
            options[this.aliasMap[o]] = true;
          }
        } else if (match = reLongOption.exec(arg)) {
          options[this.aliasMap[match[2]]] = null != match[1] ? false : true;
        } else if (match = (cache$1 = reShortParameter.exec(arg), null != cache$1 ? cache$1 : reLongParameter.exec(arg))) {
          if (this.parameters[this.aliasMap[match[1]]] instanceof ListParameter) {
            options[this.aliasMap[match[1]]].push(args.shift());
          } else {
            options[this.aliasMap[match[1]]] = args.shift();
          }
        } else if (match = /^(-.|--.*)$/.exec(arg)) {
          throw new Error("Unrecognised option '" + match[0].replace(/'/g, "\\'") + "'");
        } else {
          positionalArgs.push(arg);
        }
      }
      positionalArgs = positionalArgs.concat(additionalArgs);
      return [
        options,
        positionalArgs
      ];
    };
    Jedediah.prototype.help = function () {
      var formattedRows, leftColumnWidth, optionRows, parameterRows, rows;
      optionRows = function (accum$) {
        var name, opt;
        for (name in this.options) {
          if (!isOwn$(this.options, name))
            continue;
          opt = this.options[name];
          accum$.push([
            formatOptions([opt.name].concat(opt.aliases)),
            opt.description
          ]);
        }
        return accum$;
      }.call(this, []);
      parameterRows = function (accum$) {
        var name, opt;
        for (name in this.parameters) {
          if (!isOwn$(this.parameters, name))
            continue;
          opt = this.parameters[name];
          accum$.push([
            '' + formatOptions([opt.name].concat(opt.aliases)) + ' ' + opt.placeholder,
            opt.description
          ]);
        }
        return accum$;
      }.call(this, []);
      leftColumnWidth = [].slice.call(optionRows).concat([].slice.call(parameterRows)).reduce(function (memo, opt) {
        return Math.max(memo, opt[0].length);
      }, 0);
      rows = [].slice.call(optionRows).concat([].slice.call(parameterRows));
      rows.sort(function (a, b) {
        a = a[0];
        b = b[0];
        if (a.slice(0, +1 + 1 || 9e9) === '--' && b.slice(0, +1 + 1 || 9e9) !== '--')
          return 1;
        if (b.slice(0, +1 + 1 || 9e9) === '--' && a.slice(0, +1 + 1 || 9e9) !== '--')
          return -1;
        if (a.toLowerCase() < b.toLowerCase()) {
          return -1;
        } else {
          return 1;
        }
      });
      formattedRows = function (accum$) {
        var row;
        for (var i$ = 0, length$ = rows.length; i$ < length$; ++i$) {
          row = rows[i$];
          accum$.push('  ' + row[0] + Array(leftColumnWidth - row[0].length + 1).join(' ') + '  ' + wrap(leftColumnWidth, row[1]));
        }
        return accum$;
      }.call(this, []);
      return formattedRows.join('\n');
    };
    return Jedediah;
  }();
  function isOwn$(o, p) {
    return {}.hasOwnProperty.call(o, p);
  }
  function in$(member, list) {
    for (var i = 0, length = list.length; i < length; ++i)
      if (i in list && list[i] === member)
        return true;
    return false;
  }
}.call(this);
