/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

class httpRequestHandler
implements Runnable {
    static final String CRLF = "\r\n";
    Socket socket;
    InputStream input;
    OutputStream output;
    String documentRoot;
    BufferedReader br;

    public httpRequestHandler(Socket socket, String httpRoot) throws Exception {
        this.socket = socket;
        this.documentRoot = httpRoot;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    @Override
    public void run() {
        try {
            this.processRequest();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void processRequest() throws Exception {
        String headerLine;
        while (!(headerLine = this.br.readLine()).equals(CRLF) && !headerLine.equals("")) {
            StringTokenizer s = new StringTokenizer(headerLine);
            String temp = s.nextToken();
            if (!temp.equals("GET")) continue;
            String ofileName = s.nextToken();
            String fileName = String.valueOf(this.documentRoot) + ofileName.replaceAll("%20", " ");
            fileName = fileName.replaceFirst("\\?.*$", "");
            FileInputStream fis = null;
            boolean fileExists = true;
            File fs = new File(fileName);
            try {
                fis = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                fileExists = false;
            }
            String directoryContent = null;
            if (!fileExists && fs.isDirectory()) {
                File[] list = fs.listFiles();
                directoryContent = "";
                int i = 0;
                while (i < list.length) {
                    directoryContent = String.valueOf(directoryContent) + "<li><a href='" + (ofileName.length() == 1 ? ofileName : String.valueOf(ofileName) + "/") + list[i].getName() + "'>" + list[i].getName() + "</a></li>";
                    ++i;
                }
                directoryContent = "<html><head></head><body><ul>" + directoryContent + "</ul></body></html>";
            }
            String serverLine = "Server: Simple Java Http Server\r\n";
            String statusLine = null;
            String contentTypeLine = null;
            String entityBody = null;
            String contentLengthLine = "error";
            if (fileExists) {
                statusLine = "HTTP/1.0 200 OK\r\n";
                String contentType = httpRequestHandler.contentType(fileName);
                if (contentType != null) {
                    contentTypeLine = "Content-type: " + contentType + CRLF;
                }
                contentLengthLine = "Content-Length: " + new Integer(fis.available()).toString() + CRLF;
            } else if (fs.isDirectory()) {
                contentTypeLine = "Content-type: text/html\r\n";
                contentLengthLine = "Content-Length: " + directoryContent.length() + CRLF;
                statusLine = "HTTP/1.0 200 OK\r\n";
            } else {
                statusLine = "HTTP/1.0 404 Not Found\r\n";
                contentTypeLine = "text/html";
                entityBody = "<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY>404 Not Found<br>usage:http://yourHostName:port/fileName.html</BODY></HTML>";
            }
            this.output.write(statusLine.getBytes());
            this.output.write(serverLine.getBytes());
            if (contentTypeLine != null) {
                this.output.write(contentTypeLine.getBytes());
            }
            this.output.write(contentLengthLine.getBytes());
            this.output.write(CRLF.getBytes());
            if (fileExists) {
                httpRequestHandler.sendBytes(fis, this.output);
                fis.close();
                continue;
            }
            if (fs.isDirectory()) {
                httpRequestHandler.sendBytes(directoryContent, this.output);
                continue;
            }
            this.output.write(entityBody.getBytes());
        }
        try {
            this.output.close();
            this.br.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendBytes(FileInputStream fis, OutputStream os) throws Exception {
        byte[] buffer = new byte[1024];
        int bytes = 0;
        while ((bytes = fis.read(buffer)) != -1) {
            os.write(buffer, 0, bytes);
        }
    }

    private static void sendBytes(String content, OutputStream os) throws Exception {
        os.write(content.getBytes(), 0, content.length());
    }

    private static String contentType(String fileName) {
        if (fileName.endsWith(".htm") || fileName.endsWith(".html") || fileName.endsWith(".txt") || fileName.endsWith(".xml")) {
            return "text/html";
        }
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".css")) {
            return "text/css";
        }
        if (fileName.endsWith(".js")) {
            return "text/javascript";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        return null;
    }
}

