// Generated by CoffeeScript 2.0.0-beta4
var CoffeeScript, Compiler, cscodegen, escodegen, escodegenCompactDefaults, escodegenFormatDefaults, formatParserError, noBrowserifyRequire, Nodes, Optimiser, Parser, pkg, Preprocessor;
formatParserError = require('./helpers').formatParserError;
Nodes = require('./nodes');
Preprocessor = require('./preprocessor').Preprocessor;
Parser = require('./parser');
Optimiser = require('./optimiser').Optimiser;
Compiler = require('./compiler').Compiler;
cscodegen = function () {
  try {
    return require('cscodegen');
  } catch (e$) {
    return;
  }
}.call(this);
escodegen = function () {
  try {
    return require('escodegen');
  } catch (e$) {
    return;
  }
}.call(this);
pkg = require('./../../package.json');
escodegenFormatDefaults = {
  indent: {
    style: '  ',
    base: 0
  },
  renumber: true,
  hexadecimal: true,
  quotes: 'auto',
  parentheses: false
};
escodegenCompactDefaults = {
  indent: {
    style: '',
    base: 0
  },
  renumber: true,
  hexadecimal: true,
  quotes: 'auto',
  escapeless: true,
  compact: true,
  parentheses: false,
  semicolons: false
};
module.exports = {
  Compiler: Compiler,
  Optimiser: Optimiser,
  Parser: Parser,
  Preprocessor: Preprocessor,
  Nodes: Nodes,
  VERSION: pkg.version,
  parse: function (coffee, options) {
    var e, parsed, preprocessed;
    if (null == options)
      options = {};
    try {
      preprocessed = Preprocessor.processSync(coffee);
      parsed = Parser.parse(preprocessed, {
        raw: options.raw,
        inputSource: options.inputSource
      });
      if (options.optimise) {
        return Optimiser.optimise(parsed);
      } else {
        return parsed;
      }
    } catch (e$) {
      e = e$;
      if (!(e instanceof Parser.SyntaxError))
        throw e;
      throw new Error(formatParserError(preprocessed, e));
    }
  },
  compile: function (csAst, options) {
    return Compiler.compile(csAst, options).toBasicObject();
  },
  cs: function (csAst, options) {
  },
  jsWithSourceMap: function (jsAst, name, options) {
    if (null == name)
      name = 'unknown';
    if (null == options)
      options = {};
    if (!(null != escodegen))
      throw new Error('escodegen not found: run `npm install escodegen`');
    if (!{}.hasOwnProperty.call(jsAst, 'type'))
      jsAst = jsAst.toBasicObject();
    return escodegen.generate(jsAst, {
      comment: !options.compact,
      sourceMapWithCode: true,
      sourceMap: name,
      format: options.compact ? escodegenCompactDefaults : null != options.format ? options.format : escodegenFormatDefaults
    });
  },
  js: function (jsAst, options) {
    return this.jsWithSourceMap(jsAst, null, options).code;
  },
  sourceMap: function (jsAst, name, options) {
    return this.jsWithSourceMap(jsAst, name, options).map;
  },
  cs2js: function (input, options) {
    var csAST, jsAST;
    if (null == options)
      options = {};
    if (null != options.optimise)
      options.optimise;
    else
      options.optimise = true;
    csAST = CoffeeScript.parse(input, options);
    jsAST = CoffeeScript.compile(csAST, { bare: options.bare });
    return CoffeeScript.js(jsAST, { compact: options.compact || options.minify });
  }
};
CoffeeScript = module.exports.CoffeeScript = module.exports;
if (process.title === 'node') {
  noBrowserifyRequire = require;
  noBrowserifyRequire('./run');
}
