'use strict';

const requestHandler = require('./requestHandler');

/**
 * Sends a properly configured and process output to the back-end
 * vendor. Currently, this is just forwarded to the appropriate handler
 * defined by "requestHandler"
 */
exports.send = (context, output) => {
  // console.log("backend sending", JSON.stringify({
  //   hostname: output.hostname,
  //   protocol: output.protocol,
  //   headers: output.headers,
  //   body: output.body,
  //   path: output.path,
  //   method: output.method,
  // }, null, 2));

  const handler = requestHandler.getRequestHandler(context, output);

  handler(context, output);
};
