/*
 * Copyright (c) 2016 Cloud Elements. All rights reserved.
 * CLOUD-ELEMENTS PROPRIETARY / CONFIDENTIAL. Use is subject to license
 * terms.
 */

const _ = require('lodash');
const scribe = require('scribe-node').load(['OAuth']);
const url = require('url');

const hasProp = {}.hasOwnProperty;
const extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

/**
 * A simple Oauth utility class which maintains various values.
 */
const MyApi = function(rte, ate, authUrl) {
  return (function(superClass) {
    extend(MyApi, superClass);

    function MyApi() {
      this.requestTokenEndpoint = rte;
      this.accessTokenEndpoint = ate;
      this.authUrl = authUrl;
    }

    /** Returns the request token endpoint. */
    MyApi.prototype.getRequestTokenEndpoint = function() {
      return this.requestTokenEndpoint;
    };

    /** Returns the access token endpoint. */
    MyApi.prototype.getAccessTokenEndpoint = function() {
      return this.accessTokenEndpoint;
    };

    /** Returns the authorization URL. */
    MyApi.prototype.getAuthorizationUrl = function(tok) {
      return this.authUrl + url.format({
        query: {
          oauth_token: tok
        }
      });
    };

    return MyApi;
  })(scribe.DefaultApi10a);
};

/**
 * Signs the request, returning the oauthParameters that correspond to
 * the (newly signed) request.
 */
exports.signReqParams = (requestUrl, body, authorizationUrl, tokenUrl,
    method, apiKey, apiSecret, userToken, userSecret, query) => {

  let service = new scribe.ServiceBuilder()
    .provider(MyApi(requestUrl, tokenUrl, authorizationUrl))
    .apiKey(apiKey)
    .apiSecret(apiSecret)
    .build();

  let accessToken = new scribe.Token(userToken, userSecret);
  let verb = method.toUpperCase();
  let OAuthRequest = service.request.constructor;
  let request = new OAuthRequest(verb, requestUrl);

  if (query !== null) {
    for (let key of Object.keys(query)) {
      let value = query[key];
      if (_.isArray(value)) {
        for (let listValue of value) {
          request.addQueryStringParameter(key, listValue);
        }
      } else {
        request.addQueryStringParameter(key, query[key]);
      }
    }
  }

  if (body !== null) {
    for (let key of Object.keys(body)) {
      request.addBodyParameter(key, body[key].toString());
    }
  }

  service.signRequest(accessToken, request);
  return request.oauthParameters;
};
