# Cloud Elements Executor

This is Cloud Elements Executor, which is distributed as a
function library for independent on-prem execution that replicates the
functionality of elements built on the Cloud Elements service.

All code and features within this service are Copyright (c) Cloud
Elements 2016, 2017 unless otherwise indicated.

## Purpose

Cloud Elements offers a set of HTTP APIs that simplify the use of a
back-end vendors service offering. Each back-end vendor has a connector
plugin on Cloud Elements called an "Element", which allows Cloud
Elements users to easily manage their interactions with that back-end
vendor.

The Cloud Elements Executor is designed to independently replicate Cloud
Elements functionality. It is written as a stand-alone JavaScript
function which accepts a request-like JavaScript object, and return a
response-like JavaScript object, which roughly correspond to the HTTP
request and HTTP response data of Elements. This function will contact
the back-end service directly, without any intervening calls to the
Cloud Elements cloud itself.

Because the Executor accurately replicates Element API functionality,
any API metadata that describes Element APIs (such as Swagger
documentation) also apply to the request and response JavaScript objects
that are passed into/out of the functino.

## How to Use

There are two major data that are required to use the Executor: 

1. The Element descriptor. This is usually saved as JSON in a file named
   'element.json', and contains the complete set of information needed
   to complete a request to a particular back-end vendor.
   
2. The request data for actually making the API request.

Once these are secured, a request can be made to the backend. Here's an
example of hard coding the request, and printing out the result:

```javascript
const element = loadElement();

const requestData = {
  "headers": {
    "x-vendor-authorization": authKey,
    "x-vendor-region": "com"
  },
  "operation": {
    "method": "GET",
    "path": "/contacts"
  },
  "queryParameters": {
    "nextPage": "eyJwYWdlIjozLCJwYWdlU2l6ZSI6NSwib2Zmc2V0IjoxMH0=",
  },
  "body": {},
  "paths": {}
}

executor.elementHandler(element)(
  requestData, {
    requestId: 'test-run-request',
    succeed: o => console.log(JSON.stringify(o, null, 2)),
    fail: o => console.warn('failure', typeof(o), o),
    done: (err, o) => {
      console.warn('error', typeof(err), err);
      console.log(o);
    }
  }
);
```

# Implementation

Under the hood, the Executor reads the element descriptor file to
find all the Cloud Elements public APIs for the given element, and how
those APIs map to the back-end service offerings. After that,
the request object is appropriately transformed, one or more actual
backend request are made, and the resultant response(s) are clarified
into a digestable form to return to the function caller.

Paging, format selection (XML, SOAP, JSON, etc), request signing, and
other service concerns are configured in the element.json itself, and
handled behind-the-scenes as appropriate in order to deliver a simple,
streamlined developer experience.
