'use strict';
const places = require('../../../data/places');
const abbreviations = require('../../../data/abbreviations');
//add Country names
let isPlace = places.countries.reduce(function (h, s) {
  h[s] = true;
  return h;
}, {});
//add City names
places.cities.forEach(function (s) {
  isPlace[s] = true;
});
//add airports
places.airports.forEach(function (s) {
  isPlace[s] = true;
});
//add place abbreviations names
abbreviations.places.forEach(function (s) {
  isPlace[s] = true;
});
//these are signals too
let firstwords = [
  'east',
  'eastern',
  'north',
  'northeast',
  'northern',
  'northwest',
  'south',
  'southeast',
  'southern',
  'southwest',
  'west',
  'western',
].reduce(function (h, s) {
  h[s] = true;
  return h;
}, {});
/*
 USPS Commonly Used Street suffixes and abbreviations
 http://pe.usps.gov/text/pub28/28apc_002.htm
 These are USPS recognized Street Designators, but an address pattern is necessary for disambiguation (ex: #237 Jacksonville Circl)
 */
// const common_street_designators = [
//   'allee',
//   'anex',
//   'annx',
//   'aven',
//   'avenu',
//   'avnue',
//   'bayoo',
//   'blfs',
//   'bluf',
//   'bottm',
//   'boul',
//   'boulv',
//   'brdge',
//   'brks',
//   'brnch',
//   'bypa',
//   'bypas',
//   'byps',
//   'canyn',
//   'causwa',
//   'centr',
//   'circ',
//   'circl',
//   'cirs',
//   'clfs',
//   'cmns',
//   'cnter',
//   'cntr',
//   'cnyn',
//   'cors',
//   'crcl',
//   'crcle',
//   'cres',
//   'crse',
//   'crsent',
//   'crsnt',
//   'crssng',
//   'crst',
//   'cswy',
//   'ctrs',
//   'curv',
//   'driv',
//   'ests',
//   'expw',
//   'expy',
//   'extn',
//   'extnsn',
//   'exts',
//   'flds',
//   'flts',
//   'forg',
//   'frds',
//   'freewy',
//   'frgs',
//   'frks',
//   'frry',
//   'frst',
//   'frway',
//   'frwy',
//   'gardn',
//   'gatewy',
//   'gatway',
//   'gdns',
//   'glns',
//   'grden',
//   'grdn',
//   'grdns',
//   'grns',
//   'grov',
//   'grvs',
//   'gtway',
//   'gtwy',
//   'harb',
//   'harbr',
//   'hbrs',
//   'highwy',
//   'hiway',
//   'hiwy',
//   'hllw',
//   'holw',
//   'holws',
//   'hrbor',
//   'hway',
//   'inlt',
//   'islnd',
//   'islnds',
//   'jction',
//   'jctn',
//   'jctns',
//   'jcts',
//   'junctn',
//   'juncton',
//   'knls',
//   'knol',
//   'lcks',
//   'ldge',
//   'lgts',
//   'lndg',
//   'lndng',
//   'lodg',
//   'mdws',
//   'medows',
//   'missn',
//   'mnrs',
//   'mntain',
//   'mntn',
//   'mntns',
//   'mountin',
//   'mssn',
//   'mtin',
//   'mtwy',
//   'opas',
//   'orch',
//   'orchrd',
//   'parkwy',
//   'pkway',
//   'pkwys',
//   'plns',
//   'plza',
//   'pnes',
//   'prts',
//   'psge',
//   'radiel',
//   'radl',
//   'rdge',
//   'rdgs',
//   'rivr',
//   'rnch',
//   'rnchs',
//   'rpds',
//   'shls',
//   'shoar',
//   'shoars',
//   'shrs',
//   'skwy',
//   'skyway',
//   'spgs',
//   'spng',
//   'spngs',
//   'sprng',
//   'sprngs',
//   'sqre',
//   'sqrs',
//   'statn',
//   'stra',
//   'strav',
//   'straven',
//   'stravenue',
//   'stravn',
//   'streme',
//   'strm',
//   'strt',
//   'strvn',
//   'strvnue',
//   'sumit',
//   'sumitt',
//   'throughway',
//   'tpke',
//   'trafficway',
//   'trak',
//   'trce',
//   'trfy',
//   'trks',
//   'trlr',
//   'trlrs',
//   'trls',
//   'trnpk',
//   'trwy',
//   'tunel',
//   'tunl',
//   'tunls',
//   'tunnl',
//   'turnpk',
//   'upas',
//   'vdct',
//   'viadct',
//   'vill',
//   'villag',
//   'villg',
//   'villiage',
//   'vist',
//   'vlgs',
//   'vlly',
//   'vlys',
//   'vsta',
//   'xing',
//   'xrds'
// ];
/*
 USPS Primary Street Suffix Names
 http://pe.usps.gov/text/pub28/28apc_002.htm
 */
const street_designators = [
  'alley',
  'annex',
  'arcade',
  'avenue',
  'bayou',
  'beach',
  'bend',
  'bluff',
  'bluffs',
  'blvd',
  'bottom',
  'boulevard',
  'branch',
  'bridge',
  'brook',
  'brooks',
  'bypass',
  'camp',
  'canyon',
  'cape',
  'causeway',
  'center',
  'centers',
  'centre',
  'circle',
  'circles',
  'cliff',
  'cliffs',
  'club',
  'common',
  'commons',
  'corner',
  'corners',
  'course',
  'court',
  'courts',
  'cove',
  'coves',
  'creek',
  'crescent',
  'crest',
  'crossing',
  'crossroad',
  'crossroads',
  'curve',
  'divide',
  'drive',
  'drives',
  'estate',
  'estates',
  'express',
  'expressway',
  'extension',
  'extensions',
  'fall',
  'falls',
  'ferry',
  'field',
  'fields',
  'flat',
  'flats',
  'ford',
  'fords',
  'forest',
  'forests',
  'forge',
  'forges',
  'fork',
  'forks',
  'fort',
  'freeway',
  'garden',
  'gardens',
  'gateway',
  'glen',
  'glens',
  'green',
  'greens',
  'grove',
  'groves',
  'harbor',
  'harbors',
  'haven',
  'heights',
  'highway',
  'hill',
  'hills',
  'hollow',
  'hollows',
  'inlet',
  'island',
  'islands',
  'isle',
  'isles',
  'junction',
  'junctions',
  'key',
  'keys',
  'knoll',
  'knolls',
  'lake',
  'lakes',
  'land',
  'landing',
  'lane',
  'light',
  'lights',
  'loaf',
  'lock',
  'locks',
  'lodge',
  'loop',
  'loops',
  'mall',
  'manor',
  'manors',
  'meadow',
  'meadows',
  'mews',
  'mill',
  'mills',
  'mission',
  'motorway',
  'mount',
  'mountain',
  'mountains',
  'neck',
  'orchard',
  'overpass',
  'park',
  'parks',
  'parkway',
  'parkways',
  'pass',
  'passage',
  'path',
  'paths',
  'pike',
  'pikes',
  'pine',
  'pines',
  'place',
  'plain',
  'plains',
  'plaza',
  'point',
  'points',
  'port',
  'ports',
  'prairie',
  'rad',
  'radial',
  'ramp',
  'ranch',
  'ranches',
  'rapid',
  'rapids',
  'rest',
  'ridge',
  'ridges',
  'river',
  'road',
  'roads',
  'route',
  'run',
  'row',
  'shoal',
  'shoals',
  'shore',
  'shores',
  'spring',
  'springs',
  'spur',
  'spurs',
  'square',
  'squares',
  'station',
  'stream',
  'street',
  'streets',
  'summit',
  'terrace',
  'trace',
  'traces',
  'track',
  'tracks',
  'trail',
  'trailer',
  'trails',
  'tunnel',
  'tunnels',
  'turnpike',
  'underpass',
  'union',
  'unions',
  'valley',
  'valleys',
  'vally',
  'via',
  'viaduct',
  'view',
  'views',
  'village',
  'villages',
  'ville',
  'vista',
  'walk',
  'walks',
  'wall',
  'way',
  'ways',
  'well',
  'wells',
].reduce(function (h, s) {
  h[s] = true;
  return h;
}, {});
/*
/*
 USPS Primary Street Suffix Names
 http://pe.usps.gov/text/pub28/28apc_002.htm
 These are valid, but only given an address pattern (such as street number)
 */
// const street_designator_abbreviation = [
//   'ally',
//   'aly',
//   'anx',
//   'arc',
//   'av',
//   'ave',
//   'avn',
//   'bch',
//   'bg',
//   'bgs',
//   'blf',
//   'bnd',
//   'bot',
//   'br',
//   'brg',
//   'brk',
//   'btm',
//   'burg',
//   'burgs',
//   'byp',
//   'byu',
//   'cen',
//   'cent',
//   'cir',
//   'clb',
//   'clf',
//   'cmn',
//   'cmp',
//   'cor',
//   'cp',
//   'cpe',
//   'crk',
//   'ct',
//   'ctr',
//   'cts',
//   'cv',
//   'cvs',
//   'cyn',
//   'dale',
//   'dam',
//   'div',
//   'dl',
//   'dm',
//   'dr',
//   'drs',
//   'drv',
//   'dv',
//   'dvd',
//   'est',
//   'exp',
//   'expr',
//   'ext',
//   'fld',
//   'fls',
//   'flt',
//   'frd',
//   'frg',
//   'frk',
//   'frt',
//   'fry',
//   'ft',
//   'fwy',
//   'gdn',
//   'gln',
//   'grn',
//   'grv',
//   'hbr',
//   'hl',
//   'hls',
//   'ht',
//   'hts',
//   'hvn',
//   'hwy',
//   'iss',
//   'jct',
//   'knl',
//   'ky',
//   'kys',
//   'lc',
//   'ldg',
//   'lf',
//   'lgt',
//   'lk',
//   'lks',
//   'ln',
//   'mdw',
//   'ml',
//   'mls',
//   'mnr',
//   'mnt',
//   'msn',
//   'mt',
//   'mtn',
//   'mtns',
//   'nck',
//   'oval',
//   'ovl',
//   'pkwy',
//   'pky',
//   'pl',
//   'pln',
//   'plz',
//   'pne',
//   'pr',
//   'prk',
//   'prr',
//   'prt',
//   'pt',
//   'pts',
//   'rd',
//   'rdg',
//   'rds',
//   'riv',
//   'rpd',
//   'rst',
//   'rte',
//   'rue',
//   'rvr',
//   'shl',
//   'shr',
//   'smt',
//   'spg',
//   'sq',
//   'sqr',
//   'sqs',
//   'squ',
//   'st',
//   'sta',
//   'stn',
//   'str',
//   'sts',
//   'ter',
//   'terr',
//   'trk',
//   'trl',
//   'un',
//   'uns',
//   'vis',
//   'vl',
//   'vlg',
//   'vly',
//   'vst',
//   'vw',
//   'vws',
//   'wl',
//   'wls',
//   'wy',
//   'xrd',
// ];
const lastwords = [
  'city',
  'county',
  'province',
  'state',
  'territory',
  'town',
];
const is_place = function (str) {
  let words = str.split(' ');
  if (words.length > 1) {
    //first words, like 'eastern'
    if (firstwords[words[0]]) {
      return true;
    }
    //last words, like 'road, street, lane, circle'
    if (street_designators[words[words.length - 1]]) {
      return true;
    }
    //last words, like 'city, town, state'
    if (lastwords[words[words.length - 1]]) {
      return true;
    }
  }
  for (let i = 0; i < words.length; i++) {
    if (isPlace[words[i]]) {
      return true;
    }
  }
  return false;
};
module.exports = is_place;
