var _                 = require('lodash'),
    gulp              = require('gulp'),
    GulpTask          = require('./gulp_task'),
    runners           = require('./runners'),
    CFValidationError = require('../validation_error');

var Task = _.spread(GulpTask);

var TaskDefinitions = function(context) {
  var self = this;
  var tasks = {
    analysisTasks: [],
    otherTasks: []
  };

  var createTask = function() {
    var task = new Task(_.toArray(arguments));
    if (this.isTaskDefined(task.name)) {
      throw new CFValidationError('Task name ' + task.name + ' already defined');
    }

    return task;
  };

  var registerTask = function(task, TaskRunner) {
    gulp.task.call(gulp, task.name, task.dependencies, function() {
      task.validateParameters(context.parameters);
      return new TaskRunner(task, context).run(_.toArray(arguments));
    });
  };

  var findTask = function(taskName) {
    return _.find(self.allTasks(), { 'name': taskName });
  };

  this.allTasks = function() {
    return (_.flatMap(tasks));
  };

  this.analysisTasks = function() {
    return tasks.analysisTasks;
  };

  this.addTask = function() {
    var task = createTask.apply(this, arguments);
    registerTask(task, runners.Default);
    tasks.otherTasks.push(task);
  };

  this.addAnalysisTask = function() {
    var task = createTask.apply(this, arguments);
    registerTask(task, runners.Report);
    tasks.analysisTasks.push(task);
  };

  this.getTask = function(taskName) {
    var task = findTask(taskName);
    if (_.isUndefined(task)) {
      throw new CFValidationError('Task not defined: ' + taskName);
    }
    return task;
  };

  this.isTaskDefined = function(taskName) {
    return findTask(taskName) !== undefined;
  };
};

module.exports = TaskDefinitions;
