var _  = require('lodash'),
    ko = require('knockout');

var GraphPainter  = require('./graph_painter.js'),
    ControlsProxy = require('./controls_proxy.js'),
    DataProxy     = require('./data_proxy.js');

module.exports = function(id, diagramSettings) {
  var graphPainter = new GraphPainter(id, diagramSettings.graphHandlers);
  var dataProxy = new DataProxy(diagramSettings.layoutAdapter, diagramSettings.dataTransform);

  this.controls = new ControlsProxy(diagramSettings.controls || {});
  this.cssClass = diagramSettings.configuration.style.cssClass;
  this.hasData = ko.observable(false);
  this.model = ko.observable();

  this.onData = function(data) {
    var self = this;
    dataProxy.processData(data).then(function(series) {
      self.hasData((_.isArray(series) && series.length > 0) || _.isObject(series));
      if (!self.hasData()) { return; }

      var model = new diagramSettings.Model(diagramSettings.configuration, series);

      self.controls.initialize(series, model);

      graphPainter.draw(model);
    });
  };
};
