webpackJsonp([5,6],{

/***/ 17:
/***/ function(module, exports, __webpack_require__) {

__webpack_require__(42);
module.exports = __webpack_require__(206);


/***/ },

/***/ 206:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.App = exports.store = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _vue = __webpack_require__(33);

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_vue2.default.config.debug = true;
var _Vuex = Vuex,
    mapGetters = _Vuex.mapGetters,
    mapActions = _Vuex.mapActions,
    Store = _Vuex.Store;
var store = exports.store = new Store({});
_vue2.default.use(CodexPlugin, {
    store: store
});

var App = exports.App = _vue2.default.extend({
    store: store,
    mixins: [_vue2.default.codex.mixins.layout, _vue2.default.codex.mixins.resize],
    data: function data() {
        return { minHeights: { page: 0, inner: 0, app: 0 } };
    },
    mounted: function mounted() {
        this.onResize();
        this.$on('resize', this.onResize);
        this.$eventHub.$on('sidebar:open-sub-menu', this.onResize);
    },

    methods: _extends({}, mapActions(['toggleSidebar', 'closeSidebar', 'openSidebar', 'hideSidebar', 'showSidebar']), {
        toggleSidenav: function toggleSidenav(name) {
            this.$refs['sidenav-' + name].toggle();
        },
        onResize: function onResize() {
            var _this = this;

            // this.minHeights.app = this.$refs.footer.$$el.offset().top + this.$refs.footer.$$el.outerHeight(true);
            this.minHeights.inner = 0;

            this.$nextTick(function () {
                var $page = _this.$$(_this.$refs.page);
                var heights = {
                    header: _this.$refs.header.$$el.outerHeight(true),
                    footer: _this.$refs.footer.$$el.outerHeight(true),
                    viewPort: _this.getViewPort().height
                };
                _this.minHeights.page = heights.viewPort - heights.header - heights.footer;
                _this.minHeights.inner = _this.minHeights.page - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'));

                _this.$emit('resize.document');

                setTimeout(function () {
                    // because of slideMenu
                    if (_this.sidebarInnerHeight > _this.minHeights.inner) _this.minHeights.inner = _this.sidebarInnerHeight;
                    if (_this.contentInnerHeight > _this.minHeights.inner) _this.minHeights.inner = _this.contentInnerHeight;
                    _this.$emit('resize.document.inner');
                }, 301);
            });
        }
    }),
    computed: _extends({}, mapGetters(['sidebar']), {
        $sidebarInner: function $sidebarInner() {
            return this.$$(this.$refs.sidebar.$el.children[0]);
        },
        $contentInner: function $contentInner() {
            return this.$$(this.$refs.content.$el.children[0]);
        },
        sidebarInnerHeight: function sidebarInnerHeight() {
            return this.$sidebarInner.outerHeight();
        },
        contentInnerHeight: function contentInnerHeight() {
            return this.$contentInner.outerHeight();
        },
        classes: function classes() {
            return {
                'sidebar-hidden': this.sidebar.hidden,
                'sidebar-closed': this.sidebar.closed
            };
        }
    })
});

exports.default = App;


window['codex'] = { store: store, App: App };

console.log('sc');

/***/ },

/***/ 33:
/***/ function(module, exports) {

module.exports = Vue;

/***/ }

},[17]);
//# sourceMappingURL=codex.document.js.map