webpackJsonp([2,6],{

/***/ 103:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator.throw(value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
var Vue = __webpack_require__(33);
var VueResource = __webpack_require__(629);
var merge = __webpack_require__(100);
Vue.use(VueResource);
Vue.http.options.credentials = false;
function apiUrl(url) {
    var _apiUrl = Vue.codex.phpdoc.apiUrl;
    if (!_apiUrl.toString().endsWith('/')) _apiUrl += '/';
    _apiUrl += url;
    return _apiUrl;
}
function getEntities(project, ref) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
        var options;
        return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        options = { params: merge({ project: project, ref: ref, tree: false, full: false }, params) };
                        return _context.abrupt("return", new Promise(function (resolve, reject) {
                            var promise = Vue.http.get(apiUrl('phpdoc/entities'), options);
                            return promise.catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return res.json();
                            }, function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context.stop();
                }
            }
        }, _callee, this);
    }));
}
exports.getEntities = getEntities;
function getEntity(project, ref, entity) {
    var params = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
        var options;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        options = { params: merge({ project: project, ref: ref, entity: entity, fields: [] }, params) };
                        return _context2.abrupt("return", new Promise(function (resolve, reject) {
                            var promise = Vue.http.get(apiUrl('phpdoc/entity'), options);
                            return promise.catch(function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return res.json();
                            }, function (err) {
                                return reject(err);
                            }).then(function (res) {
                                return resolve(res.data);
                            });
                        }));

                    case 2:
                    case "end":
                        return _context2.stop();
                }
            }
        }, _callee2, this);
    }));
}
exports.getEntity = getEntity;
//# sourceMappingURL=api.js.map

/***/ },

/***/ 147:
/***/ function(module, exports) {

module.exports = "data:image/gif;base64,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"

/***/ },

/***/ 150:
/***/ function(module, exports) {

"use strict";
"use strict";

function removeStartSlash(value) {
    if (value === undefined) {
        return;
    }
    var matches = value.match(/^\\(.*)/);
    if (matches !== null && matches.length === 2) {
        return matches[1];
    }
    return value;
}
exports.removeStartSlash = removeStartSlash;
;
//# sourceMappingURL=utils.js.map

/***/ },

/***/ 19:
/***/ function(module, exports, __webpack_require__) {

__webpack_require__(42);
module.exports = __webpack_require__(205);


/***/ },

/***/ 2:
/***/ function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(432);
if(typeof content === 'string') content = [[module.i, content, '']];
// add the styles to the DOM
var update = __webpack_require__(66)(content, {});
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-4f593914!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc.vue", function() {
			var newContent = require("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-4f593914!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc.vue");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ },

/***/ 203:
/***/ function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ },

/***/ 205:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var components = __webpack_require__(239);
var directives = __webpack_require__(240);
var filters = __webpack_require__(241);
var api = __webpack_require__(103);
var utils_1 = __webpack_require__(150);
filters['removeStartSlash'] = utils_1.removeStartSlash;
var plugin = function plugin(Vue) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (plugin.installed) return;
    Vue.codex.phpdoc = {
        apiUrl: '/api/v1/',
        api: api
    };
    console.log('phpdoc plugin', { components: components });
    Object.keys(components).forEach(function (key) {
        return Vue.component(key, components[key]);
    });
    Object.keys(directives).forEach(function (key) {
        return Vue.directive(key, directives[key]);
    });
    Object.keys(filters).forEach(function (key) {
        return Vue.filter(key, filters[key]);
    });
    if (Vue.codex.store) {
        var _require = __webpack_require__(242),
            module = _require.module,
            types = _require.types;

        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;
    }
};
window['CodexPhpdocPlugin'] = plugin;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map

/***/ },

/***/ 211:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(23);

function getSettings() {
    return {
        show: {
            inherited: true,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
exports.default = {
    name: 'c-phpdoc-content',
    props: {},
    data: function data() {
        return {
            active: 'methods',
            activeFiltersPane: false,
            method: undefined,
            count: { methods: 0, properties: 0 },
            filters: {
                methods: getSettings(),
                properties: getSettings()
            }
        };
    },
    created: function created() {},

    watch: {
        file: function file() {
            if (this.entity.methods.length > 0) this.method = this.entity.methods[0];

            this.$nextTick(function () {
                Prism.highlightAll();
            });
        }
    },
    computed: _extends({}, (0, _vuex.mapGetters)(['file']), {
        entity: function entity() {
            return this.file.entity;
        },
        hasExtend: function hasExtend() {
            return this.entity.extends && this.entity.extends.length > 0;
        },
        hasDescription: function hasDescription() {
            return this.entity.description.length > 0;
        }
    }),
    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdoc']), {
        setActive: function setActive(name) {
            this.active = name;
            this.activeFiltersPane = false;
        },
        isActive: function isActive(name) {
            return this.active === name;
        },
        setMethod: function setMethod(method) {
            if (typeof method === 'string') {
                method = find(this.entity.methods, { name: name });
            }
            this.method = method;
        },
        isActiveMethod: function isActiveMethod(method) {
            return this.method === method;
        },
        toggleFiltersPane: function toggleFiltersPane(name) {
            if (this.activeFiltersPane === name) {
                this.activeFiltersPane = false;
            } else {
                this.activeFiltersPane = name;
                this.active = name;
            }
        },
        isActiveFiltersPane: function isActiveFiltersPane(name) {
            return this.activeFiltersPane === name;
        },
        closeFiltersPane: function closeFiltersPane() {
            this.activeFiltersPane = false;
        },
        getFiltered: function getFiltered(type) {
            console.trace('getFiltered(type)', type, this.entity);
            var items = _.chain(this.entity[type]);
            if (this.filters[type].show.inherited === false) {
                items = items.filter(function (item) {
                    return item.inherited !== true;
                });
            }
            if (this.filters[type].show.public === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'public';
                });
            }
            if (this.filters[type].show.protected === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'protected';
                });
            }
            if (this.filters[type].show.private === false) {
                items = items.filter(function (item) {
                    return item.visibility !== 'private';
                });
            }

            //var a = _.sortBy(methods, this.sortMethodsBy);
            console.log('getFiltered type', type, 'items', items);

            items = items.sortBy(this.filters[type].sort.by);

            if (this.filters[type].sort.dir === 'desc') {
                items = items.reverse();
            }
            this.count[type] = items.value().length;

            return items.value();
        }
    })

};

/***/ },

/***/ 212:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

var _vuex = __webpack_require__(23);

var _find = __webpack_require__(79);

var _find2 = _interopRequireDefault(_find);

var _filter = __webpack_require__(97);

var _filter2 = _interopRequireDefault(_filter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc-filters',
    props: {
        type: String
    },
    data: function data() {
        return {
            sortMethodsOptions: ['name', 'visibility']
        };
    },

    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdocSettings']), {
        resetFilters: function resetFilters() {
            this.settings = App.defaultSettings.filters[this.type];
        },
        closeFilters: function closeFilters() {
            this.$eventHub.$emit('phpdoc.filters.close');
        },
        mounted: function mounted() {
            console.log('filters ready for ', this.type, 'with settings', this.settings);
        }
    }),
    computed: _extends({
        inherited: {
            get: function get() {
                return this.settings[this.type].show.inherited;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { inherited: v } } });
            }
        },
        public: {
            get: function get() {
                return this.settings[this.type].show.public;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { public: v } } });
            }
        },
        protected: {
            get: function get() {
                return this.settings[this.type].show.protected;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { protected: v } } });
            }
        },
        private: {
            get: function get() {
                return this.settings[this.type].show.private;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { show: { private: v } } });
            }
        },
        sortBy: {
            get: function get() {
                return this.settings[this.type].sort.by;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { by: v } } });
            }
        },
        sortDir: {
            get: function get() {
                return this.settings[this.type].sort.dir;
            },
            set: function set(v) {
                this.updatePhpdocSettings({ type: this.type, settings: { sort: { dir: v } } });
            }
        }
    }, (0, _vuex.mapGetters)(['file', 'settings']), {
        entity: function entity() {
            return this.file.entity;
        }
    })
};

/***/ },

/***/ 213:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(23);

var _find = __webpack_require__(79);

var _find2 = _interopRequireDefault(_find);

var _filter = __webpack_require__(97);

var _filter2 = _interopRequireDefault(_filter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc-method-signature',
    props: {
        method: Object
    },
    computed: {
        hasReturn: function hasReturn() {
            console.log('hasReturn', this.method.returns);
            return this.method.returns.length > 0;
        }
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 214:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(23);

var _find = __webpack_require__(79);

var _find2 = _interopRequireDefault(_find);

var _filter = __webpack_require__(97);

var _filter2 = _interopRequireDefault(_filter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc-method',
    props: {
        method: Object
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 215:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vuex = __webpack_require__(23);

var _find = __webpack_require__(79);

var _find2 = _interopRequireDefault(_find);

var _filter = __webpack_require__(97);

var _filter2 = _interopRequireDefault(_filter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc-tags',
    props: {
        object: { type: Object, required: true },
        exclude: { type: Array, default: [] }
    },
    methods: {
        hasTagHandler: function hasTagHandler(tag) {
            var tagHandler = (0, _find2.default)(tagHandlers, { 'name': tag.name });
            console.log('found taghandler for tag', tag.name, tagHandler);
            return tagHandler !== undefined;
        }
    },
    computed: {
        tags: function tags() {
            var _this = this;

            return (0, _filter2.default)(this.object.tags, function (tag) {
                return _this.exclude.indexOf(tag.name);
            });
        }
    }
}; //
//
//
//
//
//
//
//
//
//
//
//
//

/***/ },

/***/ 216:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//

var _vuex = __webpack_require__(23);

exports.default = {
    name: 'c-phpdoc-tree',
    props: {},
    data: function data() {
        return {
            config: {
                'plugins': ['types', 'search', 'wholerow'],
                'core': {
                    'themes': {
                        'responsive': false,
                        'name': 'codex'
                    }
                },
                'types': {
                    'default': { 'icon': 'fa fa-file' },
                    'folder': { 'icon': 'fa fa-folder color-blue-grey-500' },
                    'class': { icon: 'fa fa-file-code-o color-green-500' },
                    'interface': { icon: 'fa fa-code color-purple-800' },
                    'trait': { icon: 'fa fa-terminal color-blue-500' }

                }
            },
            // root <ul> jquery element
            $$treeRoot: undefined,
            // jstree instance
            jstree: undefined,
            ignoreTreeSelect: false
        };
    },
    mounted: function mounted() {
        this.makeTree(this.tree || {});
    },

    watch: {
        tree: function tree() {
            console.log('tree watch tree', this.tree);
            this.makeTree(this.tree);
            if (this.file && this.file.entity) {
                this.openTreeTo(this.file.entity.full_name);
            }
        },
        file: function file() {
            console.trace('tree watch file', this.file.entity.full_name);
            this.openTreeTo(this.file.entity.full_name);
        }
    },
    computed: _extends({}, (0, _vuex.mapGetters)(['project', 'ref', 'tree', 'entities', 'file', 'fullName'])),

    methods: _extends({}, (0, _vuex.mapActions)(['setPhpdocFile']), {
        makeTree: function makeTree(items) {
            var _this = this;

            if (this.jstree) this.jstree.destroy();
            if (this.$$treeRoot) this.$$treeRoot.remove();
            this.$$treeRoot = $('<ul>').appendTo(this.$$el);
            this.traverseTree(items, this.$$treeRoot);
            //                this.tree.jstree(config('phpdoc.jstree'));
            this.$$el.jstree(this.config);
            this.jstree = this.$$el.jstree();
            this.$$el.on('select_node.jstree', this, function (event, data) {
                if (_this.ignoreTreeSelect) return;
                if (data.node.type === 'folder') {
                    _this.tree.open_node(data.node);
                } else {
                    var fullName = data.node.data.fullName;
                    _this.$eventHub.$emit('phpdoc.tree.select', fullName, event, data);
                    _this.setPhpdocFile(fullName);
                }
            });
        },
        traverseTree: function traverseTree(items, $el, level) {
            var _this2 = this;

            level = level || 0;
            Object.keys(items).forEach(function (k) {
                var item = items[k];
                if (isNaN(parseInt(k))) {
                    // this is a string, with children
                    var $nel = $('<ul>');
                    var $nli = $('<li>').text(k).append($nel);
                    $nli.addClass('fs-12');
                    if (level == 0) {
                        $nli.attr('data-jstree', '{ "opened" : true, "type" : "folder" }');
                    } else {
                        $nli.attr('data-jstree', '{ "type" : "folder" }');
                    }

                    var namePath = "\\" + k;
                    if (typeof $el.closest('li').attr('data-full-name') !== "undefined") {
                        namePath = $el.closest('li').attr('data-full-name') + namePath;
                    }
                    $nli.attr('data-full-name', namePath);

                    $el.prepend($nli);
                    _this2.traverseTree(item, $nel, level++);
                } else {
                    $el.append($('<li>').text(item['name']).attr('data-jstree', '{ "type": "' + item['type'] + '" }').attr('data-full-name', item['full_name']));
                }
            });
        },
        searchTree: function searchTree(fullName) {
            var items = this.jstree.get_json(null, { flat: true });
            console.trace('search for', fullName, 'in', items);
            var found = false;
            items.forEach(function (item) {

                if (typeof item.data.fullName !== "undefined" && _.endsWith(item.data.fullName, fullName)) {
                    console.trace('search for', fullName, 'found', item);
                    found = item;
                    return false;
                }
            });
            return found;
        },
        openTreeTo: function openTreeTo(fullName) {
            var node = this.searchTree(fullName);
            if (node !== false) {

                this.ignoreTreeSelect = true;
                this.jstree.close_all();
                this.jstree._open_to(node);
                this.jstree.deselect_all();
                this.jstree.select_node(node);
                this.ignoreTreeSelect = false;
            }
        }
    })
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(24)))

/***/ },

/***/ 217:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//

var _vuex = __webpack_require__(23);

var _utils = __webpack_require__(150);

var _find = __webpack_require__(79);

var _find2 = _interopRequireDefault(_find);

var _last = __webpack_require__(538);

var _last2 = _interopRequireDefault(_last);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc-type',
    props: {
        type: { type: String, required: true },
        fqn: { type: Boolean, default: true }
    },
    data: function data() {
        return {
            text: '',
            isEntity: false,
            hasEntity: false,
            fullName: '',
            displayName: ''
        };
    },
    mounted: function mounted() {
        this.isEntity = this.type[0] === '\\';
        if (this.isEntity) {
            var found = (0, _find2.default)(this.entities, { 'full_name': this.type });
            this.hasEntity = found !== undefined;
        }
    },

    methods: _extends({}, (0, _vuex.mapActions)(['setPhpdocFile']), {
        onEntityClick: function onEntityClick() {
            console.log('onEntityClick', this);
            this.isEntity === true && this.setPhpdocFile(this.type);
        }
    }),
    computed: _extends({}, (0, _vuex.mapGetters)(['entities', 'updatePhpdoc']), {
        formattedType: function formattedType() {
            var type = (0, _utils.removeStartSlash)(this.type);
            if (this.fqn === false) {
                type = (0, _last2.default)(type.split('\\'));
            }
            return type;
        }
    })
};

/***/ },

/***/ 218:
/***/ function(module, exports, __webpack_require__) {

"use strict";
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; //
//
//
//
//
//
//
//
//
//
//
//
//

var _api = __webpack_require__(103);

var _api2 = _interopRequireDefault(_api);

var _vuex = __webpack_require__(23);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    name: 'c-phpdoc',
    props: {
        projectName: String,
        projectRef: String,
        fullName: String
    },
    data: function data() {
        return {};
    },
    mounted: function mounted() {
        this.open(this.projectName, this.projectRef, this.fullName);
    },

    computed: _extends({}, (0, _vuex.mapGetters)(['project', 'ref', 'tree', 'entities', 'file'])),
    watch: {
        file: function file() {
            window.history.pushState(null, this.file.entity.full_name, window.location.pathname + "#!/" + this.file.entity.full_name);
        }
    },
    methods: _extends({}, (0, _vuex.mapActions)(['updatePhpdoc', 'setPhpdocFile']), {
        open: function open(project, ref, fullName) {
            var _this = this;

            this.projectName = project;
            this.ref = ref;

            if (location.hash.indexOf('#!/') !== -1) {
                // check if the current location contains a hash, which means we want to open a specific doc page
                fullName = location.hash.replace(/\#\!\//, '');
            } else {
                // otherwise, check if we have a default class to open
                // if not, we just pass undefined. The store will auto-resolve to the first class
                fullName = fullName ? fullName : undefined;
            }

            this.updatePhpdoc({ project: project, ref: ref, entity: fullName }).then(function () {

                // do the navigation magic
                window.history.replaceState(null, fullName, window.location.pathname + "#!/" + fullName);

                window.addEventListener("popstate", function (event) {
                    console.log('popstate', window.location);
                    if (location.hash.indexOf('#!/') !== -1) {
                        _this.setPhpdocFile(location.hash.replace(/\#\!\//, ''));
                    }
                }, false);
            });
        }
    })
};

/***/ },

/***/ 23:
/***/ function(module, exports) {

module.exports = Vuex;

/***/ },

/***/ 239:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var cPhpdoc = __webpack_require__(577);
exports.cPhpdoc = cPhpdoc;
var cPhpdocTree = __webpack_require__(575);
exports.cPhpdocTree = cPhpdocTree;
var cPhpdocContent = __webpack_require__(570);
exports.cPhpdocContent = cPhpdocContent;
var cPhpdocType = __webpack_require__(576);
exports.cPhpdocType = cPhpdocType;
var cPhpdocTags = __webpack_require__(574);
exports.cPhpdocTags = cPhpdocTags;
var cPhpdocFilters = __webpack_require__(571);
exports.cPhpdocFilters = cPhpdocFilters;
var cPhpdocMethod = __webpack_require__(573);
exports.cPhpdocMethod = cPhpdocMethod;
var cPhpdocMethodSignature = __webpack_require__(572);
exports.cPhpdocMethodSignature = cPhpdocMethodSignature;
//# sourceMappingURL=index.js.map

/***/ },

/***/ 24:
/***/ function(module, exports) {

module.exports = jQuery;

/***/ },

/***/ 240:
/***/ function(module, exports) {

"use strict";
"use strict";
//# sourceMappingURL=directives.js.map

/***/ },

/***/ 241:
/***/ function(module, exports) {

"use strict";
"use strict";
//# sourceMappingURL=filters.js.map

/***/ },

/***/ 242:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var _mutations;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator.throw(value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : new P(function (resolve) {
                resolve(result.value);
            }).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
var merge = __webpack_require__(100);
var helpers_1 = __webpack_require__(49);
var api = __webpack_require__(103);
var util_1 = __webpack_require__(102);
var bag = util_1.Storage.hasBag('codex.phpdoc') ? util_1.Storage.getBag('codex.phpdoc') : util_1.Storage.createBag('codex.phpdoc', util_1.StorageProvider.LOCAL);
exports.types = {
    SET_PROJECT: 'phpdoc/SET_PROJECT',
    UPDATE_TREE: 'phpdoc/UPDATE_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    UPDATE_ENTITIES: 'phpdoc/UPDATE_ENTITIES',
    UPDATE_METHODS_SETTINGS: 'phpdoc/UPDATE_METHODS_SETTINGS',
    UPDATE_PROPERTIES_SETTINGS: 'phpdoc/UPDATE_PROPERTIES_SETTINGS'
};
function getSettings() {
    return {
        show: {
            inherited: false,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
var state = {
    project: '',
    ref: '',
    fullName: '',
    tree: undefined,
    entities: [],
    file: undefined,
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings()
    }
};
exports.module = {
    state: state,
    mutations: (_mutations = {}, _defineProperty(_mutations, exports.types.SET_PROJECT, function (state, project) {
        console.trace('SET_PROJECT', { project: project });
        state.project = project.name;
        state.ref = project.ref;
        helpers_1.emit(exports.types.SET_PROJECT);
    }), _defineProperty(_mutations, exports.types.UPDATE_ENTITIES, function (state, entities) {
        console.trace('UPDATE_ENTITIES', { entities: entities });
        state.entities = entities;
        helpers_1.emit(exports.types.UPDATE_ENTITIES);
    }), _defineProperty(_mutations, exports.types.UPDATE_TREE, function (state, tree) {
        console.trace('UPDATE_TREE', { tree: tree });
        state.tree = tree;
        helpers_1.emit(exports.types.UPDATE_TREE);
    }), _defineProperty(_mutations, exports.types.SET_FILE, function (state, file) {
        console.trace('SET_FILE', { file: file });
        state.file = file;
        state.fullName = file.entity.full_name;
        helpers_1.emit(exports.types.SET_FILE);
    }), _defineProperty(_mutations, exports.types.UPDATE_METHODS_SETTINGS, function (state, settings) {
        console.trace(exports.types.UPDATE_METHODS_SETTINGS, { settings: settings });
        state.settings.methods = merge({}, state.settings.methods, settings);
        bag.set('settings.methods', state.settings.methods, { json: true });
        helpers_1.emit(exports.types.UPDATE_METHODS_SETTINGS);
    }), _defineProperty(_mutations, exports.types.UPDATE_PROPERTIES_SETTINGS, function (state, settings) {
        console.trace(exports.types.UPDATE_PROPERTIES_SETTINGS, { settings: settings });
        state.settings.properties = merge({}, state.settings.properties, settings);
        bag.set('settings.properties', state.settings.properties, { json: true });
        helpers_1.emit(exports.types.UPDATE_PROPERTIES_SETTINGS);
    }), _mutations),
    actions: {
        updatePhpdocEntities: function updatePhpdocEntities(_ref) {
            var state = _ref.state,
                commit = _ref.commit,
                dispatch = _ref.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee() {
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                console.trace('updatePhpdocEntities', { payload: payload });
                                api.getEntities(state.project, state.ref, { tree: true }).then(function (tree) {
                                    commit(exports.types.UPDATE_TREE, tree);
                                });
                                _context.next = 4;
                                return api.getEntities(state.project, state.ref).then(function (entities) {
                                    commit(exports.types.UPDATE_ENTITIES, entities);
                                });

                            case 4:
                                return _context.abrupt("return", _context.sent);

                            case 5:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));
        },
        setPhpdocFile: function setPhpdocFile(_ref2) {
            var state = _ref2.state,
                commit = _ref2.commit,
                dispatch = _ref2.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee2() {
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                console.trace('setPhpdocFile', { payload: payload });

                                if (!(state.fullName === payload)) {
                                    _context2.next = 3;
                                    break;
                                }

                                return _context2.abrupt("return");

                            case 3:
                                _context2.next = 5;
                                return api.getEntity(state.project, state.ref, payload).then(function (file) {
                                    commit(exports.types.SET_FILE, file);
                                });

                            case 5:
                                return _context2.abrupt("return", _context2.sent);

                            case 6:
                            case "end":
                                return _context2.stop();
                        }
                    }
                }, _callee2, this);
            }));
        },
        updatePhpdoc: function updatePhpdoc(_ref3) {
            var state = _ref3.state,
                commit = _ref3.commit,
                dispatch = _ref3.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            return __awaiter(this, void 0, void 0, regeneratorRuntime.mark(function _callee3() {
                return regeneratorRuntime.wrap(function _callee3$(_context3) {
                    while (1) {
                        switch (_context3.prev = _context3.next) {
                            case 0:
                                console.trace('updatePhpdoc', { payload: payload });

                                if (!(payload.project && payload.project !== state.project || payload.ref && payload.ref !== state.ref)) {
                                    _context3.next = 10;
                                    break;
                                }

                                commit(exports.types.SET_PROJECT, { name: payload.project, ref: payload.ref });

                                if (payload.entity) {
                                    _context3.next = 9;
                                    break;
                                }

                                _context3.next = 6;
                                return dispatch('updatePhpdocEntities');

                            case 6:
                                payload.entity = state.entities[0].full_name;
                                _context3.next = 10;
                                break;

                            case 9:
                                dispatch('updatePhpdocEntities');

                            case 10:
                                if (!(payload.entity && state.fullName !== payload.entity)) {
                                    _context3.next = 14;
                                    break;
                                }

                                _context3.next = 13;
                                return dispatch('setPhpdocFile', payload.entity);

                            case 13:
                                return _context3.abrupt("return", _context3.sent);

                            case 14:
                            case "end":
                                return _context3.stop();
                        }
                    }
                }, _callee3, this);
            }));
        },
        updatePhpdocSettings: function updatePhpdocSettings(_ref4) {
            var state = _ref4.state,
                commit = _ref4.commit,
                dispatch = _ref4.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            var type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings: function resetPhpdocSettings(_ref5) {
            var state = _ref5.state,
                commit = _ref5.commit,
                dispatch = _ref5.dispatch;
            var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

            if (payload && payload === 'methods') {
                commit(exports.types.UPDATE_METHODS_SETTINGS, getSettings());
            } else if (payload && payload === 'properties') {
                commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
            } else {}
            var type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, getSettings());
            commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
        }
    },
    getters: {
        project: function project(state) {
            return state.project;
        },
        ref: function ref(state) {
            return state.ref;
        },
        fullName: function fullName(state) {
            return state.fullName;
        },
        tree: function tree(state) {
            return state.tree;
        },
        entities: function entities(state) {
            return state.entities;
        },
        file: function file(state) {
            return state.file;
        },
        settings: function settings(state) {
            return state.settings;
        }
    }
};
//# sourceMappingURL=store.js.map

/***/ },

/***/ 3:
/***/ function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(433);
if(typeof content === 'string') content = [[module.i, content, '']];
// add the styles to the DOM
var update = __webpack_require__(66)(content, {});
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-590d4280&scoped=true!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-content.vue", function() {
			var newContent = require("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-590d4280&scoped=true!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-content.vue");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ },

/***/ 33:
/***/ function(module, exports) {

module.exports = Vue;

/***/ },

/***/ 4:
/***/ function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(434);
if(typeof content === 'string') content = [[module.i, content, '']];
// add the styles to the DOM
var update = __webpack_require__(66)(content, {});
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-6ce05d32&scoped=true!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-tree.vue", function() {
			var newContent = require("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-6ce05d32&scoped=true!./../../../../node_modules/sass-loader/index.js?indentedSyntax!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-tree.vue");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ },

/***/ 432:
/***/ function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(53)();
// imports


// module
exports.push([module.i, "\n@charset \"UTF-8\";\n/**\n * Retrieves a color value from the $material-colors Sass map\n * Inspired by https://github.com/nilskaspersson/Google-Material-UI-Color-Palette/\n *\n * @function\n * @param {string} color-name             - quoted, lower-case, dasherized color\n *                                          name (e.g. 'pink', 'amber')\n * @param {string} [color-variant='500']  - quoted, lowercase color variant (e.g.\n *                                          '200', 'a100')\n */\n/*! sassyjson - v1.1.8 - 2015-09-24 */\n.jstree-node, .jstree-children, .jstree-container-ul {\n  display: block;\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  list-style-image: none;\n}\n.jstree-node {\n  white-space: nowrap;\n}\n.jstree-anchor {\n  display: inline-block;\n  color: black;\n  white-space: nowrap;\n  padding: 0 4px 0 1px;\n  margin: 0;\n  vertical-align: top;\n}\n.jstree-anchor:focus {\n  outline: 0;\n}\n.jstree-anchor, .jstree-anchor:link, .jstree-anchor:visited, .jstree-anchor:hover, .jstree-anchor:active {\n  text-decoration: none;\n  color: inherit;\n}\n.jstree-icon {\n  display: inline-block;\n  text-decoration: none;\n  margin: 0;\n  padding: 0;\n  vertical-align: top;\n  text-align: center;\n}\n.jstree-icon:empty {\n  display: inline-block;\n  text-decoration: none;\n  margin: 0;\n  padding: 0;\n  vertical-align: top;\n  text-align: center;\n}\n.jstree-ocl {\n  cursor: pointer;\n}\n.jstree-leaf > .jstree-ocl {\n  cursor: default;\n}\n.jstree .jstree-open > .jstree-children {\n  display: block;\n}\n.jstree .jstree-closed > .jstree-children,\n.jstree .jstree-leaf > .jstree-children {\n  display: none;\n}\n.jstree-anchor > .jstree-themeicon {\n  margin-right: 2px;\n}\n.jstree-no-icons .jstree-themeicon,\n.jstree-anchor > .jstree-themeicon-hidden {\n  display: none;\n}\n.jstree-hidden {\n  display: none;\n}\n.jstree-rtl .jstree-anchor {\n  padding: 0 1px 0 4px;\n}\n.jstree-rtl .jstree-anchor > .jstree-themeicon {\n  margin-left: 2px;\n  margin-right: 0;\n}\n.jstree-rtl .jstree-node {\n  margin-left: 0;\n}\n.jstree-rtl .jstree-container-ul > .jstree-node {\n  margin-right: 0;\n}\n.jstree-wholerow-ul {\n  position: relative;\n  display: inline-block;\n  min-width: 100%;\n}\n.jstree-wholerow-ul .jstree-leaf > .jstree-ocl {\n    cursor: pointer;\n}\n.jstree-wholerow-ul .jstree-anchor, .jstree-wholerow-ul .jstree-icon {\n    position: relative;\n}\n.jstree-wholerow-ul .jstree-wholerow {\n    width: 100%;\n    cursor: pointer;\n    position: absolute;\n    left: 0;\n    -webkit-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n}\n.jstree-codex .jstree-node,\n.jstree-codex .jstree-icon {\n  background-repeat: no-repeat;\n  background-color: transparent;\n}\n.jstree-codex .jstree-anchor,\n.jstree-codex .jstree-wholerow {\n  transition: background-color 0.15s, box-shadow 0.15s;\n}\n.jstree-codex .jstree-hovered {\n  background: #e7f4f9;\n  border-radius: 2px;\n  box-shadow: inset 0 0 1px #cccccc;\n}\n.jstree-codex .jstree-clicked {\n  background: #beebff;\n  border-radius: 2px;\n  box-shadow: inset 0 0 1px #999999;\n}\n.jstree-codex .jstree-no-icons .jstree-anchor > .jstree-themeicon {\n  display: none;\n}\n.jstree-codex .jstree-disabled {\n  background: transparent;\n  color: #666666;\n}\n.jstree-codex .jstree-disabled.jstree-hovered {\n    background: transparent;\n    box-shadow: none;\n}\n.jstree-codex .jstree-disabled.jstree-clicked {\n    background: #efefef;\n}\n.jstree-codex .jstree-disabled > .jstree-icon {\n    opacity: 0.8;\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='jstree-grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#jstree-grayscale\");\n    /* Firefox 10+ */\n    filter: gray;\n    /* IE6-9 */\n    -webkit-filter: grayscale(100%);\n    /* Chrome 19+ & Safari 6+ */\n}\n.jstree-codex > .jstree-striped {\n  min-width: 100%;\n  display: inline-block;\n  background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAkCAMAAAB/qqA+AAAABlBMVEUAAAAAAAClZ7nPAAAAAnRSTlMNAMM9s3UAAAAXSURBVHjajcEBAQAAAIKg/H/aCQZ70AUBjAATb6YPDgAAAABJRU5ErkJggg==\") left top repeat;\n}\n.jstree-codex > .jstree-wholerow-ul .jstree-hovered,\n.jstree-codex > .jstree-wholerow-ul .jstree-clicked {\n  background: transparent;\n  box-shadow: none;\n  border-radius: 0;\n}\n.jstree-codex .jstree-wholerow {\n  box-sizing: border-box;\n}\n.jstree-codex .jstree-wholerow-hovered {\n  background: #e7f4f9;\n}\n.jstree-codex .jstree-wholerow-clicked {\n  background: #beebff;\n  background: linear-gradient(to bottom, #beebff 0%, #a8e4ff 100%);\n}\n.jstree-codex .jstree-node {\n  min-height: 24px;\n  line-height: 24px;\n  margin-left: 24px;\n  min-width: 24px;\n}\n.jstree-codex .jstree-anchor {\n  line-height: 24px;\n  height: 24px;\n}\n.jstree-codex .jstree-icon {\n  width: 24px;\n  height: 24px;\n  line-height: 24px;\n}\n.jstree-codex .jstree-icon:empty {\n  width: 24px;\n  height: 24px;\n  line-height: 24px;\n}\n.jstree-codex.jstree-rtl .jstree-node {\n  margin-right: 24px;\n}\n.jstree-codex .jstree-wholerow {\n  height: 24px;\n}\n.jstree-codex .jstree-node,\n.jstree-codex .jstree-icon {\n  background-image: url(" + __webpack_require__(48) + ");\n}\n.jstree-codex .jstree-node {\n  background-position: -296px;\n  background-repeat: repeat-y;\n}\n.jstree-codex .jstree-last {\n  background: transparent;\n}\n.jstree-codex .jstree-open > .jstree-ocl {\n  background-position: -136px;\n  background-position-y: -4px;\n}\n.jstree-codex .jstree-closed > .jstree-ocl {\n  background-position: -104px;\n  background-position-y: -4px;\n}\n.jstree-codex .jstree-leaf > .jstree-ocl {\n  background-position: -72px;\n  background-position-y: -4px;\n}\n.jstree-codex .jstree-themeicon {\n  background-position: -264px;\n}\n.jstree-codex > .jstree-no-dots .jstree-node,\n.jstree-codex > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -40px;\n}\n.jstree-codex > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: -8px;\n}\n.jstree-codex .jstree-disabled {\n  background: transparent;\n}\n.jstree-codex .jstree-disabled.jstree-hovered {\n    background: transparent;\n}\n.jstree-codex .jstree-disabled.jstree-clicked {\n    background: #efefef;\n}\n.jstree-codex .jstree-anchor > .jstree-undetermined {\n  background-position: -200px;\n}\n.jstree-codex .jstree-anchor > .jstree-undetermined:hover {\n    background-position: -232px;\n}\n.jstree-codex > .jstree-striped {\n  background-size: auto 48px;\n}\n.jstree-codex.jstree-rtl .jstree-node {\n  background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAACAQMAAAB49I5GAAAABlBMVEUAAAAdHRvEkCwcAAAAAXRSTlMAQObYZgAAAAxJREFUCNdjAAMOBgAAGAAJMwQHdQAAAABJRU5ErkJggg==\");\n  background-position: 100% 1px;\n  background-repeat: repeat-y;\n}\n.jstree-codex.jstree-rtl .jstree-last {\n  background: transparent;\n}\n.jstree-codex.jstree-rtl .jstree-open > .jstree-ocl {\n  background-position: -168px;\n}\n.jstree-codex.jstree-rtl .jstree-closed > .jstree-ocl {\n  background-position: -136px;\n}\n.jstree-codex.jstree-rtl .jstree-leaf > .jstree-ocl {\n  background-position: -104px;\n}\n.jstree-codex.jstree-rtl > .jstree-no-dots .jstree-node,\n.jstree-codex.jstree-rtl > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex.jstree-rtl > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -72px;\n}\n.jstree-codex.jstree-rtl > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: -40px;\n}\n.jstree-codex .jstree-themeicon-custom {\n  background-color: transparent;\n  background-image: none;\n  background-position: 0 0;\n}\n.jstree-codex > .jstree-container-ul .jstree-loading > .jstree-ocl {\n  background: url(" + __webpack_require__(147) + ") center center no-repeat;\n}\n.jstree-codex .jstree-file {\n  background: url(" + __webpack_require__(48) + ")-100px-68px no-repeat;\n}\n.jstree-codex .jstree-folder {\n  background: url(" + __webpack_require__(48) + ")-260px-4px no-repeat;\n}\n.jstree-codex > .jstree-container-ul > .jstree-node {\n  margin-left: 0;\n  margin-right: 0;\n}\n.jstree-codex.jstree-rtl .jstree-node {\n  background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAACAQMAAAB49I5GAAAABlBMVEUAAAAdHRvEkCwcAAAAAXRSTlMAQObYZgAAAAxJREFUCNdjAAMOBgAAGAAJMwQHdQAAAABJRU5ErkJggg==\");\n}\n.jstree-codex.jstree-rtl .jstree-last {\n  background: transparent;\n}\n.jstree-codex-small .jstree-node {\n  min-height: 18px;\n  line-height: 18px;\n  margin-left: 18px;\n  min-width: 18px;\n}\n.jstree-codex-small .jstree-anchor {\n  line-height: 18px;\n  height: 18px;\n}\n.jstree-codex-small .jstree-icon {\n  width: 18px;\n  height: 18px;\n  line-height: 18px;\n}\n.jstree-codex-small .jstree-icon:empty {\n  width: 18px;\n  height: 18px;\n  line-height: 18px;\n}\n.jstree-codex-small.jstree-rtl .jstree-node {\n  margin-right: 18px;\n}\n.jstree-codex-small .jstree-wholerow {\n  height: 18px;\n}\n.jstree-codex-small .jstree-node,\n.jstree-codex-small .jstree-icon {\n  background-image: url(" + __webpack_require__(48) + ");\n}\n.jstree-codex-small .jstree-node {\n  background-position: -302px;\n  background-repeat: repeat-y;\n}\n.jstree-codex-small .jstree-last {\n  background: transparent;\n}\n.jstree-codex-small .jstree-open > .jstree-ocl {\n  background-position: -142px;\n  background-position-y: -4px;\n}\n.jstree-codex-small .jstree-closed > .jstree-ocl {\n  background-position: -110px;\n  background-position-y: -4px;\n}\n.jstree-codex-small .jstree-leaf > .jstree-ocl {\n  background-position: -78px;\n  background-position-y: -4px;\n}\n.jstree-codex-small .jstree-themeicon {\n  background-position: -270px;\n}\n.jstree-codex-small > .jstree-no-dots .jstree-node,\n.jstree-codex-small > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex-small > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -46px;\n}\n.jstree-codex-small > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: -14px;\n}\n.jstree-codex-small .jstree-disabled {\n  background: transparent;\n}\n.jstree-codex-small .jstree-disabled.jstree-hovered {\n    background: transparent;\n}\n.jstree-codex-small .jstree-disabled.jstree-clicked {\n    background: #efefef;\n}\n.jstree-codex-small .jstree-anchor > .jstree-undetermined {\n  background-position: -206px;\n}\n.jstree-codex-small .jstree-anchor > .jstree-undetermined:hover {\n    background-position: -238px;\n}\n.jstree-codex-small > .jstree-striped {\n  background-size: auto 36px;\n}\n.jstree-codex-small.jstree-rtl .jstree-node {\n  background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAACAQMAAAB49I5GAAAABlBMVEUAAAAdHRvEkCwcAAAAAXRSTlMAQObYZgAAAAxJREFUCNdjAAMOBgAAGAAJMwQHdQAAAABJRU5ErkJggg==\");\n  background-position: 100% 1px;\n  background-repeat: repeat-y;\n}\n.jstree-codex-small.jstree-rtl .jstree-last {\n  background: transparent;\n}\n.jstree-codex-small.jstree-rtl .jstree-open > .jstree-ocl {\n  background-position: -174px;\n}\n.jstree-codex-small.jstree-rtl .jstree-closed > .jstree-ocl {\n  background-position: -142px;\n}\n.jstree-codex-small.jstree-rtl .jstree-leaf > .jstree-ocl {\n  background-position: -110px;\n}\n.jstree-codex-small.jstree-rtl > .jstree-no-dots .jstree-node,\n.jstree-codex-small.jstree-rtl > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex-small.jstree-rtl > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -78px;\n}\n.jstree-codex-small.jstree-rtl > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: -46px;\n}\n.jstree-codex-small .jstree-themeicon-custom {\n  background-color: transparent;\n  background-image: none;\n  background-position: 0 0;\n}\n.jstree-codex-small > .jstree-container-ul .jstree-loading > .jstree-ocl {\n  background: url(" + __webpack_require__(147) + ") center center no-repeat;\n}\n.jstree-codex-small .jstree-file {\n  background: url(" + __webpack_require__(48) + ")-103px-71px no-repeat;\n}\n.jstree-codex-small .jstree-folder {\n  background: url(" + __webpack_require__(48) + ")-263px-7px no-repeat;\n}\n.jstree-codex-small > .jstree-container-ul > .jstree-node {\n  margin-left: 0;\n  margin-right: 0;\n}\n.jstree-codex-small.jstree-rtl .jstree-last {\n  background: transparent;\n}\n.jstree-codex-large .jstree-node {\n  min-height: 32px;\n  line-height: 32px;\n  margin-left: 32px;\n  min-width: 32px;\n}\n.jstree-codex-large .jstree-anchor {\n  line-height: 32px;\n  height: 32px;\n}\n.jstree-codex-large .jstree-icon {\n  width: 32px;\n  height: 32px;\n  line-height: 32px;\n}\n.jstree-codex-large .jstree-icon:empty {\n  width: 32px;\n  height: 32px;\n  line-height: 32px;\n}\n.jstree-codex-large.jstree-rtl .jstree-node {\n  margin-right: 32px;\n}\n.jstree-codex-large .jstree-wholerow {\n  height: 32px;\n}\n.jstree-codex-large .jstree-node,\n.jstree-codex-large .jstree-icon {\n  background-image: url(" + __webpack_require__(48) + ");\n}\n.jstree-codex-large .jstree-node {\n  background-position: -288px;\n  background-repeat: repeat-y;\n}\n.jstree-codex-large .jstree-last {\n  background: transparent;\n}\n.jstree-codex-large .jstree-open > .jstree-ocl {\n  background-position: -128px;\n  background-position-y: -4px;\n}\n.jstree-codex-large .jstree-closed > .jstree-ocl {\n  background-position: -96px;\n  background-position-y: -4px;\n}\n.jstree-codex-large .jstree-leaf > .jstree-ocl {\n  background-position: -64px;\n  background-position-y: -4px;\n}\n.jstree-codex-large .jstree-themeicon {\n  background-position: -256px;\n}\n.jstree-codex-large > .jstree-no-dots .jstree-node,\n.jstree-codex-large > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex-large > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -32px;\n}\n.jstree-codex-large > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: 0px;\n}\n.jstree-codex-large .jstree-disabled {\n  background: transparent;\n}\n.jstree-codex-large .jstree-disabled.jstree-hovered {\n    background: transparent;\n}\n.jstree-codex-large .jstree-disabled.jstree-clicked {\n    background: #efefef;\n}\n.jstree-codex-large .jstree-anchor > .jstree-undetermined {\n  background-position: -192px;\n}\n.jstree-codex-large .jstree-anchor > .jstree-undetermined:hover {\n    background-position: -224px;\n}\n.jstree-codex-large > .jstree-striped {\n  background-size: auto 64px;\n}\n.jstree-codex-large.jstree-rtl .jstree-node {\n  background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAACAQMAAAB49I5GAAAABlBMVEUAAAAdHRvEkCwcAAAAAXRSTlMAQObYZgAAAAxJREFUCNdjAAMOBgAAGAAJMwQHdQAAAABJRU5ErkJggg==\");\n  background-position: 100% 1px;\n  background-repeat: repeat-y;\n}\n.jstree-codex-large.jstree-rtl .jstree-last {\n  background: transparent;\n}\n.jstree-codex-large.jstree-rtl .jstree-open > .jstree-ocl {\n  background-position: -160px;\n}\n.jstree-codex-large.jstree-rtl .jstree-closed > .jstree-ocl {\n  background-position: -128px;\n}\n.jstree-codex-large.jstree-rtl .jstree-leaf > .jstree-ocl {\n  background-position: -96px;\n}\n.jstree-codex-large.jstree-rtl > .jstree-no-dots .jstree-node,\n.jstree-codex-large.jstree-rtl > .jstree-no-dots .jstree-leaf > .jstree-ocl {\n  background: transparent;\n}\n.jstree-codex-large.jstree-rtl > .jstree-no-dots .jstree-open > .jstree-ocl {\n  background-position: -64px;\n}\n.jstree-codex-large.jstree-rtl > .jstree-no-dots .jstree-closed > .jstree-ocl {\n  background-position: -32px;\n}\n.jstree-codex-large .jstree-themeicon-custom {\n  background-color: transparent;\n  background-image: none;\n  background-position: 0 0;\n}\n.jstree-codex-large > .jstree-container-ul .jstree-loading > .jstree-ocl {\n  background: url(" + __webpack_require__(147) + ") center center no-repeat;\n}\n.jstree-codex-large .jstree-file {\n  background: url(" + __webpack_require__(48) + ")-96px-64px no-repeat;\n}\n.jstree-codex-large .jstree-folder {\n  background: url(" + __webpack_require__(48) + ")-256px-0px no-repeat;\n}\n.jstree-codex-large > .jstree-container-ul > .jstree-node {\n  margin-left: 0;\n  margin-right: 0;\n}\n.jstree-codex-large.jstree-rtl .jstree-last {\n  background: transparent;\n}\n@media (max-width: 768px) and (max-width: 768px) {\n.jstree-codex-responsive .jstree-icon {\n    background-image: url(" + __webpack_require__(203) + ");\n}\n.jstree-codex-responsive .jstree-node,\n  .jstree-codex-responsive .jstree-leaf > .jstree-ocl {\n    background: transparent;\n}\n.jstree-codex-responsive .jstree-node {\n    min-height: 40px;\n    line-height: 40px;\n    margin-left: 40px;\n    min-width: 40px;\n    white-space: nowrap;\n}\n.jstree-codex-responsive .jstree-anchor {\n    line-height: 40px;\n    height: 40px;\n}\n.jstree-codex-responsive .jstree-icon, .jstree-codex-responsive .jstree-icon:empty {\n    width: 40px;\n    height: 40px;\n    line-height: 40px;\n}\n.jstree-codex-responsive > .jstree-container-ul > .jstree-node {\n    margin-left: 0;\n}\n.jstree-codex-responsive.jstree-rtl .jstree-node {\n    margin-left: 0;\n    margin-right: 40px;\n}\n.jstree-codex-responsive.jstree-rtl .jstree-container-ul > .jstree-node {\n    margin-right: 0;\n}\n.jstree-codex-responsive .jstree-ocl,\n  .jstree-codex-responsive .jstree-themeicon,\n  .jstree-codex-responsive .jstree-checkbox {\n    background-size: 120px 240px;\n}\n.jstree-codex-responsive .jstree-leaf > .jstree-ocl {\n    background: transparent;\n}\n.jstree-codex-responsive .jstree-open > .jstree-ocl {\n    background-position: 0 0px !important;\n}\n.jstree-codex-responsive .jstree-closed > .jstree-ocl {\n    background-position: -40px !important;\n}\n.jstree-codex-responsive.jstree-rtl .jstree-closed > .jstree-ocl {\n    background-position: -40px 0px !important;\n}\n.jstree-codex-responsive .jstree-themeicon {\n    background-position: -80px;\n}\n.jstree-codex-responsive .jstree-anchor > .jstree-undetermined, .jstree-codex-responsive .jstree-anchor > .jstree-undetermined:hover {\n    background-position: -120px;\n}\n.jstree-codex-responsive .jstree-anchor {\n    font-weight: bold;\n    font-size: 1.1em;\n    text-shadow: 1px 1px white;\n}\n.jstree-codex-responsive > .jstree-striped {\n    background: transparent;\n}\n.jstree-codex-responsive .jstree-wholerow {\n    border-top: 1px solid rgba(255, 255, 255, 0.7);\n    border-bottom: 1px solid rgba(64, 64, 64, 0.2);\n    background: #ebebeb;\n    height: 40px;\n}\n.jstree-codex-responsive .jstree-wholerow-hovered {\n    background: #e7f4f9;\n}\n.jstree-codex-responsive .jstree-wholerow-clicked {\n    background: #beebff;\n}\n.jstree-codex-responsive .jstree-children .jstree-last > .jstree-wholerow {\n    box-shadow: inset 0 -6px 3px -5px #666666;\n}\n.jstree-codex-responsive .jstree-children .jstree-open > .jstree-wholerow {\n    box-shadow: inset 0 6px 3px -5px #666666;\n    border-top: 0;\n}\n.jstree-codex-responsive .jstree-children .jstree-open + .jstree-open {\n    box-shadow: none;\n}\n.jstree-codex-responsive .jstree-node,\n  .jstree-codex-responsive .jstree-icon,\n  .jstree-codex-responsive .jstree-node > .jstree-ocl,\n  .jstree-codex-responsive .jstree-themeicon,\n  .jstree-codex-responsive .jstree-checkbox {\n    background-image: url(" + __webpack_require__(203) + ");\n    background-size: 120px 240px;\n}\n.jstree-codex-responsive .jstree-node {\n    background-position: -80px 0;\n    background-repeat: repeat-y;\n}\n.jstree-codex-responsive .jstree-last {\n    background: transparent;\n}\n.jstree-codex-responsive .jstree-leaf > .jstree-ocl {\n    background-position: -160px;\n}\n.jstree-codex-responsive .jstree-last > .jstree-ocl {\n    background-position: -200px;\n}\n}\n.jstree-codex .jstree-node {\n  margin-left: 0;\n  font-size: 0.9rem;\n}\n.page-phpdoc .document {\n  padding: 0;\n}\n.page-phpdoc .jstree-codex ul.jstree-container-ul,\n.page-phpdoc .jstree-codex ul.jstree-children {\n  padding-left: 4px;\n  margin-top: 0;\n}\n.page-phpdoc .jstree-codex li.jstree-node {\n  margin-left: 12px;\n}\n.page-phpdoc .jstree-codex i.jstree-icon.jstree-ocl:empty {\n  width: 16px;\n}\n.page-phpdoc .jstree-codex .jstree-anchor {\n  font-size: 12px;\n}\n.page-phpdoc .jstree-codex .jstree-anchor .jstree-icon {\n    font-size: 15px;\n}\n.page-phpdoc .phpdoc .type-link {\n  font-family: 'Source Code Pro', monospace, sans-serif;\n  color: brown;\n  padding: 0;\n  text-decoration: none;\n}\n.page-phpdoc .phpdoc .type-link:hover {\n  cursor: default;\n  text-decoration: none;\n  color: #d65f5f;\n}\n.page-phpdoc .phpdoc .type-link.local {\n  color: #3dba73;\n}\n.page-phpdoc .phpdoc .type-link.local:hover {\n  color: #246d44;\n  cursor: pointer;\n}\n.page-phpdoc .phpdoc .simple-type {\n  color: #ef6c00;\n  font-family: 'Source Code Pro', sans-serif;\n}\n.page-phpdoc .phpdoc .tooltip-inner {\n  max-width: none;\n}\n.page-phpdoc .phpdoc-settings {\n  margin-left: auto;\n  margin-right: auto;\n  padding-left: 15px;\n  padding-right: 15px;\n  min-height: 100px;\n  border-bottom: 1px solid #f0f2f1;\n}\n.page-phpdoc .phpdoc-settings::after {\n    content: \"\";\n    display: table;\n    clear: both;\n}\n.page-phpdoc .phpdoc-settings form {\n    margin: 1em 0 1em 0;\n}\n.page-phpdoc .phpdoc-settings-toggle {\n  float: right;\n}\n.page-phpdoc .phpdoc-settings-toggle > a > i.fa {\n    font-size: 40px;\n}\n.page-phpdoc .phpdoc-settings-toggle > a > span.caret {\n    margin-top: 14px;\n    margin-left: -7px;\n}\n.page-phpdoc .phpdoc-tree {\n  float: left;\n  padding-top: 10px;\n  width: 20%;\n  border-right: 1px solid #f0f2f1;\n  overflow: hidden;\n}\n.page-phpdoc .phpdoc-content {\n  width: 80%;\n  float: left;\n  font-size: 14px;\n}\n.page-phpdoc .phpdoc-content > header {\n    border-bottom: 1px solid #f0f2f1;\n    margin-bottom: 10px;\n    padding-left: 20px;\n}\n.page-phpdoc .phpdoc-content > header > i {\n      line-height: 22px !important;\n      font-size: 22px !important;\n      padding-right: 20px;\n      float: left;\n}\n.page-phpdoc .phpdoc-content > header > h3 {\n      font-weight: 200;\n      margin-top: 15px !important;\n      margin-bottom: 13px;\n      font-size: 18px !important;\n      line-height: 24px;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-description {\n    padding-left: 20px;\n}\n.page-phpdoc .phpdoc-content .table-tags th, .page-phpdoc .phpdoc-content .table-tags td {\n    padding: 3px;\n    font-size: 12px;\n}\n.page-phpdoc .phpdoc-content i.phpdoc-inherited-icon {\n    display: inline-block;\n    font: normal normal normal 14px/1 FontAwesome;\n    font-size: inherit;\n    text-rendering: auto;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n    float: right;\n    margin-right: -5px;\n    margin-top: 3px;\n    font-size: 12px;\n    color: #ffc107;\n}\n.page-phpdoc .phpdoc-content i.phpdoc-inherited-icon:before {\n      content: \"\\F062\";\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs {\n    margin-left: 20px;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li:first-child {\n      margin-left: 10px;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li a {\n      text-decoration: none;\n      height: 35px;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li.active a {\n      color: #e7461a;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li.tab-filters-toggler a {\n      padding: 8px;\n      border-left: none;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li.tab-filters-toggler.active a {\n      cursor: pointer;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > ul.nav-tabs > li.tab-filters-toggler.active a:hover {\n        color: black;\n}\n.page-phpdoc .phpdoc-content .phpdoc-content-tabs > .tab-content {\n      padding: 0;\n}\n.page-phpdoc .phpdoc-content .tab-filters {\n    border-left: 1px solid #c5d0dc;\n    border-bottom: 1px solid #c5d0dc;\n    margin-bottom: -1px;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane {\n    padding: 10px;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane h4:not(.empty) {\n      font-size: 1.2rem;\n      padding-bottom: 5px;\n      border-bottom: 1px solid #ebe6e6;\n      margin-bottom: 10px;\n      text-indent: 3px;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane .pretty {\n      display: block;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane .pretty label {\n        font-size: 0.9rem;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane .pretty i {\n        margin-right: 4px;\n}\n.page-phpdoc .phpdoc-content .tab-filters-pane .pretty i:after {\n          top: -1px;\n          left: -1px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable {\n    margin-top: 0 !important;\n    font-size: 14px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable .nav-item.active > a {\n      color: black;\n      background: white;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable .nav-item.seperator > span {\n      display: block;\n      font-weight: bold;\n      padding: 4px 10px;\n      text-decoration: none;\n      border: 1px solid #c5d0dc;\n      margin: 0 -1px 0 0;\n      color: darkgray;\n      text-align: center;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable .nav-link {\n      padding: 4px 10px;\n      text-decoration: none;\n      color: darkgray;\n      font-size: 0.9rem;\n      border-left: none;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable .nav-link i.fa {\n        margin-right: 10px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods > .tabbable .tab-content {\n      padding: 0;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods .tab-pane-header {\n    padding: 12px 15px;\n    font-family: \"Source Code Pro\", monospace;\n    font-size: 12px;\n    border-bottom: 1px solid #c5d0dc;\n    margin: 0;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods .tab-pane-header small.visibility {\n      margin-right: 15px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods .tab-pane-content {\n    padding: 10px 20px 20px 20px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods .tab-pane-content h4 {\n      font-size: 1.2rem;\n      margin: 20px -20px 10px -20px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-methods .tab-pane-content h4:first-child {\n        margin-top: 0;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-properties > table td {\n    padding: 2px 10px;\n}\n.page-phpdoc .phpdoc-content .tab-pane-phpdoc-properties > table i.visibility-icon {\n    width: 20px;\n    text-align: center;\n    font-size: 12px;\n}\n.page-phpdoc .phpdoc-method h4 {\n  border-bottom: 2px solid #e2e2e2;\n  padding-bottom: 7px;\n  padding-left: 4px;\n  margin: 10px 0;\n}\n.page-phpdoc .phpdoc-method .block {\n  padding-left: 5px;\n}\n.page-phpdoc .phpdoc-method .argument {\n  border-top: 1px dashed #f1f1f1;\n  border-bottom: 1px dashed #f1f1f1;\n  border-left: 2px solid #e6e4e4;\n  padding: 3px 0 3px 5px;\n}\n.page-phpdoc .phpdoc-method .argument + .block {\n  border-left: 2px solid #e6e4e4;\n  padding-left: 10px;\n  padding-bottom: 10px;\n  margin-bottom: 10px;\n}\n.page-phpdoc .phpdoc-method .argument + .block > p {\n    margin: 0;\n    padding-top: 10px;\n}\n.page-phpdoc .phpdoc-class-link {\n  font-size: 11px;\n  line-height: 11px;\n  vertical-align: middle;\n  background: rgba(238, 238, 238, 0.35);\n  direction: ltr;\n  text-align: left;\n  white-space: pre;\n  word-spacing: normal;\n  word-break: normal;\n  box-shadow: 0 1px 1px rgba(0, 0, 0, 0.125);\n  background: #56565f;\n  color: #ed6626;\n  padding: 1px 5px;\n  border-radius: 3px;\n  -moz-tab-size: 4;\n       tab-size: 4;\n  margin: 0 3px;\n  font-family: \"Source Code Pro\", monospace;\n  text-decoration: none !important;\n}\nbody a.phpdoc-link,\nbody a.phpdoc-class-link,\nbody a.phpdoc-popover-link {\n  text-decoration: none;\n}\nbody .popover.popover-phpdoc {\n  max-width: 100%;\n}\nbody .popover.popover-phpdoc > .popover-title {\n    font-weight: normal;\n    padding: 15px 14px 12px 14px;\n    font-size: 13px;\n}\nbody .popover.popover-phpdoc > .popover-content {\n    font-size: 11px;\n}\nbody .popover.popover-phpdoc .popover-phpdoc-description {\n    font-style: italic;\n    margin-top: 10px;\n}\nbody .popover.popover-phpdoc .popover-phpdoc-type {\n    font-size: 10px;\n    position: absolute;\n    top: 1px;\n    right: 6px;\n    color: #ada1a1;\n}\nbody .tooltip.tooltip-phpdoc > .tooltip-inner {\n  max-width: 100%;\n}\nbody .phpdoc-visibility-public {\n  color: #388e3c;\n}\nbody .phpdoc-visibility-protected {\n  color: #f57f17;\n}\nbody .phpdoc-visibility-private {\n  color: #d32f2f;\n}\nbody .phpdoc-type-class {\n  color: #388e3c;\n}\nbody .phpdoc-type-trait {\n  color: #2196f3;\n}\nbody .phpdoc-type-interface {\n  color: #6a1b9a;\n}\nbody .phpdoc-type-external {\n  color: #d32f2f;\n}\nbody .phpdoc-type-simple {\n  color: #ef6c00;\n}\nbody i.phpdoc-visibility-public {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-visibility-public:before {\n    content: \"\\F09C\";\n}\nbody i.phpdoc-visibility-protected {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-visibility-protected:before {\n    content: \"\\F13E\";\n}\nbody i.phpdoc-visibility-private {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-visibility-private:before {\n    content: \"\\F023\";\n}\nbody i.phpdoc-type-class {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-type-class:before {\n    content: \"\\F1C9\";\n}\nbody i.phpdoc-type-interface {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-type-interface:before {\n    content: \"\\F121\";\n}\nbody i.phpdoc-type-trait {\n  display: inline-block;\n  font: normal normal normal 14px/1 FontAwesome;\n  font-size: inherit;\n  text-rendering: auto;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\nbody i.phpdoc-type-trait:before {\n    content: \"\\F120\";\n}\n", ""]);

// exports


/***/ },

/***/ 433:
/***/ function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(53)();
// imports


// module
exports.push([module.i, "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", ""]);

// exports


/***/ },

/***/ 434:
/***/ function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(53)();
// imports


// module
exports.push([module.i, "\n\n\n\n\n\n", ""]);

// exports


/***/ },

/***/ 438:
/***/ function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(53)();
// imports


// module
exports.push([module.i, "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", ""]);

// exports


/***/ },

/***/ 48:
/***/ function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ },

/***/ 49:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var isNumber = __webpack_require__(195);
var event_hub_1 = __webpack_require__(74);
function getRandomId(length) {
    if (isNumber(length)) {
        length = 15;
    }
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}
exports.getRandomId = getRandomId;
function load(vNodeContext, cb) {
    if (document.readyState === 'complete') {
        vNodeContext.$nextTick(function () {
            return cb();
        });
    } else {
        document.addEventListener('DOMContentLoaded', function () {
            return cb();
        });
    }
}
exports.load = load;
function getViewPort() {
    var e = window,
        a = 'inner';
    if (!('innerWidth' in window)) {
        a = 'client';
        e = document.documentElement || document.body;
    }
    return {
        width: e[a + 'Width'],
        height: e[a + 'Height']
    };
}
exports.getViewPort = getViewPort;
function isTouchDevice() {
    try {
        document.createEvent("TouchEvent");
        return true;
    } catch (e) {
        return false;
    }
}
exports.isTouchDevice = isTouchDevice;
function getElementHeight(element) {
    if (!element['getClientRects']().length) {
        return element.offsetHeight;
    }
    var rect = element.getBoundingClientRect();
    if (rect.width || rect.height) {
        return rect.bottom - rect.top;
    }
    return 0;
}
exports.getElementHeight = getElementHeight;
function listen(target, eventType, callback) {
    if (target.addEventListener) {
        target.addEventListener(eventType, callback, false);
        return {
            remove: function remove() {
                target.removeEventListener(eventType, callback, false);
            }
        };
    } else if (target.attachEvent) {
        target.attachEvent("on" + eventType, callback);
        return {
            remove: function remove() {
                target.detachEvent("on" + eventType, callback);
            }
        };
    }
}
exports.listen = listen;
function getScroll(w, top) {
    var ret = w["page" + (top ? 'Y' : 'X') + "Offset"];
    var method = "scroll" + (top ? 'Top' : 'Left');
    if (typeof ret !== 'number') {
        var d = w.document;
        ret = d.documentElement[method];
        if (typeof ret !== 'number') {
            ret = d.body[method];
        }
    }
    return ret;
}
exports.getScroll = getScroll;
function getOffset(element) {
    var elm = element;
    var top = elm.offsetTop;
    var left = elm.offsetLeft;
    while (elm.offsetParent !== null) {
        elm = elm.offsetParent;
        top += elm.offsetTop;
        left += elm.offsetLeft;
    }
    return {
        top: top,
        left: left
    };
}
exports.getOffset = getOffset;
function cssTransitions() {
    if (typeof document === 'undefined') return false;
    var style = document.documentElement.style;
    return style['webkitTransition'] !== undefined || style['MozTransition'] !== undefined || style['OTransition'] !== undefined || style['MsTransition'] !== undefined || style.transition !== undefined;
}
exports.cssTransitions = cssTransitions;
function escapeHash(hash) {
    return hash.replace(/(:|\.|\[|\]|,|=)/g, "\\$1");
}
exports.escapeHash = escapeHash;
function registerJqueryHelpers($) {
    if ($.fn.prefixedData !== undefined) {
        return;
    }
    $.fn.prefixedData = function (prefix) {
        var origData = $(this).first().data();
        var data = {};
        for (var p in origData) {
            var pattern = new RegExp("^" + prefix + "[A-Z]+");
            if (origData.hasOwnProperty(p) && pattern.test(p)) {
                var shortName = p[prefix.length].toLowerCase() + p.substr(prefix.length + 1);
                data[shortName] = origData[p];
            }
        }
        return data;
    };
    $.fn.removeAttributes = function () {
        return this.each(function () {
            var attributes = $.map(this.attributes, function (item) {
                return item.name;
            });
            var img = $(this);
            $.each(attributes, function (i, item) {
                img.removeAttr(item);
            });
        });
    };
    $.fn.ensureClass = function (clas) {
        var has = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        var $this = $(this);
        if (has === true && $this.hasClass(clas) === false) {
            $this.addClass(clas);
        } else if (has === false && $this.hasClass(clas) === true) {
            $this.removeClass(clas);
        }
        return this;
    };
    $.fn.onClick = function () {
        var $this = $(this);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return $this.on.apply($this, [isTouchDevice() ? 'touchend' : 'click'].concat(args));
    };
}
exports.registerJqueryHelpers = registerJqueryHelpers;
function parseBool(val) {
    return val === true || val === 1 || val === 'true' || val === '1';
}
exports.parseBool = parseBool;
function setCookie(k, v) {
    Vue.cookie.set(k, JSON.stringify(v));
}
exports.setCookie = setCookie;
function getCookie(k) {
    return JSON.parse(Vue.cookie.get(k));
}
exports.getCookie = getCookie;
function emit() {
    for (var _len2 = arguments.length, params = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        params[_key2] = arguments[_key2];
    }

    params[0] = 'store.' + params[0];
    event_hub_1.default.$emit.apply(event_hub_1.default, params);
}
exports.emit = emit;
//# sourceMappingURL=helpers.js.map

/***/ },

/***/ 570:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* styles */
__webpack_require__(3)

/* script */
__vue_exports__ = __webpack_require__(211)

/* template */
var __vue_template__ = __webpack_require__(614)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-content.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns
__vue_options__._scopeId = "data-v-590d4280"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-590d4280", __vue_options__)
  } else {
    hotAPI.reload("data-v-590d4280", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-content.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 571:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(212)

/* template */
var __vue_template__ = __webpack_require__(622)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-filters.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-92a9857c", __vue_options__)
  } else {
    hotAPI.reload("data-v-92a9857c", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-filters.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 572:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(213)

/* template */
var __vue_template__ = __webpack_require__(608)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-method-signature.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-3fbebc15", __vue_options__)
  } else {
    hotAPI.reload("data-v-3fbebc15", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-method-signature.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 573:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* styles */
__webpack_require__(8)

/* script */
__vue_exports__ = __webpack_require__(214)

/* template */
var __vue_template__ = __webpack_require__(626)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-method.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-dbd1e62c", __vue_options__)
  } else {
    hotAPI.reload("data-v-dbd1e62c", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-method.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 574:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(215)

/* template */
var __vue_template__ = __webpack_require__(610)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-tags.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4a74dc62", __vue_options__)
  } else {
    hotAPI.reload("data-v-4a74dc62", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-tags.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 575:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* styles */
__webpack_require__(4)

/* script */
__vue_exports__ = __webpack_require__(216)

/* template */
var __vue_template__ = __webpack_require__(617)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-tree.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns
__vue_options__._scopeId = "data-v-6ce05d32"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-6ce05d32", __vue_options__)
  } else {
    hotAPI.reload("data-v-6ce05d32", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-tree.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 576:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* script */
__vue_exports__ = __webpack_require__(217)

/* template */
var __vue_template__ = __webpack_require__(611)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc-type.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4ea0bf03", __vue_options__)
  } else {
    hotAPI.reload("data-v-4ea0bf03", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc-type.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 577:
/***/ function(module, exports, __webpack_require__) {

var __vue_exports__, __vue_options__
var __vue_styles__ = {}

/* styles */
__webpack_require__(2)

/* script */
__vue_exports__ = __webpack_require__(218)

/* template */
var __vue_template__ = __webpack_require__(612)
__vue_options__ = __vue_exports__ = __vue_exports__ || {}
if (
  typeof __vue_exports__.default === "object" ||
  typeof __vue_exports__.default === "function"
) {
if (Object.keys(__vue_exports__).some(function (key) { return key !== "default" && key !== "__esModule" })) {console.error("named exports are not supported in *.vue files.")}
__vue_options__ = __vue_exports__ = __vue_exports__.default
}
if (typeof __vue_options__ === "function") {
  __vue_options__ = __vue_options__.options
}
__vue_options__.__file = "/home/radic/codex-theme/src/addons/phpdoc/components/phpdoc.vue"
__vue_options__.render = __vue_template__.render
__vue_options__.staticRenderFns = __vue_template__.staticRenderFns

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4f593914", __vue_options__)
  } else {
    hotAPI.reload("data-v-4f593914", __vue_options__)
  }
})()}
if (__vue_options__.functional) {console.error("[vue-loader] phpdoc.vue: functional components are not supported and should be defined in plain js files using render functions.")}

module.exports = __vue_exports__


/***/ },

/***/ 608:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-method-signature"
  }, [_vm._h('span', {
    class: ['phpdoc-visibility-' + _vm.method.visibility]
  }, [_vm._s(_vm.method.visibility)]), " " + _vm._s(_vm.method.name) + " ", _vm._m(0), " ", _vm._l((_vm.method.arguments), function(argument, argumentIndex) {
    return _vm._h('span', [(argumentIndex !== 0) ? _vm._h('strong', [","]) : _vm._e(), " ", _vm._l((argument.types), function(type, typeIndex) {
      return _vm._h('span', [(typeIndex > 0) ? _vm._h('span', ["|"]) : _vm._e(), " ", (type) ? _vm._h('c-phpdoc-type', {
        attrs: {
          "type": type,
          "fqn": false
        }
      }) : _vm._e()])
    }), " ", _vm._h('span', {
      staticClass: "color-cyan-900"
    }, [_vm._s(argument.name)])])
  }), " ", _vm._m(1), " ", (_vm.method.returns) ? _vm._h('span', ["=>"]) : _vm._e(), " ", (_vm.method.returns) ? _vm._h('c-phpdoc-type', {
    attrs: {
      "type": _vm.method.returns
    }
  }) : _vm._e()])
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('strong', ["("])
},function (){var _vm=this;
  return _vm._h('strong', [")"])
}]}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-3fbebc15", module.exports)
  }
}

/***/ },

/***/ 610:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return (_vm.object.tags.length > 0) ? _vm._h('table', {
    staticClass: "table table-hover table-bordered table-tags"
  }, [_vm._h('tbody', [_vm._l((_vm.tags), function(tag) {
    return _vm._h('tr', [_vm._h('th', {
      attrs: {
        "width": "150",
        "valign": "middle"
      }
    }, [_vm._s(tag.name)]), " ", (tag.description.length > 0) ? _vm._h('td', [_vm._s(tag.description)]) : _vm._e(), " ", (tag.type) ? _vm._h('td', [_vm._h('c-phpdoc-type', {
      attrs: {
        "type": tag.type
      }
    })]) : _vm._e()])
  })])]) : _vm._e()
},staticRenderFns: []}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-4a74dc62", module.exports)
  }
}

/***/ },

/***/ 611:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('span', [(!_vm.isEntity) ? _vm._h('span', {
    staticClass: "simple-type simple-type-string"
  }, [_vm._s(_vm.formattedType)]) : _vm._e(), " ", (_vm.isEntity) ? _vm._h('a', {
    staticClass: "type-link local",
    attrs: {
      "href": '#!/' + _vm.type,
      "rel": "tooltip",
      "title": _vm.type | _vm.removeStartSlash,
      "data-phpdoc-popover": _vm.type
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.onEntityClick($event)
      }
    }
  }, [_vm._s(_vm.formattedType)]) : _vm._e()])
},staticRenderFns: []}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-4ea0bf03", module.exports)
  }
}

/***/ },

/***/ 612:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc"
  }, [_vm._h('c-phpdoc-tree'), " ", _vm._h('c-phpdoc-content')])
},staticRenderFns: []}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-4f593914", module.exports)
  }
}

/***/ },

/***/ 614:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return (_vm.file !== undefined) ? _vm._h('section', {
    staticClass: "phpdoc-content"
  }, [_vm._h('header', [_vm._h('i', {
    class: 'phpdoc-type-' + _vm.file.type
  }), " ", _vm._h('h3', {
    staticClass: "fs22"
  }, [_vm._h('span', {
    class: 'phpdoc-type-' + _vm.file.type
  }, [_vm._s(_vm._f("removeStartSlash")(_vm.file.entity.full_name))]), " ", (_vm.hasExtend) ? _vm._h('small', {
    staticClass: "pl-xs fs-13"
  }, ["extends"]) : _vm._e(), " ", (_vm.hasExtend) ? _vm._h('c-phpdoc-type', {
    staticClass: "fs-13",
    attrs: {
      "type": _vm.entity.extends
    }
  }) : _vm._e()])]), " ", " ", _vm._h('div', {
    staticClass: "phpdoc-content-description"
  }, [(_vm.hasDescription) ? _vm._h('p', {
    staticClass: "fs-13"
  }, [_vm._s(_vm.file.entity.description)]) : _vm._e(), " ", _vm._h('c-phpdoc-tags', {
    attrs: {
      "object": _vm.entity,
      "exclude": ['example', 'inherited_from']
    }
  })]), " ", " ", _vm._h('div', {
    staticClass: "tabbable phpdoc-content-tabs",
    attrs: {
      "id": "phpdoc-tabs"
    }
  }, [_vm._h('ul', {
    staticClass: "nav nav-tabs",
    attrs: {
      "role": "tablist"
    }
  }, [_vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('methods')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-methods",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('methods')
      }
    }
  }, ["Methods"])]), " ", _vm._h('li', {
    staticClass: "nav-item",
    class: ['tab-filters-toggler', {
      'active': _vm.isActiveFiltersPane('methods')
    }],
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.toggleFiltersPane('methods')
      }
    }
  }, [_vm._m(0)])]), " ", _vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('properties')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-properties",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('properties')
      }
    }
  }, ["Properties"])]), " ", _vm._h('li', {
    staticClass: "nav-item",
    class: ['tab-filters-toggler', {
      'active': _vm.isActiveFiltersPane('properties')
    }],
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.toggleFiltersPane('properties')
      }
    }
  }, [_vm._m(1)])]), " ", _vm._h('li', {
    staticClass: "nav-item",
    class: {
      'active': _vm.isActive('source')
    },
    attrs: {
      "role": "presentation"
    }
  }, [_vm._h('a', {
    staticClass: "nav-link",
    attrs: {
      "href": "javascript:;",
      "aria-controls": "phpdoc-source",
      "role": "tab"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.setActive('source')
      }
    }
  }, ["Source"])])]), " ", _vm._h('div', {
    staticClass: "tab-content"
  }, [(_vm.activeFiltersPane !== false) ? _vm._h('div', {
    staticClass: "tab-filters"
  }, [(_vm.isActiveFiltersPane('methods')) ? _vm._h('c-phpdoc-filters', {
    staticClass: "tab-filters-pane",
    attrs: {
      "type": "methods"
    }
  }) : _vm._e(), " ", (_vm.isActiveFiltersPane('properties')) ? _vm._h('c-phpdoc-filters', {
    staticClass: "tab-filters-pane",
    attrs: {
      "type": "properties"
    }
  }) : _vm._e()]) : _vm._e(), " ", " ", _vm._h('div', {
    staticClass: "tab-pane tab-pane-phpdoc-methods",
    class: {
      'active': _vm.isActive('methods')
    },
    attrs: {
      "role": "tabpanel"
    }
  }, [_vm._h('div', {
    staticClass: "tabbable tabs-left"
  }, [_vm._h('ul', {
    staticClass: "nav nav-tabs",
    attrs: {
      "role": "tablist"
    }
  }, [_vm._l((_vm.getFiltered('methods')), function(method) {
    return _vm._h('li', {
      staticClass: "nav-item",
      class: {
        'active': _vm.isActiveMethod(method)
      },
      attrs: {
        "role": "presentation"
      }
    }, [_vm._h('a', {
      staticClass: "nav-link",
      attrs: {
        "role": "tab",
        "href": "javascript:;"
      },
      on: {
        "click": function($event) {
          $event.preventDefault();
          _vm.setMethod(method)
        }
      }
    }, [_vm._h('i', {
      staticClass: "pr-xs",
      class: 'phpdoc-visibility-' + method.visibility
    }), "\n                                " + _vm._s(method.name) + "\n                                ", (method.inherited) ? _vm._h('i', {
      staticClass: "phpdoc-inherited-icon",
      attrs: {
        "rel": "tooltip",
        "title": 'Inherited from: <br> ' + method.class_name
      }
    }) : _vm._e()])])
  })]), " ", _vm._h('div', {
    staticClass: "tab-content"
  }, [_vm._h('div', {
    staticClass: "tab-pane active",
    attrs: {
      "role": "tabpanel"
    }
  }, [(_vm.method) ? _vm._h('c-phpdoc-method', {
    attrs: {
      "method": _vm.method
    }
  }) : _vm._e()])])])]), " ", " ", _vm._h('div', {
    staticClass: "tab-pane tab-pane-phpdoc-properties",
    class: {
      'active': _vm.isActive('properties')
    },
    attrs: {
      "role": "tabpanel"
    }
  }, [_vm._h('table', {
    staticClass: "table table-hover table-striped table-bordered"
  }, [_vm._m(2), " ", _vm._h('tbody', [_vm._l((_vm.getFiltered('properties')), function(property) {
    return _vm._h('tr', [_vm._h('td', {
      class: ['text-right', 'color-teal-500', 'pr-xs', 'pl-xs', 'phpdoc-visibility-' + property.visibility]
    }, [_vm._h('i', {
      staticClass: "pr-xs",
      class: 'phpdoc-visibility-' + property.visibility
    }), "\n                            " + _vm._s(property.name) + "\n                            ", (property.inherited) ? _vm._h('i', {
      staticClass: "phpdoc-inherited-icon",
      attrs: {
        "rel": "tooltip",
        "title": 'Inherited from: <br> ' + property.class_name
      }
    }) : _vm._e(), " ", (property.static) ? _vm._h('span', {
      staticClass: "tag tag-info pull-right m-xs"
    }, ["static"]) : _vm._e()]), " ", _vm._h('td', [_vm._h('p', {
      staticClass: "m-n"
    }, [_vm._l((property.types), function(type, index) {
      return _vm._h('c-phpdoc-type', {
        attrs: {
          "type": type,
          "fqn": false
        }
      })
    })])]), " ", _vm._h('td', [_vm._h('small', [_vm._s(property.description)])])])
  })])])]), " ", " ", _vm._h('div', {
    staticClass: "tab-pane tab-pane-phpdoc-source",
    class: {
      'active': _vm.isActive('source')
    },
    attrs: {
      "role": "tabpanel"
    }
  }, [_vm._h('pre', {
    staticClass: "language-php line-numbers"
  }, [_vm._h('code', {
    staticClass: "language-php"
  }, [_vm._s(_vm.file.source)])])])])])]) : _vm._e()
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-cog"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-cog"
  })
},function (){var _vm=this;
  return _vm._h('thead', [_vm._h('tr', [_vm._h('th', {
    attrs: {
      "width": "200px"
    }
  }, [_vm._h('strong', ["Property"])]), " ", _vm._h('th', {
    staticClass: "text-center",
    attrs: {
      "width": "130px"
    }
  }, [_vm._h('strong', ["Type"])]), " ", _vm._h('th', [_vm._h('strong', ["Description"])])])])
}]}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-590d4280", module.exports)
  }
}

/***/ },

/***/ 617:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._m(0)
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-tree"
  })
}]}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-6ce05d32", module.exports)
  }
}

/***/ },

/***/ 622:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', [_vm._h('form', {
    staticClass: "form-horizontal"
  }, [_vm._h('div', {
    staticClass: "row"
  }, [_vm._m(0), " ", _vm._h('div', {
    staticClass: "col-md-3"
  }, [_vm._m(1), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.inherited),
      expression: "inherited"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.inherited) ? _vm._i(_vm.inherited, null) > -1 : _vm._q(_vm.inherited, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.inherited,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.inherited = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.inherited = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.inherited = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(2), " Show inherited " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.public),
      expression: "public"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.public) ? _vm._i(_vm.public, null) > -1 : _vm._q(_vm.public, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.public,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.public = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.public = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.public = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(3), " Show public " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.protected),
      expression: "protected"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.protected) ? _vm._i(_vm.protected, null) > -1 : _vm._q(_vm.protected, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.protected,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.protected = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.protected = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.protected = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(4), " Show protected " + _vm._s(_vm.name)])]), " ", _vm._h('div', {
    staticClass: "pretty success smooth"
  }, [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.private),
      expression: "private"
    }],
    attrs: {
      "type": "checkbox"
    },
    domProps: {
      "checked": Array.isArray(_vm.private) ? _vm._i(_vm.private, null) > -1 : _vm._q(_vm.private, true)
    },
    on: {
      "change": function($event) {
        var $$a = _vm.private,
          $$el = $event.target,
          $$c = $$el.checked ? (true) : (false);
        if (Array.isArray($$a)) {
          var $$v = null,
            $$i = _vm._i($$a, $$v);
          if ($$c) {
            $$i < 0 && (_vm.private = $$a.concat($$v))
          } else {
            $$i > -1 && (_vm.private = $$a.slice(0, $$i).concat($$a.slice($$i + 1)))
          }
        } else {
          _vm.private = $$c
        }
      }
    }
  }), " ", _vm._h('label', [_vm._m(5), " Show private " + _vm._s(_vm.name)])])]), " ", _vm._h('div', {
    staticClass: "col-md-3"
  }, [_vm._m(6), " ", _vm._h('div', {
    staticClass: "form-group"
  }, [_vm._m(7), " ", _vm._h('div', {
    staticClass: "col-sm-12"
  }, [_vm._h('select', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortBy),
      expression: "sortBy"
    }],
    staticClass: "form-control",
    attrs: {
      "id": "sort-by"
    },
    on: {
      "change": function($event) {
        _vm.sortBy = Array.prototype.filter.call($event.target.options, function(o) {
          return o.selected
        }).map(function(o) {
          var val = "_value" in o ? o._value : o.value;
          return val
        })[0]
      }
    }
  }, [_vm._l((_vm.sortMethodsOptions), function(option) {
    return _vm._h('option', [_vm._s(option)])
  })])])]), " ", _vm._h('div', {
    staticClass: "form-group"
  }, [_vm._h('div', {
    staticClass: "radio col-sm-6"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "asc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "asc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "asc"
      }
    }
  }), " Ascending "])]), " ", _vm._h('div', {
    staticClass: "radio col-sm-6"
  }, [_vm._h('label', [_vm._h('input', {
    directives: [{
      name: "model",
      rawName: "v-model",
      value: (_vm.sortDir),
      expression: "sortDir"
    }],
    attrs: {
      "type": "radio",
      "value": "desc"
    },
    domProps: {
      "checked": _vm._q(_vm.sortDir, "desc")
    },
    on: {
      "change": function($event) {
        _vm.sortDir = "desc"
      }
    }
  }), " Descending "])])])]), " ", _vm._h('div', {
    staticClass: "col-md-2 col-md-offset-1"
  }, [_vm._m(8), " ", _vm._h('a', {
    staticClass: "pull-right btn btn-primary btn-block",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.closeFilters()
      }
    }
  }, ["Close"]), " ", _vm._h('a', {
    staticClass: "pull-right btn btn-primary btn-block",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function($event) {
        $event.preventDefault();
        _vm.resetFilters()
      }
    }
  }, ["Reset to default"])])])])])
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "col-md-3 hide"
  }, [_vm._h('content')])
},function (){var _vm=this;
  return _vm._h('h4', ["Filters"])
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('i', {
    staticClass: "fa fa-check"
  })
},function (){var _vm=this;
  return _vm._h('h4', ["Sorting"])
},function (){var _vm=this;
  return _vm._h('label', {
    staticClass: "col-sm-2 hide control-label",
    attrs: {
      "for": "sort-by"
    }
  }, ["Sort By"])
},function (){var _vm=this;
  return _vm._h('h4', [" "])
}]}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-92a9857c", module.exports)
  }
}

/***/ },

/***/ 626:
/***/ function(module, exports, __webpack_require__) {

module.exports={render:function (){var _vm=this;
  return _vm._h('div', {
    staticClass: "phpdoc-method"
  }, [_vm._h('div', {
    staticClass: "tab-pane-header"
  }, [_vm._h('c-phpdoc-method-signature', {
    attrs: {
      "method": _vm.method
    }
  })]), " ", _vm._h('div', {
    staticClass: "tab-pane-content"
  }, [(_vm.method.description && _vm.method.description.length > 0) ? _vm._h('h4', ["Description"]) : _vm._e(), " ", (_vm.method.description && _vm.method.description.length > 0) ? _vm._h('div', {
    staticClass: "block"
  }, [_vm._h('span', {
    domProps: {
      "innerHTML": _vm._s(_vm.method.description)
    }
  }), " ", (_vm.method['long-description'] && _vm.method['long-description'].length > 0) ? _vm._h('span', {
    domProps: {
      "innerHTML": _vm._s(_vm.method['long-description'])
    }
  }) : _vm._e()]) : _vm._e(), " ", _vm._m(0), " ", _vm._h('div', {
    staticClass: "block"
  }, [_vm._h('c-phpdoc-tags', {
    attrs: {
      "object": _vm.method,
      "exclude": ['param', 'example', 'return']
    }
  })]), " ", (_vm.method.arguments && _vm.method.arguments.length > 0) ? _vm._h('h4', ["Arguments"]) : _vm._e(), " ", (_vm.method.arguments && _vm.method.arguments.length > 0) ? _vm._h('div', {
    staticClass: "block"
  }, [_vm._l((_vm.method.arguments), function(argument) {
    return _vm._h('div', [_vm._h('div', {
      staticClass: "argument"
    }, [_vm._l((argument.types), function(type) {
      return _vm._h('span', [(_vm.$index > 0) ? _vm._h('span', ["|"]) : _vm._e(), " ", _vm._h('c-phpdoc-type', {
        attrs: {
          "type": type,
          "fqn": false
        }
      })])
    }), " ", _vm._h('span', {
      staticClass: "color-cyan-900"
    }, [" " + _vm._s(argument.name)]), " ", (argument.default.length > 0) ? _vm._h('span', [" = " + _vm._s(argument.default)]) : _vm._e()]), " ", (argument.description && argument.description.length > 0) ? _vm._h('div', {
      staticClass: "block"
    }, [_vm._h('span', {
      domProps: {
        "innerHTML": _vm._s(argument.description)
      }
    }), " ", (argument['long-description'] && argument['long-description'].length > 0) ? _vm._h('div', {
      domProps: {
        "innerHTML": _vm._s(argument['long-description'])
      }
    }) : _vm._e()]) : _vm._e()])
  })]) : _vm._e(), " ", _vm._m(1), " ", _vm._h('div', {
    staticClass: "block"
  }, [_vm._h('c-phpdoc-type', {
    attrs: {
      "type": _vm.method.returns,
      "fqn": true
    }
  })])])])
},staticRenderFns: [function (){var _vm=this;
  return _vm._h('h4', ["Tags"])
},function (){var _vm=this;
  return _vm._h('h4', ["Returns"])
}]}
if (false) {
  module.hot.accept()
  if (module.hot.data) {
     require("vue-hot-reload-api").rerender("data-v-dbd1e62c", module.exports)
  }
}

/***/ },

/***/ 629:
/***/ function(module, exports) {

module.exports = VueResource;

/***/ },

/***/ 74:
/***/ function(module, exports, __webpack_require__) {

"use strict";
"use strict";

var Vue = __webpack_require__(33);
var eventHub = new Vue();
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = eventHub;
//# sourceMappingURL=event-hub.js.map

/***/ },

/***/ 8:
/***/ function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(438);
if(typeof content === 'string') content = [[module.i, content, '']];
// add the styles to the DOM
var update = __webpack_require__(66)(content, {});
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-dbd1e62c!./../../../../node_modules/sass-loader/index.js!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-method.vue", function() {
			var newContent = require("!!./../../../../node_modules/css-loader/index.js!./../../../../node_modules/vue-loader/lib/style-rewriter.js?id=data-v-dbd1e62c!./../../../../node_modules/sass-loader/index.js!./../../../../node_modules/vue-loader/lib/selector.js?type=styles&index=0!./phpdoc-method.vue");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }

},[19]);
//# sourceMappingURL=codex.phpdoc.plugin.js.map