import Vue from "vue";
import {mapGetters} from 'vuex';

Vue.config.debug = true;

const App = window['codex'].App.extend({
    // mixins  : [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {
            minContentHeight: 0
        }
    },
    mounted(){
        console.log('phpdoc  APP');
        this.onResizeDocument();
        this.$on('resize', this.onResizeDocument)
        this.$on('resize.document', this.onResizeDocument)
        this.$on('resize.document.inner', this.onResizeDocument)
    },
    methods : {
        // ...mapActions(['toggleSidebar'])
        onResizeDocument(){
            this.$nextTick(() => {
            let $page = this.$$(this.$refs.page);
            this.minContentHeight = $page.outerHeight(true) - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'))
            })
        }
    },
    watch:{
        file(){
            this.onResizeDocument();
            this.$scroll(this.$refs.header.$el);
        }
    },
    computed: {
        ...mapGetters(['file']),


    }
});

export default App;

window['codex'].phpdoc = {App};

console.log('sc');
