"use strict";
const components = require("./components");
const directives = require("./directives");
const filters = require("./filters");
const api = require('./api');
const utils_1 = require('./utils');
filters['removeStartSlash'] = utils_1.removeStartSlash;
let plugin = function (Vue, options = {}) {
    if (plugin.installed)
        return;
    Vue.codex.phpdoc = {
        apiUrl: '/api/v1/',
        api
    };
    console.log('phpdoc plugin', { components });
    Object.keys(components).forEach(key => Vue.component(key, components[key]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[key]));
    Object.keys(filters).forEach(key => Vue.filter(key, filters[key]));
    if (Vue.codex.store) {
        var { module, types } = require('./store');
        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;
    }
};
window['CodexPhpdocPlugin'] = plugin;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map