import   * as Vue from 'vue';
import * as components from "./components";
import * as directives from "./directives";
import * as filters from "./filters";
import * as api from './api'
import {removeStartSlash} from './utils'

filters['removeStartSlash'] = removeStartSlash;

let plugin: any = function (Vue, options: any = {}) {
    if ( plugin.installed ) return;

    Vue.codex.phpdoc = {
        apiUrl: '/api/v1/',
        api
    };

    console.log('phpdoc plugin', {components})
    Object.keys(components).forEach(key => Vue.component(key, components[ key ]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[ key ]));
    Object.keys(filters).forEach(key => Vue.filter(key, filters[ key ]));

    if ( Vue.codex.store ) {
        var { module, types } = require('./store');
        Vue.codex.store.registerModule('phpdoc', module);
        Vue.codex.phpdoc.types = types;
    }
};

window[ 'CodexPhpdocPlugin' ] = plugin;

export default plugin;