"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator.throw(value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
const merge = require("lodash/merge");
const helpers_1 = require("../../utils/helpers");
const api = require('./api');
const util_1 = require('@radic/util');
const bag = util_1.Storage.hasBag('codex.phpdoc') ? util_1.Storage.getBag('codex.phpdoc') : util_1.Storage.createBag('codex.phpdoc', util_1.StorageProvider.LOCAL);
exports.types = {
    SET_PROJECT: 'phpdoc/SET_PROJECT',
    UPDATE_TREE: 'phpdoc/UPDATE_TREE',
    SET_FILE: 'phpdoc/SET_FILE',
    UPDATE_ENTITIES: 'phpdoc/UPDATE_ENTITIES',
    UPDATE_METHODS_SETTINGS: 'phpdoc/UPDATE_METHODS_SETTINGS',
    UPDATE_PROPERTIES_SETTINGS: 'phpdoc/UPDATE_PROPERTIES_SETTINGS',
};
function getSettings() {
    return {
        show: {
            inherited: false,
            public: true,
            protected: true,
            private: true
        },
        sort: {
            by: '',
            dir: 'asc'
        },
        view: ''
    };
}
let state = {
    project: '',
    ref: '',
    fullName: '',
    tree: undefined,
    entities: [],
    file: undefined,
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', { json: true }) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', { json: true }) : getSettings(),
    }
};
exports.module = {
    state,
    mutations: {
        [exports.types.SET_PROJECT](state, project) {
            console.trace('SET_PROJECT', { project });
            state.project = project.name;
            state.ref = project.ref;
            helpers_1.emit(exports.types.SET_PROJECT);
        },
        [exports.types.UPDATE_ENTITIES](state, entities) {
            console.trace('UPDATE_ENTITIES', { entities });
            state.entities = entities;
            helpers_1.emit(exports.types.UPDATE_ENTITIES);
        },
        [exports.types.UPDATE_TREE](state, tree) {
            console.trace('UPDATE_TREE', { tree });
            state.tree = tree;
            helpers_1.emit(exports.types.UPDATE_TREE);
        },
        [exports.types.SET_FILE](state, file) {
            console.trace('SET_FILE', { file });
            state.file = file;
            state.fullName = file.entity.full_name;
            helpers_1.emit(exports.types.SET_FILE);
        },
        [exports.types.UPDATE_METHODS_SETTINGS](state, settings) {
            console.trace(exports.types.UPDATE_METHODS_SETTINGS, { settings });
            state.settings.methods = merge({}, state.settings.methods, settings);
            bag.set('settings.methods', state.settings.methods, { json: true });
            helpers_1.emit(exports.types.UPDATE_METHODS_SETTINGS);
        },
        [exports.types.UPDATE_PROPERTIES_SETTINGS](state, settings) {
            console.trace(exports.types.UPDATE_PROPERTIES_SETTINGS, { settings });
            state.settings.properties = merge({}, state.settings.properties, settings);
            bag.set('settings.properties', state.settings.properties, { json: true });
            helpers_1.emit(exports.types.UPDATE_PROPERTIES_SETTINGS);
        },
    },
    actions: {
        updatePhpdocEntities({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                console.trace('updatePhpdocEntities', { payload });
                api.getEntities(state.project, state.ref, { tree: true }).then(tree => {
                    commit(exports.types.UPDATE_TREE, tree);
                });
                return yield api.getEntities(state.project, state.ref).then(entities => {
                    commit(exports.types.UPDATE_ENTITIES, entities);
                });
            });
        },
        setPhpdocFile({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                console.trace('setPhpdocFile', { payload });
                if (state.fullName === payload) {
                    return;
                }
                return yield api.getEntity(state.project, state.ref, payload).then(file => {
                    commit(exports.types.SET_FILE, file);
                });
            });
        },
        updatePhpdoc({ state, commit, dispatch }, payload = undefined) {
            return __awaiter(this, void 0, void 0, function* () {
                console.trace('updatePhpdoc', { payload });
                if ((payload.project && payload.project !== state.project) || (payload.ref && payload.ref !== state.ref)) {
                    commit(exports.types.SET_PROJECT, { name: payload.project, ref: payload.ref });
                    if (!payload.entity) {
                        yield dispatch('updatePhpdocEntities');
                        payload.entity = state.entities[0].full_name;
                    }
                    else {
                        dispatch('updatePhpdocEntities');
                    }
                }
                if (payload.entity && state.fullName !== payload.entity) {
                    return yield dispatch('setPhpdocFile', payload.entity);
                }
            });
        },
        updatePhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            let type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings({ state, commit, dispatch }, payload = undefined) {
            if (payload && payload === 'methods') {
                commit(exports.types.UPDATE_METHODS_SETTINGS, getSettings());
            }
            else if (payload && payload === 'properties') {
                commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
            }
            else {
            }
            let type = payload.type === 'methods' ? exports.types.UPDATE_METHODS_SETTINGS : exports.types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, getSettings());
            commit(exports.types.UPDATE_PROPERTIES_SETTINGS, getSettings());
        }
    },
    getters: {
        project: state => state.project,
        ref: state => state.ref,
        fullName: state => state.fullName,
        tree: state => state.tree,
        entities: state => state.entities,
        file: state => state.file,
        settings: state => state.settings,
    }
};
//# sourceMappingURL=store.js.map