import { Dispatch, Commit } from "vuex";
import * as Vue from "vue";
import eventHub from "utils/event-hub";
import * as merge from "lodash/merge";
import { getEntity, EntityTree, Entity, SimpleEntity, File } from './api'
import { emit, getCookie, setCookie } from "../../utils/helpers";
import * as  api from './api'
import {Storage, StorageProvider} from '@radic/util'

const bag = Storage.hasBag('codex.phpdoc') ? Storage.getBag('codex.phpdoc') : Storage.createBag('codex.phpdoc', StorageProvider.LOCAL);

// const api    = container.get<any>('api')
// const config = container.get<any>('config')

export const types = {
    SET_PROJECT    : 'phpdoc/SET_PROJECT',
    UPDATE_TREE    : 'phpdoc/UPDATE_TREE',
    SET_FILE       : 'phpdoc/SET_FILE',
    UPDATE_ENTITIES: 'phpdoc/UPDATE_ENTITIES',
    UPDATE_METHODS_SETTINGS: 'phpdoc/UPDATE_METHODS_SETTINGS',
    UPDATE_PROPERTIES_SETTINGS: 'phpdoc/UPDATE_PROPERTIES_SETTINGS',
};

export interface Settings {
    show?: {
        inherited?: boolean,
        public   ?: boolean,
        protected?: boolean,
        private  ?: boolean
    }
    sort?: {
        by ?: string,
        dir?: 'asc' | 'desc'
    }
    view?: string

}
export interface State {
    project: string
    ref: string
    fullName: string
    tree: EntityTree
    entities: SimpleEntity[]
    file: File,
    settings: {
        methods: Settings,
        properties: Settings
    }
}

function getSettings() : Settings {
    return {
        show: {
            inherited: false,
            public   : true,
            protected: true,
            private  : true
        },
        sort: {
            by : '',
            dir: 'asc'
        },
        view: ''
    }
}

let state: State = {
    project : '',
    ref     : '',
    fullName: '',
    tree    : undefined,
    entities: [],
    file  : undefined,
    settings: {
        methods: bag.has('settings.methods') ? bag.get('settings.methods', {json:true}) : getSettings(),
        properties: bag.has('settings.properties') ? bag.get('settings.properties', {json:true}) : getSettings(),
    }
}

export let module = {
    state,
    mutations: {
        [types.SET_PROJECT](state, project) {
            console.trace('SET_PROJECT', { project });
            state.project = project.name;
            state.ref     = project.ref;
            emit(types.SET_PROJECT);
        },
        [types.UPDATE_ENTITIES](state, entities: Entity[]) {
            console.trace('UPDATE_ENTITIES', { entities });
            state.entities = entities;
            emit(types.UPDATE_ENTITIES);
        },
        [types.UPDATE_TREE](state, tree: EntityTree) {
            console.trace('UPDATE_TREE', { tree });
            state.tree = tree;
            emit(types.UPDATE_TREE);
        },
        [types.SET_FILE](state, file:File) {
            console.trace('SET_FILE', { file });
            state.file     = file;
            state.fullName = file.entity.full_name;
            emit(types.SET_FILE);
        },
        [types.UPDATE_METHODS_SETTINGS](state:State, settings:Settings) {
            console.trace(types.UPDATE_METHODS_SETTINGS, { settings });
            state.settings.methods = merge({}, state.settings.methods, settings);
            bag.set('settings.methods', state.settings.methods, {json:true});
            emit(types.UPDATE_METHODS_SETTINGS);
        },
        [types.UPDATE_PROPERTIES_SETTINGS](state:State, settings:Settings) {
            console.trace(types.UPDATE_PROPERTIES_SETTINGS, { settings });
            state.settings.properties = merge({}, state.settings.properties, settings);
            bag.set('settings.properties', state.settings.properties, {json:true});
            emit(types.UPDATE_PROPERTIES_SETTINGS);
        },
    },
    actions  : {
        // async setProject({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
        //     console.log('setProject', { payload });
        //     console.trace();
        //     // return await dispatch('updateEntities');
        // },
        async updatePhpdocEntities({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            console.trace('updatePhpdocEntities', { payload });
            api.getEntities(state.project, state.ref, { tree: true }).then(tree => {
                commit(types.UPDATE_TREE, tree);
            });

            return await api.getEntities(state.project, state.ref).then(entities => {
                commit(types.UPDATE_ENTITIES, entities);
            });
        },
        async setPhpdocFile({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            console.trace('setPhpdocFile', { payload });

            if ( state.fullName === payload ) {
                return;
            }
            return await api.getEntity(state.project, state.ref, payload).then(file => {
                commit(types.SET_FILE, file);
            });
        },
        async updatePhpdoc({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            console.trace('updatePhpdoc', { payload });
            if ( (payload.project && payload.project !== state.project) || (payload.ref && payload.ref !== state.ref) ) {
                commit(types.SET_PROJECT, { name: payload.project, ref: payload.ref });
                if ( ! payload.entity ) {
                    await dispatch('updatePhpdocEntities');
                    payload.entity = state.entities[ 0 ].full_name;
                } else {
                    dispatch('updatePhpdocEntities')
                }
            }
            if ( payload.entity && state.fullName !== payload.entity ) {
                return await dispatch('setPhpdocFile', payload.entity);
            }
        },
        updatePhpdocSettings({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            let type = payload.type === 'methods' ? types.UPDATE_METHODS_SETTINGS : types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, payload.settings);
        },
        resetPhpdocSettings({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            if(payload && payload === 'methods'){
                commit(types.UPDATE_METHODS_SETTINGS, getSettings())
            } else if(payload && payload === 'properties'){
                commit(types.UPDATE_PROPERTIES_SETTINGS, getSettings())
            } else {

            }
            let type = payload.type === 'methods' ? types.UPDATE_METHODS_SETTINGS : types.UPDATE_PROPERTIES_SETTINGS;
            commit(type, getSettings());
            commit(types.UPDATE_PROPERTIES_SETTINGS, getSettings())

        }
    },
    getters  : {
        project : state => state.project,
        ref     : state => state.ref,
        fullName: state => state.fullName,
        tree    : state => state.tree,
        entities: state => state.entities,
        file    : state => state.file,
        settings: state => state.settings,
    }
};


// container.bind('store').toConstantValue(store);
