import Vue from "vue";

Vue.config.debug = true;
var {mapGetters, mapActions, Store} = Vuex;

export const store = new Store({});
Vue.use(CodexPlugin, {
    store
});



export const App = Vue.extend({
    store,
    mixins  : [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {minHeights: {page: 0, inner: 0, app: 0}}
    },
    mounted(){
        this.onResize();
        this.$on('resize', this.onResize)
        this.$eventHub.$on('sidebar:open-sub-menu', this.onResize)
    },
    methods : {
        ...mapActions(['toggleSidebar', 'closeSidebar', 'openSidebar', 'hideSidebar', 'showSidebar']),
        toggleSidenav(name){
            this.$refs['sidenav-' + name].toggle();
        },
        onResize() {
            // this.minHeights.app = this.$refs.footer.$$el.offset().top + this.$refs.footer.$$el.outerHeight(true);
            this.minHeights.inner = 0;

            this.$nextTick(() => {
                let $page = this.$$(this.$refs.page);
                var heights = {
                    header  : this.$refs.header.$$el.outerHeight(true),
                    footer  : this.$refs.footer.$$el.outerHeight(true),
                    viewPort: this.getViewPort().height
                };
                this.minHeights.page = heights.viewPort - heights.header - heights.footer;
                this.minHeights.inner = this.minHeights.page - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'));

                this.$emit('resize.document');

                setTimeout(() => {
                    // because of slideMenu
                    if ( this.sidebarInnerHeight > this.minHeights.inner ) this.minHeights.inner = this.sidebarInnerHeight;
                    if ( this.contentInnerHeight > this.minHeights.inner ) this.minHeights.inner = this.contentInnerHeight;
                    this.$emit('resize.document.inner');
                }, 301)
            })
        }
    },
    computed: {
        ...mapGetters(['sidebar']),
        $sidebarInner(){
            return this.$$(this.$refs.sidebar.$el.children[0])
        },
        $contentInner(){
            return this.$$(this.$refs.content.$el.children[0])
        },
        sidebarInnerHeight(){
            return this.$sidebarInner.outerHeight();
        },
        contentInnerHeight(){
            return this.$contentInner.outerHeight();
        },
        classes(){
            return {
                'sidebar-hidden': this.sidebar.hidden,
                'sidebar-closed': this.sidebar.closed,
            }
        }
    }
});


export default App;

window['codex'] = {store, App};

console.log('sc');
