// import "materialize-css";
import jQuery from "jquery";
import "materialize-css/js/sideNav";
import Velocity from "./vendor/velocity.min";
import "materialize-css/js/hammer.min";
import "materialize-css/js/jquery.hammer";
import "materialize-css/js/jquery.easing.1.3";
import Vue from "vue";
import NProgress from "vue-nprogress";
import VueMaterial from "vue-materials";
import VueCookie from "vue-cookie";
import {sync} from "vuex-router-sync";
import CodexPlugin from "../codex.plugin";
import config from "./config";
import router from "./router";
import store from "../store/store";
import directives from "./directives";
import components from "./components";
import App from "./App.vue";
import {registerJqueryHelpers} from "utils/helpers";

registerJqueryHelpers(jQuery);
window['$'] = jQuery;
window['jQuery'] = jQuery;
window['Velocity'] = Velocity;

Vue.use(VueMaterial);
Vue.use(CodexPlugin);
Vue.use(VueCookie);
Vue.use(NProgress, {
    latencyThreshold: 100,
    router          : false,
    http            : true
});

sync(store, router);

Object.keys(components).forEach(k => Vue.component(k, components[k]));
Object.keys(directives).forEach(k => Vue.directive(k, directives[k]));

const nprogress = new NProgress({parent: '.nprogress-container'});

let app;

if ( config('debug') ) {
    window['app'] = app;
    window['codex'] = {
        store, components, router, directives,
        config : config,
        helpers: require('./utils/helpers'),
        api    : require('./api').api
    };
    Vue.config.debug = true;
}

app = new Vue({
    nprogress,
    router,
    store,
    ...App
});

export {app}


