import { load } from "./utils/helpers";
import { VNode, VNodeDirective, DirectiveOptions } from "vue/types/index";
import { merge } from "lodash";

export const dropdown: DirectiveOptions = {
    bind (el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        console.log('dropdown', { el, binding, vnode });
        load(vnode.context, () => {
            let id = binding.arg, params = {};
            if ( typeof binding.value === 'string' && typeof binding.arg !== 'string' )
                id = binding.value;

            if ( typeof binding.value !== 'string' )
                params = binding.value || {};


            el.setAttribute('data-activates', id);
            $(el).dropdown(params)
        })
    }
};


export const scrollTo: DirectiveOptions = {
    bind (el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        let o = {
            to      : null,
            duration: 500,
            easing  : 'swing',
            offset  : 0
        };
        $(() => {


            $(el).on('click', (event: JQueryEventObject) => {
                event.stopPropagation();
                event.preventDefault();
                if ( typeof binding.value === 'object' ) {
                    merge(o, binding.value);
                }

                if ( typeof binding.value === 'string' ) {
                    o.to = $(binding.value).offset().top

                } else if ( binding.arg ) {
                    o.to = $($(el).attr(binding.arg)).offset().top
                }
                setTimeout(() =>
                        $("html, body").stop().animate({ scrollTop: o.to + o.offset }, o.duration, o.easing, () => {
                            // console.log("Finished animating2");
                        })
                    , 50)
            });

            // console.log('scrollTo', { o, el, binding, vnode })
        });
    }
};


export const scrollspy: DirectiveOptions = {
    bind(el: HTMLElement, binding: VNodeDirective, vnode: VNode, oldVnode: VNode) {
        let defaults = {};
        let options  = merge({}, defaults, binding.value);
        $(() => { $(el)[ 'scrollSpy' ](options).on('scrollSpy:enter', console.log.bind(console)) });
    }
};
