"use strict";
const helpers = require("./utils/helpers");
const event_hub_1 = require("./utils/event-hub");
const SmoothScroll = require("smoothscroll");
require("./vendor/scrollspy.js");
const components = require("./components");
const directives = require("./directives");
const mixins = require("./mixins");
const VueCookie = require("vue-cookie");
const NProgress = require("vue-nprogress");
const merge = require("lodash/merge");
const vIcon = require('vue-materials/src/components/icon.vue');
merge(components, { vIcon });
let plugin = function (Vue, options = {}) {
    if (plugin.installed)
        return;
    console.log(VueCookie);
    Vue.use(VueCookie);
    Vue.use(NProgress, {
        latencyThreshold: 100,
        router: false,
        http: true
    });
    const nprogress = new NProgress({ parent: '.nprogress-container' });
    Vue.codex = {
        breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
        sidebar: { width: 250, collapsedWidth: 54 },
        mixins,
        helpers,
        eventHub: event_hub_1.default
    };
    Object.defineProperties(Vue.prototype, {
        $helpers: { get() { return Vue.codex.helpers; } }
    });
    Vue.mixin({
        nprogress,
        computed: {
            $$el() { return $(this.$el); },
            $eventHub() { return event_hub_1.default; }
        },
        methods: {
            $$: (selector, options) => $(selector, options),
            $$ready(cb) {
                if (document.readyState === 'complete') {
                    this.$nextTick(() => cb());
                }
                else {
                    document.addEventListener('DOMContentLoaded', () => cb());
                }
            },
            $scroll(el, duration = 500, callback, context) {
                SmoothScroll(el, duration, callback, context);
            }
        }
    });
    Vue.config.debug && console.log({ components, directives });
    Object.keys(components).forEach(key => Vue.component(key, components[key]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[key]));
    if (options.store) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }
};
window['CodexPlugin'] = plugin;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=index.js.map