import * as helpers from "./utils/helpers";
import eventHub from "./utils/event-hub";
import * as SmoothScroll from "smoothscroll";
import "./vendor/scrollspy.js";
import * as components from "./components";
import * as directives from "./directives";
import * as mixins from "./mixins";
import * as VueCookie from "vue-cookie";
import * as NProgress from "vue-nprogress";
import * as merge from "lodash/merge";
const vIcon             = require('vue-materials/src/components/icon.vue');

merge(components, { vIcon }); // , vCollectionItem

let plugin: any = function (Vue, options: any = {}) {
    if ( plugin.installed ) return;

    console.log(VueCookie);
    Vue.use(VueCookie);


    Vue.use(NProgress, {
        latencyThreshold: 100,
        router          : false,
        http            : true
    });

    const nprogress = new NProgress({ parent: '.nprogress-container' });


    Vue.codex = {
        breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
        sidebar    : { width: 250, collapsedWidth: 54 },
        mixins,
        helpers,
        eventHub
    };

    Object.defineProperties(Vue.prototype, {
        $helpers: { get () { return Vue.codex.helpers } }
    });


    Vue.mixin({
        nprogress,
        computed: {
            $$el(){ return $(this.$el); },
            $eventHub(){ return eventHub }
        },
        methods : {
            $$: (selector, options): JQuery => $(selector, options),

            $$ready(cb: Function) {
                if ( document.readyState === 'complete' ) {
                    this.$nextTick(() => cb())
                } else {
                    document.addEventListener('DOMContentLoaded', () => cb())
                }
            },
            $scroll(el: HTMLElement, duration: number = 500, callback?: Function, context?: any){
                SmoothScroll(el, duration, callback, context)
            }
        }
    });

    Vue.config.debug && console.log({ components, directives });

    Object.keys(components).forEach(key => Vue.component(key, components[ key ]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[ key ]));

    if ( options.store ) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }
};

window[ 'CodexPlugin' ] = plugin;

export default plugin;
