"use strict";
const helpers_1 = require("../utils/helpers");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    methods: {
        getViewPort: helpers_1.getViewPort,
        getElementHeight: helpers_1.getElementHeight,
        getBreakpoints() {
            return Object.keys(Vue.codex.breakpoints);
        },
        getBreakpoint(breakpoint) {
            return parseInt(Vue.codex.breakpoints[breakpoint]);
        },
        isBreakpointUp(breakpoint) {
            if (typeof breakpoint === 'string')
                breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) >= parseInt(breakpoint);
        },
        isBreakpointDown(breakpoint) {
            if (typeof breakpoint === 'string')
                breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) <= parseInt(breakpoint);
        }
    }
};
//# sourceMappingURL=layout.js.map