import { getViewPort, getElementHeight } from "../utils/helpers";

export default {
    methods: {
        getViewPort     : getViewPort,
        getElementHeight: getElementHeight,
        getBreakpoints(){
            return Object.keys(Vue.codex.breakpoints)
        },
        getBreakpoint(breakpoint){
            return parseInt(Vue.codex.breakpoints[ breakpoint ])
        },
        isBreakpointUp(breakpoint) {
            if ( typeof breakpoint === 'string' ) breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) >= parseInt(breakpoint)
        },
        isBreakpointDown(breakpoint) {
            if ( typeof breakpoint === 'string' ) breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) <= parseInt(breakpoint)
        }
    }
};
