import isNumber = require("lodash/isNumber");
import eventHub from "./event-hub";

export function getRandomId(length) {
    if (isNumber(length)) {
        length = 15;
    }
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}

export function load(vNodeContext, cb) {
    if ( document.readyState === 'complete' ) {
        vNodeContext.$nextTick(() => cb())
    } else {
        document.addEventListener('DOMContentLoaded', () => cb())
    }
}

/**
 * Get the current viewport
 * @returns {{width: *, height: *}}
 */
export function getViewPort() {
    var e: any = window,
        a: any = 'inner';
    if ( ! ('innerWidth' in window) ) {
        a = 'client';
        e = document.documentElement || document.body;
    }

    return {
        width : e[ a + 'Width' ],
        height: e[ a + 'Height' ]
    };
}

/**
 * Checks if the device currently used is a touch device
 * @returns {boolean}
 */
export function isTouchDevice() {
    try {
        document.createEvent("TouchEvent");
        return true;
    } catch ( e ) {
        return false;
    }
}

/**
 *
 * @param {HTMLElement} element
 */
export function getElementHeight(element) {

    // Support: IE <=11 only
    // Running getBoundingClientRect on a
    // disconnected node in IE throws an error
    if ( ! element[ 'getClientRects' ]().length ) {
        return element.offsetHeight
    }

    let rect = element.getBoundingClientRect();

    // Make sure element is not hidden (display: none)
    if ( rect.width || rect.height ) {
        return rect.bottom - rect.top
    }

    // Return zeros for disconnected and hidden elements (gh-2310)
    return 0;
}

export function listen(target: any, eventType: any, callback: any) {
    if ( target.addEventListener ) {
        target.addEventListener(eventType, callback, false);
        return {
            remove() {
                target.removeEventListener(eventType, callback, false);
            },
        };
    } else if ( target.attachEvent ) {
        target.attachEvent(`on${eventType}`, callback);
        return {
            remove() {
                target.detachEvent(`on${eventType}`, callback);
            },
        };
    }
}


export function getScroll(w, top) {
    let ret      = w[ `page${top ? 'Y' : 'X'}Offset` ];
    const method = `scroll${top ? 'Top' : 'Left'}`;
    if ( typeof ret !== 'number' ) {
        const d = w.document;
        ret     = d.documentElement[ method ];
        if ( typeof ret !== 'number' ) {
            ret = d.body[ method ];
        }
    }
    return ret;
}
export function getOffset(element) {
    let elm  = element;
    let top  = elm.offsetTop;
    let left = elm.offsetLeft;
    while ( elm.offsetParent !== null ) {
        elm = elm.offsetParent;
        top += elm.offsetTop;
        left += elm.offsetLeft;
    }
    return {
        top,
        left,
    };
}


// check if browser support css3 transitions
export function cssTransitions() {
    if ( typeof (document) === 'undefined' )
        return false;
    const style = document.documentElement.style;
    return (
        style[ 'webkitTransition' ] !== undefined ||
        style[ 'MozTransition' ] !== undefined ||
        style[ 'OTransition' ] !== undefined ||
        style[ 'MsTransition' ] !== undefined ||
        style.transition !== undefined
    )
}

export function escapeHash(hash) {
    return hash.replace( /(:|\.|\[|\]|,|=)/g, "\\$1" );
}
export function registerJqueryHelpers($) {
    if ( $.fn.prefixedData !== undefined ) {
        return;
    }
    $.fn.prefixedData = function (prefix) {
        var origData = $(this).first().data();
        var data     = {};
        for ( var p in origData ) {
            var pattern = new RegExp("^" + prefix + "[A-Z]+");
            if ( origData.hasOwnProperty(p) && pattern.test(p) ) {
                var shortName     = p[ prefix.length ].toLowerCase() + p.substr(prefix.length + 1);
                data[ shortName ] = origData[ p ];
            }
        }
        return data;
    };

    $.fn.removeAttributes = function () {
        return this.each(function () {
            var attributes = $.map(this.attributes, function (item) {
                return item.name;
            });
            var img        = $(this);
            $.each(attributes, function (i, item) {
                img.removeAttr(item);
            });
        });
    };

    $.fn.ensureClass = function (clas, has = true) {

        var $this = $(this);
        if ( has === true && $this.hasClass(clas) === false ) {
            $this.addClass(clas);
        } else if ( has === false && $this.hasClass(clas) === true ) {
            $this.removeClass(clas);
        }
        return this;
    };

    $.fn.onClick = function (...args) {
        var $this = $(this);
        return $this.on.apply($this, [ isTouchDevice() ? 'touchend' : 'click' ].concat(args));
    }

}


export function parseBool(val) {
    return val === true || val === 1 || val === 'true' || val === '1'
}

export function setCookie(k, v) {
    Vue.cookie.set(k, JSON.stringify(v))
}
export function getCookie(k) {
    return JSON.parse(Vue.cookie.get(k));
}


export function emit(...params: any[]) {
    params[ 0 ] = 'store.' + params[ 0 ];
    eventHub.$emit.apply(eventHub, params);
}