const utils_1 = require("./utils");
const lodash_1 = require("lodash");
exports.dropdown = {
    bind(el, binding, vnode, oldVnode) {
        console.log('dropdown', { el, binding, vnode });
        utils_1.load(vnode.context, () => {
            let id = binding.arg, params = {};
            if (typeof binding.value === 'string' && typeof binding.arg !== 'string')
                id = binding.value;
            if (typeof binding.value !== 'string')
                params = binding.value || {};
            el.setAttribute('data-activates', id);
            $(el).dropdown(params);
        });
    }
};
exports.scrollTo = {
    bind(el, binding, vnode, oldVnode) {
        let o = {
            to: null,
            duration: 500,
            easing: 'swing',
            offset: 0
        };
        $(() => {
            $(el).on('click', (event) => {
                event.stopPropagation();
                event.preventDefault();
                if (typeof binding.value === 'object') {
                    lodash_1.merge(o, binding.value);
                }
                if (typeof binding.value === 'string') {
                    o.to = $(binding.value).offset().top;
                }
                else if (binding.arg) {
                    o.to = $($(el).attr(binding.arg)).offset().top;
                }
                setTimeout(() => $("html, body").stop().animate({ scrollTop: o.to + o.offset }, o.duration, o.easing, () => {
                }), 50);
            });
        });
    }
};
exports.scrollspy = {
    bind(el, binding, vnode, oldVnode) {
        let defaults = {};
        let options = lodash_1.merge({}, defaults, binding.value);
        $(() => { $(el)['scrollSpy'](options).on('scrollSpy:enter', console.log.bind(console)); });
    }
};
//# sourceMappingURL=directives.js.map