const lodash_1 = require("lodash");
const helpers = require("./utils");
const mixins = require("./mixins");
let c = Vue.codex = Vue.codex || {};
window.codex = Vue.codex;
class Loader {
    constructor() {
        this.isLoading = false;
        this.bodyLoadingClass = 'page-loading';
        this.loaderId = 'page-loader';
    }
    get bodyClass() {
        return document.body.classList;
    }
    start() {
        this.getLoaderElement();
        if (!this.bodyClass.contains(this.bodyLoadingClass)) {
            this.bodyClass.add(this.bodyLoadingClass);
        }
    }
    stop() {
        this.bodyClass.remove(this.bodyLoadingClass);
    }
    getLoaderElement() {
        let container = document.getElementById(this.loaderId);
        let loader;
        if (!container) {
            container = document.createElement('div');
            container.setAttribute('id', this.loaderId);
            document.body.appendChild(container);
            loader = document.createElement('div');
            loader.classList.add('loader');
            loader.classList.add('loader-page');
        }
        else {
            loader = container.children[0];
        }
        return container;
    }
}
exports.Loader = Loader;
function init(vars) {
    c.loader = new Loader;
    c.extend = function (...objs) {
        c = lodash_1.merge.apply(lodash_1.merge, [c, ...objs]);
        return c;
    };
    c.extend({
        breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
        sidebar: { width: 250, collapsedWidth: 54 },
        eventHub: new Vue(),
        mixins,
        helpers
    });
    lodash_1.merge(c, vars);
    return c;
}
exports.init = init;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = init;
//# sourceMappingURL=init.js.map