import { merge } from 'lodash'
import * as helpers from "./utils";
import * as mixins from "./mixins";

let c: CodexGlobal = Vue.codex = Vue.codex || {};
window.codex = Vue.codex;

export interface CodexGlobal {
    loader?: Loader
    extend: (...objs: any[]) => this
    CodexPlugin?: Function
    CodexPhpdocPlugin?: Function
    App: vuejs.VueStatic
}

export class Loader {
    isLoading        = false
    bodyLoadingClass = 'page-loading'
    loaderId         = 'page-loader'

    get bodyClass() {
        return document.body.classList;
    }

    start() {
        this.getLoaderElement();
        if ( ! this.bodyClass.contains(this.bodyLoadingClass) ) {
            this.bodyClass.add(this.bodyLoadingClass)
        }
    }

    stop() {
        this.bodyClass.remove(this.bodyLoadingClass)
    }

    protected getLoaderElement(): HTMLElement {
        let container = document.getElementById(this.loaderId);
        let loader;
        if ( ! container ) {
            container = document.createElement('div');
            container.setAttribute('id', this.loaderId);
            document.body.appendChild(container);
            loader = document.createElement('div');
            loader.classList.add('loader');
            loader.classList.add('loader-page');
        } else {
            loader = container.children[ 0 ];
        }
        return container;
    }
}


export function init(vars: { [key: string]: any }) : CodexGlobal {
    c.loader = new Loader
    c.extend = function (...objs: any[]) {
        c = merge.apply(merge, [ c, ...objs ]);
        return c;
    }
    c.extend({
        breakpoints: { xs: 0, sm: 576, md: 768, lg: 922, xl: 1200 },
        sidebar    : { width: 250, collapsedWidth: 54 },
        eventHub: new Vue(),
        mixins,
        helpers
    })

    merge(c, vars);

    return c;
}


export default init;