const utils_1 = require("../utils");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    data() {
        return { isMd: false };
    },
    created() {
        this.isMd = this.isBreakpointUp('md');
    },
    methods: {
        getViewPort: utils_1.getViewPort,
        getElementHeight: utils_1.getElementHeight,
        getBreakpoints() {
            return Object.keys(Vue.codex.breakpoints);
        },
        getBreakpoint(breakpoint) {
            return parseInt(Vue.codex.breakpoints[breakpoint]);
        },
        isBreakpointUp(breakpoint) {
            if (typeof breakpoint === 'string')
                breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) >= parseInt(breakpoint);
        },
        isBreakpointDown(breakpoint) {
            if (typeof breakpoint === 'string')
                breakpoint = this.getBreakpoint(breakpoint);
            return parseInt(this.getViewPort().width) <= parseInt(breakpoint);
        }
    }
};
//# sourceMappingURL=layout.js.map