import { Dispatch, Commit } from "vuex";
import * as Vue from "vue";
import {merge} from 'lodash';
import { getCookie, setCookie } from "./utils";


// const api    = container.get<any>('api')
// const config = container.get<any>('config')

export const types = {
    SIDEBAR           : 'codex/SIDEBAR',
    TOGGLE_SIDEBAR    : 'codex/TOGGLE_SIDEBAR',
    CLOSE_SIDEBAR     : 'codex/CLOSE_SIDEBAR',
    OPEN_SIDEBAR      : 'codex/OPEN_SIDEBAR',
    HIDE_SIDEBAR      : 'codex/HIDE_SIDEBAR',
    SHOW_SIDEBAR      : 'codex/SHOW_SIDEBAR',
    UPDATE_HEIGHTS    : 'codex/UPDATE_HEIGHTS',
    UPDATE_MIN_HEIGHTS: 'codex/UPDATE_MIN_HEIGHTS',

};

let emit = (...params:any[]) => Vue.codex.eventHub.$emit.apply(Vue.codex.eventHub, params);


export let module = {
    state    : {
        sidebar   : { closed: getCookie('codex.sidebar.closed') || false, hidden: getCookie('codex.sidebar.hidden') || false }
    },
    mutations: {

        [types.TOGGLE_SIDEBAR](state) {
            state.sidebar.closed = state.sidebar.closed === false;
            setCookie('sidebar.closed', state.sidebar.closed);
            emit(types.TOGGLE_SIDEBAR);
        },
        [types.CLOSE_SIDEBAR](state) {
            state.sidebar.closed = true;
            setCookie('sidebar.closed', state.sidebar.closed);
            emit(types.CLOSE_SIDEBAR);
        },
        [types.OPEN_SIDEBAR](state) {
            state.sidebar.closed = false;
            setCookie('sidebar.closed', state.sidebar.closed);
            emit(types.OPEN_SIDEBAR);
        },
        [types.HIDE_SIDEBAR](state) {
            state.sidebar.hidden = true;
            setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(types.HIDE_SIDEBAR);
        },
        [types.SHOW_SIDEBAR](state) {
            state.sidebar.hidden = false;
            setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(types.SHOW_SIDEBAR);
        },


        [types.UPDATE_HEIGHTS](state, heights) {
            state.heights = merge(state.heights, heights);
            emit(types.UPDATE_HEIGHTS);
        },
        [types.UPDATE_MIN_HEIGHTS](state, heights) {
            state.minHeights = merge(state.minHeights, heights);
            emit(types.UPDATE_MIN_HEIGHTS);
        },

    },
    actions  : {

        toggleSidebar({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.TOGGLE_SIDEBAR);
        },
        closeSidebar({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.CLOSE_SIDEBAR);
        },
        openSidebar({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.OPEN_SIDEBAR);
        },
        hideSidebar({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.HIDE_SIDEBAR);
        },
        showSidebar({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.SHOW_SIDEBAR);
        },

        updateHeights({ state, commit, dispatch }:{ state: any, commit: Commit, dispatch: Dispatch }, payload: any = undefined) {
            commit(types.UPDATE_HEIGHTS, payload);
            commit(types.UPDATE_MIN_HEIGHTS, {
                page: state.heights.viewPort - state.heights.header - state.heights.footer
            })
        },
    },
    getters  : {
        sidebar   : state => state.sidebar,
        heights   : state => state.heights,
        minHeights: state => state.minHeights
    }
};


// container.bind('store').toConstantValue(store);
