const Vue = require("vue");
const lodash_1 = require('lodash');
const helpers_1 = require("../utils/helpers");
exports.types = {
    SIDEBAR: 'codex/SIDEBAR',
    TOGGLE_SIDEBAR: 'codex/TOGGLE_SIDEBAR',
    CLOSE_SIDEBAR: 'codex/CLOSE_SIDEBAR',
    OPEN_SIDEBAR: 'codex/OPEN_SIDEBAR',
    HIDE_SIDEBAR: 'codex/HIDE_SIDEBAR',
    SHOW_SIDEBAR: 'codex/SHOW_SIDEBAR',
    UPDATE_HEIGHTS: 'codex/UPDATE_HEIGHTS',
    UPDATE_MIN_HEIGHTS: 'codex/UPDATE_MIN_HEIGHTS',
};
const emit = Vue.codex.eventHub.$emit;
exports.module = {
    state: {
        sidebar: { closed: helpers_1.getCookie('codex.sidebar.closed') || false, hidden: helpers_1.getCookie('codex.sidebar.hidden') || false }
    },
    mutations: {
        [exports.types.TOGGLE_SIDEBAR](state) {
            state.sidebar.closed = state.sidebar.closed === false;
            helpers_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.TOGGLE_SIDEBAR);
        },
        [exports.types.CLOSE_SIDEBAR](state) {
            state.sidebar.closed = true;
            helpers_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.CLOSE_SIDEBAR);
        },
        [exports.types.OPEN_SIDEBAR](state) {
            state.sidebar.closed = false;
            helpers_1.setCookie('sidebar.closed', state.sidebar.closed);
            emit(exports.types.OPEN_SIDEBAR);
        },
        [exports.types.HIDE_SIDEBAR](state) {
            state.sidebar.hidden = true;
            helpers_1.setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(exports.types.HIDE_SIDEBAR);
        },
        [exports.types.SHOW_SIDEBAR](state) {
            state.sidebar.hidden = false;
            helpers_1.setCookie('sidebar.hidden', state.sidebar.hidden);
            emit(exports.types.SHOW_SIDEBAR);
        },
        [exports.types.UPDATE_HEIGHTS](state, heights) {
            state.heights = lodash_1.merge(state.heights, heights);
            emit(exports.types.UPDATE_HEIGHTS);
        },
        [exports.types.UPDATE_MIN_HEIGHTS](state, heights) {
            state.minHeights = lodash_1.merge(state.minHeights, heights);
            emit(exports.types.UPDATE_MIN_HEIGHTS);
        },
    },
    actions: {
        toggleSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.TOGGLE_SIDEBAR);
        },
        closeSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.CLOSE_SIDEBAR);
        },
        openSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.OPEN_SIDEBAR);
        },
        hideSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.HIDE_SIDEBAR);
        },
        showSidebar({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.SHOW_SIDEBAR);
        },
        updateHeights({ state, commit, dispatch }, payload = undefined) {
            commit(exports.types.UPDATE_HEIGHTS, payload);
            commit(exports.types.UPDATE_MIN_HEIGHTS, {
                page: state.heights.viewPort - state.heights.header - state.heights.footer
            });
        },
    },
    getters: {
        sidebar: state => state.sidebar,
        heights: state => state.heights,
        minHeights: state => state.minHeights
    }
};
//# sourceMappingURL=index.js.map