var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments)).next());
    });
};
const Vue = require("vue");
const VueResource = require("vue-resource");
const lodash_1 = require("lodash");
Vue.use(VueResource);
Vue.http.options.credentials = false;
function apiUrl(url) {
    let _apiUrl = Vue.codex.phpdoc.apiUrl;
    if (!_apiUrl.toString().endsWith('/'))
        _apiUrl += '/';
    _apiUrl += url;
    return _apiUrl;
}
function getEntities(project, ref, params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        let options = { params: lodash_1.merge({ project, ref, tree: false, full: false }, params) };
        return new Promise((resolve, reject) => {
            let promise = Vue.http.get(apiUrl('phpdoc/entities'), options);
            return promise.catch(err => reject(err)).then(res => res.json(), (err) => reject(err)).then(res => resolve(res.data));
        });
    });
}
exports.getEntities = getEntities;
function getEntity(project, ref, entity, params = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        let options = { params: lodash_1.merge({ project, ref, entity, fields: [] }, params) };
        return new Promise((resolve, reject) => {
            let promise = Vue.http.get(apiUrl('phpdoc/entity'), options);
            return promise.catch(err => reject(err)).then(res => res.json(), (err) => reject(err)).then(res => resolve(res.data));
        });
    });
}
exports.getEntity = getEntity;
//# sourceMappingURL=api.js.map