import * as Vue from "vue";
import * as VueResource from "vue-resource";
import {merge} from 'lodash';

Vue.use(VueResource);
Vue.http.options.credentials = false;

function apiUrl(url): string {
    let _apiUrl: string = Vue.codex.phpdoc.apiUrl;
    if ( ! _apiUrl.toString().endsWith('/') ) _apiUrl += '/';
    _apiUrl += url;
    return _apiUrl
}

export async function getEntities(project: string, ref: string, params: any = {}): Promise<SimpleEntity[]> {
    let options = { params: merge({ project, ref, tree: false, full: false }, params) };
    return <Promise<SimpleEntity[]>> new Promise((resolve, reject) => {
        let promise: Promise<any> = <Promise<any>>Vue.http.get(apiUrl('phpdoc/entities'), options);
        return <Promise<SimpleEntity[]>> promise.catch(err => reject(err)).then(res => res.json(), (err) => reject(err)).then(res => resolve(res.data))
    });
}

export async function getEntity(project: string, ref: string, entity: string, params: any = {}): Promise<File> {
    let options = { params: merge({ project, ref, entity, fields: [] }, params) };
    return <Promise<File>> new Promise((resolve, reject) => {
        let promise: Promise<any> = <Promise<any>>Vue.http.get(apiUrl('phpdoc/entity'), options);
        return <Promise<File>> promise.catch(err => reject(err)).then(res => res.json(), (err) => reject(err)).then(res => resolve(res.data))
    });
}
export type VisibilityType = 'public' | 'protected' | 'private';
export type EntityType = 'class' | 'interface' | 'trait';

export interface BaseEntityMember {
    name: string
    full_name: string
    namespace: string
    line: number
}

export interface Method extends BaseEntityMember {
    arguments: Argument[]
    abstract: boolean
    class_name: string
    description: string
    final: boolean
    inherited: boolean
    'long-description': string
    package: string
    returns: string
    static: boolean
    tags: Tag[]
    throws: string[],
    visibility: VisibilityType
}
export interface Argument {
    byref: boolean
    default: any
    description: string
    name: string
    types: string[]
}
export interface Constant extends BaseEntityMember {
    value: string
}
export interface Property extends BaseEntityMember {
    class_name: string
    description: string
    inherited: boolean
    'long-description': string
    package: string
    static: boolean
    tags: Tag[]
    types: string[]
    visibility: VisibilityType

}
export interface Tag {
    description: string
    line: string
    name: string
    type: string
    variable: string
}

export interface SimpleEntity {
    full_name: string
    name: string
    namespace: string
    type: EntityType
}
export interface Entity extends SimpleEntity {
    abstract: boolean
    constants: Constant[]
    description: string
    extends: string
    final: boolean
    implements: string | string[]
    'long-description': string
    methods: Method[]
    name: string
    namespace: string
    properties: Property[]
    tags: Tag[]
}
export interface File {
    file_description: string,
    'file_long-description': string
    hash: string
    parse_markers: any
    path: string
    source: string
    type: EntityType
    uses: string[]
    entity: Entity
}
export interface EntityTree {
    [key: string]: SimpleEntity | EntityTree|SimpleEntity[]
}