import Vue from "vue";
import components from '../components/welcome';

let codex =  window.codex;

Object.keys(components).forEach(key => Vue.component(key, components[key]));

const wow = new WOW({
    mobile: false,
});
wow.init();

var {mapGetters, mapActions, Store} = Vuex;
const store = new Store({});
Vue.use(codex.CodexPlugin, { store });

Vue.codex.extend({ wow, store })

const App = Vue.extend({
    store,
    mixins : [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {
            carouselHeight: 9999
        }
    },
    mounted(){
        this.updateHeight();
        this.$on('resize', () => this.updateHeight());
        this.$nextTick(() => {
            this.$$el.css('display', 'block')
        });

        this.$$ready(() => {
            this.$nextTick(() => codex.loader.stop())
            let $header = $(this.$refs.header.$el);
            this.$$('.scrollspy').scrollSpy({
                scrollOffset: $header.outerHeight(true) + 1
            }); //.on('scrollSpy:enter', console.log.bind(console)).on('scrollSpy:exit', console.log.bind(console))
        });
    },
    methods: {
        updateHeight(){
            this.carouselHeight = this.getViewPort().height + 1
        }
    }
});

codex.App = App;
