import * as gulp from 'gulp'
const HubRegistry = require('gulp-hub');
const browserSync = require('browser-sync');
const ts = require('gulp-typescript');

var sass = require('gulp-sass');
const conf = require('.//gulp.conf');

// Load some files into the registry
const hub = new HubRegistry([conf.path.tasks('*.js')]);

// Tell gulp to use the tasks just loaded
gulp.registry(hub);

gulp.task('build', gulp.series(gulp.parallel('other', 'webpack:dist')));
gulp.task('test', gulp.series('karma:single-run'));
gulp.task('test:auto', gulp.series('karma:auto-run'));
gulp.task('serve', gulp.series('clean', 'sass', 'sass:watch', 'webpack:watch', 'watch', 'browsersync'));
gulp.task('serve:dist', gulp.series('default', 'browsersync:dist'));
gulp.task('default', gulp.series('clean', 'build'));
gulp.task('watch', watch);

function reloadBrowserSync(cb) {
    browserSync.reload();
    cb();
}

function watch(done) {
    gulp.watch(conf.path.tmp('index.html'), reloadBrowserSync);
    // gulp.watch(conf.path.tmp('styles/**/*.css'), reloadBrowserSync);

    done();
}


gulp.task('sass', function () {
    return gulp.src('./src/styles/**/*.scss')
        .pipe(sass({sourceComments: false}).on('error', sass.logError))
        .pipe(gulp.dest(conf.paths.tmp + '/styles'))
        .pipe(gulp.src(conf.paths.tmp + '/styles/**/*.css'))
        .pipe(gulp.dest(conf.paths.tmp + '/styles'))
});

gulp.task('sass:watch', done => {
    gulp.watch('./src/styles/**/*.scss', gulp.series('sass', reloadBrowserSync));
    done()
});

const tsProject = ts.createProject('tsconfig.json', {

});
gulp.task('ts', () => {
    var tsResult = tsProject.src('src/app/**/*.ts')
        .pipe(tsProject());

    return tsResult;//.pipe(gulp.dest())
});

gulp.task('vue', () => {

})