const lodash_1 = require("lodash");
const vuex_1 = require("vuex");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    mixins: [],
    data() {
        return {
            resize: 0
        };
    },
    computed: vuex_1.mapGetters(['heights']),
    mounted() {
        window.addEventListener('resize', this.handleResize);
    },
    beforeDestroy() {
        window.removeEventListener('resize', this.handleResize);
    },
    methods: lodash_1.merge(vuex_1.mapActions(['updateHeights']), {
        handleResize(event) {
            if (this.resize)
                clearTimeout(this.resize);
            this.resize = setTimeout(() => {
                this.$emit('resize');
            }, 50);
        }
    })
};
//# sourceMappingURL=resize.js.map