const SmoothScroll = require("smoothscroll");
require("../../vendor/scrollspy.js");
const components = require("../../components/global");
const directives = require("./directives");
const VueCookie = require("vue-cookie");
const VueTouch = require("vue-touch");
const NProgress = require("vue-nprogress");
const lodash_1 = require("lodash");
const vIcon = require('vue-materials/src/components/icon.vue');
lodash_1.merge(components, { vIcon });
let plugin = function (Vue, options = {}) {
    if (plugin.installed)
        return;
    console.log({ NProgress, VueCookie, VueTouch });
    Vue.use(VueCookie);
    Vue.use(VueTouch);
    Vue.use(NProgress, {
        latencyThreshold: 100,
        router: false,
        http: true
    });
    const nprogress = new NProgress({ parent: '.nprogress-container' });
    Object.defineProperties(Vue.prototype, {
        $helpers: { get() { return Vue.codex.helpers; } }
    });
    let e;
    Vue.mixin({
        nprogress,
        computed: {
            $$el() { return $(this.$el); },
            $eventHub() { return Vue.codex.eventHub; },
            classes() { return {}; }
        },
        methods: {
            $$: (selector, options) => $(selector, options),
            $$ready(cb) {
                if (document.readyState === 'complete') {
                    this.$nextTick(() => cb());
                }
                else {
                    document.addEventListener('DOMContentLoaded', () => cb());
                }
            },
            $scroll(el, duration = 500, callback, context) {
                SmoothScroll(el, duration, callback, context);
            }
        }
    });
    Vue.config.debug && console.log({ components, directives });
    Object.keys(components).forEach(key => Vue.component(key, components[key]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[key]));
    if (options.store) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = plugin;
//# sourceMappingURL=plugin.js.map