import * as SmoothScroll from "smoothscroll";
import "../../vendor/scrollspy.js";
import * as components from "../../components/global";
// import * as documentComponents from "../../components/document";
import * as directives from "./directives";
import * as VueCookie from "vue-cookie";
import * as VueTouch from "vue-touch";
import * as NProgress from "vue-nprogress";
import { merge } from 'lodash';

const vIcon = require('vue-materials/src/components/icon.vue');
// merge(components, documentComponents, { vIcon }); // , vCollectionItem
merge(components, { vIcon }); // , vCollectionItem

let plugin: any = function (Vue, options: any = {}) {
    if ( plugin.installed ) return;

    console.log({ NProgress, VueCookie, VueTouch })

    Vue.use(VueCookie);

    Vue.use(VueTouch)

    Vue.use(NProgress, {
        latencyThreshold: 100,
        router          : false,
        http            : true
    });

    const nprogress = new NProgress({ parent: '.nprogress-container' });


    Object.defineProperties(Vue.prototype, {
        $helpers: { get () { return Vue.codex.helpers } }

    });

    let e: HTMLElement;

    Vue.mixin({
        nprogress,
        computed: {
            /** @returns {JQuery} */
                $$el(): JQuery { return $(this.$el); },
            $eventHub(): vuejs.Vue { return Vue.codex.eventHub },
            classes(): any { return {} }
        },
        methods : {
            $$: (selector, options): JQuery => $(selector, options),

            $$ready(cb: Function) {
                if ( document.readyState === 'complete' ) {
                    this.$nextTick(() => cb())
                } else {
                    document.addEventListener('DOMContentLoaded', () => cb())
                }
            },
            $scroll(el: HTMLElement, duration: number = 500, callback?: Function, context?: any){
                SmoothScroll(el, duration, callback, context)
            }
        }
    });

    Vue.config.debug && console.log({ components, directives });

    Object.keys(components).forEach(key => Vue.component(key, components[ key ]));
    Object.keys(directives).forEach(key => Vue.directive(key, directives[ key ]));

//a

    if ( options.store ) {
        var { module, types } = require('./store');
        options.store.registerModule('codex', module);
        Vue.codex.types = types;
        Vue.codex.store = options.store;
    }
};


export default plugin;
