import Vue from "vue";
import components from '../components/document'
import {merge} from 'lodash'

let codex = window.codex;

Object.keys(components).forEach((key) => Vue.component(key, components[key]));

var {mapGetters, mapActions, Store} = Vuex;

export const store = new Store({});
Vue.use(codex.CodexPlugin, {
    store
});
export const App = Vue.extend({
    store,
    mixins: [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {
            minHeights: {page: 0, inner: 0, app: 0},
            sidenavs  : {
                opened: '',
                right : true,
                width : 300
            }
        }
    },

    beforeMount(){
        // do not show menu on mobile by default. The user has to click the menu icon first
        if ( this.isBreakpointDown('md') ) {
            this.closeSidebar();
        }
    },
    mounted(){

        this.$$ready(() => {
            this.onResize();
            this.$nextTick(() => codex.loader.stop());
        });
        this.$on('resize', this.onResize)
        this.$eventHub.$on('sidebar:open-sub-menu', this.onResize)
    },
    methods : {
        ...mapActions(['toggleSidebar', 'closeSidebar', 'openSidebar', 'hideSidebar', 'showSidebar']),

        showSidenav(name){
            this.sidenavs.opened = name;
        },
        hideSidenav(){
            this.sidenavs.opened = '';
        },
        isSidenav(name){
            return this.sidenavs.opened === name;
        },
        sidenavTransition({el, style, cb}) {
            this.$$(el).velocity('stop')
            this.$$(el).velocity(style, {
                duration: 300,
                queue   : false,
                easing  : 'easeOutQuad',
                complete: cb
            });
        },

        onResize() {
            // Do not set heights when dealing with non-desktop devices
            if ( this.isBreakpointDown('md') ) return;
            let $page = this.$$(this.$refs.page);
            var heights = {
                header  : this.$refs.header.$$el.outerHeight(true),
                footer  : this.$refs.footer.$$el.outerHeight(true),
                viewPort: this.getViewPort().height
            };
            this.minHeights.page = heights.viewPort - heights.header - heights.footer;
            this.minHeights.inner = this.minHeights.page - (parseInt($page.css('padding-top')) + parseInt($page.css('padding-bottom')));
        }
    },
    computed: {
        ...mapGetters(['sidebar']),
        $sidebarInner(){
            return this.$$(this.$refs.sidebar.$el.children[0])
        },
        $contentInner(){
            return this.$$(this.$refs.content.$el.children[0])
        },
        sidebarInnerHeight(){
            return this.$sidebarInner.outerHeight();
        },
        contentInnerHeight(){
            return this.$contentInner.outerHeight();
        },
        classes(){
            return {
                'sidebar-hidden': this.sidebar.hidden,
                'sidebar-closed': this.sidebar.closed,
            }
        }
    }
});


export default App;

codex.App = App;