import Vue from "vue";
import {mapGetters} from 'vuex';
//import 'perfect-scrollbar/jquery';

let codex = window.codex;

if(codex.CodexPhpdocPlugin) {
    Vue.use(codex.CodexPhpdocPlugin);
}
Vue.config.debug = true;


const App = Vue.codex.App.extend({
    // mixins  : [Vue.codex.mixins.layout, Vue.codex.mixins.resize],
    data(){
        return {
            minContentHeight: 0
        }
    },
    mounted(){
        console.log('phpdoc  APP');
        this.$$ready(() => this.onResizeDocument());
        this.$on('resize', this.onResizeDocument)
        codex.loader.stop();
    },
    methods : {
        // ...mapActions(['toggleSidebar'])
        onResizeDocument(){
            this.$nextTick(() => {
                let $page = this.$$(this.$refs.page);
                this.minHeights.inner = 0;
                this.$nextTick(() => {
                    this.minHeights.inner = $page.outerHeight(true) - parseInt($page.css('padding-top')) - parseInt($page.css('padding-bottom'))
                });
            })
        }
    },
    watch   : {
        file(){
            this.$nextTick(() => {
                this.onResizeDocument();
                this.$scroll(this.$refs.header.$el);
            })
        }
    },
    computed: {
        ...mapGetters(['file'])
    }
});

export default App;

codex.App = App;

console.log('sc phpdoc');
